/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.NotificationHandler;
import com.yoctopuce.YoctoAPI.WSHandlerInterface;
import com.yoctopuce.YoctoAPI.WSHandlerYocto;
import com.yoctopuce.YoctoAPI.WSRequest;
import com.yoctopuce.YoctoAPI.WSStream;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import com.yoctopuce.YoctoWSHandler.WSHandlerJEE;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class WSNotificationHandler
extends NotificationHandler
implements WSHandlerInterface.WSHandlerResponseInterface {
    private static final int NB_TCP_CHANNEL = 4;
    private static final int HUB_TCP_CHANNEL = 0;
    private static final int DEVICE_TCP_CHANNEL = 0;
    private static final int WS_REQUEST_MAX_DURATION = 50000;
    private static final int DEFAULT_TCP_ROUND_TRIP_TIME = 30;
    private static final int DEFAULT_TCP_MAX_WINDOW_SIZE = 262144;
    private final ExecutorService _executorService;
    private MessageDigest _sha1 = null;
    private MessageDigest _md5 = null;
    private WSHandlerInterface _wsHandler;
    private final BlockingQueue<WSRequest> _pendingRequests = new LinkedBlockingQueue<WSRequest>();
    private final ArrayList<ArrayList<WSRequest>> _workingRequests;
    private final Object _stateLock = new Object();
    private volatile boolean _waitingForConnectionState;
    private volatile boolean _muststop;
    private long _connectionTime = 0L;
    private ConnectionState _connectionState = ConnectionState.CONNECTING;
    private int _remoteVersion = 0;
    private long _remoteNouce;
    private int _nounce;
    private volatile int _session_errno;
    private volatile String _session_error;
    private boolean _rwAccess = false;
    private long _tcpRoundTripTime = 30L;
    private int _tcpMaxWindowSize = 262144;
    private final int[] _lastUploadAckBytes = new int[4];
    private final long[] _lastUploadAckTime = new long[4];
    private final int[] _lastUploadRateBytes = new int[4];
    private final long[] _lastUploadRateTime = new long[4];
    private int _uploadRate = 0;
    private byte _nextAsyncId = (byte)48;
    private long _next_transmit_tm = 0L;
    private final Object _sendLock = new Object();
    private int _notifAbsPos;
    private final StringBuilder _notificationsFifo = new StringBuilder();

    WSNotificationHandler(YHTTPHub hub, Object session) {
        super(hub);
        this._wsHandler = session != null ? new WSHandlerJEE((WSHandlerInterface.WSHandlerResponseInterface)this, session) : new WSHandlerYocto(this);
        this._workingRequests = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            this._workingRequests.add(i, new ArrayList());
        }
        this._executorService = Executors.newFixedThreadPool(1);
        this._muststop = false;
        try {
            this._sha1 = MessageDigest.getInstance("SHA-1");
            this._md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._waitingForConnectionState = true;
        do {
            if (this._error_delay > 0) {
                try {
                    Thread.sleep(this._error_delay);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            Object e = this._stateLock;
            synchronized (e) {
                this._connectionState = ConnectionState.CONNECTING;
            }
            try {
                this._wsHandler.connect(this._hub, this._waitingForConnectionState, this._hub._networkTimeoutMs, this._notifAbsPos);
                this.runOnSession();
            }
            catch (YAPI_Exception e2) {
                if (e2.errorType == -2 || e2.errorType == -11 || e2.errorType == -20 || e2.errorType == -15) {
                    this._muststop = true;
                }
                this._session_errno = e2.errorType;
                this._session_error = e2.getLocalizedMessage();
            }
            this._wsHandler.close();
            this._waitingForConnectionState = true;
            ++this._notifRetryCount;
            this._hub._isNotifWorking = false;
            this._error_delay = 100 << (this._notifRetryCount > 4 ? 4 : this._notifRetryCount);
        } while (!Thread.currentThread().isInterrupted() && !this._muststop && !this._wsHandler.isCallback());
        Object object = this._stateLock;
        synchronized (object) {
            this._connectionState = ConnectionState.DEAD;
            if (this._session_errno == 0) {
                this._session_errno = -8;
                this._session_error = "WS Session is closed";
            }
            this._stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnSession() {
        if (!this._wsHandler.isOpen()) {
            this.WSLOG("WebSocket is not open");
            return;
        }
        String errmsg = "WebSocket session is closed";
        try {
            long timeout = System.currentTimeMillis() + 10000L;
            Object object = this._stateLock;
            synchronized (object) {
                while (this._connectionState == ConnectionState.CONNECTING && !this._muststop) {
                    this._stateLock.wait(1000L);
                    if (timeout >= System.currentTimeMillis()) continue;
                    this.WSLOG("YoctoHub did not send any data for 10 secs");
                    this._connectionState = ConnectionState.DISCONNECTED;
                    this._stateLock.notifyAll();
                    return;
                }
            }
            while (!Thread.currentThread().isInterrupted() && !this._muststop && this._wsHandler.isOpen()) {
                long now = YAPI.GetTickCount();
                long wait = this._next_transmit_tm >= now ? this._next_transmit_tm - now : 1000L;
                WSRequest request = this._pendingRequests.poll(wait, TimeUnit.MILLISECONDS);
                if (request != null) {
                    if (request.getState().equals((Object)WSRequest.State.FAKE_REQUEST)) break;
                    ArrayList<ArrayList<WSRequest>> arrayList = this._workingRequests;
                    synchronized (arrayList) {
                        request.reportStartOfProcess();
                        this._workingRequests.get(request.getChannel()).add(request);
                    }
                }
                this.processRequests();
                this._hub.testLogPull();
            }
        }
        catch (Exception ex) {
            errmsg = ex.getLocalizedMessage();
        }
        try {
            WSRequest wsRequest = this._pendingRequests.poll(10L, TimeUnit.MILLISECONDS);
            while (wsRequest != null) {
                wsRequest.setError(-8, errmsg);
                wsRequest = this._pendingRequests.poll(10L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object object = this._workingRequests;
        synchronized (object) {
            for (int i = 0; i < 4; ++i) {
                for (WSRequest request : this._workingRequests.get(i)) {
                    request.setError(-8, errmsg);
                }
                this._workingRequests.get(i).clear();
            }
        }
        object = this._stateLock;
        synchronized (object) {
            this._connectionState = ConnectionState.DISCONNECTED;
            this._stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WSRequest sendRequest(String req_first_line, byte[] req_head_and_body, int tcpchanel, boolean async, YGenericHub.RequestProgress progress, Object context, long expiration) throws YAPI_Exception, InterruptedException {
        WSRequest request;
        byte[] full_request;
        if (req_head_and_body == null) {
            req_first_line = (String)req_first_line + "\r\n\r\n";
            full_request = req_first_lineBytes = ((String)req_first_line).getBytes(this._hub._yctx._deviceCharset);
        } else {
            req_first_line = (String)req_first_line + "\r\n";
            req_first_lineBytes = ((String)req_first_line).getBytes(this._hub._yctx._deviceCharset);
            full_request = new byte[req_first_lineBytes.length + req_head_and_body.length];
            System.arraycopy(req_first_lineBytes, 0, full_request, 0, req_first_lineBytes.length);
            System.arraycopy(req_head_and_body, 0, full_request, req_first_lineBytes.length, req_head_and_body.length);
        }
        long timeout = System.currentTimeMillis() + 50000L;
        if (timeout < expiration) {
            expiration = timeout;
        }
        Object object = this._stateLock;
        synchronized (object) {
            while (this._connectionState != ConnectionState.CONNECTED && this._connectionState != ConnectionState.DEAD) {
                long delay = expiration - System.currentTimeMillis();
                if (delay <= 0L) {
                    if (this._connectionState != ConnectionState.CONNECTED && this._connectionState != ConnectionState.CONNECTING) {
                        throw new YAPI_Exception(-8, "IO error with hub");
                    }
                    if (this._session_errno != 0) {
                        throw new YAPI_Exception(this._session_errno, "Unable to start the request in time (" + this._session_error + ")");
                    }
                    throw new YAPI_Exception(-7, "Unable to start the request in time");
                }
                this._stateLock.wait(delay);
            }
            if (this._connectionState == ConnectionState.DEAD) {
                throw new YAPI_Exception(this._session_errno, this._session_error);
            }
            if (async) {
                byte by = this._nextAsyncId;
                this._nextAsyncId = (byte)(by + 1);
                request = new WSRequest(tcpchanel, by, full_request, expiration);
                if (this._nextAsyncId >= 127) {
                    this._nextAsyncId = (byte)48;
                }
            } else {
                request = new WSRequest(tcpchanel, full_request, expiration, progress, context);
            }
        }
        this._pendingRequests.put(request);
        return request;
    }

    private byte[] getRequestResponse(WSRequest wsRequest, long expiration) throws YAPI_Exception, InterruptedException {
        int hpos;
        WSRequest.State state = wsRequest.waitProcessingEnd(expiration);
        if (!state.equals((Object)WSRequest.State.CLOSED)) {
            wsRequest.checkError();
            throw new YAPI_Exception(-7, "request did not finished correctly");
        }
        byte[] full_result = wsRequest.getResponseBytes();
        int okpos = YAPIContext._find_in_bytes(full_result, "OK".getBytes(this._hub._yctx._deviceCharset));
        if (okpos != 0) {
            okpos = YAPIContext._find_in_bytes(full_result, "HTTP/1.1 ".getBytes(this._hub._yctx._deviceCharset));
            int endl = YAPIContext._find_in_bytes(full_result, "\r\n".getBytes(this._hub._yctx._deviceCharset));
            if (okpos == 0 && endl > 8) {
                String line = new String(full_result, 9, endl - 9);
                String[] parts = line.trim().split(" ");
                if (parts[0].equals("401")) {
                    throw new YAPI_Exception(-12, "Authentication required");
                }
                throw new YAPI_Exception(line.trim());
            }
        }
        if ((hpos = YAPIContext._find_in_bytes(full_result, "\r\n\r\n".getBytes(this._hub._yctx._deviceCharset))) >= 0) {
            return Arrays.copyOfRange(full_result, hpos + 4, full_result.length);
        }
        return full_result;
    }

    @Override
    String getThreadLabel() {
        return this._wsHandler.getThreadLabel() + "_" + this._hub._runtime_http_params.toString();
    }

    @Override
    public byte[] hubRequestSync(String req_first_line, byte[] req_head_and_body, int mstimeout) throws YAPI_Exception, InterruptedException {
        if (mstimeout == 0) {
            mstimeout = 86400000;
        }
        long expiration = System.currentTimeMillis() + (long)mstimeout;
        WSRequest wsRequest = this.sendRequest(req_first_line, req_head_and_body, 0, false, null, null, expiration);
        return this.getRequestResponse(wsRequest, expiration);
    }

    @Override
    byte[] devRequestSync(YDevice device, String req_first_line, byte[] req_head_and_body, int mstimeout, YGenericHub.RequestProgress progress, Object context) throws YAPI_Exception, InterruptedException {
        if (mstimeout == 0) {
            mstimeout = 86400000;
        }
        long expiration = System.currentTimeMillis() + (long)mstimeout;
        WSRequest wsRequest = this.sendRequest(req_first_line, req_head_and_body, 0, false, progress, context, expiration);
        return this.getRequestResponse(wsRequest, expiration);
    }

    @Override
    void devRequestAsync(YDevice device, String req_first_line, byte[] req_head_and_body, final YGenericHub.RequestAsyncResult asyncResult, final Object asyncContext) throws YAPI_Exception, InterruptedException {
        final long expiration = System.currentTimeMillis() + 50000L;
        final WSRequest wsRequest = this.sendRequest(req_first_line, req_head_and_body, 0, true, null, null, expiration);
        this._executorService.execute(new Runnable(){

            @Override
            public void run() {
                byte[] response = null;
                int error_code = 0;
                String errmsg = null;
                try {
                    response = WSNotificationHandler.this.getRequestResponse(wsRequest, expiration);
                }
                catch (YAPI_Exception e) {
                    error_code = e.errorType;
                    errmsg = e.getLocalizedMessage();
                }
                catch (InterruptedException e) {
                    error_code = -8;
                    errmsg = e.getLocalizedMessage();
                }
                if (asyncResult != null) {
                    asyncResult.RequestAsyncDone(asyncContext, response, error_code, errmsg);
                }
            }
        });
    }

    @Override
    boolean waitAndFreeAsyncTasks(long timeout) throws InterruptedException {
        this._executorService.shutdown();
        boolean allTerminated = this._executorService.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        this._muststop = true;
        this._wsHandler.close();
        return !allTerminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        if (this._sendPingNotification) {
            return this._lastPing + 6000L > System.currentTimeMillis();
        }
        Object object = this._stateLock;
        synchronized (object) {
            return this._connectionState == ConnectionState.CONNECTED || this._connectionState == ConnectionState.AUTHENTICATING || this._connectionState == ConnectionState.CONNECTING;
        }
    }

    @Override
    public boolean hasRwAccess() {
        return this._rwAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRequestQueue(String message) {
        ArrayList<ArrayList<WSRequest>> arrayList = this._workingRequests;
        synchronized (arrayList) {
            System.out.println(message + ": dump requests");
            for (WSRequest req : this._workingRequests.get(0)) {
                req.log("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void parseBinaryMessage(ByteBuffer raw_data) throws YAPI_Exception {
        raw_data.order(ByteOrder.LITTLE_ENDIAN);
        byte first_byte = raw_data.get();
        int tcpchan = first_byte & 7;
        int ystream = (first_byte & 0xFF) >> 3;
        ArrayList<WSRequest> requestOfTCPChan = this._workingRequests.get(tcpchan);
        switch (ystream) {
            case 8: {
                if (this._waitingForConnectionState) {
                    if (this._hub._runtime_http_params.hasAuthParam()) return;
                    Object object = this._stateLock;
                    // MONITORENTER : object
                    this._connectionState = ConnectionState.CONNECTED;
                    this._stateLock.notifyAll();
                    // MONITOREXIT : object
                    this._waitingForConnectionState = false;
                }
                byte[] chars = new byte[raw_data.remaining()];
                raw_data.get(chars);
                String tcpNotif = new String(chars, this._hub._yctx._deviceCharset);
                this.decodeTCPNotif(tcpNotif);
                return;
            }
            case 0: {
                return;
            }
            case 9: {
                if (tcpchan > 3) {
                    this._hub._yctx._Log("WS: Unexpected frame for tcpChan " + tcpchan + " (" + ystream + ")");
                    return;
                }
                ArrayList<ArrayList<WSRequest>> arrayList = this._workingRequests;
                // MONITORENTER : arrayList
                WSRequest workingRequest = requestOfTCPChan.size() > 0 ? requestOfTCPChan.get(0) : null;
                // MONITOREXIT : arrayList
                if (workingRequest == null) {
                    this._hub._yctx._Log("WS: Drop frame for closed tcpChan " + tcpchan + " (" + ystream + ")");
                    return;
                }
                if (raw_data.remaining() < 1) {
                    this._hub._yctx._Log("WS: Incorrect async-close packet (too short message) on tcpChan " + tcpchan);
                    return;
                }
                WSStream stream = new WSStream(ystream, tcpchan, raw_data.remaining() - 1, raw_data);
                byte asyncId = raw_data.get();
                if (workingRequest.getAsyncId() == 0) {
                    this._hub._yctx._Log("Asynchronous close received, sync reply request");
                } else if (workingRequest.getAsyncId() != asyncId) {
                    this._hub._yctx._Log("WS: Incorrect async-close signature on tcpChan " + tcpchan);
                } else {
                    workingRequest.addStream(stream);
                    workingRequest.setState(WSRequest.State.CLOSED);
                }
                ArrayList<ArrayList<WSRequest>> arrayList2 = this._workingRequests;
                // MONITORENTER : arrayList2
                requestOfTCPChan.remove(workingRequest);
                // MONITOREXIT : arrayList2
                return;
            }
            case 1: 
            case 2: {
                Object outstream;
                WSRequest workingRequest;
                if (tcpchan > 3) {
                    this._hub._yctx._Log("WS: Unexpected frame for tcpChan " + tcpchan + " (" + ystream + ")");
                    return;
                }
                int ofs = 0;
                ArrayList<ArrayList<WSRequest>> arrayList = this._workingRequests;
                // MONITORENTER : arrayList
                do {
                    workingRequest = requestOfTCPChan.size() > ofs ? requestOfTCPChan.get(ofs) : null;
                    ++ofs;
                } while (workingRequest != null && workingRequest.getState() == WSRequest.State.CLOSED);
                // MONITOREXIT : arrayList
                if (workingRequest == null) {
                    this._hub._yctx._Log(String.format(Locale.US, "WS: Drop frame for closed tcpChan %d (%s)\n", tcpchan, ystream == 2 ? "TCP_CLOSE" : "TCP"));
                    return;
                }
                WSRequest.State workingRequestState = workingRequest.getState();
                WSStream stream = new WSStream(ystream, tcpchan, raw_data.remaining(), raw_data);
                workingRequest.addStream(stream);
                if (ystream != 2) return;
                if (workingRequest.isAsync()) {
                    this._hub._yctx._Log(String.format(Locale.US, "WS: Synchronous close received instead of async-%d close for tcpchan %d\n", workingRequest.getAsyncId(), tcpchan));
                    workingRequest.setState(WSRequest.State.CLOSED);
                } else {
                    if (workingRequestState == WSRequest.State.OPEN) {
                        outstream = new WSStream(2, tcpchan, 0, null);
                        try {
                            Object object = this._sendLock;
                            // MONITORENTER : object
                            this._wsHandler.sendBinary(((WSStream)outstream).getContent(), true);
                            // MONITOREXIT : object
                        }
                        catch (YAPI_Exception e) {
                            e.printStackTrace();
                        }
                    }
                    workingRequest.setState(WSRequest.State.CLOSED);
                }
                outstream = this._workingRequests;
                // MONITORENTER : outstream
                requestOfTCPChan.remove(workingRequest);
                // MONITOREXIT : outstream
                return;
            }
            case 5: {
                int metatype = raw_data.get() & 0xFF;
                switch (metatype) {
                    case 4: {
                        int len;
                        int version = raw_data.get() & 0xFF;
                        if (version < 1) return;
                        if (raw_data.limit() < 28) {
                            return;
                        }
                        this._remoteVersion = version;
                        short maxtcpws = raw_data.getShort();
                        if (maxtcpws > 0) {
                            this._tcpMaxWindowSize = maxtcpws;
                        }
                        long nounce = raw_data.getInt();
                        nounce &= 0xFFFFFFFFFFFFFFFFL;
                        byte[] serial_char = new byte[raw_data.remaining()];
                        raw_data.get(serial_char);
                        for (len = 8; len < serial_char.length && serial_char[len] != 0; ++len) {
                        }
                        String remoteSerial = new String(serial_char, 0, len, Charset.forName("ISO-8859-1"));
                        if (this._hub.updateHubSerial(remoteSerial)) {
                            Object object = this._stateLock;
                            // MONITORENTER : object
                            this._connectionState = ConnectionState.DEAD;
                            this._stateLock.notifyAll();
                            // MONITOREXIT : object
                            throw new YAPI_Exception(-11, "Duplicate hub detected");
                        }
                        this._remoteNouce = nounce;
                        this._connectionTime = YAPI.GetTickCount();
                        Random randomGenerator = new Random();
                        this._nounce = randomGenerator.nextInt();
                        Object object = this._stateLock;
                        // MONITORENTER : object
                        this._connectionState = ConnectionState.AUTHENTICATING;
                        this._stateLock.notifyAll();
                        // MONITOREXIT : object
                        this.sendAuthenticationMeta();
                        return;
                    }
                    case 5: {
                        Object object = this._stateLock;
                        // MONITORENTER : object
                        if (this._connectionState != ConnectionState.AUTHENTICATING) {
                            // MONITOREXIT : object
                            return;
                        }
                        // MONITOREXIT : object
                        int version = raw_data.get() & 0xFF;
                        if (version < 1) return;
                        if (raw_data.limit() < 28) {
                            return;
                        }
                        this._tcpRoundTripTime = YAPI.GetTickCount() - this._connectionTime + 1L;
                        long uploadRate = (long)(this._tcpMaxWindowSize * 1000) / this._tcpRoundTripTime;
                        this._hub._yctx._Log(String.format(Locale.US, "WS:RTT=%dms, WS=%d, uploadRate=%f KB/s\n", this._tcpRoundTripTime, this._tcpMaxWindowSize, (double)uploadRate / 1000.0));
                        int flags = raw_data.getShort() & 0xFFFF;
                        raw_data.getInt();
                        if ((flags & 2) != 0) {
                            this._rwAccess = true;
                        }
                        if ((flags & 1) != 0) {
                            byte[] remote_sha1 = new byte[20];
                            raw_data.get(remote_sha1);
                            byte[] sha1 = this.computeAUTH(this._hub._runtime_http_params.getUser(), this._hub._runtime_http_params.getPass(), this._hub.getSerialNumber(), this._nounce);
                            if (Arrays.equals(sha1, remote_sha1)) {
                                Object object2 = this._stateLock;
                                // MONITORENTER : object2
                                this._connectionState = ConnectionState.CONNECTED;
                                this._stateLock.notifyAll();
                                // MONITOREXIT : object2
                                this._waitingForConnectionState = false;
                                return;
                            }
                            this.errorOnSession(-12, String.format("Authentication as %s failed", this._hub._runtime_http_params.getUser()));
                            return;
                        }
                        if (!this._hub._runtime_http_params.hasAuthParam() || this._hub._runtime_http_params.getPass().equals("")) {
                            Object remote_sha1 = this._stateLock;
                            // MONITORENTER : remote_sha1
                            this._connectionState = ConnectionState.CONNECTED;
                            this._stateLock.notifyAll();
                            // MONITOREXIT : remote_sha1
                            this._waitingForConnectionState = false;
                            return;
                        }
                        if (this._hub._runtime_http_params.getUser().equals("admin") && !this._rwAccess) {
                            this.errorOnSession(-12, String.format("Authentication as %s failed", this._hub._runtime_http_params.getUser()));
                            return;
                        }
                        this.errorOnSession(-12, String.format("Authentication error : hub has no password for %s", this._hub._runtime_http_params.getUser()));
                        return;
                    }
                    case 6: {
                        raw_data.get();
                        int html_error = raw_data.getShort() & 0xFFFF;
                        if (html_error == 401) {
                            this.errorOnSession(-12, "Authentication failed");
                            return;
                        }
                        this.errorOnSession(-8, String.format(Locale.US, "Remote hub closed connection with error %d", html_error));
                        return;
                    }
                    case 7: {
                        tcpchan = raw_data.get();
                        ArrayList<ArrayList<WSRequest>> sha1 = this._workingRequests;
                        // MONITORENTER : sha1
                        ArrayList<WSRequest> uploadChandRequests = this._workingRequests.get(tcpchan);
                        WSRequest workingRequest = uploadChandRequests.size() > 0 ? uploadChandRequests.get(0) : null;
                        // MONITOREXIT : sha1
                        if (workingRequest == null) return;
                        int b0 = raw_data.get() & 0xFF;
                        int b1 = raw_data.get() & 0xFF;
                        int b2 = raw_data.get() & 0xFF;
                        int b3 = raw_data.get() & 0xFF;
                        int ackBytes = b0 + (b1 << 8) + (b2 << 16) + (b3 << 24);
                        long ackTime = YAPI.GetTickCount();
                        if (this._lastUploadAckTime[tcpchan] != 0L && ackBytes > this._lastUploadAckBytes[tcpchan]) {
                            this._lastUploadAckBytes[tcpchan] = ackBytes;
                            this._lastUploadAckTime[tcpchan] = ackTime;
                            int deltaBytes = ackBytes - this._lastUploadRateBytes[tcpchan];
                            long deltaTime = ackTime - this._lastUploadRateTime[tcpchan];
                            if (deltaTime < 500L) {
                                return;
                            }
                            if (deltaTime < 1000L && deltaBytes < 65536) {
                                return;
                            }
                            this._lastUploadRateBytes[tcpchan] = ackBytes;
                            this._lastUploadRateTime[tcpchan] = ackTime;
                            workingRequest.reportProgress(ackBytes);
                            double newRate = (double)deltaBytes * 1000.0 / (double)deltaTime;
                            this._uploadRate = (int)(0.8 * (double)this._uploadRate + 0.3 * newRate);
                            this._hub._yctx._Log(String.format(Locale.US, "Upload rate: %.2f KB/s (based on %.2f KB in %fs)\n", newRate / 1000.0, (double)deltaBytes / 1000.0, (double)deltaTime / 1000.0));
                            return;
                        }
                        this._hub._yctx._Log("First Ack received\n");
                        this._lastUploadAckBytes[tcpchan] = ackBytes;
                        this._lastUploadAckTime[tcpchan] = ackTime;
                        this._lastUploadRateBytes[tcpchan] = ackBytes;
                        this._lastUploadRateTime[tcpchan] = ackTime;
                        workingRequest.reportProgress(ackBytes);
                        return;
                    }
                }
                this.WSLOG(String.format(Locale.US, "unhandled Meta pkt %d", ystream));
                return;
            }
        }
        this._hub._yctx._Log(String.format(Locale.US, "Invalid WS stream type (%d)\n", ystream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processRequests() throws YAPI_Exception {
        if (this._next_transmit_tm != 0L && this._next_transmit_tm > YAPI.GetTickCount()) {
            return;
        }
        int tcpchan = 0;
        block18: while (tcpchan < 4) {
            WSRequest req;
            ArrayList<WSRequest> requestOfTCPChan = this._workingRequests.get(tcpchan);
            int reqIndex = 0;
            ArrayList<ArrayList<WSRequest>> arrayList = this._workingRequests;
            synchronized (arrayList) {
                req = requestOfTCPChan.size() > reqIndex ? requestOfTCPChan.get(reqIndex) : null;
            }
            while (true) {
                ArrayList<ArrayList<WSRequest>> arrayList2;
                block40: {
                    int throttle_end;
                    int throttle_start;
                    ByteBuffer requestBytes;
                    block44: {
                        block41: {
                            long timeOnTheAir;
                            block46: {
                                block45: {
                                    block43: {
                                        WSRequest.State reqState;
                                        block42: {
                                            if (req == null) break block41;
                                            reqState = req.getState();
                                            if (!reqState.equals((Object)WSRequest.State.CLOSED_BY_API)) break block42;
                                            if (req.getExpiration() + 5000L < System.currentTimeMillis()) {
                                                req.setState(WSRequest.State.FAKE_REQUEST);
                                                arrayList2 = this._workingRequests;
                                                synchronized (arrayList2) {
                                                    requestOfTCPChan.remove(req);
                                                }
                                            }
                                            break block40;
                                        }
                                        if (!reqState.equals((Object)WSRequest.State.OPEN)) break block40;
                                        if (req.getExpiration() >= System.currentTimeMillis()) break block43;
                                        if (req.isAsync()) {
                                            req.setState(WSRequest.State.FAKE_REQUEST);
                                            arrayList2 = this._workingRequests;
                                            synchronized (arrayList2) {
                                                requestOfTCPChan.remove(req);
                                                break block40;
                                            }
                                        } else if (req.getRequestBytes().position() > 0) {
                                            wsstream = new WSStream(1, tcpchan, 0, null);
                                            Object object = this._sendLock;
                                            synchronized (object) {
                                                this._wsHandler.sendBinary(((WSStream)wsstream).getContent(), true);
                                            }
                                            req.setState(WSRequest.State.CLOSED_BY_API);
                                            break block40;
                                        } else {
                                            req.setState(WSRequest.State.CLOSED);
                                            wsstream = this._workingRequests;
                                            synchronized (wsstream) {
                                                requestOfTCPChan.remove(req);
                                            }
                                        }
                                        break block40;
                                    }
                                    requestBytes = req.getRequestBytes();
                                    throttle_start = requestBytes.position();
                                    throttle_end = requestBytes.limit();
                                    if (throttle_end <= 2108 || this._remoteVersion < 2 || tcpchan != 0) break block44;
                                    if (requestBytes.position() != 0) break block45;
                                    throttle_end = 2108;
                                    this._lastUploadAckBytes[tcpchan] = 0;
                                    this._lastUploadAckTime[tcpchan] = 0L;
                                    this._uploadRate = (int)((long)(this._tcpMaxWindowSize * 1000) / this._tcpRoundTripTime);
                                    break block44;
                                }
                                if (this._lastUploadAckTime[tcpchan] != 0L) break block46;
                                throttle_end = 0;
                                break block44;
                            }
                            int uploadRate = this._uploadRate;
                            int bytesOnTheAir = requestBytes.position() - this._lastUploadAckBytes[tcpchan];
                            int toBeSent = (int)((long)(2 * uploadRate + 1024 - bytesOnTheAir) + (long)uploadRate * (timeOnTheAir = YAPI.GetTickCount() - this._lastUploadAckTime[tcpchan]) / 1000L);
                            if (toBeSent + bytesOnTheAir > 262144) {
                                toBeSent = 262144 - bytesOnTheAir;
                            }
                            this.WSLOG(String.format(Locale.US, "throttling: %d bytes/s (%d + %d = %d)", this._uploadRate, toBeSent, bytesOnTheAir, bytesOnTheAir + toBeSent));
                            if (toBeSent < 64) {
                                long waitTime = 1000 * (128 - toBeSent) / this._uploadRate;
                                if (waitTime < 2L) {
                                    waitTime = 2L;
                                }
                                this._next_transmit_tm = YAPI.GetTickCount() + waitTime;
                                this.WSLOG(String.format(Locale.US, "WS: %d sent %dms ago, waiting %dms...", bytesOnTheAir, timeOnTheAir, waitTime));
                                throttle_end = 0;
                            }
                            if (throttle_end <= requestBytes.position() + toBeSent) break block44;
                            if (toBeSent > 124) {
                                toBeSent = toBeSent / 124 * 124;
                            }
                            throttle_end = requestBytes.position() + toBeSent;
                            break block44;
                        }
                        ++tcpchan;
                        continue block18;
                    }
                    while (requestBytes.position() < throttle_end) {
                        Object object;
                        WSStream wsstream;
                        int pos;
                        int datalen = throttle_end - requestBytes.position();
                        if (datalen > WSStream.MAX_DATA_LEN) {
                            datalen = WSStream.MAX_DATA_LEN;
                        }
                        if ((pos = requestBytes.position()) < 180 && pos + datalen >= 192) {
                            datalen = 191 - pos;
                        }
                        if (req.isAsync() && pos + datalen == requestBytes.limit()) {
                            if (datalen == WSStream.MAX_DATA_LEN) {
                                wsstream = new WSStream(1, tcpchan, datalen, requestBytes);
                                Object object2 = this._sendLock;
                                synchronized (object2) {
                                    this._wsHandler.sendBinary(wsstream.getContent(), true);
                                }
                                req.reportDataSent();
                                datalen = 0;
                            }
                            wsstream = new WSStream(9, tcpchan, datalen, requestBytes, req.getAsyncId());
                            object = this._sendLock;
                            synchronized (object) {
                                this._wsHandler.sendBinary(wsstream.getContent(), true);
                            }
                            req.reportDataSent();
                            continue;
                        }
                        wsstream = new WSStream(1, tcpchan, datalen, requestBytes);
                        object = this._sendLock;
                        synchronized (object) {
                            this._wsHandler.sendBinary(wsstream.getContent(), true);
                        }
                        req.reportDataSent();
                    }
                    if (requestBytes.position() < requestBytes.limit()) {
                        int sent = requestBytes.position() - throttle_start;
                        if (sent > 0 && this._uploadRate > 0) {
                            long waitTime = 1000 * sent / this._uploadRate;
                            if (waitTime < 2L) {
                                waitTime = 2L;
                            }
                            this._next_transmit_tm = YAPI.GetTickCount() + waitTime;
                            this.WSLOG(String.format(Locale.US, "Sent %dbytes, waiting %dms...", sent, waitTime));
                        } else {
                            this._next_transmit_tm = YAPI.GetTickCount() + 100L;
                        }
                    }
                }
                arrayList2 = this._workingRequests;
                synchronized (arrayList2) {
                    req = requestOfTCPChan.size() > ++reqIndex ? requestOfTCPChan.get(reqIndex) : null;
                }
            }
            break;
        }
        return;
    }

    @Override
    public void WSLOG(String s) {
        this._hub._yctx._Log(s + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAuthenticationMeta() {
        ByteBuffer auth = ByteBuffer.allocate(28);
        auth.order(ByteOrder.LITTLE_ENDIAN);
        auth.put((byte)5);
        if (this._hub._runtime_http_params.hasAuthParam()) {
            auth.put((byte)2);
            auth.putShort((short)1);
            auth.putInt(this._nounce);
            byte[] sha1 = this.computeAUTH(this._hub._runtime_http_params.getUser(), this._hub._runtime_http_params.getPass(), this._hub.getSerialNumber(), this._remoteNouce);
            auth.put(sha1);
        } else {
            auth.put((byte)2);
            auth.putInt(0);
            for (int i = 0; i < 5; ++i) {
                auth.putInt(0);
            }
        }
        auth.rewind();
        WSStream stream = new WSStream(5, 0, 28, auth);
        try {
            Object object = this._sendLock;
            synchronized (object) {
                this._wsHandler.sendBinary(stream.getContent(), true);
            }
        }
        catch (YAPI_Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] computeAUTH(String user, String pass, String serial, long noune) {
        String ha1_str = user + ":" + serial + ":" + pass;
        this._md5.reset();
        this._md5.update(ha1_str.getBytes(this._hub._yctx._deviceCharset));
        byte[] digest = this._md5.digest();
        String ha1 = YAPIContext._bytesToHexStr(digest, 0, digest.length).toLowerCase();
        String sha1_raw = ha1 + String.format("%02x%02x%02x%02x", noune & 0xFFL, noune >> 8 & 0xFFL, noune >> 16 & 0xFFL, noune >> 24 & 0xFFL);
        this._sha1.reset();
        this._sha1.update(sha1_raw.getBytes(this._hub._yctx._deviceCharset));
        return this._sha1.digest();
    }

    private void decodeTCPNotif(String tcpNofif) {
        int pos;
        this._notificationsFifo.append(tcpNofif);
        while ((pos = this._notificationsFifo.indexOf("\n")) >= 0) {
            String line = this._notificationsFifo.substring(0, pos + 1);
            if (line.indexOf(27) == -1) {
                this.handleNetNotification(line);
            }
            this._notificationsFifo.delete(0, pos + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void errorOnSession(int errno, String closeReason) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._connectionState == ConnectionState.DEAD) {
                return;
            }
            this._connectionState = ConnectionState.DEAD;
            if (errno != 0) {
                this._session_errno = errno;
                this._session_error = !closeReason.equals("") ? closeReason : "WebSocket connection has been closed";
            }
            this._stateLock.notifyAll();
        }
        this._wsHandler.close();
        WSRequest fakeRequest = new WSRequest(-8, closeReason);
        try {
            this._pendingRequests.put(fakeRequest);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static enum ConnectionState {
        DEAD,
        DISCONNECTED,
        CONNECTING,
        AUTHENTICATING,
        CONNECTED;

    }
}

