/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WSHandlerInterface;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.MessageHandler;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@ClientEndpoint
public class WSHandlerJEE
implements WSHandlerInterface,
MessageHandler {
    private final boolean _isHttpCallback;
    private final WSHandlerInterface.WSHandlerResponseInterface _nhandler;
    private Session _session;

    WSHandlerJEE(WSHandlerInterface.WSHandlerResponseInterface nhandler, Object session) {
        this._isHttpCallback = session != null;
        this._nhandler = nhandler;
        if (this._isHttpCallback) {
            MessageHandler.Whole<ByteBuffer> messageHandler = new MessageHandler.Whole<ByteBuffer>(){

                public void onMessage(ByteBuffer byteBuffer) {
                    WSHandlerJEE.this._nhandler.parseBinaryMessage(byteBuffer);
                }
            };
            this._session.addMessageHandler((MessageHandler)messageHandler);
        }
    }

    @Override
    public void connect(YHTTPHub hub, boolean first_notification_connection, int mstimeout, int notifAbsPos) throws YAPI_Exception {
        if (!this._isHttpCallback) {
            URI uri;
            WebSocketContainer webSocketContainer = ContainerProvider.getWebSocketContainer();
            String url = hub._http_params.getUrl(true, false) + "/not.byn";
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return;
            }
            try {
                this._session = webSocketContainer.connectToServer((Object)this, uri);
            }
            catch (IOException | DeploymentException e) {
                e.printStackTrace();
                throw new YAPI_Exception(-8, e.getLocalizedMessage());
            }
        }
    }

    @Override
    public void close() {
        try {
            this._session.close();
        }
        catch (IOException | IllegalStateException ignored) {
            ignored.printStackTrace();
        }
    }

    @Override
    public boolean isOpen() {
        return this._session.isOpen();
    }

    @OnOpen
    public void onOpen(Session session) {
        this._session = session;
    }

    @OnMessage
    public void onMessage(ByteBuffer raw_data, Session session) {
        if (this._session != session) {
            return;
        }
        this._nhandler.parseBinaryMessage(raw_data);
    }

    @Override
    public void sendBinary(ByteBuffer partialByte, boolean isLast) throws YAPI_Exception {
        try {
            RemoteEndpoint.Basic remote = this._session.getBasicRemote();
            remote.sendBinary(partialByte, isLast);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new YAPI_Exception(-8, e.getLocalizedMessage());
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        this._nhandler.errorOnSession(-8, closeReason.getReasonPhrase());
    }

    @Override
    public String getThreadLabel() {
        String label = "WS Notification handler session ";
        if (this._session != null) {
            label = label + "(session " + this._session.getId() + ")";
        }
        return label;
    }

    @Override
    public boolean isCallback() {
        return this._isHttpCallback;
    }
}

