/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import java.util.Locale;

public class YPwmOutput
extends YFunction {
    public static final int ENABLED_FALSE = 0;
    public static final int ENABLED_TRUE = 1;
    public static final int ENABLED_INVALID = -1;
    public static final double FREQUENCY_INVALID = -1.79769313486231E308;
    public static final double PERIOD_INVALID = -1.79769313486231E308;
    public static final double DUTYCYCLE_INVALID = -1.79769313486231E308;
    public static final double PULSEDURATION_INVALID = -1.79769313486231E308;
    public static final String PWMTRANSITION_INVALID = "!INVALID!";
    public static final int ENABLEDATPOWERON_FALSE = 0;
    public static final int ENABLEDATPOWERON_TRUE = 1;
    public static final int ENABLEDATPOWERON_INVALID = -1;
    public static final double DUTYCYCLEATPOWERON_INVALID = -1.79769313486231E308;
    protected int _enabled = -1;
    protected double _frequency = -1.79769313486231E308;
    protected double _period = -1.79769313486231E308;
    protected double _dutyCycle = -1.79769313486231E308;
    protected double _pulseDuration = -1.79769313486231E308;
    protected String _pwmTransition = "!INVALID!";
    protected int _enabledAtPowerOn = -1;
    protected double _dutyCycleAtPowerOn = -1.79769313486231E308;
    protected UpdateCallback _valueCallbackPwmOutput = null;

    protected YPwmOutput(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "PwmOutput";
    }

    protected YPwmOutput(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("enabled")) {
            int n = this._enabled = json_val.getInt("enabled") > 0 ? 1 : 0;
        }
        if (json_val.has("frequency")) {
            this._frequency = (double)Math.round(json_val.getDouble("frequency") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("period")) {
            this._period = (double)Math.round(json_val.getDouble("period") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("dutyCycle")) {
            this._dutyCycle = (double)Math.round(json_val.getDouble("dutyCycle") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("pulseDuration")) {
            this._pulseDuration = (double)Math.round(json_val.getDouble("pulseDuration") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("pwmTransition")) {
            this._pwmTransition = json_val.getString("pwmTransition");
        }
        if (json_val.has("enabledAtPowerOn")) {
            int n = this._enabledAtPowerOn = json_val.getInt("enabledAtPowerOn") > 0 ? 1 : 0;
        }
        if (json_val.has("dutyCycleAtPowerOn")) {
            this._dutyCycleAtPowerOn = (double)Math.round(json_val.getDouble("dutyCycleAtPowerOn") * 1000.0 / 65536.0) / 1000.0;
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_enabled() throws YAPI_Exception {
        int res;
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._enabled;
        }
        return res;
    }

    public int getEnabled() throws YAPI_Exception {
        return this.get_enabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_enabled(int newval) throws YAPI_Exception {
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            String rest_val = newval > 0 ? "1" : "0";
            this._setAttr("enabled", rest_val);
        }
        return 0;
    }

    public int setEnabled(int newval) throws YAPI_Exception {
        return this.set_enabled(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_frequency(double newval) throws YAPI_Exception {
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("frequency", rest_val);
        }
        return 0;
    }

    public int setFrequency(double newval) throws YAPI_Exception {
        return this.set_frequency(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_frequency() throws YAPI_Exception {
        double res;
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._frequency;
        }
        return res;
    }

    public double getFrequency() throws YAPI_Exception {
        return this.get_frequency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_period(double newval) throws YAPI_Exception {
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("period", rest_val);
        }
        return 0;
    }

    public int setPeriod(double newval) throws YAPI_Exception {
        return this.set_period(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_period() throws YAPI_Exception {
        double res;
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._period;
        }
        return res;
    }

    public double getPeriod() throws YAPI_Exception {
        return this.get_period();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_dutyCycle(double newval) throws YAPI_Exception {
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("dutyCycle", rest_val);
        }
        return 0;
    }

    public int setDutyCycle(double newval) throws YAPI_Exception {
        return this.set_dutyCycle(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_dutyCycle() throws YAPI_Exception {
        double res;
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._dutyCycle;
        }
        return res;
    }

    public double getDutyCycle() throws YAPI_Exception {
        return this.get_dutyCycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_pulseDuration(double newval) throws YAPI_Exception {
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("pulseDuration", rest_val);
        }
        return 0;
    }

    public int setPulseDuration(double newval) throws YAPI_Exception {
        return this.set_pulseDuration(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_pulseDuration() throws YAPI_Exception {
        double res;
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._pulseDuration;
        }
        return res;
    }

    public double getPulseDuration() throws YAPI_Exception {
        return this.get_pulseDuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_pwmTransition() throws YAPI_Exception {
        String res;
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return PWMTRANSITION_INVALID;
            }
            res = this._pwmTransition;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_pwmTransition(String newval) throws YAPI_Exception {
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            String rest_val = newval;
            this._setAttr("pwmTransition", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_enabledAtPowerOn() throws YAPI_Exception {
        int res;
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._enabledAtPowerOn;
        }
        return res;
    }

    public int getEnabledAtPowerOn() throws YAPI_Exception {
        return this.get_enabledAtPowerOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_enabledAtPowerOn(int newval) throws YAPI_Exception {
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            String rest_val = newval > 0 ? "1" : "0";
            this._setAttr("enabledAtPowerOn", rest_val);
        }
        return 0;
    }

    public int setEnabledAtPowerOn(int newval) throws YAPI_Exception {
        return this.set_enabledAtPowerOn(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_dutyCycleAtPowerOn(double newval) throws YAPI_Exception {
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("dutyCycleAtPowerOn", rest_val);
        }
        return 0;
    }

    public int setDutyCycleAtPowerOn(double newval) throws YAPI_Exception {
        return this.set_dutyCycleAtPowerOn(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_dutyCycleAtPowerOn() throws YAPI_Exception {
        double res;
        YPwmOutput yPwmOutput = this;
        synchronized (yPwmOutput) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._dutyCycleAtPowerOn;
        }
        return res;
    }

    public double getDutyCycleAtPowerOn() throws YAPI_Exception {
        return this.get_dutyCycleAtPowerOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YPwmOutput FindPwmOutput(String func) {
        YPwmOutput obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YPwmOutput)YFunction._FindFromCache("PwmOutput", func);
            if (obj == null) {
                obj = new YPwmOutput(func);
                YFunction._AddToCache("PwmOutput", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YPwmOutput FindPwmOutputInContext(YAPIContext yctx, String func) {
        YPwmOutput obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YPwmOutput)YFunction._FindFromCacheInContext(yctx, "PwmOutput", func);
            if (obj == null) {
                obj = new YPwmOutput(yctx, func);
                YFunction._AddToCache("PwmOutput", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackPwmOutput = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackPwmOutput != null) {
            this._valueCallbackPwmOutput.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int pulseDurationMove(double ms_target, int ms_duration) throws YAPI_Exception {
        if (ms_target < 0.0) {
            ms_target = 0.0;
        }
        String newval = String.format(Locale.US, "%dms:%d", (int)Math.round(ms_target * 65536.0), ms_duration);
        return this.set_pwmTransition(newval);
    }

    public int dutyCycleMove(double target, int ms_duration) throws YAPI_Exception {
        if (target < 0.0) {
            target = 0.0;
        }
        if (target > 100.0) {
            target = 100.0;
        }
        String newval = String.format(Locale.US, "%d:%d", (int)Math.round(target * 65536.0), ms_duration);
        return this.set_pwmTransition(newval);
    }

    public int frequencyMove(double target, int ms_duration) throws YAPI_Exception {
        if (target < 0.001) {
            target = 0.001;
        }
        String newval = String.format(Locale.US, "%fHz:%d", target, ms_duration);
        return this.set_pwmTransition(newval);
    }

    public int phaseMove(double target, int ms_duration) throws YAPI_Exception {
        String newval = String.format(Locale.US, "%fps:%d", target, ms_duration);
        return this.set_pwmTransition(newval);
    }

    public int triggerPulsesByDuration(double ms_target, int n_pulses) throws YAPI_Exception {
        if (ms_target < 0.0) {
            ms_target = 0.0;
        }
        String newval = String.format(Locale.US, "%dms*%d", (int)Math.round(ms_target * 65536.0), n_pulses);
        return this.set_pwmTransition(newval);
    }

    public int triggerPulsesByDutyCycle(double target, int n_pulses) throws YAPI_Exception {
        if (target < 0.0) {
            target = 0.0;
        }
        if (target > 100.0) {
            target = 100.0;
        }
        String newval = String.format(Locale.US, "%d*%d", (int)Math.round(target * 65536.0), n_pulses);
        return this.set_pwmTransition(newval);
    }

    public int triggerPulsesByFrequency(double target, int n_pulses) throws YAPI_Exception {
        if (target < 0.001) {
            target = 0.001;
        }
        String newval = String.format(Locale.US, "%fHz*%d", target, n_pulses);
        return this.set_pwmTransition(newval);
    }

    public int markForRepeat() throws YAPI_Exception {
        return this.set_pwmTransition(":");
    }

    public int repeatFromMark() throws YAPI_Exception {
        return this.set_pwmTransition("R");
    }

    public YPwmOutput nextPwmOutput() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YPwmOutput.FindPwmOutputInContext(this._yapi, next_hwid);
    }

    public static YPwmOutput FirstPwmOutput() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("PwmOutput");
        if (next_hwid == null) {
            return null;
        }
        return YPwmOutput.FindPwmOutputInContext(yctx, next_hwid);
    }

    public static YPwmOutput FirstPwmOutputInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("PwmOutput");
        if (next_hwid == null) {
            return null;
        }
        return YPwmOutput.FindPwmOutputInContext(yctx, next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YPwmOutput var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YPwmOutput var1, String var2);
    }
}

