/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import org.json.JSONException;
import org.json.JSONObject;

public class YWakeUpMonitor
extends YFunction {
    public static final int POWERDURATION_INVALID = Integer.MIN_VALUE;
    public static final int SLEEPCOUNTDOWN_INVALID = Integer.MIN_VALUE;
    public static final long NEXTWAKEUP_INVALID = -9223372036854775807L;
    public static final int WAKEUPREASON_USBPOWER = 0;
    public static final int WAKEUPREASON_EXTPOWER = 1;
    public static final int WAKEUPREASON_ENDOFSLEEP = 2;
    public static final int WAKEUPREASON_EXTSIG1 = 3;
    public static final int WAKEUPREASON_SCHEDULE1 = 4;
    public static final int WAKEUPREASON_SCHEDULE2 = 5;
    public static final int WAKEUPREASON_INVALID = -1;
    public static final int WAKEUPSTATE_SLEEPING = 0;
    public static final int WAKEUPSTATE_AWAKE = 1;
    public static final int WAKEUPSTATE_INVALID = -1;
    public static final long RTCTIME_INVALID = -9223372036854775807L;
    protected int _powerDuration = Integer.MIN_VALUE;
    protected int _sleepCountdown = Integer.MIN_VALUE;
    protected long _nextWakeUp = -9223372036854775807L;
    protected int _wakeUpReason = -1;
    protected int _wakeUpState = -1;
    protected long _rtcTime = -9223372036854775807L;
    public static final int _endOfTime = 2145960000;
    protected UpdateCallback _valueCallbackWakeUpMonitor = null;

    protected YWakeUpMonitor(String func) {
        super(func);
        this._className = "WakeUpMonitor";
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("powerDuration")) {
            this._powerDuration = json_val.getInt("powerDuration");
        }
        if (json_val.has("sleepCountdown")) {
            this._sleepCountdown = json_val.getInt("sleepCountdown");
        }
        if (json_val.has("nextWakeUp")) {
            this._nextWakeUp = json_val.getLong("nextWakeUp");
        }
        if (json_val.has("wakeUpReason")) {
            this._wakeUpReason = json_val.getInt("wakeUpReason");
        }
        if (json_val.has("wakeUpState")) {
            this._wakeUpState = json_val.getInt("wakeUpState");
        }
        if (json_val.has("rtcTime")) {
            this._rtcTime = json_val.getLong("rtcTime");
        }
        super._parseAttr(json_val);
    }

    public int get_powerDuration() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return Integer.MIN_VALUE;
        }
        return this._powerDuration;
    }

    public int getPowerDuration() throws YAPI_Exception {
        return this.get_powerDuration();
    }

    public int set_powerDuration(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("powerDuration", rest_val);
        return 0;
    }

    public int setPowerDuration(int newval) throws YAPI_Exception {
        return this.set_powerDuration(newval);
    }

    public int get_sleepCountdown() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return Integer.MIN_VALUE;
        }
        return this._sleepCountdown;
    }

    public int getSleepCountdown() throws YAPI_Exception {
        return this.get_sleepCountdown();
    }

    public int set_sleepCountdown(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("sleepCountdown", rest_val);
        return 0;
    }

    public int setSleepCountdown(int newval) throws YAPI_Exception {
        return this.set_sleepCountdown(newval);
    }

    public long get_nextWakeUp() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -9223372036854775807L;
        }
        return this._nextWakeUp;
    }

    public long getNextWakeUp() throws YAPI_Exception {
        return this.get_nextWakeUp();
    }

    public int set_nextWakeUp(long newval) throws YAPI_Exception {
        String rest_val = Long.toString(newval);
        this._setAttr("nextWakeUp", rest_val);
        return 0;
    }

    public int setNextWakeUp(long newval) throws YAPI_Exception {
        return this.set_nextWakeUp(newval);
    }

    public int get_wakeUpReason() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._wakeUpReason;
    }

    public int getWakeUpReason() throws YAPI_Exception {
        return this.get_wakeUpReason();
    }

    public int get_wakeUpState() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._wakeUpState;
    }

    public int getWakeUpState() throws YAPI_Exception {
        return this.get_wakeUpState();
    }

    public int set_wakeUpState(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("wakeUpState", rest_val);
        return 0;
    }

    public int setWakeUpState(int newval) throws YAPI_Exception {
        return this.set_wakeUpState(newval);
    }

    public long get_rtcTime() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -9223372036854775807L;
        }
        return this._rtcTime;
    }

    public long getRtcTime() throws YAPI_Exception {
        return this.get_rtcTime();
    }

    public static YWakeUpMonitor FindWakeUpMonitor(String func) {
        YWakeUpMonitor obj = (YWakeUpMonitor)YFunction._FindFromCache("WakeUpMonitor", func);
        if (obj == null) {
            obj = new YWakeUpMonitor(func);
            YFunction._AddToCache("WakeUpMonitor", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackWakeUpMonitor = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackWakeUpMonitor != null) {
            this._valueCallbackWakeUpMonitor.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int wakeUp() throws YAPI_Exception {
        return this.set_wakeUpState(1);
    }

    public int sleep(int secBeforeSleep) throws YAPI_Exception {
        int currTime = (int)this.get_rtcTime();
        if (currTime == 0) {
            throw new YAPI_Exception(-13, "RTC time not set");
        }
        this.set_nextWakeUp(2145960000L);
        this.set_sleepCountdown(secBeforeSleep);
        return 0;
    }

    public int sleepFor(int secUntilWakeUp, int secBeforeSleep) throws YAPI_Exception {
        int currTime = (int)this.get_rtcTime();
        if (currTime == 0) {
            throw new YAPI_Exception(-13, "RTC time not set");
        }
        this.set_nextWakeUp(currTime + secUntilWakeUp);
        this.set_sleepCountdown(secBeforeSleep);
        return 0;
    }

    public int sleepUntil(int wakeUpTime, int secBeforeSleep) throws YAPI_Exception {
        int currTime = (int)this.get_rtcTime();
        if (currTime == 0) {
            throw new YAPI_Exception(-13, "RTC time not set");
        }
        this.set_nextWakeUp(wakeUpTime);
        this.set_sleepCountdown(secBeforeSleep);
        return 0;
    }

    public int resetSleepCountDown() throws YAPI_Exception {
        this.set_sleepCountdown(0);
        this.set_nextWakeUp(0L);
        return 0;
    }

    public YWakeUpMonitor nextWakeUpMonitor() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YWakeUpMonitor.FindWakeUpMonitor(next_hwid);
    }

    public static YWakeUpMonitor FirstWakeUpMonitor() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("WakeUpMonitor");
        if (next_hwid == null) {
            return null;
        }
        return YWakeUpMonitor.FindWakeUpMonitor(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YWakeUpMonitor var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YWakeUpMonitor var1, String var2);
    }
}

