/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSensor;
import org.json.JSONException;
import org.json.JSONObject;

public class YPower
extends YSensor {
    public static final double COSPHI_INVALID = -1.79769313486231E308;
    public static final double METER_INVALID = -1.79769313486231E308;
    public static final int METERTIMER_INVALID = -1;
    protected double _cosPhi = -1.79769313486231E308;
    protected double _meter = -1.79769313486231E308;
    protected int _meterTimer = -1;
    protected UpdateCallback _valueCallbackPower = null;
    protected TimedReportCallback _timedReportCallbackPower = null;

    protected YPower(String func) {
        super(func);
        this._className = "Power";
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("cosPhi")) {
            this._cosPhi = (double)Math.round(json_val.getDouble("cosPhi") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("meter")) {
            this._meter = (double)Math.round(json_val.getDouble("meter") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("meterTimer")) {
            this._meterTimer = json_val.getInt("meterTimer");
        }
        super._parseAttr(json_val);
    }

    public double get_cosPhi() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._cosPhi;
    }

    public double getCosPhi() throws YAPI_Exception {
        return this.get_cosPhi();
    }

    public int set_meter(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("meter", rest_val);
        return 0;
    }

    public int setMeter(double newval) throws YAPI_Exception {
        return this.set_meter(newval);
    }

    public double get_meter() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._meter;
    }

    public double getMeter() throws YAPI_Exception {
        return this.get_meter();
    }

    public int get_meterTimer() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._meterTimer;
    }

    public int getMeterTimer() throws YAPI_Exception {
        return this.get_meterTimer();
    }

    public static YPower FindPower(String func) {
        YPower obj = (YPower)YFunction._FindFromCache("Power", func);
        if (obj == null) {
            obj = new YPower(func);
            YFunction._AddToCache("Power", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackPower = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackPower != null) {
            this._valueCallbackPower.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(this, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(this, false);
        }
        this._timedReportCallbackPower = callback;
        return 0;
    }

    @Override
    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackPower != null) {
            this._timedReportCallbackPower.timedReportCallback(this, value);
        } else {
            super._invokeTimedReportCallback(value);
        }
        return 0;
    }

    public int reset() throws YAPI_Exception {
        return this.set_meter(0.0);
    }

    public YPower nextPower() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YPower.FindPower(next_hwid);
    }

    public static YPower FirstPower() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Power");
        if (next_hwid == null) {
            return null;
        }
        return YPower.FindPower(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YPower var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YPower var1, String var2);
    }
}

