/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareFile;
import com.yoctopuce.YoctoAPI.YFunctionType;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YPEntry;
import com.yoctopuce.YoctoAPI.yHTTPRequest;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class YHTTPHub
extends YGenericHub {
    private static final char NOTIFY_NETPKT_NAME = '0';
    private static final char NOTIFY_NETPKT_CHILD = '2';
    private static final char NOTIFY_NETPKT_FUNCNAME = '4';
    private static final char NOTIFY_NETPKT_FUNCVAL = '5';
    private static final char NOTIFY_NETPKT_LOG = '7';
    private static final char NOTIFY_NETPKT_FUNCNAMEYDX = '8';
    private static final char NOTIFY_NETPKT_FLUSHV2YDX = 't';
    private static final char NOTIFY_NETPKT_FUNCV2YDX = 'u';
    private static final char NOTIFY_NETPKT_TIMEV2YDX = 'v';
    private static final char NOTIFY_NETPKT_DEVLOGYDX = 'w';
    private static final char NOTIFY_NETPKT_TIMEVALYDX = 'x';
    private static final char NOTIFY_NETPKT_FUNCVALYDX = 'y';
    private static final char NOTIFY_NETPKT_TIMEAVGYDX = 'z';
    private static final char NOTIFY_NETPKT_NOT_SYNC = '@';
    private static final long YPROG_BOOTLOADER_TIMEOUT = 10000L;
    private static final int NOTIFY_NETPKT_STOP = 10;
    private NotificationHandler _notificationHandler;
    private Thread _thread;
    private final Object _authLock = new Object();
    private final YGenericHub.HTTPParams _http_params;
    private String _http_realm = "";
    private String _nounce = "";
    private String _serial = "";
    private int _nounce_count = 0;
    private String _ha1 = "";
    private String _opaque = "";
    private Random _randGen = new Random();
    private MessageDigest mdigest;
    private int _authRetryCount = 0;
    private boolean _writeProtected = false;
    private HashMap<YDevice, yHTTPRequest> _httpReqByDev = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needRetryWithAuth() {
        Object object = this._authLock;
        synchronized (object) {
            return this._http_params.geUser().length() != 0 && this._http_params.getPass().length() != 0 && this._authRetryCount++ <= 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authSucceded() {
        Object object = this._authLock;
        synchronized (object) {
            this._authRetryCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseWWWAuthenticate(String header) {
        Object object = this._authLock;
        synchronized (object) {
            String[] tags;
            int pos = header.indexOf("\r\nWWW-Authenticate:");
            if (pos == -1) {
                return;
            }
            int eol = (header = header.substring(pos + 19)).indexOf(13);
            if (eol >= 0) {
                header = header.substring(0, eol);
            }
            this._http_realm = "";
            this._nounce = "";
            this._opaque = "";
            this._nounce_count = 0;
            for (String tag : tags = header.split(" ")) {
                String value;
                String name;
                String[] parts = tag.split("[=\",]");
                if (parts.length == 2) {
                    name = parts[0];
                    value = parts[1];
                } else {
                    if (parts.length != 3) continue;
                    name = parts[0];
                    value = parts[2];
                }
                if (name.equals("realm")) {
                    this._http_realm = value;
                    continue;
                }
                if (name.equals("nonce")) {
                    this._nounce = value;
                    continue;
                }
                if (!name.equals("opaque")) continue;
                this._opaque = value;
            }
            String plaintext = this._http_params.geUser() + ":" + this._http_realm + ":" + this._http_params.getPass();
            this.mdigest.reset();
            this.mdigest.update(plaintext.getBytes());
            byte[] digest = this.mdigest.digest();
            this._ha1 = YAPI._bytesToHexStr(digest, 0, digest.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAuthorization(String request) throws YAPI_Exception {
        Object object = this._authLock;
        synchronized (object) {
            if (this._http_params.geUser().length() == 0 || this._http_realm.length() == 0) {
                return "";
            }
            ++this._nounce_count;
            int pos = request.indexOf(32);
            String method = request.substring(0, pos);
            int enduri = request.indexOf(32, pos + 1);
            if (enduri < 0) {
                enduri = request.length();
            }
            String uri = request.substring(pos + 1, enduri);
            String nc = String.format("%08x", this._nounce_count);
            String cnonce = String.format("%08x", this._randGen.nextInt());
            String plaintext = method + ":" + uri;
            this.mdigest.reset();
            this.mdigest.update(plaintext.getBytes());
            byte[] digest = this.mdigest.digest();
            String ha2 = YAPI._bytesToHexStr(digest, 0, digest.length);
            plaintext = this._ha1 + ":" + this._nounce + ":" + nc + ":" + cnonce + ":auth:" + ha2;
            this.mdigest.reset();
            this.mdigest.update(plaintext.getBytes());
            digest = this.mdigest.digest();
            String response = YAPI._bytesToHexStr(digest, 0, digest.length);
            return String.format("Authorization: Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", qop=auth, nc=%s, cnonce=\"%s\", response=\"%s\", opaque=\"%s\"\r\n", this._http_params.geUser(), this._http_realm, this._nounce, uri, nc, cnonce, response, this._opaque);
        }
    }

    YHTTPHub(int idx, YGenericHub.HTTPParams httpParams, boolean reportConnnectionLost) throws YAPI_Exception {
        super(idx, reportConnnectionLost);
        this._http_params = httpParams;
        try {
            this.mdigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new YAPI_Exception(-3, "No MD5 provider");
        }
    }

    synchronized String getSerialFromYDX(int devydx) {
        if (this._serialByYdx.containsKey(devydx)) {
            return (String)this._serialByYdx.get(devydx);
        }
        return null;
    }

    @Override
    synchronized void startNotifications() throws YAPI_Exception {
        if (this._notificationHandler != null) {
            throw new YAPI_Exception(-2, "notification already started");
        }
        this._notificationHandler = new NotificationHandler();
        this._thread = new Thread((Runnable)this._notificationHandler, "Notification handler for " + this.getHost());
        this._thread.start();
    }

    @Override
    synchronized void stopNotifications() {
        if (this._notificationHandler != null) {
            this._thread.interrupt();
            this._notificationHandler.killNetworkIO();
            try {
                this._thread.join(10000L);
            }
            catch (InterruptedException e) {
                this._thread = null;
                this._notificationHandler = null;
            }
        }
    }

    @Override
    synchronized void release() {
        for (yHTTPRequest req : this._httpReqByDev.values()) {
            req.WaitRequestEnd();
        }
        this._httpReqByDev = null;
    }

    @Override
    String getRootUrl() {
        return this._http_params.getUrl();
    }

    @Override
    synchronized boolean isSameRootUrl(String url) {
        YGenericHub.HTTPParams params = new YGenericHub.HTTPParams(url);
        return params.getUrl().equals(this._http_params.getUrl());
    }

    @Override
    synchronized void updateDeviceList(boolean forceupdate) throws YAPI_Exception {
        String yreq;
        long now = YAPI.GetTickCount();
        if (forceupdate) {
            this._devListExpires = 0L;
        }
        if (this._devListExpires > now) {
            return;
        }
        if (this._notificationHandler.disconectionDetetcted()) {
            if (this._reportConnnectionLost) {
                throw new YAPI_Exception(-7, "hub " + this._http_params.getUrl() + " is not reachable");
            }
            return;
        }
        yHTTPRequest req = new yHTTPRequest(this, "updateDeviceList " + this._http_params.getHost());
        try {
            yreq = new String(req.RequestSync("GET /api.json", null));
        }
        catch (YAPI_Exception ex) {
            if (this._reportConnnectionLost) {
                throw ex;
            }
            return;
        }
        HashMap<String, ArrayList<YPEntry>> yellowPages = new HashMap<String, ArrayList<YPEntry>>();
        ArrayList<WPEntry> whitePages = new ArrayList<WPEntry>();
        try {
            JSONObject loadval = new JSONObject(yreq);
            if (!loadval.has("services") || !loadval.getJSONObject("services").has("whitePages")) {
                throw new YAPI_Exception(-2, "Device " + this._http_params.getHost() + " is not a hub");
            }
            this._serial = loadval.getJSONObject("module").getString("serialNumber");
            JSONArray whitePages_json = loadval.getJSONObject("services").getJSONArray("whitePages");
            JSONObject yellowPages_json = loadval.getJSONObject("services").getJSONObject("yellowPages");
            if (loadval.has("network")) {
                String adminpass = loadval.getJSONObject("network").getString("adminPassword");
                this._writeProtected = adminpass.length() > 0;
            }
            Iterator keys = yellowPages_json.keys();
            while (keys.hasNext()) {
                String classname = keys.next().toString();
                YFunctionType ftype = YAPI.SafeYAPI().getFnByType(classname);
                JSONArray yprecs_json = yellowPages_json.getJSONArray(classname);
                ArrayList<YPEntry> yprecs_arr = new ArrayList<YPEntry>(yprecs_json.length());
                for (int i = 0; i < yprecs_json.length(); ++i) {
                    YPEntry yprec = new YPEntry(yprecs_json.getJSONObject(i));
                    yprecs_arr.add(yprec);
                    ftype.reindexFunction(yprec);
                }
                yellowPages.put(classname, yprecs_arr);
            }
            this._serialByYdx.clear();
            for (int i = 0; i < whitePages_json.length(); ++i) {
                WPEntry devinfo = new WPEntry(whitePages_json.getJSONObject(i));
                this._serialByYdx.put(devinfo.getIndex(), devinfo.getSerialNumber());
                whitePages.add(devinfo);
            }
        }
        catch (JSONException e) {
            throw new YAPI_Exception(-8, "Request failed, could not parse API result for " + this._http_params.getHost(), e);
        }
        this.updateFromWpAndYp(whitePages, yellowPages);
        now = YAPI.GetTickCount();
        this._devListExpires = now + this._devListValidity;
    }

    @Override
    ArrayList<String> firmwareUpdate(String serial, YFirmwareFile firmware, byte[] settings, YGenericHub.UpdateProgress progress) throws YAPI_Exception, InterruptedException {
        boolean use_self_flash = false;
        String baseurl = "";
        boolean need_reboot = true;
        yHTTPRequest req = new yHTTPRequest(this, "hubFUpdate" + serial);
        if (serial.equals(this._serial) && !this._serial.startsWith("VIRTHUB")) {
            use_self_flash = true;
        } else {
            try {
                req.RequestSync("GET /bySerial/" + serial + "/flash.json?a=state", null);
                baseurl = "/bySerial/" + serial;
                use_self_flash = true;
            }
            catch (YAPI_Exception ex) {
                // empty catch block
            }
        }
        progress.firmware_progress(5, "Enter in bootloader");
        ArrayList<String> bootloaders = this.getBootloaders();
        if (bootloaders.size() >= 4) {
            throw new YAPI_Exception(-8, "Too many devices in update mode");
        }
        boolean is_shield = serial.startsWith("YHUBSHL1");
        for (String bl : bootloaders) {
            if (bl.equals(serial)) {
                need_reboot = false;
                continue;
            }
            if (!is_shield || !bl.startsWith("YHUBSHL1")) continue;
            throw new YAPI_Exception(-8, "Only one YoctoHub-Shield is allowed in update mode");
        }
        if (!use_self_flash && need_reboot) {
            req.RequestSync("GET /bySerial/" + serial + "/api/module/rebootCountdown?rebootCountdown=-1", null);
        }
        progress.firmware_progress(10, "Send firmware to bootloader");
        byte[] head_body = YDevice.formatHTTPUpload("firmware", firmware.getData());
        req.RequestSync("POST " + baseurl + "/upload.html", head_body);
        byte[] bytes = req.RequestSync("GET " + baseurl + "/flash.json?a=state", null);
        String uploadresstr = new String(bytes);
        try {
            JSONObject uploadres = new JSONObject(uploadresstr);
            if (!uploadres.getString("state").equals("valid")) {
                throw new YAPI_Exception(-8, "Upload of firmware failed: invalid firmware(" + uploadres.getString("state") + ")");
            }
            if (uploadres.getInt("progress") != 100) {
                throw new YAPI_Exception(-8, "Upload of firmware failed: incomplete upload");
            }
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, "invalid json response :" + ex.getLocalizedMessage());
        }
        if (use_self_flash) {
            progress.firmware_progress(20, "Upload startupConf.json");
            head_body = YDevice.formatHTTPUpload("startupConf.json", settings);
            req.RequestSync("POST " + baseurl + "/upload.html", head_body);
            progress.firmware_progress(20, "Upload firmwareConf");
            head_body = YDevice.formatHTTPUpload("firmwareConf", settings);
            req.RequestSync("POST " + baseurl + "/upload.html", head_body);
        }
        if (!use_self_flash) {
            long timeout = YAPI.GetTickCount() + 10000L;
            boolean found = false;
            progress.firmware_progress(40, "Wait for device to be in bootloader");
            do {
                ArrayList<String> list = this.getBootloaders();
                for (String bl : list) {
                    if (!bl.equals(serial)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Thread.sleep(100L);
            } while (!found && YAPI.GetTickCount() < timeout);
            progress.firmware_progress(45, "Flash firmware");
            byte[] res = req.RequestSync("GET /flash.json?a=flash&s=" + serial, null);
            try {
                String jsonstr = new String(res);
                JSONObject flashres = new JSONObject(jsonstr);
                JSONArray list = flashres.getJSONArray("logs");
                ArrayList<String> logs = new ArrayList<String>(list.length());
                for (int i = 0; i < list.length(); ++i) {
                    logs.add(list.getString(i));
                }
                return logs;
            }
            catch (JSONException ex) {
                throw new YAPI_Exception(-8, "invalid response");
            }
        }
        progress.firmware_progress(40, "Flash firmware");
        req.RequestSync("GET " + baseurl + "/api/module/rebootCountdown?rebootCountdown=-1003", null);
        Thread.sleep(7000L);
        return null;
    }

    @Override
    synchronized void devRequestAsync(YDevice device, String req_first_line, byte[] req_head_and_body, YGenericHub.RequestAsyncResult asyncResult, Object asyncContext) throws YAPI_Exception {
        if (this._notificationHandler.disconectionDetetcted()) {
            throw new YAPI_Exception(-7, "hub " + this._http_params.getUrl() + " is not reachable");
        }
        if (!this._httpReqByDev.containsKey(device)) {
            this._httpReqByDev.put(device, new yHTTPRequest(this, "Device " + device.getSerialNumber()));
        }
        yHTTPRequest req = this._httpReqByDev.get(device);
        if (this._writeProtected && !this._http_params.geUser().equals("admin")) {
            throw new YAPI_Exception(-12, "Access denied: admin credentials required");
        }
        req.RequestAsync(req_first_line, req_head_and_body, asyncResult, asyncContext);
    }

    @Override
    synchronized byte[] devRequestSync(YDevice device, String req_first_line, byte[] req_head_and_body) throws YAPI_Exception {
        if (this._notificationHandler.disconectionDetetcted()) {
            throw new YAPI_Exception(-7, "hub " + this._http_params.getUrl() + " is not reachable");
        }
        if (!this._httpReqByDev.containsKey(device)) {
            this._httpReqByDev.put(device, new yHTTPRequest(this, "Device " + device.getSerialNumber()));
        }
        yHTTPRequest req = this._httpReqByDev.get(device);
        return req.RequestSync(req_first_line, req_head_and_body);
    }

    String getHost() {
        return this._http_params.getHost();
    }

    int getPort() {
        return this._http_params.getPort();
    }

    @Override
    public ArrayList<String> getBootloaders() throws YAPI_Exception {
        ArrayList<String> res = new ArrayList<String>();
        yHTTPRequest req = new yHTTPRequest(this, "getBootloaders");
        byte[] raw_data = req.RequestSync("GET /flash.json?a=list", null);
        String jsonstr = new String(raw_data);
        try {
            JSONObject flashres = new JSONObject(jsonstr);
            JSONArray list = flashres.getJSONArray("list");
            for (int i = 0; i < list.length(); ++i) {
                res.add(list.getString(i));
            }
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, "Unable to retrieve bootloader list");
        }
        return res;
    }

    private class NotificationHandler
    implements Runnable {
        private static final int NET_HUB_NOT_CONNECTION_TIMEOUT = 6000;
        private long _notifyPos = -1L;
        private int _notifRetryCount = 0;
        private volatile boolean _sendPingNotification = false;
        private volatile boolean _connected = false;
        private int _error_delay = 0;
        private yHTTPRequest _yreq;

        private NotificationHandler() {
        }

        boolean disconectionDetetcted() {
            return this._sendPingNotification && !this._connected;
        }

        private byte[] decodeNetFuncValV2(byte[] p) {
            int newCh;
            int p_ofs = 0;
            int ch = p[p_ofs] & 0xFF;
            byte[] funcVal = new byte[7];
            Arrays.fill(funcVal, (byte)0);
            if (ch < 32 || ch > 159) {
                return null;
            }
            funcVal[0] = (byte)(((ch -= 32) & 0x40) != 0 ? 1 : 2);
            ch &= 0x3F;
            for (int len = 0; len < 6 && ++p_ofs < p.length && (newCh = p[p_ofs] & 0xFF) != 10; ++len) {
                if (newCh < 32 || newCh > 159) {
                    return null;
                }
                ch = (ch << 7) + (newCh -= 32);
                funcVal[len + 1] = (byte)(ch >> 5 - len);
            }
            return funcVal;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void handleNetNotification(String notification_line) {
            String ev = notification_line.trim();
            if (ev.length() >= 3 && ev.charAt(0) >= 't' && ev.charAt(0) <= 'z') {
                YDevice ydev;
                YHTTPHub.this._devListValidity = 10000L;
                this._notifRetryCount = 0;
                if (this._notifyPos >= 0L) {
                    this._notifyPos += (long)(ev.length() + 1);
                }
                int devydx = ev.charAt(1) - 65;
                int funydx = ev.charAt(2) - 48;
                if ((funydx & 0x40) != 0) {
                    funydx -= 64;
                    devydx += 128;
                }
                String value = ev.substring(3);
                String serial = YHTTPHub.this.getSerialFromYDX(devydx);
                if (serial == null || (ydev = YAPI.SafeYAPI().getDevice(serial)) == null) return;
                switch (ev.charAt(0)) {
                    case 'y': {
                        String funcid = ydev.getYPEntry(funydx).getFuncId();
                        if (funcid.equals("")) return;
                        YAPI.SafeYAPI().setFunctionValue(serial + "." + funcid, value);
                        return;
                    }
                    case 'w': {
                        ydev.triggerLogPull();
                        return;
                    }
                    case 'v': 
                    case 'x': 
                    case 'z': {
                        if (funydx == 15) {
                            Integer[] data = new Integer[5];
                            for (int i = 0; i < 5; ++i) {
                                String part = value.substring(i * 2, i * 2 + 2);
                                data[i] = Integer.parseInt(part, 16);
                            }
                            ydev.setDeviceTime(data);
                            return;
                        }
                        String funcid = ydev.getYPEntry(funydx).getFuncId();
                        if (funcid.equals("")) return;
                        ArrayList<Integer> report = new ArrayList<Integer>(1 + value.length() / 2);
                        report.add(ev.charAt(0) == 'x' ? 0 : (ev.charAt(0) == 'z' ? 1 : 2));
                        for (int pos = 0; pos < value.length(); pos += 2) {
                            int intval = Integer.parseInt(value.substring(pos, pos + 2), 16);
                            report.add(intval);
                        }
                        YAPI.SafeYAPI().setTimedReport(serial + "." + funcid, ydev.getDeviceTime(), report);
                        return;
                    }
                    case 'u': {
                        String funcid = ydev.getYPEntry(funydx).getFuncId();
                        if (funcid.equals("")) return;
                        byte[] rawval = this.decodeNetFuncValV2(value.getBytes());
                        if (rawval == null) return;
                        String decodedval = YGenericHub.decodePubVal(rawval[0], rawval, 1, 6);
                        YAPI.SafeYAPI().setFunctionValue(serial + "." + funcid, decodedval);
                        return;
                    }
                }
                return;
            } else if (ev.length() >= 5 && ev.startsWith("YN01")) {
                char notype;
                YHTTPHub.this._devListValidity = 10000L;
                this._notifRetryCount = 0;
                if (this._notifyPos >= 0L) {
                    this._notifyPos += (long)(ev.length() + 1);
                }
                if ((notype = ev.charAt(4)) == '@') {
                    this._notifyPos = Integer.valueOf(ev.substring(5)).intValue();
                    return;
                } else {
                    switch (notype) {
                        case '0': 
                        case '2': 
                        case '4': 
                        case '8': {
                            YHTTPHub.this._devListExpires = 0L;
                            return;
                        }
                        case '5': {
                            String[] parts = ev.substring(5).split(",");
                            YAPI.SafeYAPI().setFunctionValue(parts[0] + "." + parts[1], parts[2]);
                        }
                    }
                }
                return;
            } else {
                YHTTPHub.this._devListValidity = 500L;
                this._notifyPos = -1L;
            }
        }

        @Override
        public void run() {
            this._yreq = new yHTTPRequest(YHTTPHub.this, "Notification of " + YHTTPHub.this._http_params.getHost());
            while (!Thread.currentThread().isInterrupted()) {
                if (this._error_delay > 0) {
                    try {
                        Thread.sleep(this._error_delay);
                    }
                    catch (InterruptedException ex) {
                        this._connected = false;
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                try {
                    this._yreq._requestReserve();
                    String notUrl = this._notifyPos < 0L ? "GET /not.byn" : String.format("GET /not.byn?abs=%d", this._notifyPos);
                    this._yreq._requestStart(notUrl, null, null, null);
                    this._connected = true;
                    String fifo = "";
                    do {
                        int pos;
                        this._yreq._requestProcesss();
                        byte[] partial = this._yreq.getPartialResult();
                        if (partial != null) {
                            fifo = fifo + new String(partial);
                        }
                        while ((pos = fifo.indexOf("\n")) >= 0) {
                            if (pos == 0 && !this._sendPingNotification) {
                                try {
                                    this._yreq.setNoTrafficTimeout(6000);
                                    this._sendPingNotification = true;
                                }
                                catch (SocketException ex) {
                                    Logger.getLogger(YHTTPHub.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            } else {
                                String line = fifo.substring(0, pos + 1);
                                if (line.indexOf(27) == -1) {
                                    this.handleNetNotification(line);
                                }
                            }
                            fifo = fifo.substring(pos + 1);
                            if (pos >= 0) continue;
                        }
                        this._error_delay = 0;
                    } while (!Thread.currentThread().isInterrupted());
                    this._yreq._requestStop();
                    this._yreq._requestRelease();
                }
                catch (YAPI_Exception ex) {
                    this._connected = false;
                    this._yreq._requestStop();
                    this._yreq._requestRelease();
                    ++this._notifRetryCount;
                    YHTTPHub.this._devListValidity = 500L;
                    this._error_delay = 100 << (this._notifRetryCount > 4 ? 4 : this._notifRetryCount);
                }
            }
            this._yreq._requestStop();
            this._yreq._requestRelease();
        }

        public void killNetworkIO() {
            if (this._yreq != null) {
                this._yreq.kill();
            }
        }
    }
}

