/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareFile;
import com.yoctopuce.YoctoAPI.YPEntry;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;

abstract class YGenericHub {
    protected static final int NOTIFY_V2_LEGACY = 0;
    protected static final int NOTIFY_V2_6RAWBYTES = 1;
    protected static final int NOTIFY_V2_TYPEDDATA = 2;
    protected static final int NOTIFY_V2_FLUSHGROUP = 3;
    private static final int PUBVAL_LEGACY = 0;
    private static final int PUBVAL_1RAWBYTE = 1;
    private static final int PUBVAL_2RAWBYTES = 2;
    private static final int PUBVAL_3RAWBYTES = 3;
    private static final int PUBVAL_4RAWBYTES = 4;
    private static final int PUBVAL_5RAWBYTES = 5;
    private static final int PUBVAL_6RAWBYTES = 6;
    private static final int PUBVAL_C_LONG = 7;
    private static final int PUBVAL_C_FLOAT = 8;
    private static final int PUBVAL_YOCTO_FLOAT_E3 = 9;
    private static final int PUBVAL_YOCTO_FLOAT_E6 = 10;
    protected int _hubidx;
    protected long _notifyTrigger = 0L;
    protected Object _notifyHandle = null;
    protected volatile long _devListValidity = 500L;
    protected long _devListExpires = 0L;
    protected HashMap<Integer, String> _serialByYdx = new HashMap();
    protected HashMap<String, YDevice> _devices = new HashMap();
    protected final boolean _reportConnnectionLost;

    public YGenericHub(int idx, boolean reportConnnectionLost) {
        this._hubidx = idx;
        this._reportConnnectionLost = reportConnnectionLost;
    }

    abstract void release();

    abstract String getRootUrl();

    abstract boolean isSameRootUrl(String var1);

    abstract void startNotifications() throws YAPI_Exception;

    abstract void stopNotifications();

    static String decodePubVal(int typeV2, byte[] funcval, int ofs, int funcvallen) {
        int len;
        String buffer = "";
        if (typeV2 == 1 || typeV2 == 2) {
            int funcValType = typeV2 == 1 ? 6 : funcval[ofs++] & 0xFF;
            switch (funcValType) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    for (int i = 0; i < funcValType; ++i) {
                        int c = funcval[ofs++] & 0xFF;
                        int b = c >> 4;
                        buffer = buffer + (b > 9 ? b + 97 - 10 : b + 48);
                        b = c & 0xF;
                        buffer = buffer + (b > 9 ? b + 97 - 10 : b + 48);
                    }
                    return buffer;
                }
                case 7: 
                case 9: {
                    int endp;
                    int numVal = funcval[ofs++] & 0xFF;
                    numVal += (funcval[ofs++] & 0xFF) << 8;
                    numVal += (funcval[ofs++] & 0xFF) << 16;
                    numVal += (funcval[ofs++] & 0xFF) << 24;
                    if (funcValType == 7) {
                        return String.format("%d", numVal);
                    }
                    buffer = String.format("%.3f", (double)numVal / 1000.0);
                    for (endp = buffer.length(); endp > 0 && buffer.charAt(endp - 1) == '0'; --endp) {
                    }
                    if (endp > 0 && buffer.charAt(endp - 1) == '.') {
                        --endp;
                    }
                    return buffer.substring(0, endp);
                }
                case 8: {
                    int endp;
                    float floatVal = ByteBuffer.wrap(funcval).order(ByteOrder.LITTLE_ENDIAN).getFloat();
                    buffer = String.format("%.6f", Float.valueOf(floatVal));
                    for (endp = buffer.length(); endp > 0 && buffer.charAt(endp - 1) == '0'; --endp) {
                    }
                    if (endp > 0 && buffer.charAt(endp - 1) == '.') {
                        --endp;
                    }
                    return buffer.substring(0, endp);
                }
                default: {
                    return "?";
                }
            }
        }
        for (len = 0; len < 6 && len < funcvallen && funcval[len] != 0; ++len) {
        }
        return new String(funcval, 0, len);
    }

    protected void updateFromWpAndYp(ArrayList<WPEntry> whitePages, HashMap<String, ArrayList<YPEntry>> yellowPages) throws YAPI_Exception {
        String serial;
        ArrayList<YDevice> toRemove = new ArrayList<YDevice>(this._devices.values());
        for (WPEntry wp : whitePages) {
            serial = wp.getSerialNumber();
            if (this._devices.containsKey(serial)) {
                YDevice currdev = this._devices.get(serial);
                if (!currdev.getLogicalName().equals(wp.getLogicalName())) {
                    currdev.refresh();
                    YAPI.SafeYAPI().pushPlugEvent(YAPI.PlugEvent.Event.CHANGE, serial);
                } else if (currdev.getBeacon() > 0 != wp.getBeacon() > 0) {
                    currdev.refresh();
                }
                toRemove.remove(currdev);
                continue;
            }
            YDevice dev = new YDevice(this, wp, yellowPages);
            this._devices.put(serial, dev);
            YAPI.SafeYAPI().pushPlugEvent(YAPI.PlugEvent.Event.PLUG, serial);
            YAPI.SafeYAPI()._Log("HUB: device " + serial + " has been plugged\n");
        }
        for (YDevice dev : toRemove) {
            serial = dev.getSerialNumber();
            YAPI.SafeYAPI().pushPlugEvent(YAPI.PlugEvent.Event.UNPLUG, serial);
            YAPI.SafeYAPI()._Log("HUB: device " + serial + " has been unplugged\n");
            this._devices.remove(serial);
        }
    }

    abstract void updateDeviceList(boolean var1) throws YAPI_Exception;

    public abstract ArrayList<String> getBootloaders() throws YAPI_Exception;

    abstract ArrayList<String> firmwareUpdate(String var1, YFirmwareFile var2, byte[] var3, UpdateProgress var4) throws YAPI_Exception, InterruptedException;

    abstract void devRequestAsync(YDevice var1, String var2, byte[] var3, RequestAsyncResult var4, Object var5) throws YAPI_Exception;

    abstract byte[] devRequestSync(YDevice var1, String var2, byte[] var3) throws YAPI_Exception;

    protected static class HTTPParams {
        private final String _host;
        private final int _port;
        private final String _user;
        private final String _pass;

        public HTTPParams(String url) {
            int portpos;
            int pos = 0;
            if (url.startsWith("http://")) {
                pos = 7;
            }
            int end_auth = url.indexOf(64, pos);
            int end_user = url.indexOf(58, pos);
            if (end_auth >= 0 && end_user >= 0 && end_user < end_auth) {
                this._user = url.substring(pos, end_user);
                this._pass = url.substring(end_user + 1, end_auth);
                pos = end_auth + 1;
            } else {
                this._user = "";
                this._pass = "";
            }
            int end_url = url.indexOf(47, pos);
            if (end_url < 0) {
                end_url = url.length();
            }
            if ((portpos = url.indexOf(58, pos)) > 0 && portpos < end_url) {
                this._host = url.substring(pos, portpos);
                this._port = Integer.parseInt(url.substring(portpos + 1, end_url));
            } else {
                this._host = url.substring(pos, end_url);
                this._port = 4444;
            }
        }

        String getHost() {
            return this._host;
        }

        String getPass() {
            return this._pass;
        }

        int getPort() {
            return this._port;
        }

        String geUser() {
            return this._user;
        }

        public String getUrl() {
            StringBuilder url = new StringBuilder();
            if (!this._user.equals("")) {
                url.append(this._user);
                if (!this._pass.equals("")) {
                    url.append(":");
                    url.append(this._pass);
                }
                url.append("@");
            }
            url.append(this._host);
            url.append(":");
            url.append(this._pass);
            return url.toString();
        }
    }

    static interface RequestAsyncResult {
        public void RequestAsyncDone(Object var1, byte[] var2, int var3, String var4);
    }

    static interface UpdateProgress {
        public void firmware_progress(int var1, String var2);
    }
}

