/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDisplayLayer;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import org.json.JSONException;
import org.json.JSONObject;

public class YDisplay
extends YFunction {
    public static final int ENABLED_FALSE = 0;
    public static final int ENABLED_TRUE = 1;
    public static final int ENABLED_INVALID = -1;
    public static final String STARTUPSEQ_INVALID = "!INVALID!";
    public static final int BRIGHTNESS_INVALID = -1;
    public static final int ORIENTATION_LEFT = 0;
    public static final int ORIENTATION_UP = 1;
    public static final int ORIENTATION_RIGHT = 2;
    public static final int ORIENTATION_DOWN = 3;
    public static final int ORIENTATION_INVALID = -1;
    public static final int DISPLAYWIDTH_INVALID = -1;
    public static final int DISPLAYHEIGHT_INVALID = -1;
    public static final int DISPLAYTYPE_MONO = 0;
    public static final int DISPLAYTYPE_GRAY = 1;
    public static final int DISPLAYTYPE_RGB = 2;
    public static final int DISPLAYTYPE_INVALID = -1;
    public static final int LAYERWIDTH_INVALID = -1;
    public static final int LAYERHEIGHT_INVALID = -1;
    public static final int LAYERCOUNT_INVALID = -1;
    public static final String COMMAND_INVALID = "!INVALID!";
    protected int _enabled = -1;
    protected String _startupSeq = "!INVALID!";
    protected int _brightness = -1;
    protected int _orientation = -1;
    protected int _displayWidth = -1;
    protected int _displayHeight = -1;
    protected int _displayType = -1;
    protected int _layerWidth = -1;
    protected int _layerHeight = -1;
    protected int _layerCount = -1;
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackDisplay = null;
    private YDisplayLayer[] _allDisplayLayers = null;
    private Boolean _recording = false;
    private String _sequence;

    protected YDisplay(String func) {
        super(func);
        this._className = "Display";
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("enabled")) {
            int n = this._enabled = json_val.getInt("enabled") > 0 ? 1 : 0;
        }
        if (json_val.has("startupSeq")) {
            this._startupSeq = json_val.getString("startupSeq");
        }
        if (json_val.has("brightness")) {
            this._brightness = json_val.getInt("brightness");
        }
        if (json_val.has("orientation")) {
            this._orientation = json_val.getInt("orientation");
        }
        if (json_val.has("displayWidth")) {
            this._displayWidth = json_val.getInt("displayWidth");
        }
        if (json_val.has("displayHeight")) {
            this._displayHeight = json_val.getInt("displayHeight");
        }
        if (json_val.has("displayType")) {
            this._displayType = json_val.getInt("displayType");
        }
        if (json_val.has("layerWidth")) {
            this._layerWidth = json_val.getInt("layerWidth");
        }
        if (json_val.has("layerHeight")) {
            this._layerHeight = json_val.getInt("layerHeight");
        }
        if (json_val.has("layerCount")) {
            this._layerCount = json_val.getInt("layerCount");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    public int get_enabled() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._enabled;
    }

    public int getEnabled() throws YAPI_Exception {
        return this.get_enabled();
    }

    public int set_enabled(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("enabled", rest_val);
        return 0;
    }

    public int setEnabled(int newval) throws YAPI_Exception {
        return this.set_enabled(newval);
    }

    public String get_startupSeq() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._startupSeq;
    }

    public String getStartupSeq() throws YAPI_Exception {
        return this.get_startupSeq();
    }

    public int set_startupSeq(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("startupSeq", rest_val);
        return 0;
    }

    public int setStartupSeq(String newval) throws YAPI_Exception {
        return this.set_startupSeq(newval);
    }

    public int get_brightness() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._brightness;
    }

    public int getBrightness() throws YAPI_Exception {
        return this.get_brightness();
    }

    public int set_brightness(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("brightness", rest_val);
        return 0;
    }

    public int setBrightness(int newval) throws YAPI_Exception {
        return this.set_brightness(newval);
    }

    public int get_orientation() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._orientation;
    }

    public int getOrientation() throws YAPI_Exception {
        return this.get_orientation();
    }

    public int set_orientation(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("orientation", rest_val);
        return 0;
    }

    public int setOrientation(int newval) throws YAPI_Exception {
        return this.set_orientation(newval);
    }

    public int get_displayWidth() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._displayWidth;
    }

    public int getDisplayWidth() throws YAPI_Exception {
        return this.get_displayWidth();
    }

    public int get_displayHeight() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._displayHeight;
    }

    public int getDisplayHeight() throws YAPI_Exception {
        return this.get_displayHeight();
    }

    public int get_displayType() throws YAPI_Exception {
        if (this._cacheExpiration == 0L && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._displayType;
    }

    public int getDisplayType() throws YAPI_Exception {
        return this.get_displayType();
    }

    public int get_layerWidth() throws YAPI_Exception {
        if (this._cacheExpiration == 0L && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._layerWidth;
    }

    public int getLayerWidth() throws YAPI_Exception {
        return this.get_layerWidth();
    }

    public int get_layerHeight() throws YAPI_Exception {
        if (this._cacheExpiration == 0L && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._layerHeight;
    }

    public int getLayerHeight() throws YAPI_Exception {
        return this.get_layerHeight();
    }

    public int get_layerCount() throws YAPI_Exception {
        if (this._cacheExpiration == 0L && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._layerCount;
    }

    public int getLayerCount() throws YAPI_Exception {
        return this.get_layerCount();
    }

    public String get_command() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._command;
    }

    public String getCommand() throws YAPI_Exception {
        return this.get_command();
    }

    public int set_command(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("command", rest_val);
        return 0;
    }

    public int setCommand(String newval) throws YAPI_Exception {
        return this.set_command(newval);
    }

    public static YDisplay FindDisplay(String func) {
        YDisplay obj = (YDisplay)YFunction._FindFromCache("Display", func);
        if (obj == null) {
            obj = new YDisplay(func);
            YFunction._AddToCache("Display", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackDisplay = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackDisplay != null) {
            this._valueCallbackDisplay.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int resetAll() throws YAPI_Exception {
        this.flushLayers();
        this.resetHiddenLayerFlags();
        return this.sendCommand("Z");
    }

    public int fade(int brightness, int duration) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format("+%d,%d", brightness, duration));
    }

    public int newSequence() throws YAPI_Exception {
        this.flushLayers();
        this._sequence = "";
        this._recording = true;
        return 0;
    }

    public int saveSequence(String sequenceName) throws YAPI_Exception {
        this.flushLayers();
        this._recording = false;
        this._upload(sequenceName, this._sequence.getBytes());
        this._sequence = String.format("", new Object[0]);
        return 0;
    }

    public int playSequence(String sequenceName) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format("S%s", sequenceName));
    }

    public int pauseSequence(int delay_ms) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format("W%d", delay_ms));
    }

    public int stopSequence() throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand("S");
    }

    public int upload(String pathname, byte[] content) throws YAPI_Exception {
        return this._upload(pathname, content);
    }

    public int copyLayerContent(int srcLayerId, int dstLayerId) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format("o%d,%d", srcLayerId, dstLayerId));
    }

    public int swapLayerContent(int layerIdA, int layerIdB) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format("E%d,%d", layerIdA, layerIdB));
    }

    public YDisplay nextDisplay() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YDisplay.FindDisplay(next_hwid);
    }

    public static YDisplay FirstDisplay() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Display");
        if (next_hwid == null) {
            return null;
        }
        return YDisplay.FindDisplay(next_hwid);
    }

    public synchronized YDisplayLayer get_displayLayer(int layerId) throws YAPI_Exception {
        if (this._allDisplayLayers == null) {
            int nb_display_layer = this.get_layerCount();
            this._allDisplayLayers = new YDisplayLayer[nb_display_layer];
            for (int i = 0; i < nb_display_layer; ++i) {
                this._allDisplayLayers[i] = new YDisplayLayer(this, i);
            }
        }
        if (layerId < 0 || layerId >= this._allDisplayLayers.length) {
            throw new YAPI_Exception(-2, "Invalid layerId");
        }
        return this._allDisplayLayers[layerId];
    }

    public synchronized int flushLayers() throws YAPI_Exception {
        if (this._allDisplayLayers != null) {
            for (int i = 0; i < this._allDisplayLayers.length; ++i) {
                this._allDisplayLayers[i].flush_now();
            }
        }
        return 0;
    }

    public synchronized void resetHiddenLayerFlags() throws YAPI_Exception {
        if (this._allDisplayLayers != null) {
            for (int i = 0; i < this._allDisplayLayers.length; ++i) {
                this._allDisplayLayers[i].resetHiddenFlag();
            }
        }
    }

    public synchronized int sendCommand(String cmd) throws YAPI_Exception {
        if (!this._recording.booleanValue()) {
            return this.set_command(cmd);
        }
        this._sequence = this._sequence + cmd + "\n";
        return 0;
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YDisplay var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YDisplay var1, String var2);
    }
}

