/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YCallbackHub;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YFunctionType;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YModule;
import com.yoctopuce.YoctoAPI.YPEntry;
import com.yoctopuce.YoctoAPI.YSSDP;
import com.yoctopuce.YoctoAPI.YSensor;
import com.yoctopuce.YoctoAPI.YUSBHub;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;

public class YAPI {
    public static final String INVALID_STRING = "!INVALID!";
    public static final double INVALID_DOUBLE = -1.79769313486231E308;
    public static final int INVALID_INT = Integer.MIN_VALUE;
    public static final long INVALID_LONG = -9223372036854775807L;
    public static final int INVALID_UINT = -1;
    public static final String YOCTO_API_VERSION_STR = "1.10";
    public static final String YOCTO_API_BUILD_STR = "19938";
    public static final int YOCTO_API_VERSION_BCD = 272;
    public static final int YOCTO_VENDORID = 9440;
    public static final int YOCTO_DEVID_FACTORYBOOT = 1;
    public static final int YOCTO_DEVID_BOOTLOADER = 2;
    public static final int SUCCESS = 0;
    public static final int NOT_INITIALIZED = -1;
    public static final int INVALID_ARGUMENT = -2;
    public static final int NOT_SUPPORTED = -3;
    public static final int DEVICE_NOT_FOUND = -4;
    public static final int VERSION_MISMATCH = -5;
    public static final int DEVICE_BUSY = -6;
    public static final int TIMEOUT = -7;
    public static final int IO_ERROR = -8;
    public static final int NO_MORE_DATA = -9;
    public static final int EXHAUSTED = -10;
    public static final int DOUBLE_ACCES = -11;
    public static final int UNAUTHORIZED = -12;
    public static final int RTC_NOT_READY = -13;
    public static final int FILE_NOT_FOUND = -14;
    static final String DefaultEncoding = "ISO-8859-1";
    static Charset DeviceCharset;
    static final int YOCTO_CALIB_TYPE_OFS = 30;
    static final int YOCTO_MANUFACTURER_LEN = 20;
    static final int YOCTO_SERIAL_LEN = 20;
    static final int YOCTO_BASE_SERIAL_LEN = 8;
    static final int YOCTO_PRODUCTNAME_LEN = 28;
    static final int YOCTO_FIRMWARE_LEN = 22;
    static final int YOCTO_LOGICAL_LEN = 20;
    static final int YOCTO_FUNCTION_LEN = 20;
    static final int YOCTO_PUBVAL_SIZE = 6;
    static final int YOCTO_PUBVAL_LEN = 16;
    static final int YOCTO_PASS_LEN = 20;
    static final int YOCTO_REALM_LEN = 20;
    public static final int DETECT_NONE = 0;
    public static final int DETECT_USB = 1;
    public static final int DETECT_NET = 2;
    public static final int DETECT_ALL = 3;
    private final YSSDP.YSSDPReportInterface _ssdpCallback = new YSSDP.YSSDPReportInterface(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void HubDiscoveryCallback(String serial, String urlToRegister, String urlToUnregister) {
            if (urlToRegister != null) {
                Object object = YAPI.this._newHubCallbackLock;
                synchronized (object) {
                    if (YAPI.this._HubDiscoveryCallback != null) {
                        YAPI.this._HubDiscoveryCallback.yHubDiscoveryCallback(serial, urlToRegister);
                    }
                }
            }
            if ((YAPI.this._apiMode & 2) != 0 && urlToRegister != null) {
                if (urlToUnregister != null) {
                    YAPI.this._UnregisterHub(urlToUnregister);
                }
                try {
                    YAPI.this._PreregisterHub(urlToRegister);
                }
                catch (YAPI_Exception ex) {
                    YAPI.this._Log("Unable to register hub " + urlToRegister + " detected by SSDP:" + ex.toString());
                }
            }
        }
    };
    private static final HashMap<String, YPEntry.BaseClass> _BaseType;
    private static final CalibrationHandlerCallback linearCalibrationHandler;
    public int DefaultCacheValidity;
    private int _apiMode;
    ArrayList<YGenericHub> _hubs;
    private HashMap<String, YDevice> _devs;
    private HashMap<String, String> _snByUrl;
    private HashMap<String, String> _snByName;
    private HashMap<String, YFunctionType> _fnByType;
    private boolean _firstArrival;
    private final Queue<PlugEvent> _pendingCallbacks = new LinkedList<PlugEvent>();
    private final Queue<DataEvent> _data_events = new LinkedList<DataEvent>();
    private DeviceArrivalCallback _arrivalCallback = null;
    private DeviceChangeCallback _namechgCallback = null;
    private DeviceRemovalCallback _removalCallback = null;
    private LogCallback _logCallback = null;
    private final Object _newHubCallbackLock = new Object();
    private HubDiscoveryCallback _HubDiscoveryCallback = null;
    private HashMap<Integer, CalibrationHandlerCallback> _calibHandlers = new HashMap();
    private YSSDP _ssdp;
    private static final ArrayList<YFunction> _ValueCallbackList;
    private static final ArrayList<YFunction> _TimedReportCallbackList;
    private static final double[] decExp;
    protected static final char[] _hexArray;
    private static HashMap<Long, YAPI> _MultipleYAPI;
    private static YAPI _SingleYAPI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushPlugEvent(PlugEvent.Event ev, String serial) {
        Queue<PlugEvent> queue = this._pendingCallbacks;
        synchronized (queue) {
            this._pendingCallbacks.add(new PlugEvent(ev, serial));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _updateDeviceList_internal(boolean forceupdate, boolean invokecallbacks) throws YAPI_Exception {
        if (this._firstArrival && invokecallbacks && this._arrivalCallback != null) {
            forceupdate = true;
        }
        for (YGenericHub h : this._hubs) {
            h.updateDeviceList(forceupdate);
        }
        if (invokecallbacks) {
            while (true) {
                PlugEvent evt;
                Queue<PlugEvent> queue = this._pendingCallbacks;
                synchronized (queue) {
                    if (this._pendingCallbacks.isEmpty()) {
                        break;
                    }
                    evt = this._pendingCallbacks.poll();
                }
                switch (evt.ev) {
                    case PLUG: {
                        if (this._arrivalCallback == null) break;
                        this._arrivalCallback.yDeviceArrival(evt.module);
                        break;
                    }
                    case CHANGE: {
                        if (this._namechgCallback == null) break;
                        this._namechgCallback.yDeviceChange(evt.module);
                        break;
                    }
                    case UNPLUG: {
                        if (this._removalCallback != null) {
                            this._removalCallback.yDeviceRemoval(evt.module);
                        }
                        this.forgetDevice(this._devs.get(evt.module.get_serialNumber()));
                    }
                }
            }
            if (this._arrivalCallback != null && this._firstArrival) {
                this._firstArrival = false;
            }
        }
    }

    CalibrationHandlerCallback _getCalibrationHandler(int calibType) {
        if (!this._calibHandlers.containsKey(calibType)) {
            return null;
        }
        return this._calibHandlers.get(calibType);
    }

    static double _decimalToDouble(int val) {
        boolean negate = false;
        int mantis = val & 0x7FF;
        if (mantis == 0) {
            return 0.0;
        }
        if (val > Short.MAX_VALUE) {
            negate = true;
            val = 65536 - val;
        } else if (val < 0) {
            negate = true;
            val = -val;
        }
        int exp = val >> 11;
        double res = (double)mantis * decExp[exp];
        return negate ? -res : res;
    }

    static long _doubleToDecimal(double val) {
        int decpow;
        boolean negate = false;
        if (val == 0.0) {
            return 0L;
        }
        if (val < 0.0) {
            negate = true;
            val = -val;
        }
        double comp = val / 1999.0;
        for (decpow = 0; comp > decExp[decpow] && decpow < 15; ++decpow) {
        }
        double mant = val / decExp[decpow];
        long res = decpow == 15 && mant > 2047.0 ? 32767L : (long)(decpow << 11) + Math.round(mant);
        return negate ? -res : res;
    }

    static ArrayList<Integer> _decodeWords(String data) {
        ArrayList<Integer> udata = new ArrayList<Integer>();
        int datalen = data.length();
        int p = 0;
        while (p < datalen) {
            int val;
            int c;
            if ((c = data.charAt(p++)) == 42) {
                val = 0;
            } else if (c == 88) {
                val = 65535;
            } else if (c == 89) {
                val = Short.MAX_VALUE;
            } else if (c >= 97) {
                int srcpos = udata.size() - 1 - (c - 97);
                val = srcpos < 0 ? 0 : udata.get(srcpos);
            } else {
                if (p + 2 > datalen) {
                    return udata;
                }
                val = c - 48;
                c = data.charAt(p++);
                val += c - 48 << 5;
                if ((c = data.charAt(p++)) == 122) {
                    c = 92;
                }
                val += c - 48 << 10;
            }
            udata.add(val);
        }
        return udata;
    }

    static ArrayList<Integer> _decodeFloats(String data) {
        ArrayList<Integer> idata = new ArrayList<Integer>();
        int datalen = data.length();
        int p = 0;
        while (p < datalen) {
            int val = 0;
            int sign = 1;
            int dec = 0;
            int decInc = 0;
            char c = data.charAt(p++);
            while (c != '-' && (c < '0' || c > '9')) {
                if (p >= datalen) {
                    return idata;
                }
                c = data.charAt(p++);
            }
            if (c == '-') {
                if (p >= datalen) {
                    return idata;
                }
                sign = -sign;
                c = data.charAt(p++);
            }
            while (c >= '0' && c <= '9' || c == '.') {
                if (c == '.') {
                    decInc = 1;
                } else if (dec < 3) {
                    val = val * 10 + (c - 48);
                    dec += decInc;
                }
                if (p < datalen) {
                    c = data.charAt(p++);
                    continue;
                }
                c = '\u0000';
            }
            if (dec < 3) {
                val = dec == 0 ? (val *= 1000) : (dec == 1 ? (val *= 100) : (val *= 10));
            }
            idata.add(sign * val);
        }
        return idata;
    }

    static int _find_in_bytes(byte[] source, byte[] match) {
        if (source == null || match == null) {
            return -1;
        }
        if (source.length == 0 || match.length == 0) {
            return -1;
        }
        int ret = -1;
        int mpos = 0;
        byte m = match[mpos];
        for (int spos = 0; spos < source.length; ++spos) {
            if (m == source[spos]) {
                if (mpos == 0) {
                    ret = spos;
                } else if (mpos == match.length - 1) {
                    return ret;
                }
                m = match[++mpos];
                continue;
            }
            ret = -1;
            mpos = 0;
            m = match[mpos];
        }
        return ret;
    }

    static String _bytesToHexStr(byte[] bytes, int offset, int len) {
        char[] hexChars = new char[len * 2];
        for (int j = 0; j < len; ++j) {
            int v = bytes[offset + j] & 0xFF;
            hexChars[j * 2] = _hexArray[v >>> 4];
            hexChars[j * 2 + 1] = _hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    YDevice getDevice(String device) {
        YDevice dev = null;
        if (device.startsWith("http://")) {
            String serial;
            if (this._snByUrl.containsKey(device) && this._devs.containsKey(serial = this._snByUrl.get(device))) {
                dev = this._devs.get(serial);
            }
        } else if (this._devs.containsKey(device)) {
            dev = this._devs.get(device);
        } else if (this._snByName.containsKey(device)) {
            String serial = this._snByName.get(device);
            dev = this._devs.get(serial);
        }
        return dev;
    }

    String functionClass(String funcid) {
        int dotpos = funcid.indexOf(46);
        if (dotpos >= 0) {
            funcid = funcid.substring(dotpos + 1);
        }
        int classlen = funcid.length();
        while (funcid.charAt(classlen - 1) <= '9') {
            --classlen;
        }
        String classname = funcid.substring(0, 1).toUpperCase(Locale.US) + funcid.substring(1, classlen);
        this.getFnByType(classname);
        return classname;
    }

    void reindexDevice(YDevice dev) {
        String serial = dev.getSerialNumber();
        String lname = dev.getLogicalName();
        this._devs.put(serial, dev);
        if (!lname.equals("")) {
            this._snByName.put(lname, serial);
        }
        this._fnByType.get("Module").reindexFunction(dev.getModuleYPEntry());
        int count = dev.functionCount();
        for (int i = 0; i < count; ++i) {
            YPEntry yp = dev.getYPEntry(i);
            this._fnByType.get(yp.getClassname()).reindexFunction(yp);
        }
    }

    void forgetDevice(YDevice dev) {
        String serial = dev.getSerialNumber();
        String lname = dev.getLogicalName();
        this._devs.remove(serial);
        if (this._snByName.containsKey(lname) && this._snByName.get(lname).equals(serial)) {
            this._snByName.remove(lname);
        }
        this._fnByType.get("Module").forgetFunction(serial + ".module");
        int count = dev.functionCount();
        for (int i = 0; i < count; ++i) {
            YPEntry yp = dev.getYPEntry(i);
            this._fnByType.get(yp.getClassname()).forgetFunction(yp.getHardwareId());
        }
    }

    YFunctionType getFnByType(String className) {
        if (!this._fnByType.containsKey(className)) {
            this._fnByType.put(className, new YFunctionType(className));
        }
        return this._fnByType.get(className);
    }

    YPEntry resolveFunction(String className, String func) throws YAPI_Exception {
        if (!_BaseType.containsKey(className)) {
            return this.getFnByType(className).getYPEntry(func);
        }
        YPEntry.BaseClass baseType = _BaseType.get(className);
        for (YFunctionType subClassType : this._fnByType.values()) {
            try {
                YPEntry yp = subClassType.getYPEntry(func);
                if (!yp.getBaseclass().equals((Object)baseType)) continue;
                return yp;
            }
            catch (YAPI_Exception ignore) {
            }
        }
        throw new YAPI_Exception(-4, "No function of type " + className + " found");
    }

    void setFunction(String className, String func, YFunction yfunc) {
        this.getFnByType(className).setFunction(func, yfunc);
    }

    YFunction getFunction(String className, String func) {
        return this.getFnByType(className).getFunction(func);
    }

    void setFunctionValue(String hwid, String pubval) {
        String classname = this.functionClass(hwid);
        YFunctionType fnByType = this.getFnByType(classname);
        fnByType.setFunctionValue(hwid, pubval);
    }

    void setTimedReport(String hwid, double deviceTime, ArrayList<Integer> report) {
        String classname = this.functionClass(hwid);
        this.getFnByType(classname).setTimedReport(hwid, deviceTime, report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _PushDataEvent(DataEvent ev) {
        Queue<DataEvent> queue = this._data_events;
        synchronized (queue) {
            this._data_events.add(ev);
        }
    }

    String getFirstHardwareId(String className) {
        if (!_BaseType.containsKey(className)) {
            YFunctionType ft = this.getFnByType(className);
            YPEntry yp = ft.getFirstYPEntry();
            if (yp == null) {
                return null;
            }
            return yp.getHardwareId();
        }
        YPEntry.BaseClass baseType = _BaseType.get(className);
        for (YFunctionType subClassType : this._fnByType.values()) {
            YPEntry yp = subClassType.getFirstYPEntry();
            if (yp == null || !yp.getBaseclass().equals((Object)baseType)) continue;
            return yp.getHardwareId();
        }
        return null;
    }

    String getNextHardwareId(String className, String hwid) {
        if (!_BaseType.containsKey(className)) {
            YFunctionType ft = this.getFnByType(className);
            YPEntry yp = ft.getNextYPEntry(hwid);
            if (yp == null) {
                return null;
            }
            return yp.getHardwareId();
        }
        YPEntry.BaseClass baseType = _BaseType.get(className);
        String prevclass = this.functionClass(hwid);
        YPEntry res = this.getFnByType(prevclass).getNextYPEntry(hwid);
        if (res != null) {
            return res.getHardwareId();
        }
        for (String altClassName : this._fnByType.keySet()) {
            if (!prevclass.equals("")) {
                if (!altClassName.equals(prevclass)) continue;
                prevclass = "";
                continue;
            }
            res = this._fnByType.get(altClassName).getFirstYPEntry();
            if (res == null || !res.getBaseclass().equals((Object)baseType)) continue;
            return res.getHardwareId();
        }
        return null;
    }

    YDevice funcGetDevice(String className, String func) throws YAPI_Exception {
        YPEntry resolved;
        try {
            resolved = this.resolveFunction(className, func);
        }
        catch (YAPI_Exception ex) {
            if (ex.errorType == -4 && this._hubs.isEmpty()) {
                throw new YAPI_Exception(ex.errorType, "Impossible to contact any device because no hub has been registered");
            }
            this._updateDeviceList_internal(true, false);
            resolved = this.resolveFunction(className, func);
        }
        String devid = resolved.getSerial();
        YDevice dev = this.getDevice(devid);
        if (dev == null) {
            this._updateDeviceList_internal(true, false);
            dev = this.getDevice(devid);
            if (dev == null) {
                throw new YAPI_Exception(-4, "Device [" + devid + "] not online");
            }
        }
        return dev;
    }

    protected synchronized int _AddNewHub(String url, boolean reportConnnectionLost, InputStream request, OutputStream response) throws YAPI_Exception {
        YGenericHub newhub;
        for (YGenericHub h : this._hubs) {
            if (!h.isSameRootUrl(url)) continue;
            return 0;
        }
        YGenericHub.HTTPParams parsedurl = new YGenericHub.HTTPParams(url);
        if (url.equals("usb")) {
            YUSBHub.CheckUSBAcces();
            newhub = new YUSBHub(this._hubs.size());
        } else {
            if (url.equals("net")) {
                if ((this._apiMode & 2) == 0) {
                    if (YUSBHub.RegisterLocalhost()) {
                        newhub = new YHTTPHub(this._hubs.size(), new YGenericHub.HTTPParams("localhost"), false);
                        this._hubs.add(newhub);
                        newhub.startNotifications();
                    }
                    this._apiMode |= 2;
                    this._ssdp.addCallback(this._ssdpCallback);
                }
                return 0;
            }
            newhub = parsedurl.getHost().equals("callback") ? new YCallbackHub(this._hubs.size(), parsedurl, request, response) : new YHTTPHub(this._hubs.size(), parsedurl, reportConnnectionLost);
        }
        this._hubs.add(newhub);
        newhub.startNotifications();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _UpdateValueCallbackList(YFunction func, boolean add) {
        if (add) {
            func.isOnline();
            ArrayList<YFunction> arrayList = _ValueCallbackList;
            synchronized (arrayList) {
                if (!_ValueCallbackList.contains(func)) {
                    _ValueCallbackList.add(func);
                }
            }
        }
        ArrayList<YFunction> arrayList = _ValueCallbackList;
        synchronized (arrayList) {
            _ValueCallbackList.remove(func);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YFunction _GetValueCallback(String hwid) {
        ArrayList<YFunction> arrayList = _ValueCallbackList;
        synchronized (arrayList) {
            for (YFunction func : _ValueCallbackList) {
                try {
                    if (!func.getHardwareId().equals(hwid)) continue;
                    return func;
                }
                catch (YAPI_Exception ignore) {
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _UpdateTimedReportCallbackList(YFunction func, boolean add) {
        if (add) {
            func.isOnline();
            ArrayList<YFunction> arrayList = _TimedReportCallbackList;
            synchronized (arrayList) {
                if (!_TimedReportCallbackList.contains(func)) {
                    _TimedReportCallbackList.add(func);
                }
            }
        }
        ArrayList<YFunction> arrayList = _TimedReportCallbackList;
        synchronized (arrayList) {
            _TimedReportCallbackList.remove(func);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YFunction _GetTimedReportCallback(String hwid) {
        ArrayList<YFunction> arrayList = _TimedReportCallbackList;
        synchronized (arrayList) {
            for (YFunction func : _TimedReportCallbackList) {
                try {
                    if (!func.getHardwareId().equals(hwid)) continue;
                    return func;
                }
                catch (YAPI_Exception ignore) {
                }
            }
        }
        return null;
    }

    public static synchronized void SetThreadSpecificMode() throws YAPI_Exception {
        if (_SingleYAPI != null) {
            throw new YAPI_Exception(-2, "SetSingleThreadMode must be called before start using the Yoctopuce API");
        }
        _MultipleYAPI = new HashMap();
    }

    static synchronized YAPI GetYAPI() {
        if (_MultipleYAPI != null) {
            return _MultipleYAPI.get(Thread.currentThread().getId());
        }
        return _SingleYAPI;
    }

    static synchronized YAPI SafeYAPI() {
        YAPI yapi = YAPI.GetYAPI();
        if (yapi == null) {
            yapi = new YAPI();
            YAPI.AddYAPI(yapi);
        }
        return yapi;
    }

    static synchronized void AddYAPI(YAPI yapi) {
        if (_MultipleYAPI != null) {
            _MultipleYAPI.put(Thread.currentThread().getId(), yapi);
        } else {
            _SingleYAPI = yapi;
        }
    }

    static synchronized void RemoveYAPI() {
        if (_MultipleYAPI != null) {
            _MultipleYAPI.remove(Thread.currentThread().getId());
        } else {
            _SingleYAPI = null;
        }
    }

    YAPI() {
        try {
            DeviceCharset = Charset.forName(DefaultEncoding);
        }
        catch (Exception dummy) {
            DeviceCharset = Charset.defaultCharset();
        }
        this.DefaultCacheValidity = 5;
        this._hubs = new ArrayList();
        this._devs = new HashMap();
        this._snByUrl = new HashMap();
        this._snByName = new HashMap();
        this._fnByType = new HashMap(2);
        this._firstArrival = true;
        this._pendingCallbacks.clear();
        this._data_events.clear();
        this._ssdp = null;
        this._fnByType.put("Module", new YFunctionType("Module"));
        for (int i = 1; i <= 20; ++i) {
            this._calibHandlers.put(i, linearCalibrationHandler);
        }
        this._calibHandlers.put(30, linearCalibrationHandler);
        this._ssdp = new YSSDP();
    }

    void _FreeAPI() {
        if ((this._apiMode & 2) != 0) {
            this._ssdp.Stop();
        }
        for (YGenericHub h : this._hubs) {
            h.stopNotifications();
            h.release();
        }
    }

    public int _RegisterHub(String url) throws YAPI_Exception {
        this._AddNewHub(url, true, null, null);
        this._updateDeviceList_internal(true, false);
        return 0;
    }

    public int _RegisterHub(String url, InputStream request, OutputStream response) throws YAPI_Exception {
        this._AddNewHub(url, true, request, response);
        this._updateDeviceList_internal(true, false);
        return 0;
    }

    public int _PreregisterHub(String url) throws YAPI_Exception {
        this._AddNewHub(url, false, null, null);
        return 0;
    }

    public void _UnregisterHub(String url) {
        if (url.equals("net")) {
            this._apiMode &= 0xFFFFFFFD;
            return;
        }
        for (YGenericHub h : this._hubs) {
            if (!h.isSameRootUrl(url)) continue;
            h.stopNotifications();
            for (String serial : h._serialByYdx.values()) {
                this.forgetDevice(this._devs.get(serial));
            }
            h.release();
            this._hubs.remove(h);
            return;
        }
    }

    public int _UpdateDeviceList() throws YAPI_Exception {
        this._updateDeviceList_internal(false, true);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int _HandleEvents() throws YAPI_Exception {
        while (true) {
            DataEvent pv;
            Queue<DataEvent> queue = this._data_events;
            synchronized (queue) {
                if (this._data_events.isEmpty()) {
                    break;
                }
                pv = this._data_events.poll();
            }
            pv.invoke();
        }
        return 0;
    }

    public int _Sleep(long ms_duration) throws YAPI_Exception {
        long end = YAPI.GetTickCount() + ms_duration;
        do {
            this._HandleEvents();
            if (end <= YAPI.GetTickCount()) continue;
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException ex) {
                throw new YAPI_Exception(-8, "Thread has been interrupted");
            }
        } while (end > YAPI.GetTickCount());
        return 0;
    }

    public int _TriggerHubDiscovery() throws YAPI_Exception {
        this._ssdp.addCallback(this._ssdpCallback);
        return 0;
    }

    public void _RegisterDeviceArrivalCallback(DeviceArrivalCallback arrivalCallback) {
        this._arrivalCallback = arrivalCallback;
    }

    public void _RegisterDeviceChangeCallback(DeviceChangeCallback changeCallback) {
        this._namechgCallback = changeCallback;
    }

    public synchronized void _RegisterDeviceRemovalCallback(DeviceRemovalCallback removalCallback) {
        this._removalCallback = removalCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _RegisterHubDiscoveryCallback(HubDiscoveryCallback hubDiscoveryCallback) {
        Object object = this._newHubCallbackLock;
        synchronized (object) {
            this._HubDiscoveryCallback = hubDiscoveryCallback;
        }
        try {
            this._TriggerHubDiscovery();
        }
        catch (YAPI_Exception yAPI_Exception) {
            // empty catch block
        }
    }

    public void _RegisterLogFunction(LogCallback logfun) {
        this._logCallback = logfun;
    }

    void _Log(String message) {
        if (this._logCallback != null) {
            this._logCallback.yLog(message);
        }
    }

    public static String GetAPIVersion() {
        return "1.10.19938";
    }

    public static int InitAPI(int mode) throws YAPI_Exception {
        YAPI yapi = YAPI.SafeYAPI();
        if ((mode & 2) != 0) {
            yapi._RegisterHub("net");
        }
        if ((mode & 1) != 0) {
            yapi._RegisterHub("usb");
        }
        return 0;
    }

    public static void FreeAPI() {
        YAPI yapi = YAPI.GetYAPI();
        if (yapi != null) {
            yapi._FreeAPI();
            YAPI.RemoveYAPI();
        }
    }

    public static int RegisterHub(String url) throws YAPI_Exception {
        return YAPI.SafeYAPI()._RegisterHub(url);
    }

    public static int RegisterHub(String url, InputStream request, OutputStream response) throws YAPI_Exception {
        return YAPI.SafeYAPI()._RegisterHub(url, request, response);
    }

    public static void EnableUSBHost(Object osContext) throws YAPI_Exception {
        YUSBHub.SetContextType(osContext);
    }

    public static int PreregisterHub(String url) throws YAPI_Exception {
        return YAPI.SafeYAPI()._PreregisterHub(url);
    }

    public static void UnregisterHub(String url) {
        YAPI.SafeYAPI()._UnregisterHub(url);
    }

    public static int UpdateDeviceList() throws YAPI_Exception {
        return YAPI.SafeYAPI()._UpdateDeviceList();
    }

    public static int HandleEvents() throws YAPI_Exception {
        return YAPI.SafeYAPI()._HandleEvents();
    }

    public static int Sleep(long ms_duration) throws YAPI_Exception {
        return YAPI.SafeYAPI()._Sleep(ms_duration);
    }

    public static int TriggerHubDiscovery() throws YAPI_Exception {
        return YAPI.SafeYAPI()._TriggerHubDiscovery();
    }

    public static long GetTickCount() {
        return System.currentTimeMillis();
    }

    public static boolean CheckLogicalName(String name) {
        return name != null && (name.equals("") || name.length() <= 19 && name.matches("^[A-Za-z0-9_-]*$"));
    }

    public static void RegisterDeviceArrivalCallback(DeviceArrivalCallback arrivalCallback) {
        YAPI.SafeYAPI()._RegisterDeviceArrivalCallback(arrivalCallback);
    }

    public static void RegisterDeviceChangeCallback(DeviceChangeCallback changeCallback) {
        YAPI.SafeYAPI()._RegisterDeviceChangeCallback(changeCallback);
    }

    public static void RegisterDeviceRemovalCallback(DeviceRemovalCallback removalCallback) {
        YAPI.SafeYAPI()._RegisterDeviceRemovalCallback(removalCallback);
    }

    public static void RegisterHubDiscoveryCallback(HubDiscoveryCallback hubDiscoveryCallback) {
        YAPI.SafeYAPI()._RegisterHubDiscoveryCallback(hubDiscoveryCallback);
    }

    public static void RegisterLogFunction(LogCallback logfun) {
        YAPI.SafeYAPI()._RegisterLogFunction(logfun);
    }

    static {
        _BaseType = new HashMap();
        _BaseType.put("Function", YPEntry.BaseClass.Function);
        _BaseType.put("Sensor", YPEntry.BaseClass.Sensor);
        linearCalibrationHandler = new CalibrationHandlerCallback(){

            @Override
            public double yCalibrationHandler(double rawValue, int calibType, ArrayList<Integer> params, ArrayList<Double> rawValues, ArrayList<Double> refValues) {
                int npt;
                double x = rawValues.get(0);
                double adj = refValues.get(0) - x;
                int i = 0;
                if (calibType < 30) {
                    npt = calibType % 10;
                    if (npt > rawValues.size()) {
                        npt = rawValues.size();
                    }
                    if (npt > refValues.size()) {
                        npt = refValues.size();
                    }
                } else {
                    npt = refValues.size();
                }
                while (rawValue > rawValues.get(i) && ++i < npt) {
                    double x2 = x;
                    double adj2 = adj;
                    x = rawValues.get(i);
                    adj = refValues.get(i) - x;
                    if (!(rawValue < x) || !(x > x2)) continue;
                    adj = adj2 + (adj - adj2) * (rawValue - x2) / (x - x2);
                }
                return rawValue + adj;
            }
        };
        _ValueCallbackList = new ArrayList();
        _TimedReportCallbackList = new ArrayList();
        decExp = new double[]{1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
        _hexArray = "0123456789abcdef".toCharArray();
        _MultipleYAPI = null;
        _SingleYAPI = null;
    }

    static class PlugEvent {
        public Event ev;
        public YModule module;

        public PlugEvent(Event ev, String serial) {
            this.ev = ev;
            this.module = YModule.FindModule(serial + ".module");
        }

        public static enum Event {
            PLUG,
            UNPLUG,
            CHANGE;

        }
    }

    static class DataEvent {
        private final YFunction _fun;
        private final String _value;
        private final ArrayList<Integer> _report;
        private final double _timestamp;

        public DataEvent(YFunction fun, String value) {
            this._fun = fun;
            this._value = value;
            this._report = null;
            this._timestamp = 0.0;
        }

        public DataEvent(YFunction fun, double timestamp, ArrayList<Integer> report) {
            this._fun = fun;
            this._value = null;
            this._timestamp = timestamp;
            this._report = report;
        }

        public void invoke() {
            if (this._value == null) {
                YSensor sensor = (YSensor)this._fun;
                YMeasure mesure = sensor._decodeTimedReport(this._timestamp, this._report);
                sensor._invokeTimedReportCallback(mesure);
            } else {
                this._fun._invokeValueCallback(this._value);
            }
        }
    }

    public static interface HubDiscoveryCallback {
        public void yHubDiscoveryCallback(String var1, String var2);
    }

    public static interface CalibrationHandlerCallback {
        public double yCalibrationHandler(double var1, int var3, ArrayList<Integer> var4, ArrayList<Double> var5, ArrayList<Double> var6);
    }

    public static interface LogCallback {
        public void yLog(String var1);
    }

    public static interface DeviceChangeCallback {
        public void yDeviceChange(YModule var1);
    }

    public static interface DeviceRemovalCallback {
        public void yDeviceRemoval(YModule var1);
    }

    public static interface DeviceArrivalCallback {
        public void yDeviceArrival(YModule var1);
    }
}

