/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Date;

class yHTTPRequest
implements Runnable {
    private Object _context;
    private YGenericHub.RequestAsyncResult _resultCallback;
    public static final int MAX_REQUEST_MS = 5000;
    private final YHTTPHub _hub;
    private Socket _socket = null;
    private boolean _reuse_socket = false;
    private BufferedOutputStream _out = null;
    private BufferedInputStream _in = null;
    private State _state = State.AVAIL;
    private boolean _eof;
    private String _firstLine;
    private byte[] _rest_of_request;
    private final String _dbglabel;
    private final StringBuilder _header = new StringBuilder(1024);
    private Boolean _header_found;
    private final ByteArrayOutputStream _result = new ByteArrayOutputStream(1024);
    private long _startRequestTime;
    private long _lastReceiveTime;
    private volatile int _noTrafficTimeout = 0;
    private volatile int _soTimeout = 5000;

    public void kill() {
        this._requestStop();
    }

    yHTTPRequest(YHTTPHub hub, String dbglabel) {
        this._hub = hub;
        this._dbglabel = dbglabel;
    }

    public void setNoTrafficTimeout(int noTrafficTimeout) throws SocketException {
        this._noTrafficTimeout = noTrafficTimeout;
        if (this._soTimeout > noTrafficTimeout) {
            this._soTimeout = noTrafficTimeout;
            if (this._socket != null) {
                this._socket.setSoTimeout(this._soTimeout);
            }
        }
    }

    synchronized void _requestReserve() throws YAPI_Exception {
        long timeout = YAPI.GetTickCount() + 5000L + 1000L;
        while (timeout > YAPI.GetTickCount() && this._state != State.AVAIL) {
            try {
                long toWait = timeout - YAPI.GetTickCount();
                this.wait(toWait);
            }
            catch (InterruptedException ie) {
                throw new YAPI_Exception(-7, "Last Http request did not finished");
            }
        }
        if (this._state != State.AVAIL) {
            throw new YAPI_Exception(-7, "Last Http request did not finished");
        }
        this._state = State.IN_REQUEST;
    }

    synchronized void _requestRelease() {
        this._state = State.AVAIL;
        this.notify();
    }

    void _requestStart(String firstLine, byte[] rest_of_request, Object context, YGenericHub.RequestAsyncResult resultCallback) throws YAPI_Exception {
        byte[] full_request;
        String str_request;
        this._firstLine = firstLine;
        this._rest_of_request = rest_of_request;
        this._context = context;
        this._resultCallback = resultCallback;
        String persistent_tag = firstLine.substring(firstLine.length() - 2);
        firstLine = persistent_tag.equals("&.") ? firstLine + " \r\n" : firstLine + " \r\nConnection: close\r\n";
        if (rest_of_request == null) {
            str_request = firstLine + this._hub.getAuthorization(firstLine) + "\r\n";
            full_request = str_request.getBytes();
        } else {
            str_request = firstLine + this._hub.getAuthorization(firstLine);
            int len = str_request.length();
            full_request = new byte[len + rest_of_request.length];
            System.arraycopy(str_request.getBytes(), 0, full_request, 0, len);
            System.arraycopy(rest_of_request, 0, full_request, len, rest_of_request.length);
        }
        try {
            if (!this._reuse_socket) {
                this._socket = new Socket(this._hub.getHost(), this._hub.getPort());
                this._socket.setTcpNoDelay(true);
                this._socket.setSoTimeout(this._soTimeout);
                this._out = new BufferedOutputStream(this._socket.getOutputStream());
                this._in = new BufferedInputStream(this._socket.getInputStream());
            }
            this._result.reset();
            this._header.setLength(0);
            this._header_found = false;
            this._eof = false;
            this._out.write(full_request);
            this._out.flush();
            this._reuse_socket = false;
            this._lastReceiveTime = -1L;
            this._startRequestTime = new Date().getTime();
        }
        catch (UnknownHostException e) {
            this._requestStop();
            throw new YAPI_Exception(-2, "Unknown host(" + this._hub.getHost() + ")");
        }
        catch (SocketException e) {
            this._requestStop();
            throw new YAPI_Exception(-8, e.getLocalizedMessage());
        }
        catch (IOException e) {
            this._requestStop();
            throw new YAPI_Exception(-8, e.getLocalizedMessage());
        }
    }

    void _requestStop() {
        if (!this._reuse_socket) {
            if (this._out != null) {
                try {
                    this._out.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                this._out = null;
            }
            if (this._in != null) {
                try {
                    this._in.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                this._in = null;
            }
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._socket = null;
            }
        }
    }

    void _requestReset() throws YAPI_Exception {
        this._requestStop();
        this._requestStart(this._firstLine, this._rest_of_request, this._context, this._resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _requestProcesss() throws YAPI_Exception {
        boolean retry;
        int read = 0;
        if (this._eof) {
            return -1;
        }
        do {
            retry = false;
            byte[] buffer = new byte[1024];
            try {
                read = this._in.read(buffer, 0, buffer.length);
            }
            catch (SocketTimeoutException e) {
                Date now = new Date();
                long duration = now.getTime() - this._startRequestTime;
                if (duration > 5000L) {
                    throw new YAPI_Exception(-7, String.format("TCP request took too long (%dms)", duration));
                }
                if (duration > 2500L) {
                    YAPI.SafeYAPI()._Log(String.format("Slow TCP request on %s (%dms)\n", this._hub.getHost(), duration));
                }
                if (this._lastReceiveTime < 0L || now.getTime() - this._lastReceiveTime < (long)this._noTrafficTimeout) {
                    retry = true;
                    continue;
                }
                throw new YAPI_Exception(-7, String.format("Hub did not send data during %dms", now.getTime() - this._lastReceiveTime));
            }
            catch (IOException e) {
                throw new YAPI_Exception(-8, e.getLocalizedMessage());
            }
            if (read < 0) {
                this._reuse_socket = false;
                this._eof = true;
                continue;
            }
            if (read <= 0) continue;
            this._lastReceiveTime = new Date().getTime();
            ByteArrayOutputStream byteArrayOutputStream = this._result;
            synchronized (byteArrayOutputStream) {
                if (!this._header_found.booleanValue()) {
                    String partial_head = new String(buffer, 0, read, YAPI.DeviceCharset);
                    this._header.append(partial_head);
                    int pos = this._header.indexOf("\r\n\r\n");
                    if (pos > 0) {
                        pos += 4;
                        try {
                            this._result.write(this._header.substring(pos).getBytes(YAPI.DeviceCharset));
                        }
                        catch (IOException ex) {
                            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
                        }
                        this._header_found = true;
                        this._header.setLength(pos);
                        if (this._header.indexOf("0K\r\n") == 0) {
                            this._reuse_socket = true;
                        } else if (this._header.indexOf("OK\r\n") != 0) {
                            int lpos = this._header.indexOf("\r\n");
                            if (this._header.indexOf("HTTP/1.1 ") != 0) {
                                throw new YAPI_Exception(-8, "Invalid HTTP response header");
                            }
                            String[] parts = this._header.substring(9, lpos).split(" ");
                            if (parts[0].equals("401")) {
                                if (!this._hub.needRetryWithAuth()) {
                                    throw new YAPI_Exception(-12, "Authentication required");
                                }
                                this._hub.parseWWWAuthenticate(this._header.toString());
                                this._requestReset();
                                break;
                            }
                            if (!parts[0].equals("200") && !parts[0].equals("304")) {
                                throw new YAPI_Exception(-8, "Received HTTP status " + parts[0] + " (" + parts[1] + ")");
                            }
                        }
                        this._hub.authSucceded();
                    }
                } else {
                    this._result.write(buffer, 0, read);
                }
                if (this._reuse_socket && this._result.toString().endsWith("\r\n")) {
                    this._eof = true;
                }
            }
        } while (retry);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getPartialResult() throws YAPI_Exception {
        byte[] res;
        ByteArrayOutputStream byteArrayOutputStream = this._result;
        synchronized (byteArrayOutputStream) {
            if (!this._header_found.booleanValue()) {
                return null;
            }
            if (this._result.size() == 0) {
                if (this._eof) {
                    throw new YAPI_Exception(-9, "end of file reached");
                }
                return null;
            }
            res = this._result.toByteArray();
            this._result.reset();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] RequestSync(String req_first_line, byte[] req_head_and_body) throws YAPI_Exception {
        byte[] res;
        this._requestReserve();
        try {
            int read;
            this._requestStart(req_first_line, req_head_and_body, null, null);
            while ((read = this._requestProcesss()) >= 0) {
            }
            ByteArrayOutputStream byteArrayOutputStream = this._result;
            synchronized (byteArrayOutputStream) {
                res = this._result.toByteArray();
                this._result.reset();
            }
        }
        catch (YAPI_Exception ex) {
            this._requestStop();
            this._requestRelease();
            throw ex;
        }
        this._requestStop();
        this._requestRelease();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] res = null;
        int errorType = 0;
        String errmsg = null;
        try {
            int read;
            this._requestProcesss();
            while ((read = this._requestProcesss()) >= 0) {
            }
            ByteArrayOutputStream byteArrayOutputStream = this._result;
            synchronized (byteArrayOutputStream) {
                res = this._result.toByteArray();
                this._result.reset();
            }
        }
        catch (YAPI_Exception ex) {
            errorType = ex.errorType;
            errmsg = ex.getMessage();
            YAPI.SafeYAPI()._Log("ASYNC request " + this._firstLine + "failed:" + errmsg + "\n");
        }
        this._requestStop();
        if (this._resultCallback != null) {
            this._resultCallback.RequestAsyncDone(this._context, res, errorType, errmsg);
        }
        this._requestRelease();
    }

    void RequestAsync(String req_first_line, byte[] req_head_and_body, YGenericHub.RequestAsyncResult callback, Object context) throws YAPI_Exception {
        this._requestReserve();
        try {
            this._requestStart(req_first_line, req_head_and_body, context, callback);
            Thread t = new Thread(this);
            t.setName(this._dbglabel);
            t.start();
        }
        catch (YAPI_Exception ex) {
            this._requestRelease();
            throw ex;
        }
    }

    synchronized void WaitRequestEnd() {
        long timeout = YAPI.GetTickCount() + 5000L;
        while (timeout > YAPI.GetTickCount() && this._state == State.IN_REQUEST) {
            long toWait = timeout - YAPI.GetTickCount();
            try {
                this.wait(toWait);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        if (this._state == State.IN_REQUEST) {
            YAPI.SafeYAPI()._Log("WARNING: Last Http request did not finished");
        }
        this._reuse_socket = false;
        this._requestStop();
        this._state = State.STOPPED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        AVAIL,
        IN_REQUEST,
        STOPPED;

    }
}

