/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YWlanRecord;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YWireless
extends YFunction {
    public static final int LINKQUALITY_INVALID = -1;
    public static final String SSID_INVALID = "!INVALID!";
    public static final int CHANNEL_INVALID = -1;
    public static final int SECURITY_UNKNOWN = 0;
    public static final int SECURITY_OPEN = 1;
    public static final int SECURITY_WEP = 2;
    public static final int SECURITY_WPA = 3;
    public static final int SECURITY_WPA2 = 4;
    public static final int SECURITY_INVALID = -1;
    public static final String MESSAGE_INVALID = "!INVALID!";
    public static final String WLANCONFIG_INVALID = "!INVALID!";
    protected int _linkQuality = -1;
    protected String _ssid = "!INVALID!";
    protected int _channel = -1;
    protected int _security = -1;
    protected String _message = "!INVALID!";
    protected String _wlanConfig = "!INVALID!";
    protected UpdateCallback _valueCallbackWireless = null;

    protected YWireless(String func) {
        super(func);
        this._className = "Wireless";
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("linkQuality")) {
            this._linkQuality = json_val.getInt("linkQuality");
        }
        if (json_val.has("ssid")) {
            this._ssid = json_val.getString("ssid");
        }
        if (json_val.has("channel")) {
            this._channel = json_val.getInt("channel");
        }
        if (json_val.has("security")) {
            this._security = json_val.getInt("security");
        }
        if (json_val.has("message")) {
            this._message = json_val.getString("message");
        }
        if (json_val.has("wlanConfig")) {
            this._wlanConfig = json_val.getString("wlanConfig");
        }
        super._parseAttr(json_val);
    }

    public int get_linkQuality() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._linkQuality;
    }

    public int getLinkQuality() throws YAPI_Exception {
        return this.get_linkQuality();
    }

    public String get_ssid() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._ssid;
    }

    public String getSsid() throws YAPI_Exception {
        return this.get_ssid();
    }

    public int get_channel() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._channel;
    }

    public int getChannel() throws YAPI_Exception {
        return this.get_channel();
    }

    public int get_security() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._security;
    }

    public int getSecurity() throws YAPI_Exception {
        return this.get_security();
    }

    public String get_message() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._message;
    }

    public String getMessage() throws YAPI_Exception {
        return this.get_message();
    }

    public String get_wlanConfig() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._wlanConfig;
    }

    public String getWlanConfig() throws YAPI_Exception {
        return this.get_wlanConfig();
    }

    public int set_wlanConfig(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("wlanConfig", rest_val);
        return 0;
    }

    public int setWlanConfig(String newval) throws YAPI_Exception {
        return this.set_wlanConfig(newval);
    }

    public static YWireless FindWireless(String func) {
        YWireless obj = (YWireless)YFunction._FindFromCache("Wireless", func);
        if (obj == null) {
            obj = new YWireless(func);
            YFunction._AddToCache("Wireless", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackWireless = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackWireless != null) {
            this._valueCallbackWireless.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int joinNetwork(String ssid, String securityKey) throws YAPI_Exception {
        return this.set_wlanConfig(String.format("INFRA:%s\\%s", ssid, securityKey));
    }

    public int adhocNetwork(String ssid, String securityKey) throws YAPI_Exception {
        return this.set_wlanConfig(String.format("ADHOC:%s\\%s", ssid, securityKey));
    }

    public int softAPNetwork(String ssid, String securityKey) throws YAPI_Exception {
        return this.set_wlanConfig(String.format("SOFTAP:%s\\%s", ssid, securityKey));
    }

    public ArrayList<YWlanRecord> get_detectedWlans() throws YAPI_Exception {
        ArrayList<Object> wlanlist = new ArrayList();
        ArrayList<YWlanRecord> res = new ArrayList<YWlanRecord>();
        byte[] json = this._download("wlan.json?by=name");
        wlanlist = this._json_get_array(json);
        res.clear();
        for (String string : wlanlist) {
            res.add(new YWlanRecord(string));
        }
        return res;
    }

    public YWireless nextWireless() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YWireless.FindWireless(next_hwid);
    }

    public static YWireless FirstWireless() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Wireless");
        if (next_hwid == null) {
            return null;
        }
        return YWireless.FindWireless(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YWireless var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YWireless var1, String var2);
    }
}

