/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSensor;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YTemperature
extends YSensor {
    public static final int SENSORTYPE_DIGITAL = 0;
    public static final int SENSORTYPE_TYPE_K = 1;
    public static final int SENSORTYPE_TYPE_E = 2;
    public static final int SENSORTYPE_TYPE_J = 3;
    public static final int SENSORTYPE_TYPE_N = 4;
    public static final int SENSORTYPE_TYPE_R = 5;
    public static final int SENSORTYPE_TYPE_S = 6;
    public static final int SENSORTYPE_TYPE_T = 7;
    public static final int SENSORTYPE_PT100_4WIRES = 8;
    public static final int SENSORTYPE_PT100_3WIRES = 9;
    public static final int SENSORTYPE_PT100_2WIRES = 10;
    public static final int SENSORTYPE_RES_OHM = 11;
    public static final int SENSORTYPE_RES_NTC = 12;
    public static final int SENSORTYPE_RES_LINEAR = 13;
    public static final int SENSORTYPE_INVALID = -1;
    public static final String COMMAND_INVALID = "!INVALID!";
    protected int _sensorType = -1;
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackTemperature = null;
    protected TimedReportCallback _timedReportCallbackTemperature = null;

    protected YTemperature(String func) {
        super(func);
        this._className = "Temperature";
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("sensorType")) {
            this._sensorType = json_val.getInt("sensorType");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    public int set_unit(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("unit", rest_val);
        return 0;
    }

    public int setUnit(String newval) throws YAPI_Exception {
        return this.set_unit(newval);
    }

    public int get_sensorType() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._sensorType;
    }

    public int getSensorType() throws YAPI_Exception {
        return this.get_sensorType();
    }

    public int set_sensorType(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("sensorType", rest_val);
        return 0;
    }

    public int setSensorType(int newval) throws YAPI_Exception {
        return this.set_sensorType(newval);
    }

    public String get_command() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return COMMAND_INVALID;
        }
        return this._command;
    }

    public String getCommand() throws YAPI_Exception {
        return this.get_command();
    }

    public int set_command(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("command", rest_val);
        return 0;
    }

    public int setCommand(String newval) throws YAPI_Exception {
        return this.set_command(newval);
    }

    public static YTemperature FindTemperature(String func) {
        YTemperature obj = (YTemperature)YFunction._FindFromCache("Temperature", func);
        if (obj == null) {
            obj = new YTemperature(func);
            YFunction._AddToCache("Temperature", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackTemperature = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackTemperature != null) {
            this._valueCallbackTemperature.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(this, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(this, false);
        }
        this._timedReportCallbackTemperature = callback;
        return 0;
    }

    @Override
    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackTemperature != null) {
            this._timedReportCallbackTemperature.timedReportCallback(this, value);
        } else {
            super._invokeTimedReportCallback(value);
        }
        return 0;
    }

    public int set_thermistorResponseTable(ArrayList<Double> tempValues, ArrayList<Double> resValues) throws YAPI_Exception {
        int siz = tempValues.size();
        if (siz < 2) {
            throw new YAPI_Exception(-2, "thermistor response table must have at least two points");
        }
        if (siz != resValues.size()) {
            throw new YAPI_Exception(-2, "table sizes mismatch");
        }
        int res = this.set_command("Z");
        if (res != 0) {
            throw new YAPI_Exception(-8, "unable to reset thermistor parameters");
        }
        int found = 1;
        double prev = 0.0;
        while (found > 0) {
            found = 0;
            double curr = 9.9999999E7;
            double currTemp = -999999.0;
            for (int idx = 0; idx < siz; ++idx) {
                double idxres = resValues.get(idx);
                if (!(idxres > prev) || !(idxres < curr)) continue;
                curr = idxres;
                currTemp = tempValues.get(idx);
                found = 1;
            }
            if (found <= 0) continue;
            res = this.set_command(String.format("m%d:%d", (int)Math.round(1000.0 * curr), (int)Math.round(1000.0 * currTemp)));
            if (res != 0) {
                throw new YAPI_Exception(-8, "unable to reset thermistor parameters");
            }
            prev = curr;
        }
        return 0;
    }

    public int loadThermistorResponseTable(ArrayList<Double> tempValues, ArrayList<Double> resValues) throws YAPI_Exception {
        double temp;
        int idx;
        ArrayList<Object> paramlist = new ArrayList();
        ArrayList<Double> templist = new ArrayList<Double>();
        tempValues.clear();
        resValues.clear();
        String id = this.get_functionId();
        id = id.substring(11, 11 + id.length() - 1);
        byte[] bin_json = this._download(String.format("extra.json?page=%s", id));
        paramlist = this._json_get_array(bin_json);
        int siz = paramlist.size() >> 1;
        templist.clear();
        for (idx = 0; idx < siz; ++idx) {
            temp = Double.valueOf((String)paramlist.get(2 * idx + 1)) / 1000.0;
            templist.add(temp);
        }
        tempValues.clear();
        resValues.clear();
        int found = 1;
        double prev = -999999.0;
        while (found > 0) {
            found = 0;
            double curr = 999999.0;
            double currRes = -999999.0;
            for (idx = 0; idx < siz; ++idx) {
                temp = (Double)templist.get(idx);
                if (!(temp > prev) || !(temp < curr)) continue;
                curr = temp;
                currRes = Double.valueOf((String)paramlist.get(2 * idx)) / 1000.0;
                found = 1;
            }
            if (found <= 0) continue;
            tempValues.add(curr);
            resValues.add(currRes);
            prev = curr;
        }
        return 0;
    }

    public YTemperature nextTemperature() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YTemperature.FindTemperature(next_hwid);
    }

    public static YTemperature FirstTemperature() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Temperature");
        if (next_hwid == null) {
            return null;
        }
        return YTemperature.FindTemperature(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YTemperature var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YTemperature var1, String var2);
    }
}

