/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import org.json.JSONException;
import org.json.JSONObject;

public class YServo
extends YFunction {
    public static final int POSITION_INVALID = Integer.MIN_VALUE;
    public static final int ENABLED_FALSE = 0;
    public static final int ENABLED_TRUE = 1;
    public static final int ENABLED_INVALID = -1;
    public static final int RANGE_INVALID = -1;
    public static final int NEUTRAL_INVALID = -1;
    public static final int POSITIONATPOWERON_INVALID = Integer.MIN_VALUE;
    public static final int ENABLEDATPOWERON_FALSE = 0;
    public static final int ENABLEDATPOWERON_TRUE = 1;
    public static final int ENABLEDATPOWERON_INVALID = -1;
    public static final YMove MOVE_INVALID = null;
    protected int _position = Integer.MIN_VALUE;
    protected int _enabled = -1;
    protected int _range = -1;
    protected int _neutral = -1;
    protected YMove _move = new YMove();
    protected int _positionAtPowerOn = Integer.MIN_VALUE;
    protected int _enabledAtPowerOn = -1;
    protected UpdateCallback _valueCallbackServo = null;

    protected YServo(String func) {
        super(func);
        this._className = "Servo";
    }

    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("position")) {
            this._position = json_val.getInt("position");
        }
        if (json_val.has("enabled")) {
            int n = this._enabled = json_val.getInt("enabled") > 0 ? 1 : 0;
        }
        if (json_val.has("range")) {
            this._range = json_val.getInt("range");
        }
        if (json_val.has("neutral")) {
            this._neutral = json_val.getInt("neutral");
        }
        if (json_val.has("move")) {
            JSONObject subjson = json_val.getJSONObject("move");
            if (subjson.has("moving")) {
                this._move.moving = subjson.getInt("moving");
            }
            if (subjson.has("target")) {
                this._move.moving = subjson.getInt("target");
            }
            if (subjson.has("ms")) {
                this._move.moving = subjson.getInt("ms");
            }
        }
        if (json_val.has("positionAtPowerOn")) {
            this._positionAtPowerOn = json_val.getInt("positionAtPowerOn");
        }
        if (json_val.has("enabledAtPowerOn")) {
            this._enabledAtPowerOn = json_val.getInt("enabledAtPowerOn") > 0 ? 1 : 0;
        }
        super._parseAttr(json_val);
    }

    public int get_position() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return Integer.MIN_VALUE;
        }
        return this._position;
    }

    public int getPosition() throws YAPI_Exception {
        return this.get_position();
    }

    public int set_position(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("position", rest_val);
        return 0;
    }

    public int setPosition(int newval) throws YAPI_Exception {
        return this.set_position(newval);
    }

    public int get_enabled() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._enabled;
    }

    public int getEnabled() throws YAPI_Exception {
        return this.get_enabled();
    }

    public int set_enabled(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("enabled", rest_val);
        return 0;
    }

    public int setEnabled(int newval) throws YAPI_Exception {
        return this.set_enabled(newval);
    }

    public int get_range() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._range;
    }

    public int getRange() throws YAPI_Exception {
        return this.get_range();
    }

    public int set_range(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("range", rest_val);
        return 0;
    }

    public int setRange(int newval) throws YAPI_Exception {
        return this.set_range(newval);
    }

    public int get_neutral() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._neutral;
    }

    public int getNeutral() throws YAPI_Exception {
        return this.get_neutral();
    }

    public int set_neutral(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("neutral", rest_val);
        return 0;
    }

    public int setNeutral(int newval) throws YAPI_Exception {
        return this.set_neutral(newval);
    }

    public YMove get_move() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return MOVE_INVALID;
        }
        return this._move;
    }

    public YMove getMove() throws YAPI_Exception {
        return this.get_move();
    }

    public int set_move(YMove newval) throws YAPI_Exception {
        String rest_val = String.format("%d:%d", newval.target, newval.ms);
        this._setAttr("move", rest_val);
        return 0;
    }

    public int setMove(YMove newval) throws YAPI_Exception {
        return this.set_move(newval);
    }

    public int move(int target, int ms_duration) throws YAPI_Exception {
        String rest_val = String.format("%d:%d", target, ms_duration);
        this._setAttr("move", rest_val);
        return 0;
    }

    public int get_positionAtPowerOn() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return Integer.MIN_VALUE;
        }
        return this._positionAtPowerOn;
    }

    public int getPositionAtPowerOn() throws YAPI_Exception {
        return this.get_positionAtPowerOn();
    }

    public int set_positionAtPowerOn(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("positionAtPowerOn", rest_val);
        return 0;
    }

    public int setPositionAtPowerOn(int newval) throws YAPI_Exception {
        return this.set_positionAtPowerOn(newval);
    }

    public int get_enabledAtPowerOn() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._enabledAtPowerOn;
    }

    public int getEnabledAtPowerOn() throws YAPI_Exception {
        return this.get_enabledAtPowerOn();
    }

    public int set_enabledAtPowerOn(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("enabledAtPowerOn", rest_val);
        return 0;
    }

    public int setEnabledAtPowerOn(int newval) throws YAPI_Exception {
        return this.set_enabledAtPowerOn(newval);
    }

    public static YServo FindServo(String func) {
        YServo obj = (YServo)YFunction._FindFromCache("Servo", func);
        if (obj == null) {
            obj = new YServo(func);
            YFunction._AddToCache("Servo", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackServo = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    public int _invokeValueCallback(String value) {
        if (this._valueCallbackServo != null) {
            this._valueCallbackServo.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public YServo nextServo() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YServo.FindServo(next_hwid);
    }

    public static YServo FirstServo() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Servo");
        if (next_hwid == null) {
            return null;
        }
        return YServo.FindServo(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YServo var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YServo var1, String var2);
    }

    public static class YMove {
        public int target = Integer.MIN_VALUE;
        public int ms = Integer.MIN_VALUE;
        public int moving = -1;
    }
}

