/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataSet;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YSensor
extends YFunction {
    public static final String UNIT_INVALID = "!INVALID!";
    public static final double CURRENTVALUE_INVALID = -1.79769313486231E308;
    public static final double LOWESTVALUE_INVALID = -1.79769313486231E308;
    public static final double HIGHESTVALUE_INVALID = -1.79769313486231E308;
    public static final double CURRENTRAWVALUE_INVALID = -1.79769313486231E308;
    public static final String LOGFREQUENCY_INVALID = "!INVALID!";
    public static final String REPORTFREQUENCY_INVALID = "!INVALID!";
    public static final String CALIBRATIONPARAM_INVALID = "!INVALID!";
    public static final double RESOLUTION_INVALID = -1.79769313486231E308;
    protected String _unit = "!INVALID!";
    protected double _currentValue = -1.79769313486231E308;
    protected double _lowestValue = -1.79769313486231E308;
    protected double _highestValue = -1.79769313486231E308;
    protected double _currentRawValue = -1.79769313486231E308;
    protected String _logFrequency = "!INVALID!";
    protected String _reportFrequency = "!INVALID!";
    protected String _calibrationParam = "!INVALID!";
    protected double _resolution = -1.79769313486231E308;
    protected UpdateCallback _valueCallbackSensor = null;
    protected TimedReportCallback _timedReportCallbackSensor = null;
    protected double _prevTimedReport = 0.0;
    protected double _iresol = 0.0;
    protected double _offset = 0.0;
    protected double _scale = 0.0;
    protected double _decexp = 0.0;
    protected boolean _isScal;
    protected boolean _isScal32;
    protected int _caltyp = 0;
    protected ArrayList<Integer> _calpar = new ArrayList();
    protected ArrayList<Double> _calraw = new ArrayList();
    protected ArrayList<Double> _calref = new ArrayList();
    protected YAPI.CalibrationHandlerCallback _calhdl;

    String _encodeCalibrationPoints(ArrayList<Double> rawValues, ArrayList<Double> refValues, String actualCparams) throws YAPI_Exception {
        int npt = rawValues.size() < refValues.size() ? rawValues.size() : refValues.size();
        int minRaw = 0;
        if (npt == 0) {
            return "0";
        }
        int pos = actualCparams.indexOf(44);
        if (actualCparams.equals("") || actualCparams.equals("0") || pos >= 0) {
            this._throw(-3, "Device does not support new calibration parameters. Please upgrade your firmware");
            return "0";
        }
        ArrayList<Integer> iCalib = YAPI._decodeWords(actualCparams);
        int calibrationOffset = iCalib.get(0);
        int divisor = iCalib.get(1);
        int calibType = divisor > 0 ? npt : 10 + npt;
        String res = Integer.toString(calibType);
        if (calibType <= 10) {
            for (int i = 0; i < npt; ++i) {
                int refVal;
                int rawVal = (int)(rawValues.get(i) * (double)divisor - (double)calibrationOffset + 0.5);
                if (rawVal < minRaw || rawVal >= 65536 || (refVal = (int)(refValues.get(i) * (double)divisor - (double)calibrationOffset + 0.5)) < 0 || refVal >= 65536) continue;
                res = res + String.format(",%d,%d", rawVal, refVal);
                minRaw = rawVal + 1;
            }
        } else {
            for (int i = 0; i < npt; ++i) {
                int rawVal = (int)YAPI._doubleToDecimal(rawValues.get(i));
                int refVal = (int)YAPI._doubleToDecimal(refValues.get(i));
                res = res + String.format(",%d,%d", rawVal, refVal);
            }
        }
        return res;
    }

    static int _decodeCalibrationPoints(String calibParams, ArrayList<Integer> intPt, ArrayList<Double> rawPt, ArrayList<Double> calPt) throws YAPI_Exception {
        int calibType;
        intPt.clear();
        rawPt.clear();
        calPt.clear();
        if (calibParams.equals("") || calibParams.equals("0")) {
            return 0;
        }
        if (calibParams.indexOf(44) != -1) {
            return -1;
        }
        ArrayList<Integer> iCalib = YAPI._decodeWords(calibParams);
        if (iCalib.size() < 2) {
            return -1;
        }
        if (iCalib.size() == 2) {
            return 0;
        }
        int pos = 0;
        double calibrationOffset = iCalib.get(pos++).intValue();
        double divisor = iCalib.get(pos++).intValue();
        if ((calibType = iCalib.get(pos++).intValue()) == 0) {
            return 0;
        }
        while (pos < iCalib.size()) {
            int ival = iCalib.get(pos++);
            double fval = calibType <= 10 ? ((double)ival + calibrationOffset) / divisor : YAPI._decimalToDouble(ival);
            intPt.add(ival);
            if ((intPt.size() & 1) == 1) {
                rawPt.add(fval);
                continue;
            }
            calPt.add(fval);
        }
        if (intPt.size() < 10) {
            return -1;
        }
        return calibType;
    }

    protected YSensor(String func) {
        super(func);
        this._className = "Sensor";
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("unit")) {
            this._unit = json_val.getString("unit");
        }
        if (json_val.has("currentValue")) {
            this._currentValue = (double)Math.round(json_val.getDouble("currentValue") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("lowestValue")) {
            this._lowestValue = (double)Math.round(json_val.getDouble("lowestValue") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("highestValue")) {
            this._highestValue = (double)Math.round(json_val.getDouble("highestValue") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("currentRawValue")) {
            this._currentRawValue = (double)Math.round(json_val.getDouble("currentRawValue") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("logFrequency")) {
            this._logFrequency = json_val.getString("logFrequency");
        }
        if (json_val.has("reportFrequency")) {
            this._reportFrequency = json_val.getString("reportFrequency");
        }
        if (json_val.has("calibrationParam")) {
            this._calibrationParam = json_val.getString("calibrationParam");
        }
        if (json_val.has("resolution")) {
            this._resolution = (double)Math.round(json_val.getDouble("resolution") * 1000.0 / 65536.0) / 1000.0;
        }
        super._parseAttr(json_val);
    }

    public String get_unit() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._unit;
    }

    public String getUnit() throws YAPI_Exception {
        return this.get_unit();
    }

    public double get_currentValue() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        double res = this._applyCalibration(this._currentRawValue);
        if (res == -1.79769313486231E308) {
            res = this._currentValue;
        }
        return (double)Math.round(res *= this._iresol) / this._iresol;
    }

    public double getCurrentValue() throws YAPI_Exception {
        return this.get_currentValue();
    }

    public int set_lowestValue(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("lowestValue", rest_val);
        return 0;
    }

    public int setLowestValue(double newval) throws YAPI_Exception {
        return this.set_lowestValue(newval);
    }

    public double get_lowestValue() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        double res = this._lowestValue * this._iresol;
        return (double)Math.round(res) / this._iresol;
    }

    public double getLowestValue() throws YAPI_Exception {
        return this.get_lowestValue();
    }

    public int set_highestValue(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("highestValue", rest_val);
        return 0;
    }

    public int setHighestValue(double newval) throws YAPI_Exception {
        return this.set_highestValue(newval);
    }

    public double get_highestValue() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        double res = this._highestValue * this._iresol;
        return (double)Math.round(res) / this._iresol;
    }

    public double getHighestValue() throws YAPI_Exception {
        return this.get_highestValue();
    }

    public double get_currentRawValue() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._currentRawValue;
    }

    public double getCurrentRawValue() throws YAPI_Exception {
        return this.get_currentRawValue();
    }

    public String get_logFrequency() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._logFrequency;
    }

    public String getLogFrequency() throws YAPI_Exception {
        return this.get_logFrequency();
    }

    public int set_logFrequency(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("logFrequency", rest_val);
        return 0;
    }

    public int setLogFrequency(String newval) throws YAPI_Exception {
        return this.set_logFrequency(newval);
    }

    public String get_reportFrequency() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._reportFrequency;
    }

    public String getReportFrequency() throws YAPI_Exception {
        return this.get_reportFrequency();
    }

    public int set_reportFrequency(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("reportFrequency", rest_val);
        return 0;
    }

    public int setReportFrequency(String newval) throws YAPI_Exception {
        return this.set_reportFrequency(newval);
    }

    public String get_calibrationParam() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._calibrationParam;
    }

    public String getCalibrationParam() throws YAPI_Exception {
        return this.get_calibrationParam();
    }

    public int set_calibrationParam(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("calibrationParam", rest_val);
        return 0;
    }

    public int setCalibrationParam(String newval) throws YAPI_Exception {
        return this.set_calibrationParam(newval);
    }

    public int set_resolution(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("resolution", rest_val);
        return 0;
    }

    public int setResolution(double newval) throws YAPI_Exception {
        return this.set_resolution(newval);
    }

    public double get_resolution() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._resolution;
    }

    public double getResolution() throws YAPI_Exception {
        return this.get_resolution();
    }

    public static YSensor FindSensor(String func) {
        YSensor obj = (YSensor)YFunction._FindFromCache("Sensor", func);
        if (obj == null) {
            obj = new YSensor(func);
            YFunction._AddToCache("Sensor", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackSensor = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackSensor != null) {
            this._valueCallbackSensor.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    @Override
    public int _parserHelper() {
        ArrayList<Object> iCalib = new ArrayList();
        this._caltyp = -1;
        this._scale = -1.0;
        this._isScal32 = false;
        this._calpar.clear();
        this._calraw.clear();
        this._calref.clear();
        if (this._resolution > 0.0) {
            this._iresol = Math.round(1.0 / this._resolution);
        } else {
            this._iresol = 10000.0;
            this._resolution = 1.0E-4;
        }
        if (this._calibrationParam.equals("") || this._calibrationParam.equals("0")) {
            this._caltyp = 0;
            return 0;
        }
        if (this._calibrationParam.indexOf(",") >= 0) {
            int position;
            YAPI.SafeYAPI();
            iCalib = YAPI._decodeFloats(this._calibrationParam);
            this._caltyp = (Integer)iCalib.get(0) / 1000;
            if (this._caltyp > 0) {
                if (this._caltyp < 30) {
                    this._caltyp = -1;
                    return 0;
                }
                this._calhdl = YAPI.SafeYAPI()._getCalibrationHandler(this._caltyp);
                if (this._calhdl == null) {
                    this._caltyp = -1;
                    return 0;
                }
            }
            this._isScal = true;
            this._isScal32 = true;
            this._offset = 0.0;
            this._scale = 1000.0;
            int maxpos = iCalib.size();
            this._calpar.clear();
            for (position = 1; position < maxpos; ++position) {
                this._calpar.add((Integer)iCalib.get(position));
            }
            this._calraw.clear();
            this._calref.clear();
            position = 1;
            while (position + 1 < maxpos) {
                double fRaw = ((Integer)iCalib.get(position)).doubleValue();
                double fRef = ((Integer)iCalib.get(position + 1)).doubleValue();
                this._calraw.add(fRaw /= 1000.0);
                this._calref.add(fRef /= 1000.0);
                position += 2;
            }
        } else {
            int position;
            YAPI.SafeYAPI();
            iCalib = YAPI._decodeWords(this._calibrationParam);
            if (iCalib.size() < 2) {
                this._caltyp = -1;
                return 0;
            }
            boolean bl = this._isScal = (Integer)iCalib.get(1) > 0;
            if (this._isScal) {
                this._offset = ((Integer)iCalib.get(0)).doubleValue();
                if (this._offset > 32767.0) {
                    this._offset -= 65536.0;
                }
                this._scale = ((Integer)iCalib.get(1)).doubleValue();
                this._decexp = 0.0;
            } else {
                this._offset = 0.0;
                this._scale = 1.0;
                this._decexp = 1.0;
                for (position = ((Integer)iCalib.get(0)).intValue(); position > 0; --position) {
                    this._decexp *= 10.0;
                }
            }
            if (iCalib.size() == 2) {
                this._caltyp = 0;
                return 0;
            }
            this._caltyp = (Integer)iCalib.get(2);
            this._calhdl = YAPI.SafeYAPI()._getCalibrationHandler(this._caltyp);
            int maxpos = this._caltyp <= 10 ? this._caltyp : (this._caltyp <= 20 ? this._caltyp - 10 : 5);
            if ((maxpos = 3 + 2 * maxpos) > iCalib.size()) {
                maxpos = iCalib.size();
            }
            this._calpar.clear();
            this._calraw.clear();
            this._calref.clear();
            position = 3;
            while (position + 1 < maxpos) {
                int iRaw = (Integer)iCalib.get(position);
                int iRef = (Integer)iCalib.get(position + 1);
                this._calpar.add(iRaw);
                this._calpar.add(iRef);
                if (this._isScal) {
                    double fRaw = iRaw;
                    fRaw = (fRaw - this._offset) / this._scale;
                    double fRef = iRef;
                    fRef = (fRef - this._offset) / this._scale;
                    this._calraw.add(fRaw);
                    this._calref.add(fRef);
                } else {
                    YAPI.SafeYAPI();
                    this._calraw.add(YAPI._decimalToDouble(iRaw));
                    YAPI.SafeYAPI();
                    this._calref.add(YAPI._decimalToDouble(iRef));
                }
                position += 2;
            }
        }
        return 0;
    }

    public int startDataLogger() throws YAPI_Exception {
        byte[] res = this._download("api/dataLogger/recording?recording=1");
        if (res.length <= 0) {
            throw new YAPI_Exception(-8, "unable to start datalogger");
        }
        return 0;
    }

    public int stopDataLogger() throws YAPI_Exception {
        byte[] res = this._download("api/dataLogger/recording?recording=0");
        if (res.length <= 0) {
            throw new YAPI_Exception(-8, "unable to stop datalogger");
        }
        return 0;
    }

    public YDataSet get_recordedData(long startTime, long endTime) throws YAPI_Exception {
        String funcid = this.get_functionId();
        String funit = this.get_unit();
        return new YDataSet(this, funcid, funit, startTime, endTime);
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(this, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(this, false);
        }
        this._timedReportCallbackSensor = callback;
        return 0;
    }

    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackSensor != null) {
            this._timedReportCallbackSensor.timedReportCallback(this, value);
        }
        return 0;
    }

    public int calibrateFromPoints(ArrayList<Double> rawValues, ArrayList<Double> refValues) throws YAPI_Exception {
        String rest_val = this._encodeCalibrationPoints(rawValues, refValues);
        return this._setAttr("calibrationParam", rest_val);
    }

    public int loadCalibrationPoints(ArrayList<Double> rawValues, ArrayList<Double> refValues) throws YAPI_Exception {
        rawValues.clear();
        refValues.clear();
        if (this._scale == 0.0 && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -4;
        }
        if (this._caltyp < 0) {
            this._throw(-3, "Calibration parameters format mismatch. Please upgrade your library or firmware.");
            return -3;
        }
        rawValues.clear();
        refValues.clear();
        for (double ii : this._calraw) {
            rawValues.add(ii);
        }
        for (double ii : this._calref) {
            refValues.add(ii);
        }
        return 0;
    }

    public String _encodeCalibrationPoints(ArrayList<Double> rawValues, ArrayList<Double> refValues) throws YAPI_Exception {
        String res;
        int npt = rawValues.size();
        if (npt != refValues.size()) {
            this._throw(-2, "Invalid calibration parameters (size mismatch)");
            return "!INVALID!";
        }
        if (npt == 0) {
            return "0";
        }
        if (this._scale == 0.0 && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        if (this._caltyp < 0 || this._scale < 0.0) {
            this._throw(-3, "Calibration parameters format mismatch. Please upgrade your library or firmware.");
            return "0";
        }
        if (this._isScal32) {
            res = String.format("%d", 30);
            for (int idx = 0; idx < npt; ++idx) {
                res = String.format("%s,%f,%f", res, (double)rawValues.get(idx), (double)refValues.get(idx));
            }
        } else if (this._isScal) {
            res = String.format("%d", npt);
            for (int idx = 0; idx < npt; ++idx) {
                int iRaw = (int)Math.round(rawValues.get(idx) * this._scale + this._offset);
                int iRef = (int)Math.round(refValues.get(idx) * this._scale + this._offset);
                res = String.format("%s,%d,%d", res, iRaw, iRef);
            }
        } else {
            res = String.format("%d", 10 + npt);
            for (int idx = 0; idx < npt; ++idx) {
                YAPI.SafeYAPI();
                int iRaw = (int)YAPI._doubleToDecimal(rawValues.get(idx));
                YAPI.SafeYAPI();
                int iRef = (int)YAPI._doubleToDecimal(refValues.get(idx));
                res = String.format("%s,%d,%d", res, iRaw, iRef);
            }
        }
        return res;
    }

    public double _applyCalibration(double rawValue) {
        if (rawValue == -1.79769313486231E308) {
            return -1.79769313486231E308;
        }
        if (this._caltyp == 0) {
            return rawValue;
        }
        if (this._caltyp < 0) {
            return -1.79769313486231E308;
        }
        if (this._calhdl == null) {
            return -1.79769313486231E308;
        }
        return this._calhdl.yCalibrationHandler(rawValue, this._caltyp, this._calpar, this._calraw, this._calref);
    }

    public YMeasure _decodeTimedReport(double timestamp, ArrayList<Integer> report) {
        double maxVal;
        double minVal;
        double avgVal;
        double endTime;
        double startTime = this._prevTimedReport;
        this._prevTimedReport = endTime = timestamp;
        if (startTime == 0.0) {
            startTime = endTime;
        }
        if (report.get(0) == 2) {
            if (report.size() <= 5) {
                int poww = 1;
                int avgRaw = 0;
                int byteVal = 0;
                for (int i = 1; i < report.size(); ++i) {
                    byteVal = report.get(i);
                    avgRaw += poww * byteVal;
                    poww *= 256;
                }
                if ((byteVal & 0x80) != 0) {
                    avgRaw -= poww;
                }
                avgVal = (double)avgRaw / 1000.0;
                if (this._caltyp != 0 && this._calhdl != null) {
                    avgVal = this._calhdl.yCalibrationHandler(avgVal, this._caltyp, this._calpar, this._calraw, this._calref);
                }
                minVal = avgVal;
                maxVal = avgVal;
            } else {
                int i;
                int sublen = 1 + (report.get(1) & 3);
                int poww = 1;
                int avgRaw = 0;
                int byteVal = 0;
                for (i = 2; sublen > 0 && i < report.size(); ++i, --sublen) {
                    byteVal = report.get(i);
                    avgRaw += poww * byteVal;
                    poww *= 256;
                }
                if ((byteVal & 0x80) != 0) {
                    avgRaw -= poww;
                }
                poww = 1;
                int difRaw = 0;
                for (sublen = 1 + (report.get(1) >> 2 & 3); sublen > 0 && i < report.size(); ++i, --sublen) {
                    byteVal = report.get(i);
                    difRaw += poww * byteVal;
                    poww *= 256;
                }
                int minRaw = avgRaw - difRaw;
                poww = 1;
                difRaw = 0;
                for (sublen = 1 + (report.get(1) >> 4 & 3); sublen > 0 && i < report.size(); ++i, --sublen) {
                    byteVal = report.get(i);
                    difRaw += poww * byteVal;
                    poww *= 256;
                }
                int maxRaw = avgRaw + difRaw;
                avgVal = (double)avgRaw / 1000.0;
                minVal = (double)minRaw / 1000.0;
                maxVal = (double)maxRaw / 1000.0;
                if (this._caltyp != 0 && this._calhdl != null) {
                    avgVal = this._calhdl.yCalibrationHandler(avgVal, this._caltyp, this._calpar, this._calraw, this._calref);
                    minVal = this._calhdl.yCalibrationHandler(minVal, this._caltyp, this._calpar, this._calraw, this._calref);
                    maxVal = this._calhdl.yCalibrationHandler(maxVal, this._caltyp, this._calpar, this._calraw, this._calref);
                }
            }
        } else if (report.get(0) == 0) {
            int poww = 1;
            int avgRaw = 0;
            int byteVal = 0;
            for (int i = 1; i < report.size(); ++i) {
                byteVal = report.get(i);
                avgRaw += poww * byteVal;
                poww *= 256;
            }
            if (this._isScal) {
                avgVal = this._decodeVal(avgRaw);
            } else {
                if ((byteVal & 0x80) != 0) {
                    avgRaw -= poww;
                }
                avgVal = this._decodeAvg(avgRaw);
            }
            minVal = avgVal;
            maxVal = avgVal;
        } else {
            int minRaw = report.get(1) + 256 * report.get(2);
            int maxRaw = report.get(3) + 256 * report.get(4);
            int avgRaw = report.get(5) + 256 * report.get(6) + 65536 * report.get(7);
            int byteVal = report.get(8);
            avgRaw = (byteVal & 0x80) == 0 ? (avgRaw += 0x1000000 * byteVal) : (avgRaw -= 0x1000000 * (256 - byteVal));
            minVal = this._decodeVal(minRaw);
            avgVal = this._decodeAvg(avgRaw);
            maxVal = this._decodeVal(maxRaw);
        }
        return new YMeasure(startTime, endTime, minVal, avgVal, maxVal);
    }

    public double _decodeVal(int w) {
        double val = w;
        if (this._isScal) {
            val = (val - this._offset) / this._scale;
        } else {
            YAPI.SafeYAPI();
            val = YAPI._decimalToDouble(w);
        }
        if (this._caltyp != 0 && this._calhdl != null) {
            val = this._calhdl.yCalibrationHandler(val, this._caltyp, this._calpar, this._calraw, this._calref);
        }
        return val;
    }

    public double _decodeAvg(int dw) {
        double val = dw;
        val = this._isScal ? (val / 100.0 - this._offset) / this._scale : (val /= this._decexp);
        if (this._caltyp != 0 && this._calhdl != null) {
            val = this._calhdl.yCalibrationHandler(val, this._caltyp, this._calpar, this._calraw, this._calref);
        }
        return val;
    }

    public YSensor nextSensor() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YSensor.FindSensor(next_hwid);
    }

    public static YSensor FirstSensor() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Sensor");
        if (next_hwid == null) {
            return null;
        }
        return YSensor.FindSensor(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YSensor var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YSensor var1, String var2);
    }
}

