/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YSSDPCacheEntry;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class YSSDP {
    private static final int SSDP_PORT = 1900;
    private static final String SSDP_MCAST_ADDR = "239.255.255.250";
    private static final String SSDP_URN_YOCTOPUCE = "urn:yoctopuce-com:device:hub:1";
    private static final String SSDP_DISCOVERY_MESSAGE = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:" + Integer.toString(1900) + "\r\n" + "MAN: \"ssdp:discover\"\r\n" + "MX: 5\r\n" + "ST: " + "urn:yoctopuce-com:device:hub:1" + "\r\n" + "\r\n";
    private static final String SSDP_NOTIFY = "NOTIFY * HTTP/1.1";
    private static final String SSDP_HTTP = "HTTP/1.1 200 OK";
    private HashMap<String, YSSDPCacheEntry> mCache = new HashMap();
    private InetAddress mMcastAddr;
    private boolean mListening = false;
    private MulticastSocket mSocketReception;
    private YSSDPReportInterface _callbacks;
    private Thread mListenBcastThread = new Thread(new Runnable(){

        public void run() {
            while (YSSDP.this.mListening) {
                byte[] pktContent = new byte[1536];
                DatagramPacket pkt = new DatagramPacket(pktContent, pktContent.length);
                try {
                    YSSDP.this.mSocketReception.receive(pkt);
                    String ssdpMessage = new String(pktContent, pkt.getOffset(), pkt.getLength());
                    YSSDP.this.parseIncomingMessage(ssdpMessage);
                }
                catch (SocketTimeoutException ignored) {
                }
                catch (IOException e) {
                    YAPI.SafeYAPI()._Log("SSDP:" + e.getLocalizedMessage());
                }
                YSSDP.this.checkCacheExpiration();
            }
        }
    });
    private Thread mListenMSearchThread = new Thread(new Runnable(){

        public void run() {
            MulticastSocket mMsearchSocket;
            Date date = new Date();
            try {
                mMsearchSocket = new MulticastSocket();
                mMsearchSocket.setTimeToLive(15);
                byte[] outPktContent = SSDP_DISCOVERY_MESSAGE.getBytes();
                DatagramPacket outPkt = new DatagramPacket(outPktContent, outPktContent.length, YSSDP.this.mMcastAddr, 1900);
                mMsearchSocket.send(outPkt);
            }
            catch (IOException ex) {
                YAPI.SafeYAPI()._Log("Unable to Send SSDP mSearch:" + ex.getLocalizedMessage());
                return;
            }
            while (YSSDP.this.mListening && new Date().getTime() - date.getTime() < 180000L) {
                byte[] pktContent = new byte[1536];
                DatagramPacket pkt = new DatagramPacket(pktContent, pktContent.length);
                try {
                    mMsearchSocket.receive(pkt);
                    String ssdpMessage = new String(pktContent, pkt.getOffset(), pkt.getLength());
                    YSSDP.this.parseIncomingMessage(ssdpMessage);
                }
                catch (IOException ex) {
                    YAPI.SafeYAPI()._Log("SSDP error:" + ex.getLocalizedMessage());
                    return;
                }
            }
        }
    });

    YSSDP() {
    }

    synchronized void addCallback(YSSDPReportInterface callback) throws YAPI_Exception {
        if (this._callbacks == callback) {
            return;
        }
        this._callbacks = callback;
        if (!this.mListening) {
            try {
                this.startListening();
            }
            catch (IOException e) {
                throw new YAPI_Exception(-8, "Unable to start SSDP thread : " + e.toString());
            }
        }
    }

    private synchronized void updateCache(String uuid, String url, int cacheValidity) {
        if (cacheValidity <= 0) {
            cacheValidity = 1800;
        }
        cacheValidity *= 1000;
        if (this.mCache.containsKey(uuid)) {
            YSSDPCacheEntry entry = this.mCache.get(uuid);
            if (!entry.getURL().equals(url)) {
                this._callbacks.HubDiscoveryCallback(entry.getSerial(), url, entry.getURL());
                entry.setURL(url);
            } else {
                this._callbacks.HubDiscoveryCallback(entry.getSerial(), url, null);
            }
            entry.resetExpiration(cacheValidity);
            return;
        }
        YSSDPCacheEntry entry = new YSSDPCacheEntry(uuid, url, cacheValidity);
        this.mCache.put(uuid, entry);
        this._callbacks.HubDiscoveryCallback(entry.getSerial(), entry.getURL(), null);
    }

    private synchronized void checkCacheExpiration() {
        ArrayList<String> to_remove = new ArrayList<String>();
        for (YSSDPCacheEntry entry : this.mCache.values()) {
            if (!entry.hasExpired()) continue;
            this._callbacks.HubDiscoveryCallback(entry.getSerial(), null, entry.getURL());
            to_remove.add(entry.getUUID());
        }
        for (String uuid : to_remove) {
            this.mCache.remove(uuid);
        }
    }

    private void startListening() throws IOException {
        this.mMcastAddr = InetAddress.getByName(SSDP_MCAST_ADDR);
        this.mSocketReception = new MulticastSocket(1900);
        this.mListening = false;
        this.mSocketReception.joinGroup(this.mMcastAddr);
        this.mSocketReception.setSoTimeout(10000);
        this.mListening = true;
        this.mListenBcastThread.start();
        this.mListenMSearchThread.start();
    }

    void Stop() {
        this.mListening = false;
        if (this.mListenMSearchThread.isAlive()) {
            this.mListenMSearchThread.interrupt();
        }
        if (this.mListenBcastThread.isAlive()) {
            this.mListenBcastThread.interrupt();
        }
    }

    private void parseIncomingMessage(String message) {
        int i = 0;
        String location = null;
        String usn = null;
        String cache = null;
        String[] lines = message.split("\r\n");
        if (!lines[i].equals(SSDP_HTTP) && !lines[i].equals(SSDP_NOTIFY)) {
            return;
        }
        for (i = 0; i < lines.length; ++i) {
            int pos = lines[i].indexOf(":");
            if (pos <= 0) continue;
            if (lines[i].startsWith("LOCATION")) {
                location = lines[i].substring(pos + 1).trim();
                continue;
            }
            if (lines[i].startsWith("USN")) {
                usn = lines[i].substring(pos + 1).trim();
                continue;
            }
            if (!lines[i].startsWith("CACHE-CONTROL")) continue;
            cache = lines[i].substring(pos + 1).trim();
        }
        if (location != null && usn != null && cache != null) {
            int poscache;
            int posslash;
            int posurn;
            int posuuid = usn.indexOf(58);
            if (posuuid < 0) {
                return;
            }
            if ((posurn = usn.indexOf("::", ++posuuid)) < 0) {
                return;
            }
            String uuid = usn.substring(posuuid, posurn).trim();
            String urn = usn.substring(posurn + 2).trim();
            if (!urn.equals(SSDP_URN_YOCTOPUCE)) {
                return;
            }
            if (location.startsWith("http://")) {
                location = location.substring(7);
            }
            if ((posslash = location.indexOf(47)) > 0) {
                location = location.substring(0, posslash);
            }
            if ((poscache = cache.indexOf(61)) < 0) {
                return;
            }
            cache = cache.substring(poscache + 1).trim();
            int cacheVal = Integer.decode(cache);
            this.updateCache(uuid, location, cacheVal);
        }
    }

    static interface YSSDPReportInterface {
        public void HubDiscoveryCallback(String var1, String var2, String var3);
    }
}

