/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import org.json.JSONException;
import org.json.JSONObject;

public class YPwmOutput
extends YFunction {
    public static final int ENABLED_FALSE = 0;
    public static final int ENABLED_TRUE = 1;
    public static final int ENABLED_INVALID = -1;
    public static final double FREQUENCY_INVALID = -1.79769313486231E308;
    public static final double PERIOD_INVALID = -1.79769313486231E308;
    public static final double DUTYCYCLE_INVALID = -1.79769313486231E308;
    public static final double PULSEDURATION_INVALID = -1.79769313486231E308;
    public static final String PWMTRANSITION_INVALID = "!INVALID!";
    public static final int ENABLEDATPOWERON_FALSE = 0;
    public static final int ENABLEDATPOWERON_TRUE = 1;
    public static final int ENABLEDATPOWERON_INVALID = -1;
    public static final double DUTYCYCLEATPOWERON_INVALID = -1.79769313486231E308;
    protected int _enabled = -1;
    protected double _frequency = -1.79769313486231E308;
    protected double _period = -1.79769313486231E308;
    protected double _dutyCycle = -1.79769313486231E308;
    protected double _pulseDuration = -1.79769313486231E308;
    protected String _pwmTransition = "!INVALID!";
    protected int _enabledAtPowerOn = -1;
    protected double _dutyCycleAtPowerOn = -1.79769313486231E308;
    protected UpdateCallback _valueCallbackPwmOutput = null;

    protected YPwmOutput(String func) {
        super(func);
        this._className = "PwmOutput";
    }

    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("enabled")) {
            int n = this._enabled = json_val.getInt("enabled") > 0 ? 1 : 0;
        }
        if (json_val.has("frequency")) {
            this._frequency = (double)Math.round(json_val.getDouble("frequency") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("period")) {
            this._period = (double)Math.round(json_val.getDouble("period") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("dutyCycle")) {
            this._dutyCycle = (double)Math.round(json_val.getDouble("dutyCycle") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("pulseDuration")) {
            this._pulseDuration = (double)Math.round(json_val.getDouble("pulseDuration") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("pwmTransition")) {
            this._pwmTransition = json_val.getString("pwmTransition");
        }
        if (json_val.has("enabledAtPowerOn")) {
            int n = this._enabledAtPowerOn = json_val.getInt("enabledAtPowerOn") > 0 ? 1 : 0;
        }
        if (json_val.has("dutyCycleAtPowerOn")) {
            this._dutyCycleAtPowerOn = (double)Math.round(json_val.getDouble("dutyCycleAtPowerOn") * 1000.0 / 65536.0) / 1000.0;
        }
        super._parseAttr(json_val);
    }

    public int get_enabled() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._enabled;
    }

    public int getEnabled() throws YAPI_Exception {
        return this.get_enabled();
    }

    public int set_enabled(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("enabled", rest_val);
        return 0;
    }

    public int setEnabled(int newval) throws YAPI_Exception {
        return this.set_enabled(newval);
    }

    public int set_frequency(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("frequency", rest_val);
        return 0;
    }

    public int setFrequency(double newval) throws YAPI_Exception {
        return this.set_frequency(newval);
    }

    public double get_frequency() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._frequency;
    }

    public double getFrequency() throws YAPI_Exception {
        return this.get_frequency();
    }

    public int set_period(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("period", rest_val);
        return 0;
    }

    public int setPeriod(double newval) throws YAPI_Exception {
        return this.set_period(newval);
    }

    public double get_period() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._period;
    }

    public double getPeriod() throws YAPI_Exception {
        return this.get_period();
    }

    public int set_dutyCycle(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("dutyCycle", rest_val);
        return 0;
    }

    public int setDutyCycle(double newval) throws YAPI_Exception {
        return this.set_dutyCycle(newval);
    }

    public double get_dutyCycle() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._dutyCycle;
    }

    public double getDutyCycle() throws YAPI_Exception {
        return this.get_dutyCycle();
    }

    public int set_pulseDuration(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("pulseDuration", rest_val);
        return 0;
    }

    public int setPulseDuration(double newval) throws YAPI_Exception {
        return this.set_pulseDuration(newval);
    }

    public double get_pulseDuration() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._pulseDuration;
    }

    public double getPulseDuration() throws YAPI_Exception {
        return this.get_pulseDuration();
    }

    public String get_pwmTransition() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return PWMTRANSITION_INVALID;
        }
        return this._pwmTransition;
    }

    public String getPwmTransition() throws YAPI_Exception {
        return this.get_pwmTransition();
    }

    public int set_pwmTransition(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("pwmTransition", rest_val);
        return 0;
    }

    public int setPwmTransition(String newval) throws YAPI_Exception {
        return this.set_pwmTransition(newval);
    }

    public int get_enabledAtPowerOn() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._enabledAtPowerOn;
    }

    public int getEnabledAtPowerOn() throws YAPI_Exception {
        return this.get_enabledAtPowerOn();
    }

    public int set_enabledAtPowerOn(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("enabledAtPowerOn", rest_val);
        return 0;
    }

    public int setEnabledAtPowerOn(int newval) throws YAPI_Exception {
        return this.set_enabledAtPowerOn(newval);
    }

    public int set_dutyCycleAtPowerOn(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("dutyCycleAtPowerOn", rest_val);
        return 0;
    }

    public int setDutyCycleAtPowerOn(double newval) throws YAPI_Exception {
        return this.set_dutyCycleAtPowerOn(newval);
    }

    public double get_dutyCycleAtPowerOn() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._dutyCycleAtPowerOn;
    }

    public double getDutyCycleAtPowerOn() throws YAPI_Exception {
        return this.get_dutyCycleAtPowerOn();
    }

    public static YPwmOutput FindPwmOutput(String func) {
        YPwmOutput obj = (YPwmOutput)YFunction._FindFromCache("PwmOutput", func);
        if (obj == null) {
            obj = new YPwmOutput(func);
            YFunction._AddToCache("PwmOutput", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackPwmOutput = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    public int _invokeValueCallback(String value) {
        if (this._valueCallbackPwmOutput != null) {
            this._valueCallbackPwmOutput.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int pulseDurationMove(double ms_target, int ms_duration) throws YAPI_Exception {
        if (ms_target < 0.0) {
            ms_target = 0.0;
        }
        String newval = String.format("%dms:%d", (int)Math.round(ms_target * 65536.0), ms_duration);
        return this.set_pwmTransition(newval);
    }

    public int dutyCycleMove(double target, int ms_duration) throws YAPI_Exception {
        if (target < 0.0) {
            target = 0.0;
        }
        if (target > 100.0) {
            target = 100.0;
        }
        String newval = String.format("%d:%d", (int)Math.round(target * 65536.0), ms_duration);
        return this.set_pwmTransition(newval);
    }

    public YPwmOutput nextPwmOutput() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YPwmOutput.FindPwmOutput(next_hwid);
    }

    public static YPwmOutput FirstPwmOutput() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("PwmOutput");
        if (next_hwid == null) {
            return null;
        }
        return YPwmOutput.FindPwmOutput(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YPwmOutput var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YPwmOutput var1, String var2);
    }
}

