/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataLogger;
import com.yoctopuce.YoctoAPI.YDataStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class YOldDataStream
extends YDataStream {
    YDataLogger _dataLogger;
    int _timeStamp;
    int _interval;

    public YOldDataStream(YDataLogger parent, int run, int stamp, long utc, int itv) {
        super(parent);
        this._dataLogger = parent;
        this._runNo = run;
        this._timeStamp = stamp;
        this._utcStamp = utc;
        this._interval = itv;
        this._samplesPerHour = 3600 / this._interval;
        this._isClosed = true;
        this._minVal = -1.79769313486231E308;
        this._avgVal = -1.79769313486231E308;
        this._maxVal = -1.79769313486231E308;
    }

    public int loadStream() throws YAPI_Exception {
        int[] colofs;
        double[] colscl;
        int c;
        int i;
        JSONArray coldiv = null;
        int[] coltyp = null;
        JSONObject jsonObj = null;
        try {
            JSONTokener jsonTokenner = this._dataLogger.getData(this._runNo, this._timeStamp);
            jsonObj = new JSONObject(jsonTokenner);
            if (jsonObj.has("time")) {
                this._timeStamp = jsonObj.getInt("time");
            }
            if (jsonObj.has("UTC")) {
                this._utcStamp = jsonObj.getLong("UTC");
            }
            if (jsonObj.has("interval")) {
                this._interval = jsonObj.getInt("interval");
            }
            if (jsonObj.has("nRows")) {
                this._nRows = jsonObj.getInt("nRows");
            }
            if (jsonObj.has("keys")) {
                JSONArray jsonKeys = jsonObj.getJSONArray("keys");
                if (this._nCols == 0) {
                    this._nCols = jsonKeys.length();
                } else if (this._nCols != jsonKeys.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
                this._columnNames = new ArrayList(this._nCols);
                for (i = 0; i < jsonKeys.length(); ++i) {
                    this._columnNames.add(jsonKeys.getString(i));
                }
            }
            if (jsonObj.has("div")) {
                coldiv = jsonObj.getJSONArray("div");
                if (this._nCols == 0) {
                    this._nCols = coldiv.length();
                } else if (this._nCols != coldiv.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
            }
            if (jsonObj.has("type")) {
                JSONArray types = jsonObj.getJSONArray("type");
                if (this._nCols == 0) {
                    this._nCols = types.length();
                } else if (this._nCols != types.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
                coltyp = new int[this._nCols];
                for (c = 0; c < this._nCols; ++c) {
                    coltyp[c] = types.getInt(c);
                }
            }
            if (jsonObj.has("scal")) {
                JSONArray json_colscl = jsonObj.getJSONArray("scal");
                if (this._nCols == 0) {
                    this._nCols = json_colscl.length();
                } else if (this._nCols != json_colscl.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
                colscl = new double[json_colscl.length()];
                colofs = new int[json_colscl.length()];
                for (i = 0; i < json_colscl.length(); ++i) {
                    double dval = json_colscl.getDouble(i);
                    colscl[i] = dval / 65536.0;
                    colofs[i] = coltyp[i] != 0 ? -32767 : 0;
                }
            } else {
                colscl = new double[coldiv.length()];
                colofs = new int[coldiv.length()];
                for (int i2 = 0; i2 < coldiv.length(); ++i2) {
                    colscl[i2] = 1.0 / coldiv.getDouble(i2);
                    colofs[i2] = coltyp[i2] != 0 ? -32767 : 0;
                }
            }
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, "json parse error");
        }
        if (jsonObj != null && jsonObj.has("data")) {
            if (this._nCols == 0 || coldiv == null || coltyp == null) {
                throw new YAPI_Exception(-8, "DataStream corrupted");
            }
            ArrayList<Integer> udata = null;
            try {
                String data = jsonObj.getString("data");
                udata = YAPI._decodeWords(data);
            }
            catch (JSONException ignore) {
                // empty catch block
            }
            if (udata == null) {
                try {
                    JSONArray jsonData = jsonObj.getJSONArray("data");
                    udata = new ArrayList();
                    for (i = 0; i < jsonData.length(); ++i) {
                        udata.add(jsonData.getInt(i));
                    }
                }
                catch (JSONException ex) {
                    throw new YAPI_Exception(-8, "");
                }
            }
            this._values = new ArrayList();
            ArrayList<Double> dat = new ArrayList<Double>();
            c = 0;
            for (int val_i : udata) {
                double val_d = coltyp[c] < 2 ? (double)(val_i + colofs[c]) * colscl[c] : YAPI._decimalToDouble(val_i - Short.MAX_VALUE);
                dat.add(val_d);
                if (++c != this._nCols) continue;
                this._values.add(dat);
                dat = new ArrayList();
                c = 0;
            }
        }
        return 0;
    }

    public int get_startTime() {
        return this._timeStamp;
    }

    public int getStartTime() {
        return this._timeStamp;
    }

    public double get_dataSamplesInterval() {
        return this._interval;
    }

    public double getDataSamplesInterval() {
        return this._interval;
    }
}

