/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSensor;
import org.json.JSONException;
import org.json.JSONObject;

public class YLightSensor
extends YSensor {
    public static final int MEASURETYPE_HUMAN_EYE = 0;
    public static final int MEASURETYPE_WIDE_SPECTRUM = 1;
    public static final int MEASURETYPE_INFRARED = 2;
    public static final int MEASURETYPE_HIGH_RATE = 3;
    public static final int MEASURETYPE_HIGH_ENERGY = 4;
    public static final int MEASURETYPE_INVALID = -1;
    protected int _measureType = -1;
    protected UpdateCallback _valueCallbackLightSensor = null;
    protected TimedReportCallback _timedReportCallbackLightSensor = null;

    protected YLightSensor(String func) {
        super(func);
        this._className = "LightSensor";
    }

    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("measureType")) {
            this._measureType = json_val.getInt("measureType");
        }
        super._parseAttr(json_val);
    }

    public int set_currentValue(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("currentValue", rest_val);
        return 0;
    }

    public int setCurrentValue(double newval) throws YAPI_Exception {
        return this.set_currentValue(newval);
    }

    public int calibrate(double calibratedVal) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(calibratedVal * 65536.0));
        this._setAttr("currentValue", rest_val);
        return 0;
    }

    public int get_measureType() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._measureType;
    }

    public int getMeasureType() throws YAPI_Exception {
        return this.get_measureType();
    }

    public int set_measureType(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("measureType", rest_val);
        return 0;
    }

    public int setMeasureType(int newval) throws YAPI_Exception {
        return this.set_measureType(newval);
    }

    public static YLightSensor FindLightSensor(String func) {
        YLightSensor obj = (YLightSensor)YFunction._FindFromCache("LightSensor", func);
        if (obj == null) {
            obj = new YLightSensor(func);
            YFunction._AddToCache("LightSensor", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackLightSensor = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    public int _invokeValueCallback(String value) {
        if (this._valueCallbackLightSensor != null) {
            this._valueCallbackLightSensor.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(this, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(this, false);
        }
        this._timedReportCallbackLightSensor = callback;
        return 0;
    }

    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackLightSensor != null) {
            this._timedReportCallbackLightSensor.timedReportCallback(this, value);
        } else {
            super._invokeTimedReportCallback(value);
        }
        return 0;
    }

    public YLightSensor nextLightSensor() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YLightSensor.FindLightSensor(next_hwid);
    }

    public static YLightSensor FirstLightSensor() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("LightSensor");
        if (next_hwid == null) {
            return null;
        }
        return YLightSensor.FindLightSensor(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YLightSensor var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YLightSensor var1, String var2);
    }
}

