/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFileRecord;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YFiles
extends YFunction {
    public static final int FILESCOUNT_INVALID = -1;
    public static final int FREESPACE_INVALID = -1;
    protected int _filesCount = -1;
    protected int _freeSpace = -1;
    protected UpdateCallback _valueCallbackFiles = null;

    protected YFiles(String func) {
        super(func);
        this._className = "Files";
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("filesCount")) {
            this._filesCount = json_val.getInt("filesCount");
        }
        if (json_val.has("freeSpace")) {
            this._freeSpace = json_val.getInt("freeSpace");
        }
        super._parseAttr(json_val);
    }

    public int get_filesCount() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._filesCount;
    }

    public int getFilesCount() throws YAPI_Exception {
        return this.get_filesCount();
    }

    public int get_freeSpace() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._freeSpace;
    }

    public int getFreeSpace() throws YAPI_Exception {
        return this.get_freeSpace();
    }

    public static YFiles FindFiles(String func) {
        YFiles obj = (YFiles)YFunction._FindFromCache("Files", func);
        if (obj == null) {
            obj = new YFiles(func);
            YFunction._AddToCache("Files", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackFiles = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackFiles != null) {
            this._valueCallbackFiles.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public byte[] sendCommand(String command) throws YAPI_Exception {
        String url = String.format("files.json?a=%s", command);
        return this._download(url);
    }

    public int format_fs() throws YAPI_Exception {
        byte[] json = this.sendCommand("format");
        String res = this._json_get_key(json, "res");
        if (!res.equals("ok")) {
            throw new YAPI_Exception(-8, "format failed");
        }
        return 0;
    }

    public ArrayList<YFileRecord> get_list(String pattern) throws YAPI_Exception {
        ArrayList<Object> filelist = new ArrayList();
        ArrayList<YFileRecord> res = new ArrayList<YFileRecord>();
        byte[] json = this.sendCommand(String.format("dir&f=%s", pattern));
        filelist = this._json_get_array(json);
        res.clear();
        for (String string : filelist) {
            res.add(new YFileRecord(string));
        }
        return res;
    }

    public byte[] download(String pathname) throws YAPI_Exception {
        return this._download(pathname);
    }

    public int upload(String pathname, byte[] content) throws YAPI_Exception {
        return this._upload(pathname, content);
    }

    public int remove(String pathname) throws YAPI_Exception {
        byte[] json = this.sendCommand(String.format("del&f=%s", pathname));
        String res = this._json_get_key(json, "res");
        if (!res.equals("ok")) {
            throw new YAPI_Exception(-8, "unable to remove file");
        }
        return 0;
    }

    public YFiles nextFiles() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YFiles.FindFiles(next_hwid);
    }

    public static YFiles FirstFiles() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Files");
        if (next_hwid == null) {
            return null;
        }
        return YFiles.FindFiles(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YFiles var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YFiles var1, String var2);
    }
}

