/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import org.json.JSONException;
import org.json.JSONObject;

public class YDigitalIO
extends YFunction {
    public static final int PORTSTATE_INVALID = -1;
    public static final int PORTDIRECTION_INVALID = -1;
    public static final int PORTOPENDRAIN_INVALID = -1;
    public static final int PORTPOLARITY_INVALID = -1;
    public static final int PORTSIZE_INVALID = -1;
    public static final int OUTPUTVOLTAGE_USB_5V = 0;
    public static final int OUTPUTVOLTAGE_USB_3V = 1;
    public static final int OUTPUTVOLTAGE_EXT_V = 2;
    public static final int OUTPUTVOLTAGE_INVALID = -1;
    public static final String COMMAND_INVALID = "!INVALID!";
    protected int _portState = -1;
    protected int _portDirection = -1;
    protected int _portOpenDrain = -1;
    protected int _portPolarity = -1;
    protected int _portSize = -1;
    protected int _outputVoltage = -1;
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackDigitalIO = null;

    protected YDigitalIO(String func) {
        super(func);
        this._className = "DigitalIO";
    }

    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("portState")) {
            this._portState = json_val.getInt("portState");
        }
        if (json_val.has("portDirection")) {
            this._portDirection = json_val.getInt("portDirection");
        }
        if (json_val.has("portOpenDrain")) {
            this._portOpenDrain = json_val.getInt("portOpenDrain");
        }
        if (json_val.has("portPolarity")) {
            this._portPolarity = json_val.getInt("portPolarity");
        }
        if (json_val.has("portSize")) {
            this._portSize = json_val.getInt("portSize");
        }
        if (json_val.has("outputVoltage")) {
            this._outputVoltage = json_val.getInt("outputVoltage");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    public int get_portState() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._portState;
    }

    public int getPortState() throws YAPI_Exception {
        return this.get_portState();
    }

    public int set_portState(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("portState", rest_val);
        return 0;
    }

    public int setPortState(int newval) throws YAPI_Exception {
        return this.set_portState(newval);
    }

    public int get_portDirection() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._portDirection;
    }

    public int getPortDirection() throws YAPI_Exception {
        return this.get_portDirection();
    }

    public int set_portDirection(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("portDirection", rest_val);
        return 0;
    }

    public int setPortDirection(int newval) throws YAPI_Exception {
        return this.set_portDirection(newval);
    }

    public int get_portOpenDrain() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._portOpenDrain;
    }

    public int getPortOpenDrain() throws YAPI_Exception {
        return this.get_portOpenDrain();
    }

    public int set_portOpenDrain(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("portOpenDrain", rest_val);
        return 0;
    }

    public int setPortOpenDrain(int newval) throws YAPI_Exception {
        return this.set_portOpenDrain(newval);
    }

    public int get_portPolarity() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._portPolarity;
    }

    public int getPortPolarity() throws YAPI_Exception {
        return this.get_portPolarity();
    }

    public int set_portPolarity(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("portPolarity", rest_val);
        return 0;
    }

    public int setPortPolarity(int newval) throws YAPI_Exception {
        return this.set_portPolarity(newval);
    }

    public int get_portSize() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._portSize;
    }

    public int getPortSize() throws YAPI_Exception {
        return this.get_portSize();
    }

    public int get_outputVoltage() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._outputVoltage;
    }

    public int getOutputVoltage() throws YAPI_Exception {
        return this.get_outputVoltage();
    }

    public int set_outputVoltage(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("outputVoltage", rest_val);
        return 0;
    }

    public int setOutputVoltage(int newval) throws YAPI_Exception {
        return this.set_outputVoltage(newval);
    }

    public String get_command() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return COMMAND_INVALID;
        }
        return this._command;
    }

    public String getCommand() throws YAPI_Exception {
        return this.get_command();
    }

    public int set_command(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("command", rest_val);
        return 0;
    }

    public int setCommand(String newval) throws YAPI_Exception {
        return this.set_command(newval);
    }

    public static YDigitalIO FindDigitalIO(String func) {
        YDigitalIO obj = (YDigitalIO)YFunction._FindFromCache("DigitalIO", func);
        if (obj == null) {
            obj = new YDigitalIO(func);
            YFunction._AddToCache("DigitalIO", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackDigitalIO = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    public int _invokeValueCallback(String value) {
        if (this._valueCallbackDigitalIO != null) {
            this._valueCallbackDigitalIO.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int set_bitState(int bitno, int bitstate) throws YAPI_Exception {
        if (bitstate < 0) {
            throw new YAPI_Exception(-2, "invalid bitstate");
        }
        if (bitstate > 1) {
            throw new YAPI_Exception(-2, "invalid bitstate");
        }
        return this.set_command(String.format("%c%d", 82 + bitstate, bitno));
    }

    public int get_bitState(int bitno) throws YAPI_Exception {
        int portVal = this.get_portState();
        return portVal >> bitno & 1;
    }

    public int toggle_bitState(int bitno) throws YAPI_Exception {
        return this.set_command(String.format("T%d", bitno));
    }

    public int set_bitDirection(int bitno, int bitdirection) throws YAPI_Exception {
        if (bitdirection < 0) {
            throw new YAPI_Exception(-2, "invalid direction");
        }
        if (bitdirection > 1) {
            throw new YAPI_Exception(-2, "invalid direction");
        }
        return this.set_command(String.format("%c%d", 73 + 6 * bitdirection, bitno));
    }

    public int get_bitDirection(int bitno) throws YAPI_Exception {
        int portDir = this.get_portDirection();
        return portDir >> bitno & 1;
    }

    public int set_bitPolarity(int bitno, int bitpolarity) throws YAPI_Exception {
        if (bitpolarity < 0) {
            throw new YAPI_Exception(-2, "invalid bitpolarity");
        }
        if (bitpolarity > 1) {
            throw new YAPI_Exception(-2, "invalid bitpolarity");
        }
        return this.set_command(String.format("%c%d", 110 + 4 * bitpolarity, bitno));
    }

    public int get_bitPolarity(int bitno) throws YAPI_Exception {
        int portPol = this.get_portPolarity();
        return portPol >> bitno & 1;
    }

    public int set_bitOpenDrain(int bitno, int opendrain) throws YAPI_Exception {
        if (opendrain < 0) {
            throw new YAPI_Exception(-2, "invalid state");
        }
        if (opendrain > 1) {
            throw new YAPI_Exception(-2, "invalid state");
        }
        return this.set_command(String.format("%c%d", 100 - 32 * opendrain, bitno));
    }

    public int get_bitOpenDrain(int bitno) throws YAPI_Exception {
        int portOpenDrain = this.get_portOpenDrain();
        return portOpenDrain >> bitno & 1;
    }

    public int pulse(int bitno, int ms_duration) throws YAPI_Exception {
        return this.set_command(String.format("Z%d,0,%d", bitno, ms_duration));
    }

    public int delayedPulse(int bitno, int ms_delay, int ms_duration) throws YAPI_Exception {
        return this.set_command(String.format("Z%d,%d,%d", bitno, ms_delay, ms_duration));
    }

    public YDigitalIO nextDigitalIO() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YDigitalIO.FindDigitalIO(next_hwid);
    }

    public static YDigitalIO FirstDigitalIO() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("DigitalIO");
        if (next_hwid == null) {
            return null;
        }
        return YDigitalIO.FindDigitalIO(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YDigitalIO var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YDigitalIO var1, String var2);
    }
}

