/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataStream;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YModule;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YDataSet {
    protected YFunction _parent;
    protected String _hardwareId;
    protected String _functionId;
    protected String _unit;
    protected long _startTime = 0L;
    protected long _endTime = 0L;
    protected int _progress = 0;
    protected ArrayList<Integer> _calib = new ArrayList();
    protected ArrayList<YDataStream> _streams = new ArrayList();
    protected YMeasure _summary;
    protected ArrayList<YMeasure> _preview = new ArrayList();
    protected ArrayList<YMeasure> _measures = new ArrayList();

    public YDataSet(YFunction parent, String functionId, String unit, long startTime, long endTime) {
        this._parent = parent;
        this._functionId = functionId;
        this._unit = unit;
        this._startTime = startTime;
        this._endTime = endTime;
        this._progress = -1;
        this._hardwareId = "";
        this._summary = new YMeasure();
    }

    public YDataSet(YFunction parent, String json) throws YAPI_Exception {
        this._parent = parent;
        this._startTime = 0L;
        this._endTime = 0L;
        this._hardwareId = "";
        this._summary = new YMeasure();
        this._parse(json);
    }

    protected int _parse(String json_str) throws YAPI_Exception {
        double summaryMinVal = Double.MAX_VALUE;
        double summaryMaxVal = Double.MIN_VALUE;
        double summaryTotalTime = 0.0;
        double summaryTotalAvg = 0.0;
        try {
            JSONObject json = new JSONObject(json_str);
            this._functionId = json.getString("id");
            this._unit = json.getString("unit");
            if (json.has("calib")) {
                this._calib = YAPI._decodeFloats(json.getString("calib"));
                this._calib.set(0, this._calib.get(0) / 1000);
            } else {
                this._calib = YAPI._decodeWords(json.getString("cal"));
            }
            this._streams = new ArrayList();
            this._preview = new ArrayList();
            this._measures = new ArrayList();
            JSONArray jstreams = json.getJSONArray("streams");
            for (int i = 0; i < jstreams.length(); ++i) {
                YDataStream stream = this._parent._findDataStream(this, jstreams.getString(i));
                if (this._startTime > 0L && stream.get_startTimeUTC() + (long)stream.get_duration() <= this._startTime || this._endTime > 0L && stream.get_startTimeUTC() > this._endTime) continue;
                this._streams.add(stream);
                if (!stream.isClosed() || stream.get_startTimeUTC() < this._startTime || this._endTime != 0L && stream.get_startTimeUTC() + (long)stream.get_duration() > this._endTime) continue;
                if (summaryMinVal > stream.get_minValue()) {
                    summaryMinVal = stream.get_minValue();
                }
                if (summaryMaxVal < stream.get_maxValue()) {
                    summaryMaxVal = stream.get_maxValue();
                }
                summaryTotalAvg += stream.get_averageValue() * (double)stream.get_duration();
                summaryTotalTime += (double)stream.get_duration();
                YMeasure rec = new YMeasure(stream.get_startTimeUTC(), stream.get_startTimeUTC() + (long)stream.get_duration(), stream.get_minValue(), stream.get_averageValue(), stream.get_maxValue());
                this._preview.add(rec);
            }
            if (this._streams.size() > 0 && summaryTotalTime > 0.0) {
                YDataStream stream = this._streams.get(this._streams.size() - 1);
                long endtime = stream.get_startTimeUTC() + (long)stream.get_duration();
                long startTime = this._streams.get(0).get_startTimeUTC() - (long)(stream.get_dataSamplesIntervalMs() / 1000);
                if (this._startTime < startTime) {
                    this._startTime = startTime;
                }
                if (this._endTime == 0L || this._endTime > endtime) {
                    this._endTime = endtime;
                }
                this._summary = new YMeasure(this._startTime, this._endTime, summaryMinVal, summaryTotalAvg / summaryTotalTime, summaryMaxVal);
            }
        }
        catch (JSONException e) {
            throw new YAPI_Exception(-8, "invalid json structure for YDataSet: " + e.getMessage());
        }
        this._progress = 0;
        return this.get_progress();
    }

    public ArrayList<Integer> get_calibration() {
        return this._calib;
    }

    public int processMore(int progress, byte[] data) throws YAPI_Exception {
        double itv;
        ArrayList<Object> dataRows = new ArrayList();
        if (progress != this._progress) {
            return this._progress;
        }
        if (this._progress < 0) {
            String strdata = new String(data);
            if (strdata.equals("{}")) {
                this._parent._throw(-5, "device firmware is too old");
                return -5;
            }
            return this._parse(strdata);
        }
        YDataStream stream = this._streams.get(this._progress);
        stream.parse(data);
        dataRows = stream.get_dataRows();
        ++this._progress;
        if (dataRows.size() == 0) {
            return this.get_progress();
        }
        double tim = stream.get_startTimeUTC();
        if (tim < (itv = stream.get_dataSamplesInterval())) {
            tim = itv;
        }
        int nCols = ((ArrayList)dataRows.get(0)).size();
        int minCol = 0;
        int avgCol = nCols > 2 ? 1 : 0;
        int maxCol = nCols > 2 ? 2 : 0;
        for (ArrayList arrayList : dataRows) {
            if (tim >= (double)this._startTime && (this._endTime == 0L || tim <= (double)this._endTime)) {
                this._measures.add(new YMeasure(tim - itv, tim, (Double)arrayList.get(minCol), (Double)arrayList.get(avgCol), (Double)arrayList.get(maxCol)));
            }
            tim += itv;
        }
        return this.get_progress();
    }

    public ArrayList<YDataStream> get_privateDataStreams() {
        return this._streams;
    }

    public String get_hardwareId() throws YAPI_Exception {
        if (!this._hardwareId.equals("")) {
            return this._hardwareId;
        }
        YModule mo = this._parent.get_module();
        this._hardwareId = String.format("%s.%s", mo.get_serialNumber(), this.get_functionId());
        return this._hardwareId;
    }

    public String get_functionId() {
        return this._functionId;
    }

    public String get_unit() throws YAPI_Exception {
        return this._unit;
    }

    public long get_startTimeUTC() {
        return this._startTime;
    }

    public long get_endTimeUTC() {
        return this._endTime;
    }

    public int get_progress() {
        if (this._progress < 0) {
            return 0;
        }
        if (this._progress >= this._streams.size()) {
            return 100;
        }
        return (1 + (1 + this._progress) * 98) / (1 + this._streams.size());
    }

    public int loadMore() throws YAPI_Exception {
        String url;
        if (this._progress < 0) {
            url = String.format("logger.json?id=%s", this._functionId);
        } else {
            if (this._progress >= this._streams.size()) {
                return 100;
            }
            YDataStream stream = this._streams.get(this._progress);
            url = stream.get_url();
        }
        return this.processMore(this._progress, this._parent._download(url));
    }

    public YMeasure get_summary() {
        return this._summary;
    }

    public ArrayList<YMeasure> get_preview() throws YAPI_Exception {
        return this._preview;
    }

    public ArrayList<YMeasure> get_measures() throws YAPI_Exception {
        return this._measures;
    }
}

