/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareFile;
import com.yoctopuce.YoctoAPI.YFunctionType;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YPEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YCallbackHub
extends YGenericHub {
    private final YGenericHub.HTTPParams _http_params;
    private final OutputStream _out;
    private JSONObject _callbackCache;

    YCallbackHub(int idx, YGenericHub.HTTPParams httpParams, InputStream request, OutputStream response) throws YAPI_Exception {
        super(idx, true);
        this._http_params = httpParams;
        this._out = response;
        if (request == null || this._out == null) {
            throw new YAPI_Exception(-2, "Use RegisterHub(String url, BufferedReader request, PrintWriter response) to start api in callback");
        }
        try {
            this.loadCallbackCache(request);
        }
        catch (IOException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
    }

    @Override
    void release() {
    }

    @Override
    String getRootUrl() {
        return this._http_params.getUrl();
    }

    @Override
    synchronized boolean isSameRootUrl(String url) {
        YGenericHub.HTTPParams params = new YGenericHub.HTTPParams(url);
        return params.getUrl().equals(this._http_params.getUrl());
    }

    @Override
    void startNotifications() throws YAPI_Exception {
    }

    @Override
    void stopNotifications() {
    }

    private void _output(String msg) throws IOException {
        this._out.write(msg.getBytes());
    }

    private void loadCallbackCache(InputStream in) throws YAPI_Exception, IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = in.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        String data_str = buffer.toString();
        if (data_str.length() == 0) {
            String errmsg = "RegisterHub(callback) used without posting YoctoAPI data";
            this._output("\n!YoctoAPI:" + errmsg + "\n");
            this._callbackCache = null;
            throw new YAPI_Exception(-8, errmsg);
        }
        try {
            this._callbackCache = new JSONObject(data_str);
        }
        catch (JSONException ex) {
            String errmsg = "invalid data:[\n" + ex.toString() + data_str + "\n]";
            this._output("\n!YoctoAPI:" + errmsg + "\n");
            this._callbackCache = null;
            throw new YAPI_Exception(-8, errmsg);
        }
        if (!this._http_params.getPass().equals("")) {
            String salt;
            MessageDigest mdigest;
            try {
                mdigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new YAPI_Exception(-3, "No MD5 provider");
            }
            if (!this._callbackCache.has("sign")) {
                String errmsg = "missing signature from incoming YoctoHub (callback password required)";
                this._output("\n!YoctoAPI:" + errmsg + "\n");
                this._callbackCache = null;
                throw new YAPI_Exception(-12, errmsg);
            }
            String sign = this._callbackCache.optString("sign");
            String pass = this._http_params.getPass();
            if (pass.length() == 32) {
                salt = pass.toLowerCase();
            } else {
                mdigest.reset();
                mdigest.update(pass.getBytes());
                byte[] md5pass = mdigest.digest();
                salt = YAPI._bytesToHexStr(md5pass, 0, md5pass.length);
            }
            data_str = data_str.replace(sign, salt);
            mdigest.reset();
            mdigest.update(data_str.getBytes());
            byte[] md5 = mdigest.digest();
            String check = YAPI._bytesToHexStr(md5, 0, md5.length);
            if (!check.equals(sign)) {
                String errmsg = "invalid signature from incoming YoctoHub (invalid callback password)";
                this._output("\n!YoctoAPI:" + errmsg + "\n");
                this._callbackCache = null;
                throw new YAPI_Exception(-12, errmsg);
            }
        }
    }

    private byte[] cachedRequest(String query, byte[] header_and_body) throws YAPI_Exception, IOException {
        int endline = query.indexOf("\r");
        if (endline >= 0) {
            query = query.substring(0, endline);
        }
        if (query.startsWith("POST ")) {
            int body_start;
            int endb;
            String boundary = "???";
            for (endb = body_start = YAPI._find_in_bytes(header_and_body, "\r\n\r\n".getBytes()) + 4; endb < header_and_body.length && header_and_body[endb] != 13; ++endb) {
            }
            String tmp = new String(header_and_body, body_start, 2);
            if (tmp.equals("--") && endb > body_start + 2 && endb < body_start + 20) {
                boundary = new String(header_and_body, body_start + 2, endb - body_start - 2);
            }
            int bodylen = header_and_body.length - body_start;
            this._output("\n@YoctoAPI:" + query + " " + Integer.toString(bodylen) + ":" + boundary + "\n");
            this._out.write(header_and_body, body_start, bodylen);
            return "".getBytes();
        }
        if (!query.startsWith("GET ")) {
            return null;
        }
        int jzon = query.indexOf("?fw=");
        if (jzon >= 0 && query.indexOf(38, jzon) < 0) {
            query = query.substring(0, jzon);
        }
        if (!query.contains("?") || query.contains("/logs.txt") || query.contains("/logger.json") || query.contains("/ping.txt") || query.contains("/files.json?a=dir")) {
            try {
                String[] parts = query.split(" ");
                String url = parts[1];
                boolean getmodule = url.contains("api/module.json");
                if (getmodule) {
                    url = url.replace("api/module.json", "api.json");
                }
                if (!this._callbackCache.has(url)) {
                    this._output("\n!YoctoAPI:" + url + " is not preloaded, adding to list");
                    this._output("\n@YoctoAPI:+" + url + "\n");
                    return null;
                }
                JSONObject jsonres = this._callbackCache.getJSONObject(url);
                if (getmodule) {
                    jsonres = jsonres.getJSONObject("module");
                }
                return jsonres.toString().getBytes();
            }
            catch (JSONException ex) {
                return "".getBytes();
            }
        }
        this._output("\n@YoctoAPI:" + query + "\n");
        return "".getBytes();
    }

    @Override
    synchronized void updateDeviceList(boolean forceupdate) throws YAPI_Exception {
        String yreq;
        long now = YAPI.GetTickCount();
        if (forceupdate) {
            this._devListExpires = 0L;
        }
        if (this._devListExpires > now) {
            return;
        }
        try {
            yreq = new String(this.cachedRequest("GET /api.json\r\n", null));
        }
        catch (IOException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        HashMap<String, ArrayList<YPEntry>> yellowPages = new HashMap<String, ArrayList<YPEntry>>();
        ArrayList<WPEntry> whitePages = new ArrayList<WPEntry>();
        try {
            JSONObject loadval = new JSONObject(yreq);
            if (!loadval.has("services") || !loadval.getJSONObject("services").has("whitePages")) {
                throw new YAPI_Exception(-2, "Device " + this._http_params.getHost() + " is not a hub");
            }
            JSONArray whitePages_json = loadval.getJSONObject("services").getJSONArray("whitePages");
            JSONObject yellowPages_json = loadval.getJSONObject("services").getJSONObject("yellowPages");
            Iterator keys = yellowPages_json.keys();
            while (keys.hasNext()) {
                String classname = keys.next().toString();
                YFunctionType ftype = YAPI.SafeYAPI().getFnByType(classname);
                JSONArray yprecs_json = yellowPages_json.getJSONArray(classname);
                ArrayList<YPEntry> yprecs_arr = new ArrayList<YPEntry>(yprecs_json.length());
                for (int i = 0; i < yprecs_json.length(); ++i) {
                    YPEntry yprec = new YPEntry(yprecs_json.getJSONObject(i));
                    yprecs_arr.add(yprec);
                    ftype.reindexFunction(yprec);
                }
                yellowPages.put(classname, yprecs_arr);
            }
            for (int i = 0; i < whitePages_json.length(); ++i) {
                WPEntry devinfo = new WPEntry(whitePages_json.getJSONObject(i));
                this._serialByYdx.put(devinfo.getIndex(), devinfo.getSerialNumber());
                whitePages.add(devinfo);
            }
        }
        catch (JSONException e) {
            throw new YAPI_Exception(-8, "Request failed, could not parse API result for " + this._http_params.getHost(), (Exception)((Object)e));
        }
        this.updateFromWpAndYp(whitePages, yellowPages);
        now = YAPI.GetTickCount();
        this._devListExpires = now + this._devListValidity;
    }

    @Override
    public ArrayList<String> getBootloaders() throws YAPI_Exception {
        throw new YAPI_Exception(-3, "Firmware update is not supported in HTTP callback");
    }

    @Override
    ArrayList<String> firmwareUpdate(String serial, YFirmwareFile firmware, byte[] settings, YGenericHub.UpdateProgress progress) throws YAPI_Exception, InterruptedException {
        throw new YAPI_Exception(-3, "Firmware update is not supported in HTTP callback");
    }

    @Override
    void devRequestAsync(YDevice device, String req_first_line, byte[] req_head_and_body, YGenericHub.RequestAsyncResult asyncResult, Object asyncContext) throws YAPI_Exception {
        try {
            this.cachedRequest(req_first_line, req_head_and_body);
        }
        catch (IOException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
    }

    @Override
    byte[] devRequestSync(YDevice device, String req_first_line, byte[] req_head_and_body) throws YAPI_Exception {
        try {
            return this.cachedRequest(req_first_line, req_head_and_body);
        }
        catch (IOException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
    }
}

