/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import org.json.JSONException;
import org.json.JSONObject;

public class YBuzzer
extends YFunction {
    public static final double FREQUENCY_INVALID = -1.79769313486231E308;
    public static final int VOLUME_INVALID = -1;
    public static final int PLAYSEQSIZE_INVALID = -1;
    public static final int PLAYSEQMAXSIZE_INVALID = -1;
    public static final int PLAYSEQSIGNATURE_INVALID = -1;
    public static final String COMMAND_INVALID = "!INVALID!";
    protected double _frequency = -1.79769313486231E308;
    protected int _volume = -1;
    protected int _playSeqSize = -1;
    protected int _playSeqMaxSize = -1;
    protected int _playSeqSignature = -1;
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackBuzzer = null;

    protected YBuzzer(String func) {
        super(func);
        this._className = "Buzzer";
    }

    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("frequency")) {
            this._frequency = (double)Math.round(json_val.getDouble("frequency") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("volume")) {
            this._volume = json_val.getInt("volume");
        }
        if (json_val.has("playSeqSize")) {
            this._playSeqSize = json_val.getInt("playSeqSize");
        }
        if (json_val.has("playSeqMaxSize")) {
            this._playSeqMaxSize = json_val.getInt("playSeqMaxSize");
        }
        if (json_val.has("playSeqSignature")) {
            this._playSeqSignature = json_val.getInt("playSeqSignature");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    public int set_frequency(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("frequency", rest_val);
        return 0;
    }

    public int setFrequency(double newval) throws YAPI_Exception {
        return this.set_frequency(newval);
    }

    public double get_frequency() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._frequency;
    }

    public double getFrequency() throws YAPI_Exception {
        return this.get_frequency();
    }

    public int get_volume() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._volume;
    }

    public int getVolume() throws YAPI_Exception {
        return this.get_volume();
    }

    public int set_volume(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("volume", rest_val);
        return 0;
    }

    public int setVolume(int newval) throws YAPI_Exception {
        return this.set_volume(newval);
    }

    public int get_playSeqSize() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._playSeqSize;
    }

    public int getPlaySeqSize() throws YAPI_Exception {
        return this.get_playSeqSize();
    }

    public int get_playSeqMaxSize() throws YAPI_Exception {
        if (this._cacheExpiration == 0L && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._playSeqMaxSize;
    }

    public int getPlaySeqMaxSize() throws YAPI_Exception {
        return this.get_playSeqMaxSize();
    }

    public int get_playSeqSignature() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._playSeqSignature;
    }

    public int getPlaySeqSignature() throws YAPI_Exception {
        return this.get_playSeqSignature();
    }

    public String get_command() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return COMMAND_INVALID;
        }
        return this._command;
    }

    public String getCommand() throws YAPI_Exception {
        return this.get_command();
    }

    public int set_command(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("command", rest_val);
        return 0;
    }

    public int setCommand(String newval) throws YAPI_Exception {
        return this.set_command(newval);
    }

    public static YBuzzer FindBuzzer(String func) {
        YBuzzer obj = (YBuzzer)YFunction._FindFromCache("Buzzer", func);
        if (obj == null) {
            obj = new YBuzzer(func);
            YFunction._AddToCache("Buzzer", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackBuzzer = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    public int _invokeValueCallback(String value) {
        if (this._valueCallbackBuzzer != null) {
            this._valueCallbackBuzzer.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int sendCommand(String command) throws YAPI_Exception {
        return this.set_command(command);
    }

    public int addFreqMoveToPlaySeq(int freq, int msDelay) throws YAPI_Exception {
        return this.sendCommand(String.format("A%d,%d", freq, msDelay));
    }

    public int addPulseToPlaySeq(int freq, int msDuration) throws YAPI_Exception {
        return this.sendCommand(String.format("B%d,%d", freq, msDuration));
    }

    public int addVolMoveToPlaySeq(int volume, int msDuration) throws YAPI_Exception {
        return this.sendCommand(String.format("C%d,%d", volume, msDuration));
    }

    public int startPlaySeq() throws YAPI_Exception {
        return this.sendCommand("S");
    }

    public int stopPlaySeq() throws YAPI_Exception {
        return this.sendCommand("X");
    }

    public int resetPlaySeq() throws YAPI_Exception {
        return this.sendCommand("Z");
    }

    public int pulse(int frequency, int duration) throws YAPI_Exception {
        return this.set_command(String.format("P%d,%d", frequency, duration));
    }

    public int freqMove(int frequency, int duration) throws YAPI_Exception {
        return this.set_command(String.format("F%d,%d", frequency, duration));
    }

    public int volumeMove(int volume, int duration) throws YAPI_Exception {
        return this.set_command(String.format("V%d,%d", volume, duration));
    }

    public YBuzzer nextBuzzer() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YBuzzer.FindBuzzer(next_hwid);
    }

    public static YBuzzer FirstBuzzer() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Buzzer");
        if (next_hwid == null) {
            return null;
        }
        return YBuzzer.FindBuzzer(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YBuzzer var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YBuzzer var1, String var2);
    }
}

