/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.List;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class ScatterChart
extends XYChart {
    public static final String TYPE = "Scatter";
    private static final float SIZE = 3.0f;
    private static final int SHAPE_WIDTH = 10;
    private float size = 3.0f;

    ScatterChart() {
    }

    public ScatterChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
        this.size = renderer.getPointSize();
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super.setDatasetRenderer(dataset, renderer);
        this.size = renderer.getPointSize();
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> points, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, int startIndex) {
        XYSeriesRenderer renderer = (XYSeriesRenderer)seriesRenderer;
        paint.setColor(renderer.getColor());
        float stroke = paint.getStrokeWidth();
        if (renderer.isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStrokeWidth(renderer.getPointStrokeWidth());
            paint.setStyle(Paint.Style.STROKE);
        }
        int length = points.size();
        switch (renderer.getPointStyle()) {
            case X: {
                paint.setStrokeWidth(renderer.getPointStrokeWidth());
                for (int i = 0; i < length; i += 2) {
                    this.drawX(canvas, paint, points.get(i).floatValue(), points.get(i + 1).floatValue());
                }
                break;
            }
            case CIRCLE: {
                for (int i = 0; i < length; i += 2) {
                    this.drawCircle(canvas, paint, points.get(i).floatValue(), points.get(i + 1).floatValue());
                }
                break;
            }
            case TRIANGLE: {
                float[] path = new float[6];
                for (int i = 0; i < length; i += 2) {
                    this.drawTriangle(canvas, paint, path, points.get(i).floatValue(), points.get(i + 1).floatValue());
                }
                break;
            }
            case SQUARE: {
                for (int i = 0; i < length; i += 2) {
                    this.drawSquare(canvas, paint, points.get(i).floatValue(), points.get(i + 1).floatValue());
                }
                break;
            }
            case DIAMOND: {
                float[] path = new float[8];
                for (int i = 0; i < length; i += 2) {
                    this.drawDiamond(canvas, paint, path, points.get(i).floatValue(), points.get(i + 1).floatValue());
                }
                break;
            }
            case POINT: {
                for (int i = 0; i < length; i += 2) {
                    canvas.drawPoint(points.get(i).floatValue(), points.get(i + 1).floatValue(), paint);
                }
                break;
            }
        }
        paint.setStrokeWidth(stroke);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(List<Float> points, List<Double> values, float yAxisValue, int seriesIndex, int startIndex) {
        int length = points.size();
        ClickableArea[] ret = new ClickableArea[length / 2];
        for (int i = 0; i < length; i += 2) {
            int selectableBuffer = this.mRenderer.getSelectableBuffer();
            ret[i / 2] = new ClickableArea(new RectF(points.get(i).floatValue() - (float)selectableBuffer, points.get(i + 1).floatValue() - (float)selectableBuffer, points.get(i).floatValue() + (float)selectableBuffer, points.get(i + 1).floatValue() + (float)selectableBuffer), values.get(i), values.get(i + 1));
        }
        return ret;
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        if (((XYSeriesRenderer)renderer).isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStyle(Paint.Style.STROKE);
        }
        switch (((XYSeriesRenderer)renderer).getPointStyle()) {
            case X: {
                this.drawX(canvas, paint, x + 10.0f, y);
                break;
            }
            case CIRCLE: {
                this.drawCircle(canvas, paint, x + 10.0f, y);
                break;
            }
            case TRIANGLE: {
                this.drawTriangle(canvas, paint, new float[6], x + 10.0f, y);
                break;
            }
            case SQUARE: {
                this.drawSquare(canvas, paint, x + 10.0f, y);
                break;
            }
            case DIAMOND: {
                this.drawDiamond(canvas, paint, new float[8], x + 10.0f, y);
                break;
            }
            case POINT: {
                canvas.drawPoint(x + 10.0f, y, paint);
            }
        }
    }

    private void drawX(Canvas canvas, Paint paint, float x, float y) {
        canvas.drawLine(x - this.size, y - this.size, x + this.size, y + this.size, paint);
        canvas.drawLine(x + this.size, y - this.size, x - this.size, y + this.size, paint);
    }

    private void drawCircle(Canvas canvas, Paint paint, float x, float y) {
        canvas.drawCircle(x, y, this.size, paint);
    }

    private void drawTriangle(Canvas canvas, Paint paint, float[] path, float x, float y) {
        path[0] = x;
        path[1] = y - this.size - this.size / 2.0f;
        path[2] = x - this.size;
        path[3] = y + this.size;
        path[4] = x + this.size;
        path[5] = path[3];
        this.drawPath(canvas, path, paint, true);
    }

    private void drawSquare(Canvas canvas, Paint paint, float x, float y) {
        canvas.drawRect(x - this.size, y - this.size, x + this.size, y + this.size, paint);
    }

    private void drawDiamond(Canvas canvas, Paint paint, float[] path, float x, float y) {
        path[0] = x;
        path[1] = y - this.size;
        path[2] = x - this.size;
        path[3] = y;
        path[4] = x;
        path[5] = y + this.size;
        path[6] = x + this.size;
        path[7] = y;
        this.drawPath(canvas, path, paint, true);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

