/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import java.io.Serializable;

public class PieSegment
implements Serializable {
    private float mStartAngle;
    private float mEndAngle;
    private int mDataIndex;
    private float mValue;

    public PieSegment(int dataIndex, float value, float startAngle, float angle) {
        this.mStartAngle = startAngle;
        this.mEndAngle = angle + startAngle;
        this.mDataIndex = dataIndex;
        this.mValue = value;
    }

    public boolean isInSegment(double angle) {
        double stopAngle;
        if (angle >= (double)this.mStartAngle && angle <= (double)this.mEndAngle) {
            return true;
        }
        double cAngle = angle % 360.0;
        double startAngle = this.mStartAngle;
        for (stopAngle = (double)this.mEndAngle; stopAngle > 360.0; stopAngle -= 360.0) {
            startAngle -= 360.0;
        }
        return cAngle >= startAngle && cAngle <= stopAngle;
    }

    protected float getStartAngle() {
        return this.mStartAngle;
    }

    protected float getEndAngle() {
        return this.mEndAngle;
    }

    protected int getDataIndex() {
        return this.mDataIndex;
    }

    protected float getValue() {
        return this.mValue;
    }

    public String toString() {
        return "mDataIndex=" + this.mDataIndex + ",mValue=" + this.mValue + ",mStartAngle=" + this.mStartAngle + ",mEndAngle=" + this.mEndAngle;
    }
}

