/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YUSBHub;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class YUSBRawDevice
implements Runnable {
    private State _state;
    private YUSBHub _usbHub;
    private String _serial;
    private final UsbDevice _device;
    private final UsbManager _manager;
    private final IOHandler _ioHandler;
    private UsbDeviceConnection _connection;
    private UsbInterface _intf;
    private boolean _muststop = false;
    private final Object _threadLock = new Object();
    private Thread thread;
    private boolean _ioStarted;

    public String getSerial() {
        return this._serial;
    }

    public boolean isUsable() {
        return this._state == State.ACCEPTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mustBgThreadStop() {
        boolean b;
        Object object = this._threadLock;
        synchronized (object) {
            b = this._muststop;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBgThread() {
        Object object = this._threadLock;
        synchronized (object) {
            this._muststop = true;
        }
    }

    public UsbDevice getUsbDevice() {
        return this._device;
    }

    YUSBRawDevice(YUSBHub yusbHub, UsbDevice device, UsbManager manager, IOHandler handler) {
        this._usbHub = yusbHub;
        this._device = device;
        this._manager = manager;
        this._ioHandler = handler;
        this._ioStarted = false;
        this._state = State.PLUGGED;
    }

    public synchronized void ensureIOStarted() {
        if (this._ioStarted) {
            return;
        }
        this._intf = this._device.getInterface(0);
        if (!this._manager.hasPermission(this._device)) {
            if (this._state == State.REJECTED && this._device.getProductId() != 2) {
                return;
            }
            this._usbHub.triggerPermissionRequest(this);
        } else {
            this.permissionAccepted();
        }
    }

    boolean permissionAccepted() {
        this._state = State.ACCEPTED;
        this._connection = this._manager.openDevice(this._device);
        if (this._connection == null) {
            YAPI.SafeYAPI()._Log("unable to open connection to device " + this._device.getDeviceName());
            this.release();
            return false;
        }
        if (!this._connection.claimInterface(this._intf, true)) {
            YAPI.SafeYAPI()._Log("unable to claim interface 0 for device " + this._device.getDeviceName());
            this.release();
            return false;
        }
        this._serial = this._connection.getSerial();
        this.thread = new Thread(this);
        this.thread.setName("IOusb_" + this._serial);
        this.thread.start();
        this._ioStarted = true;
        this._ioHandler.rawDeviceUpdateState(this);
        return true;
    }

    public void permissionRejected() {
        this._state = State.REJECTED;
    }

    public void unplug() {
        this._state = State.UNPLUGGED;
    }

    public synchronized void release() {
        this.stopBgThread();
        if (this._connection != null) {
            this._connection.releaseInterface(this._intf);
            this._connection.close();
        }
        if (this.thread != null) {
            try {
                this.thread.join(20L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.thread = null;
        }
        this._connection = null;
        this._intf = null;
    }

    public synchronized void sendPkt(byte[] outPkt) throws YAPI_Exception {
        int result;
        if (this._intf == null) {
            throw new YAPI_Exception(-8, "Device is gone");
        }
        UsbEndpoint endpointOUT = null;
        for (int e = 0; e < this._intf.getEndpointCount(); ++e) {
            UsbEndpoint endp = this._intf.getEndpoint(e);
            if (endp.getDirection() != 0) continue;
            endpointOUT = endp;
        }
        if (endpointOUT == null) {
            throw new YAPI_Exception(-8, "Unable to get USB Out endpoint");
        }
        int retry = 0;
        while ((result = this._connection.bulkTransfer(endpointOUT, outPkt, outPkt.length, 1000)) < 0 && ++retry < 15) {
        }
    }

    @Override
    public void run() {
        int nbSuccessiveError = 0;
        UsbEndpoint endpointIN = null;
        for (int e = 0; e < this._intf.getEndpointCount(); ++e) {
            UsbEndpoint endp = this._intf.getEndpoint(e);
            if (endp.getDirection() != 128) continue;
            endpointIN = endp;
        }
        if (endpointIN == null) {
            this._ioHandler.ioError("Unable to get USB In endpoint");
            return;
        }
        UsbRequest d2h_r = new UsbRequest();
        d2h_r.initialize(this._connection, endpointIN);
        byte[] data = new byte[64];
        data[0] = -34;
        data[1] = -83;
        data[2] = -66;
        data[3] = -17;
        d2h_r.setClientData((Object)data);
        ByteBuffer d2h_pkt = ByteBuffer.wrap(data);
        d2h_pkt.order(ByteOrder.LITTLE_ENDIAN);
        d2h_r.queue(d2h_pkt, 64);
        while (!this.mustBgThreadStop() && this._connection != null) {
            UsbRequest finished;
            try {
                finished = this._connection.requestWait();
            }
            catch (Exception e) {
                finished = null;
            }
            if (finished != null) {
                UsbEndpoint endp = finished.getEndpoint();
                nbSuccessiveError = 0;
                if (endp == null || endp.getDirection() != 128) continue;
                ByteBuffer wraped = ByteBuffer.wrap(data);
                wraped.order(ByteOrder.LITTLE_ENDIAN);
                if (!this.mustBgThreadStop()) {
                    this._ioHandler.newPKT(wraped);
                }
                data[0] = -34;
                data[1] = -83;
                data[2] = -66;
                data[3] = -17;
                d2h_pkt.clear();
                d2h_r.queue(d2h_pkt, 64);
                continue;
            }
            if (nbSuccessiveError <= 5) continue;
            this._ioHandler.ioError("Too may successive USB error");
            break;
        }
    }

    public static interface IOHandler {
        public void newPKT(ByteBuffer var1);

        public void ioError(String var1);

        public void rawDeviceUpdateState(YUSBRawDevice var1);
    }

    static enum State {
        UNPLUGGED,
        PLUGGED,
        ACCEPTED,
        REJECTED;

    }
}

