/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class YUSBProgPkt {
    private static final int USB_PKT_SIZE = 64;
    static final int PROG_INVALID = -1;
    static final int PROG_NOP = 0;
    static final int PROG_REBOOT = 1;
    static final int PROG_ERASE = 2;
    static final int PROG_PROG = 3;
    static final int PROG_VERIF = 4;
    static final int PROG_INFO = 5;
    static final int PROG_INFO_EXT = 6;
    static final int MAX_BYTE_IN_PACKET = 60;
    static final int MAX_INSTR_IN_PACKET = 20;
    private final int _type;
    private final int _size;
    private int _progdata_ofs;
    private int _pos;
    private int _nPages;
    private int _pageNo;
    private final boolean _use_ext_pkt;
    private int _address;
    private short _pr_blk_size;
    private int _devid;
    private int _settings_addr;
    private int _last_addr;
    private int _config_start;
    private int _config_stop;
    private short _er_blk_size;
    private byte _version;
    private short _ext_jedec_id;
    private short _ext_page_size;
    private short _ext_total_pages;
    private short _first_code_page;
    private short _first_yfs3_page;
    private byte _devid_;
    private byte[] _progdata;
    private short _sign;

    public byte[] getProgdata() {
        return this._progdata;
    }

    public int getProgdata_ofs() {
        return this._progdata_ofs;
    }

    public YUSBProgPkt(ByteBuffer pkt) {
        pkt.order(ByteOrder.LITTLE_ENDIAN);
        if (pkt.remaining() < 64) {
            this._type = -1;
            this._size = 0;
            this._use_ext_pkt = false;
            return;
        }
        int b = pkt.get() & 0xFF;
        this._type = b >> 5;
        this._size = b & 0x1F;
        switch (this._type) {
            default: {
                this._use_ext_pkt = false;
                break;
            }
            case 3: 
            case 4: {
                int dwordpos_lo = pkt.get() & 0xFF;
                int pageno_lo = pkt.get() & 0xFF;
                int misc_hi = pkt.get() & 0xFF;
                this._pos = dwordpos_lo + (misc_hi << 2 & 0x300);
                this._pageNo = pageno_lo + ((misc_hi & 0x3F) << 8);
                this._address = (dwordpos_lo << 16) + (misc_hi << 8) + pageno_lo;
                this._use_ext_pkt = true;
                this._progdata = new byte[this._size * 2];
                pkt.get(this._progdata);
                this._progdata_ofs = 0;
                break;
            }
            case 5: {
                this._use_ext_pkt = false;
                pkt.get();
                this._pr_blk_size = pkt.getShort();
                this._devid = pkt.getInt();
                this._settings_addr = pkt.getInt();
                this._last_addr = pkt.getInt();
                this._config_start = pkt.getInt();
                this._config_stop = pkt.getInt();
                this._er_blk_size = pkt.getShort();
                break;
            }
            case 6: {
                this._use_ext_pkt = true;
                this._version = pkt.get();
                this._pr_blk_size = pkt.getShort();
                this._devid = pkt.getInt();
                this._settings_addr = pkt.getInt();
                this._last_addr = pkt.getInt();
                this._config_start = pkt.getInt();
                this._config_stop = pkt.getInt();
                this._er_blk_size = pkt.getShort();
                this._ext_jedec_id = pkt.getShort();
                this._ext_page_size = pkt.getShort();
                this._ext_total_pages = pkt.getShort();
                this._first_code_page = pkt.getShort();
                this._first_yfs3_page = pkt.getShort();
            }
        }
    }

    public YUSBProgPkt(int type, boolean ext_pkt) {
        this._type = type;
        this._size = 0;
        this._use_ext_pkt = ext_pkt;
    }

    public YUSBProgPkt(int type, int page, int pos, int nPages) {
        this._type = type;
        this._size = 0;
        this._use_ext_pkt = true;
        this._pageNo = page;
        this._pos = pos;
        this._nPages = nPages;
    }

    public YUSBProgPkt(int type, int page, int pos) {
        this._type = type;
        this._size = 0;
        this._use_ext_pkt = true;
        this._pageNo = page;
        this._pos = pos;
    }

    public YUSBProgPkt(int type, int page, int pos, int size, byte[] instr, int ofs) {
        this._type = type;
        this._size = size;
        this._use_ext_pkt = true;
        this._pageNo = page;
        this._pos = pos;
        this._progdata = instr;
        this._progdata_ofs = ofs;
    }

    public YUSBProgPkt(int type, int address) {
        this._type = type;
        this._size = 0;
        this._use_ext_pkt = false;
        this._address = address;
    }

    public YUSBProgPkt(int type, int address, int nbinstr, byte[] instr, int ofs) {
        this._type = type;
        this._size = nbinstr;
        this._use_ext_pkt = false;
        this._address = address;
        this._progdata = instr;
        this._progdata_ofs = ofs;
    }

    public int getType() {
        return this._type;
    }

    public int getSize() {
        return this._size;
    }

    public short getPr_blk_size() {
        return this._pr_blk_size;
    }

    public int getSettings_addr() {
        return this._settings_addr;
    }

    public int getLast_addr() {
        return this._last_addr;
    }

    public int getConfig_start() {
        return this._config_start;
    }

    public int getConfig_stop() {
        return this._config_stop;
    }

    public short getEr_blk_size() {
        return this._er_blk_size;
    }

    public byte getVersion() {
        return this._version;
    }

    public short getExt_jedec_id() {
        return this._ext_jedec_id;
    }

    public short getExt_page_size() {
        return this._ext_page_size;
    }

    public short getExt_total_pages() {
        return this._ext_total_pages;
    }

    public short getFirst_code_page() {
        return this._first_code_page;
    }

    public short getFirst_yfs3_page() {
        return this._first_yfs3_page;
    }

    public byte[] getRawPkt() {
        byte[] pkt = new byte[64];
        ByteBuffer bb = ByteBuffer.wrap(pkt);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put((byte)((this._size & 0x1F) + ((this._type & 7) << 5) & 0xFF));
        switch (this._type) {
            case 0: 
            case 1: {
                if (!this._use_ext_pkt) break;
                bb.put((byte)0);
                bb.put((byte)0);
                bb.put((byte)0);
                bb.putShort(this._sign);
                break;
            }
            case 2: {
                if (!this._use_ext_pkt) break;
                bb.put((byte)(this._pos & 0xFF));
                bb.put((byte)(this._pageNo & 0xFF));
                bb.put((byte)((this._pageNo >> 8 & 0x3F) + ((this._pos & 0x300) >> 2)));
                bb.put((byte)(this._nPages & 0xFF));
                bb.put((byte)(this._nPages >> 8 & 0xFF));
                break;
            }
            case 3: 
            case 4: {
                if (this._use_ext_pkt) {
                    bb.put((byte)(this._pos & 0xFF));
                    bb.put((byte)(this._pageNo & 0xFF));
                    bb.put((byte)((this._pageNo >> 8 & 0x3F) + ((this._pos & 0x300) >> 2)));
                    if (this._type != 3) break;
                    bb.put(this._progdata, this._progdata_ofs, this._size * 2);
                    break;
                }
                bb.put((byte)(this._address >> 16 & 0xFF));
                bb.put((byte)(this._address & 0xFF));
                bb.put((byte)(this._address >> 8 & 0xFF));
                bb.put(this._progdata, this._progdata_ofs, this._size * 3);
                break;
            }
        }
        return pkt;
    }

    public int getDevid_family() {
        return this._devid >> 8 & 0xFF;
    }

    public int getDevid_model() {
        return this._devid & 0xFF;
    }

    public int getDevid_rev() {
        return this._devid >> 16 & 0xFFFF;
    }

    public int getPageNo() {
        return this._pageNo;
    }

    public int getPos() {
        return this._pos;
    }

    public void setBtSign(int sign) {
        if (this._use_ext_pkt) {
            this._sign = (short)(sign & 0xFFFF);
        }
    }
}

