/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YPktStreamHead;
import com.yoctopuce.YoctoAPI.YUSBDevice;
import com.yoctopuce.YoctoAPI.YUSBPkt;
import java.util.ArrayList;

public class YUSBPktOut
extends YUSBPkt {
    private static final int USB_META_UTCTIME = 1;

    YUSBPktOut(YUSBDevice dev) {
        super(dev, 0, new ArrayList<YPktStreamHead>());
    }

    public byte[] getRawPkt() throws YAPI_Exception {
        byte[] res = new byte[64];
        int pos = 0;
        for (YPktStreamHead s : this._streams) {
            pos += s.getRawStream(res, pos);
        }
        YPktStreamHead.PadWithEmpty(res, pos, 64);
        return res;
    }

    private void addStream(YPktStreamHead stream) {
        if (this.getFreeSize() < stream.getFullSize()) {
            YAPI.SafeYAPI()._Log("USB Out packet overflow");
            return;
        }
        this._streams.add(stream);
    }

    private int getFreeSize() {
        int used = 0;
        for (YPktStreamHead s : this._streams) {
            used += s.getFullSize();
        }
        return 64 - used;
    }

    public int pushTCP(byte[] bytes, int pos, int len) throws YAPI_Exception {
        int avail = this.getFreeSize() - 2;
        if (avail <= 0) {
            return 0;
        }
        if (avail < len) {
            len = avail;
        }
        YPktStreamHead s = new YPktStreamHead(0, 0, 1, bytes, pos, len);
        this.addStream(s);
        return len;
    }

    public void pushTCPClose() throws YAPI_Exception {
        YPktStreamHead s = new YPktStreamHead(0, 0, 2, null, 0, 0);
        this.addStream(s);
    }

    public void pushMetaUTC() {
        byte[] pktdata = new byte[5];
        pktdata[0] = 1;
        long currUtcTime = System.currentTimeMillis() / 1000L;
        pktdata[1] = (byte)(currUtcTime & 0xFFL);
        pktdata[2] = (byte)(currUtcTime >> 8 & 0xFFL);
        pktdata[3] = (byte)(currUtcTime >> 16 & 0xFFL);
        pktdata[4] = (byte)(currUtcTime >> 24 & 0xFFL);
        YPktStreamHead s = new YPktStreamHead(0, 0, 5, pktdata, 0, pktdata.length);
        this.addStream(s);
    }

    public static YUSBPktOut ResetPkt(YUSBDevice dev) {
        YUSBPkt.ConfPktReset reset = new YUSBPkt.ConfPktReset(518, 1, 0, 0);
        YUSBPktOut pkt = new YUSBPktOut(dev);
        pkt.addStream(reset.getAsStream());
        return pkt;
    }

    public static YUSBPktOut StartPkt(YUSBDevice dev) {
        YUSBPkt.ConfPktStart reset = new YUSBPkt.ConfPktStart(1);
        YUSBPktOut pkt = new YUSBPktOut(dev);
        pkt.addStream(reset.getAsStream());
        return pkt;
    }
}

