/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YPktStreamHead;
import com.yoctopuce.YoctoAPI.YUSBDevice;
import java.util.ArrayList;

public class YUSBPkt {
    protected static final int YPKT_USB_VERSION_BCD = 518;
    public static final int USB_PKT_SIZE = 64;
    private final YUSBDevice _dev;
    protected int _pktno = 0;
    protected ArrayList<YPktStreamHead> _streams;

    YUSBPkt(YUSBDevice dev, int pktno, ArrayList<YPktStreamHead> streams) {
        this._dev = dev;
        this._streams = streams;
        this._pktno = pktno;
    }

    int getPktno() {
        return this._pktno;
    }

    public ArrayList<YPktStreamHead> getStreams() {
        return this._streams;
    }

    protected static boolean isCompatibe(int version, String serial) throws YAPI_Exception {
        if ((version & 0xFF00) != 512) {
            if ((version & 0xFF00) > 512) {
                YAPI.SafeYAPI()._Log(String.format("Yoctopuce library is too old (using 0x%x need 0x%x) to handle device %s, please upgrade your Yoctopuce library\n", 518, version, serial));
                throw new YAPI_Exception(-8, "Library is too old to handle this device");
            }
            throw new YAPI_Exception(-8, "implement backward compatibility when implementing a new protocol");
        }
        if (version != 518) {
            if (version > 518) {
                YAPI.SafeYAPI()._Log(String.format("Device %s is using an newer protocol, consider upgrading your Yoctopuce library\n", serial));
            } else {
                YAPI.SafeYAPI()._Log(String.format("Device %s is using an older protocol, consider upgrading the device firmware\n", serial));
            }
            return false;
        }
        return true;
    }

    public String toString() {
        String dump = String.format("pktno:%d with %d ystream", this._pktno, this._streams.size());
        for (YPktStreamHead s : this._streams) {
            dump = dump + "\n" + s.toString();
        }
        return dump;
    }

    protected static class ConfPktStart {
        private int _nbIface;

        public ConfPktStart(int nbiface) {
            this._nbIface = nbiface;
        }

        public int getNbIface() {
            return this._nbIface;
        }

        public static ConfPktStart Decode(byte[] data) {
            return new ConfPktStart(data[0]);
        }

        public YPktStreamHead getAsStream() {
            byte[] data = new byte[62];
            data[0] = (byte)this._nbIface;
            return new YPktStreamHead(0, 1, 1, data, 0, data.length);
        }
    }

    protected static class ConfPktReset {
        private int _api;
        private int _ok;
        private int _ifaceNo;
        private int _nbIface;

        public ConfPktReset(int api, int ok, int ifaceno, int nbiface) {
            this._api = api;
            this._ok = ok;
            this._ifaceNo = ifaceno;
            this._nbIface = nbiface;
        }

        public int getApi() {
            return this._api;
        }

        public int getOk() {
            return this._ok;
        }

        public int getIfaceNo() {
            return this._ifaceNo;
        }

        public int getNbIface() {
            return this._nbIface;
        }

        public static ConfPktReset Decode(byte[] data) {
            int api = data[0] + (data[1] << 8);
            return new ConfPktReset(api, data[2], data[3], data[4]);
        }

        public YPktStreamHead getAsStream() {
            byte[] data = new byte[62];
            data[0] = (byte)(this._api & 0xFF);
            data[1] = (byte)(this._api >> 8 & 0xFF);
            data[2] = 1;
            return new YPktStreamHead(0, 1, 0, data, 0, data.length);
        }
    }
}

