/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareFile;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YPEntry;
import com.yoctopuce.YoctoAPI.YUSBBootloader;
import com.yoctopuce.YoctoAPI.YUSBDevice;
import com.yoctopuce.YoctoAPI.YUSBRawDevice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

class YUSBHub
extends YGenericHub {
    private static final String ACTION_USB_PERMISSION = "com.yoctopuce.YoctoAPI.USB_PERMISSION";
    private static final long YPROG_BOOTLOADER_TIMEOUT = 3600000L;
    private static Context sAppContext = null;
    private final HashMap<String, YUSBRawDevice> _usbDevices = new HashMap(1);
    private final HashMap<String, YUSBDevice> _devsFromAndroidRef = new HashMap(2);
    private final HashMap<String, YUSBBootloader> _bootloadersFromAndroidRef = new HashMap(2);
    private final UsbManager _manager;
    private final BroadcastReceiver _usbBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
            if (device == null) {
                return;
            }
            String deviceName = device.getDeviceName();
            YUSBRawDevice yusbRawDevice = (YUSBRawDevice)YUSBHub.this._usbDevices.get(deviceName);
            if (YUSBHub.ACTION_USB_PERMISSION.equals(action)) {
                if (intent.getBooleanExtra("permission", false)) {
                    YAPI.SafeYAPI()._Log("HUB_USB: permission granted for device " + deviceName + "\n");
                    if (yusbRawDevice != null) {
                        yusbRawDevice.permissionAccepted();
                    }
                } else {
                    YAPI.SafeYAPI()._Log("HUB_USB: permission denied for device " + deviceName + "\n");
                    if (yusbRawDevice != null) {
                        yusbRawDevice.permissionRejected();
                    }
                }
                Queue queue = YUSBHub.this._permissionPending;
                synchronized (queue) {
                    YUSBRawDevice current = (YUSBRawDevice)YUSBHub.this._permissionPending.poll();
                    if (!current.getUsbDevice().equals((Object)device)) {
                        return;
                    }
                    YUSBRawDevice next = (YUSBRawDevice)YUSBHub.this._permissionPending.peek();
                    if (next != null) {
                        YUSBHub.this.doPermissionRequest(next.getUsbDevice());
                    }
                }
            } else {
                if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                    return;
                }
                if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                    YAPI.SafeYAPI()._Log("HUB_USB: uplug of device " + deviceName + "\n");
                    if (yusbRawDevice != null) {
                        yusbRawDevice.unplug();
                    }
                }
            }
        }
    };
    private final Queue<YUSBRawDevice> _permissionPending = new LinkedList<YUSBRawDevice>();

    YUSBHub(int idx) throws YAPI_Exception {
        super(idx, true);
        this._manager = (UsbManager)sAppContext.getSystemService("usb");
        if (this._manager == null) {
            throw new YAPI_Exception(-8, "Unable to get Android USB manager");
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_USB_PERMISSION);
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        sAppContext.registerReceiver(this._usbBroadcastReceiver, filter);
    }

    @Override
    void startNotifications() {
    }

    @Override
    void stopNotifications() {
    }

    @Override
    void release() {
        sAppContext.unregisterReceiver(this._usbBroadcastReceiver);
        for (String devname : this._usbDevices.keySet()) {
            this._usbDevices.get(devname).release();
        }
        this._usbDevices.clear();
        this._devsFromAndroidRef.clear();
        this._bootloadersFromAndroidRef.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerPermissionRequest(YUSBRawDevice device) {
        boolean doRequest = false;
        Queue<YUSBRawDevice> queue = this._permissionPending;
        synchronized (queue) {
            if (this._permissionPending.contains(device)) {
                return;
            }
            if (this._permissionPending.size() == 0) {
                doRequest = true;
            }
            this._permissionPending.add(device);
        }
        YAPI.SafeYAPI()._Log("HUB_USB: trigger request permission for " + device.getUsbDevice().getDeviceName() + "\n");
        if (doRequest) {
            UsbDevice usbDevice = device.getUsbDevice();
            this.doPermissionRequest(usbDevice);
        }
    }

    private void doPermissionRequest(UsbDevice device) {
        Intent intent = new Intent(ACTION_USB_PERMISSION);
        YAPI.SafeYAPI()._Log("HUB_USB: request permission for " + device.getDeviceName() + "\n");
        PendingIntent askPermissionIntent = PendingIntent.getBroadcast((Context)sAppContext, (int)0, (Intent)intent, (int)0);
        this._manager.requestPermission(device, askPermissionIntent);
    }

    void refreshUsableDeviceList() {
        HashMap connectedDevices = this._manager.getDeviceList();
        if (connectedDevices == null) {
            return;
        }
        ArrayList<String> toRemove = new ArrayList<String>(this._usbDevices.keySet());
        for (Map.Entry entry : connectedDevices.entrySet()) {
            YUSBRawDevice rawDevice;
            String key = (String)entry.getKey();
            UsbDevice usbdevice = (UsbDevice)entry.getValue();
            if (usbdevice.getInterfaceCount() < 1) continue;
            int deviceid = usbdevice.getProductId();
            if (usbdevice.getVendorId() != 9440 || deviceid == 1) continue;
            if (this._usbDevices.containsKey(key)) {
                toRemove.remove(key);
                this._usbDevices.get(key).ensureIOStarted();
                continue;
            }
            if (deviceid == 2) {
                YUSBBootloader bootloader = new YUSBBootloader();
                rawDevice = new YUSBRawDevice(this, usbdevice, this._manager, bootloader);
                this._bootloadersFromAndroidRef.put(key, bootloader);
            } else {
                YUSBDevice device = new YUSBDevice();
                rawDevice = new YUSBRawDevice(this, usbdevice, this._manager, device);
                this._devsFromAndroidRef.put(key, device);
            }
            rawDevice.ensureIOStarted();
            this._usbDevices.put(key, rawDevice);
        }
        for (String devname : toRemove) {
            YUSBRawDevice yusbRawDevice = this._usbDevices.get(devname);
            if (yusbRawDevice != null) {
                yusbRawDevice.release();
            }
            if (this._devsFromAndroidRef.containsKey(devname)) {
                this._devsFromAndroidRef.remove(devname);
            }
            if (this._bootloadersFromAndroidRef.containsKey(devname)) {
                this._bootloadersFromAndroidRef.remove(devname);
            }
            this._usbDevices.remove(devname);
        }
    }

    @Override
    synchronized void updateDeviceList(boolean forceupdate) throws YAPI_Exception {
        long now = YAPI.GetTickCount();
        if (forceupdate) {
            this._devListExpires = 0L;
        }
        if (this._devListExpires > now) {
            return;
        }
        this.refreshUsableDeviceList();
        HashMap<String, ArrayList<YPEntry>> yellowPages = new HashMap<String, ArrayList<YPEntry>>();
        ArrayList<WPEntry> whitePages = new ArrayList<WPEntry>();
        for (YUSBDevice d : this._devsFromAndroidRef.values()) {
            if (!d.isAllowed() || !d.waitEndOfInit(500)) continue;
            d.updateWhitesPages(whitePages);
            d.updateYellowPages(yellowPages);
        }
        this.updateFromWpAndYp(whitePages, yellowPages);
        now = YAPI.GetTickCount();
        this._devListExpires = now + this._devListValidity;
    }

    @Override
    public ArrayList<String> getBootloaders() {
        ArrayList<String> res = new ArrayList<String>(this._bootloadersFromAndroidRef.size());
        this.refreshUsableDeviceList();
        for (YUSBBootloader bootloader : this._bootloadersFromAndroidRef.values()) {
            if (!bootloader.isReady()) continue;
            res.add(bootloader.getSerial());
        }
        return res;
    }

    @Override
    ArrayList<String> firmwareUpdate(String serial, YFirmwareFile firmware, byte[] settings, YGenericHub.UpdateProgress progress) throws YAPI_Exception, InterruptedException {
        String reboot_req = "GET /api/module/rebootCountdown?rebootCountdown=-3";
        progress.firmware_progress(1, "Wait bootloader to be detected");
        YUSBBootloader bootloader = null;
        long timeout = YAPI.GetTickCount() + 3600000L;
        boolean rebootsent = false;
        do {
            this.refreshUsableDeviceList();
            for (YUSBBootloader b : this._bootloadersFromAndroidRef.values()) {
                if (!b.isReady() || !serial.equals(b.getSerial())) continue;
                bootloader = b;
                break;
            }
            if (bootloader == null) {
                if (!rebootsent) {
                    YUSBDevice d = this.devFromSerial(serial);
                    d.sendRequestSync(reboot_req, null);
                    rebootsent = true;
                } else {
                    Thread.sleep(500L, 0);
                }
            }
            this.refreshUsableDeviceList();
        } while (bootloader == null && timeout > YAPI.GetTickCount());
        if (bootloader == null) {
            throw new YAPI_Exception(-4, "bootloader is not detected");
        }
        progress.firmware_progress(5, "Start usb firmware update");
        bootloader.firmwareUpdate(firmware, progress);
        return null;
    }

    protected YUSBDevice devFromSerial(String serial) throws YAPI_Exception {
        for (Map.Entry<String, YUSBDevice> entry : this._devsFromAndroidRef.entrySet()) {
            YUSBDevice yusbDevice = entry.getValue();
            if (!serial.equals(yusbDevice.getSerial())) continue;
            return yusbDevice;
        }
        throw new YAPI_Exception(-4, "Device has been unplugged");
    }

    @Override
    void devRequestAsync(YDevice device, String req_first_line, byte[] req_head_and_body, YGenericHub.RequestAsyncResult asyncResult, Object asyncContext) throws YAPI_Exception {
        String serial = device.getSerialNumber();
        int i = req_first_line.lastIndexOf("&.");
        if (i >= 0) {
            req_first_line = req_first_line.substring(0, i);
        }
        YUSBDevice d = this.devFromSerial(serial);
        d.sendRequestAsync(req_first_line, req_head_and_body, asyncResult, asyncContext);
    }

    @Override
    byte[] devRequestSync(YDevice device, String req_first_line, byte[] req_head_and_body) throws YAPI_Exception {
        String serial = device.getSerialNumber();
        YUSBDevice d = this.devFromSerial(serial);
        return d.sendRequestSync(req_first_line, req_head_and_body);
    }

    static void SetContextType(Object ctx) throws YAPI_Exception {
        YAPI.SafeYAPI()._Log("HUB_USB:context type=" + ctx.getClass().getName() + "\n");
        if (!(ctx instanceof Context)) {
            throw new YAPI_Exception(-2, "Object is not a valid Android Application Context");
        }
        Context app_ctx = ((Context)ctx).getApplicationContext();
        if (sAppContext != null && app_ctx != sAppContext) {
            throw new YAPI_Exception(-2, "Android Application Context allready set");
        }
        sAppContext = app_ctx;
    }

    static void CheckUSBAcces() throws YAPI_Exception {
        if (sAppContext == null) {
            throw new YAPI_Exception(-2, "You must enable USB host mode before registering usb devices");
        }
    }

    @Override
    String getRootUrl() {
        return "usb";
    }

    @Override
    boolean isSameRootUrl(String url) {
        return url.equals("usb");
    }

    public static boolean RegisterLocalhost() {
        return false;
    }
}

