/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YPEntry;
import com.yoctopuce.YoctoAPI.YPktStreamHead;
import com.yoctopuce.YoctoAPI.YUSBPkt;
import com.yoctopuce.YoctoAPI.YUSBPktIn;
import com.yoctopuce.YoctoAPI.YUSBPktOut;
import com.yoctopuce.YoctoAPI.YUSBRawDevice;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class YUSBDevice
implements YUSBRawDevice.IOHandler {
    private static final long META_UTC_DELAY = 1800000L;
    private String _serial = null;
    private int _lastpktno;
    private YUSBRawDevice _rawDev;
    private long _lastMetaUTC = -1L;
    private final HashMap<String, WPEntry> _usbWP = new HashMap();
    private final HashMap<String, YPEntry> _usbYP = new HashMap();
    private HashMap<String, String> _usbIdx2Funcid = new HashMap();
    private ArrayList<String> _usbIdx2Serial = new ArrayList();
    private final Object _stateLock = new Object();
    private PKT_State _pkt_state = PKT_State.Plugged;
    private TCP_State _tcp_state = TCP_State.Closed;
    private YGenericHub.RequestAsyncResult _asyncResult;
    private Object _asyncContext;
    private final ByteArrayOutputStream _req_result = new ByteArrayOutputStream(1024);
    private long _currentRequestTimeout;

    public boolean isAllowed() {
        return this._rawDev != null && this._rawDev.isUsable();
    }

    public String getSerial() {
        return this._serial;
    }

    String getSerialFromYdx(int ydx) {
        return this._usbIdx2Serial.get(ydx);
    }

    public String getFuncidFromYdx(String serial, int i) {
        return this._usbIdx2Funcid.get(serial + i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YPEntry getYPEntry(String serial, String functionId) throws YAPI_Exception {
        YPEntry yp;
        String hwid = serial + "." + functionId;
        HashMap<String, YPEntry> hashMap = this._usbYP;
        synchronized (hashMap) {
            if (!this._usbYP.containsKey(hwid)) {
                yp = new YPEntry(serial, functionId);
                this._usbYP.put(hwid, yp);
            } else {
                yp = this._usbYP.get(hwid);
            }
        }
        return yp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YPEntry getYPEntryFromYdx(String serial, int funIdx) {
        YPEntry yp;
        String functionId = this.getFuncidFromYdx(serial, funIdx);
        String hwid = serial + "." + functionId;
        HashMap<String, YPEntry> hashMap = this._usbYP;
        synchronized (hashMap) {
            if (!this._usbYP.containsKey(hwid)) {
                yp = new YPEntry(serial, functionId);
                this._usbYP.put(hwid, yp);
            } else {
                yp = this._usbYP.get(hwid);
            }
        }
        return yp;
    }

    public boolean waitEndOfInit(int wait) {
        try {
            this.waitForTcpState(PKT_State.StreamReadyReceived, null, wait, "Device not ready");
        }
        catch (YAPI_Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewState(PKT_State new_pkt_state, TCP_State new_tcp_State) {
        Object object = this._stateLock;
        synchronized (object) {
            this._pkt_state = new_pkt_state;
            if (new_tcp_State != null) {
                this._tcp_state = TCP_State.Closed;
            }
            this._stateLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testState(PKT_State pkt_state, TCP_State tcp_State) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._pkt_state != pkt_state) {
                return false;
            }
            if (tcp_State != null && this._tcp_state != tcp_State) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteClose() {
        Object object = this._stateLock;
        synchronized (object) {
            switch (this._tcp_state) {
                case Close_by_API: {
                    this._tcp_state = TCP_State.Closed;
                    this._stateLock.notify();
                    break;
                }
                case Close_by_dev: 
                case Closed: {
                    YAPI.SafeYAPI()._Log("Drop unexpected close from device\n");
                    break;
                }
                case Opened: {
                    this._tcp_state = TCP_State.Close_by_dev;
                    this._stateLock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTcpState(PKT_State wanted, PKT_State next, long mswait, String message) throws YAPI_Exception {
        long timeout = YAPI.GetTickCount() + mswait;
        Object object = this._stateLock;
        synchronized (object) {
            while (this._pkt_state != PKT_State.IOError && this._pkt_state != wanted && timeout > YAPI.GetTickCount()) {
                long millis = timeout - YAPI.GetTickCount();
                try {
                    this._stateLock.wait(millis);
                }
                catch (InterruptedException e) {
                    throw new YAPI_Exception(-7, "Device " + this._serial + " " + message, e);
                }
            }
            if (this._pkt_state == PKT_State.IOError) {
                throw new YAPI_Exception(-8, "Device " + this._serial + " " + message + " (io error)");
            }
            if (this._pkt_state != wanted) {
                throw new YAPI_Exception(-7, "Device " + this._serial + " " + message + " (" + (Object)((Object)this._pkt_state) + ")");
            }
            if (next != null) {
                this._pkt_state = next;
                this._stateLock.notify();
            }
        }
    }

    private void sendConfReset() {
        YUSBPktOut ypkt_reset = YUSBPktOut.ResetPkt(this);
        try {
            this._rawDev.sendPkt(ypkt_reset.getRawPkt());
            this.setNewState(PKT_State.ResetSend, TCP_State.Closed);
        }
        catch (YAPI_Exception e) {
            e.printStackTrace();
            this.ioError("Unable to send reset pkt:" + e.getLocalizedMessage());
        }
    }

    private void receiveConfReset(YUSBPktIn newpkt) {
        if (this.testState(PKT_State.ResetSend, null)) {
            YUSBPkt.ConfPktReset reset = newpkt.getConfPktReset();
            try {
                YUSBPkt.isCompatibe(reset.getApi(), this._serial);
            }
            catch (YAPI_Exception e) {
                this.ioError(e.getLocalizedMessage());
                return;
            }
            YUSBPktOut ypkt_start = YUSBPktOut.StartPkt(this);
            try {
                this._rawDev.sendPkt(ypkt_start.getRawPkt());
                this.setNewState(PKT_State.StartSend, null);
            }
            catch (YAPI_Exception e) {
                e.printStackTrace();
                this.ioError("Unable to send start pkt:" + e.getLocalizedMessage());
            }
        } else {
            YAPI.SafeYAPI()._Log("Drop late reset packet:" + newpkt.toString());
        }
    }

    private void receiveConfStart(YUSBPktIn newpkt) {
        if (this.testState(PKT_State.StartSend, null)) {
            this._lastpktno = newpkt.getPktno();
            this.setNewState(PKT_State.StartReceived, null);
        } else {
            YAPI.SafeYAPI()._Log("Drop late start packet:" + newpkt.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStreamReady() {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._pkt_state == PKT_State.StartReceived) {
                this._pkt_state = PKT_State.StreamReadyReceived;
                this._stateLock.notify();
            } else {
                YAPI.SafeYAPI()._Log("Streamready to early! :" + (Object)((Object)this._pkt_state));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLastRequest(boolean andOpenNewRequest) throws YAPI_Exception {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._tcp_state == TCP_State.Closed) {
                if (andOpenNewRequest) {
                    this._tcp_state = TCP_State.Opened;
                }
                return;
            }
            while (this._tcp_state == TCP_State.Opened && this._currentRequestTimeout > YAPI.GetTickCount()) {
                try {
                    this._stateLock.wait(this._currentRequestTimeout - YAPI.GetTickCount());
                }
                catch (InterruptedException e) {
                    throw new YAPI_Exception(-7, "HTTP request on " + this._serial + " did not finished correctly", e);
                }
            }
            YUSBPktOut ypkt = new YUSBPktOut(this);
            ypkt.pushTCPClose();
            this._rawDev.sendPkt(ypkt.getRawPkt());
            if (this._tcp_state == TCP_State.Close_by_dev) {
                this._tcp_state = TCP_State.Closed;
            } else {
                this._tcp_state = TCP_State.Close_by_API;
                long timeout = YAPI.GetTickCount() + 100L;
                while (this._tcp_state == TCP_State.Close_by_API && timeout > YAPI.GetTickCount()) {
                    try {
                        this._stateLock.wait(timeout - YAPI.GetTickCount());
                    }
                    catch (InterruptedException e) {
                        throw new YAPI_Exception(-7, "HTTP request on " + this._serial + " did not finished correctly", e);
                    }
                }
                if (this._tcp_state != TCP_State.Closed) {
                    YAPI.SafeYAPI()._Log("USB Close without device ack\n");
                    this._tcp_state = TCP_State.Closed;
                }
            }
            if (andOpenNewRequest) {
                this._tcp_state = TCP_State.Opened;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(String firstLine, byte[] rest_of_request, YGenericHub.RequestAsyncResult asyncResult, Object asyncContext) throws YAPI_Exception {
        YUSBPktOut ypkt;
        byte[] currentRequest;
        this.waitForTcpState(PKT_State.StreamReadyReceived, null, 10L, "Device not ready");
        this.finishLastRequest(true);
        ByteArrayOutputStream byteArrayOutputStream = this._req_result;
        synchronized (byteArrayOutputStream) {
            this._req_result.reset();
        }
        if (rest_of_request == null) {
            currentRequest = (firstLine + "\r\n\r\n").getBytes();
        } else {
            firstLine = firstLine + "\r\n";
            int len = firstLine.length() + rest_of_request.length;
            currentRequest = new byte[len];
            System.arraycopy(firstLine.getBytes(), 0, currentRequest, 0, len);
            System.arraycopy(rest_of_request, 0, currentRequest, firstLine.length(), rest_of_request.length);
        }
        this._asyncResult = asyncResult;
        this._asyncContext = asyncContext;
        this._currentRequestTimeout = YAPI.GetTickCount() + 10000L;
        for (int pos = 0; pos < currentRequest.length; pos += ypkt.pushTCP(currentRequest, pos, currentRequest.length - pos)) {
            ypkt = new YUSBPktOut(this);
            this._rawDev.sendPkt(ypkt.getRawPkt());
        }
    }

    public synchronized void sendRequestAsync(String firstLine, byte[] rest_of_request, YGenericHub.RequestAsyncResult asyncResult, Object asyncContext) throws YAPI_Exception {
        this.sendRequest(firstLine, rest_of_request, asyncResult, asyncContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] sendRequestSync(String firstLine, byte[] rest_of_request) throws YAPI_Exception {
        byte[] result;
        this.sendRequest(firstLine, rest_of_request, null, null);
        this.finishLastRequest(false);
        ByteArrayOutputStream byteArrayOutputStream = this._req_result;
        synchronized (byteArrayOutputStream) {
            result = this._req_result.toByteArray();
        }
        int hpos = YAPI._find_in_bytes(result, "\r\n\r\n".getBytes());
        if (hpos >= 0) {
            return Arrays.copyOfRange(result, hpos + 4, result.length);
        }
        return result;
    }

    public void checkMetaUTC() {
        if (this._lastMetaUTC + 1800000L < YAPI.GetTickCount()) {
            YUSBPktOut ypkt = new YUSBPktOut(this);
            ypkt.pushMetaUTC();
            try {
                this._rawDev.sendPkt(ypkt.getRawPkt());
                this._lastMetaUTC = YAPI.GetTickCount();
            }
            catch (YAPI_Exception e) {
                e.printStackTrace();
                this.ioError("Unable to send meta UTC pkt:" + e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWhitesPages(ArrayList<WPEntry> publicWP) {
        HashMap<String, WPEntry> hashMap = this._usbWP;
        synchronized (hashMap) {
            for (WPEntry wp : this._usbWP.values()) {
                if (!wp.isValid()) continue;
                publicWP.add(wp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateYellowPages(HashMap<String, ArrayList<YPEntry>> publicYP) {
        HashMap<String, YPEntry> hashMap = this._usbYP;
        synchronized (hashMap) {
            for (YPEntry yp : this._usbYP.values()) {
                if (!publicYP.containsKey(yp.getCateg())) {
                    publicYP.put(yp.getCateg(), new ArrayList());
                }
                publicYP.get(yp.getCateg()).add(yp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifcation(YPktStreamHead.NotificationStreams not) throws YAPI_Exception {
        WPEntry wp;
        HashMap<String, WPEntry> hashMap = this._usbWP;
        synchronized (hashMap) {
            if (!this._usbWP.containsKey(not.getSerial())) {
                wp = new WPEntry(this._usbWP.size(), not.getSerial(), "");
                this._usbWP.put(not.getSerial(), wp);
            } else {
                wp = this._usbWP.get(not.getSerial());
            }
        }
        switch (not.getNotType()) {
            case CHILD: {
                this._usbIdx2Serial.add(not.getDevydy(), not.getChildserial());
                break;
            }
            case FIRMWARE: {
                wp.setProductId(not.getDeviceid());
                break;
            }
            case FUNCNAME: {
                YPEntry yp = this.getYPEntry(not.getSerial(), not.getFunctionId());
                yp.setLogicalName(not.getFuncname());
                break;
            }
            case FUNCNAMEYDX: {
                this._usbIdx2Funcid.put(not.getSerial() + not.getFunydx(), not.getFunctionId());
                YPEntry yp = this.getYPEntry(not.getSerial(), not.getFunctionId());
                yp.setLogicalName(not.getFuncname());
                yp.setIndex(not.getFunydx());
                yp.setBaseclass(not.getFunclass());
                break;
            }
            case FUNCVAL: {
                YPEntry yp = this.getYPEntry(not.getSerial(), not.getFunctionId());
                YAPI.SafeYAPI().setFunctionValue(yp.getHardwareId(), not.getFuncval());
                break;
            }
            case FUNCVALFLUSH: {
                break;
            }
            case LOG: {
                break;
            }
            case NAME: {
                wp.setLogicalName(not.getLogicalname());
                wp.setBeacon(not.getBeacon());
                break;
            }
            case PRODNAME: {
                wp.setProductName(not.getProduct());
                break;
            }
            case STREAMREADY: {
                wp.validate();
                if (!this._serial.equals(not.getSerial())) break;
                this.setStreamReady();
            }
        }
    }

    public void handleTimedNotification(byte[] data) {
        int len;
        YDevice ydev = YAPI.SafeYAPI().getDevice(this._serial);
        if (ydev == null) {
            return;
        }
        for (int pos = 0; pos < data.length; pos += len) {
            int funYdx = data[pos] & 0xF;
            boolean isAvg = (data[pos] & 0x80) != 0;
            if (data.length < ++pos + (len = 1 + (data[pos] >> 4 & 7))) {
                YAPI.SafeYAPI()._Log("drop invalid timedNotification");
                return;
            }
            if (funYdx == 15) {
                Integer[] intData = new Integer[len];
                for (int i = 0; i < len; ++i) {
                    intData[i] = data[pos + i] & 0xFF;
                }
                ydev.setDeviceTime(intData);
                continue;
            }
            YPEntry yp = this.getYPEntryFromYdx(this._serial, funYdx);
            ArrayList<Integer> report = new ArrayList<Integer>(len + 1);
            report.add(isAvg ? 1 : 0);
            for (int i = 0; i < len; ++i) {
                int b = data[pos + i] & 0xFF;
                report.add(b);
            }
            YAPI.SafeYAPI().setTimedReport(yp.getHardwareId(), ydev.getDeviceTime(), report);
        }
    }

    public void handleTimedNotificationV2(byte[] data) {
        int len;
        YDevice ydev = YAPI.SafeYAPI().getDevice(this._serial);
        if (ydev == null) {
            return;
        }
        for (int pos = 0; pos < data.length; pos += len) {
            int funYdx = data[pos] & 0xF;
            int extralen = data[pos] >> 4;
            len = extralen + 1;
            ++pos;
            if (funYdx == 15) {
                Integer[] intData = new Integer[len];
                for (int i = 0; i < len; ++i) {
                    intData[i] = data[pos + i] & 0xFF;
                }
                ydev.setDeviceTime(intData);
                continue;
            }
            YPEntry yp = this.getYPEntryFromYdx(this._serial, funYdx);
            ArrayList<Integer> report = new ArrayList<Integer>(len + 1);
            report.add(2);
            for (int i = 0; i < len; ++i) {
                int b = data[pos + i] & 0xFF;
                report.add(b);
            }
            YAPI.SafeYAPI().setTimedReport(yp.getHardwareId(), ydev.getDeviceTime(), report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamHandler(ArrayList<YPktStreamHead> streams) {
        block20: for (YPktStreamHead s : streams) {
            int streamType = s.getStreamType();
            switch (streamType) {
                case 3: 
                case 7: {
                    try {
                        YPktStreamHead.NotificationStreams not = s.decodeAsNotification(this, streamType == 7);
                        this.handleNotifcation(not);
                    }
                    catch (YAPI_Exception ignore) {
                        YAPI.SafeYAPI()._Log("drop invalid notification");
                    }
                    break;
                }
                case 1: {
                    if (!this.testState(PKT_State.StreamReadyReceived, null)) continue block20;
                    ByteArrayOutputStream byteArrayOutputStream = this._req_result;
                    synchronized (byteArrayOutputStream) {
                        try {
                            this._req_result.write(s.getDataAsByteArray());
                        }
                        catch (IOException e) {
                            this.ioError(e.getLocalizedMessage());
                        }
                        break;
                    }
                }
                case 2: {
                    if (!this.testState(PKT_State.StreamReadyReceived, null)) continue block20;
                    ByteArrayOutputStream byteArrayOutputStream = this._req_result;
                    synchronized (byteArrayOutputStream) {
                        try {
                            this._req_result.write(s.getDataAsByteArray());
                        }
                        catch (IOException e) {
                            this.ioError(e.getLocalizedMessage());
                        }
                        if (this._asyncResult != null) {
                            this._asyncResult.RequestAsyncDone(this._asyncContext, this._req_result.toByteArray(), 0, null);
                        }
                    }
                    this.remoteClose();
                    break;
                }
                case 0: {
                    break;
                }
                case 4: {
                    if (!this.testState(PKT_State.StreamReadyReceived, null)) continue block20;
                    this.handleTimedNotification(s.getDataAsByteArray());
                    break;
                }
                case 6: {
                    if (!this.testState(PKT_State.StreamReadyReceived, null)) continue block20;
                    this.handleTimedNotificationV2(s.getDataAsByteArray());
                    break;
                }
                default: {
                    YAPI.SafeYAPI()._Log("drop unknown ystream:" + s.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newPKT(ByteBuffer android_raw_pkt) {
        YUSBPktIn newpkt;
        try {
            newpkt = YUSBPktIn.Decode(this, android_raw_pkt);
        }
        catch (YAPI_Exception e) {
            YAPI.SafeYAPI()._Log("Drop invalid packet:" + e.getLocalizedMessage());
            e.printStackTrace();
            return;
        }
        if (newpkt.isConfPktReset()) {
            this.receiveConfReset(newpkt);
        } else if (newpkt.isConfPktStart()) {
            this.receiveConfStart(newpkt);
        } else {
            boolean use = false;
            Object object = this._stateLock;
            synchronized (object) {
                if (this._pkt_state == PKT_State.StreamReadyReceived || this._pkt_state == PKT_State.StartReceived) {
                    use = true;
                }
            }
            if (use) {
                int expectedPktNo = this._lastpktno + 1 & 7;
                if (newpkt.getPktno() != expectedPktNo) {
                    String message = "Missing packet (look of pkt " + expectedPktNo + " but get " + newpkt.getPktno() + ")";
                    YAPI.SafeYAPI()._Log(message + "\n");
                    this.ioError(message);
                    return;
                }
                this._lastpktno = newpkt.getPktno();
                ArrayList<YPktStreamHead> streams = newpkt.getStreams();
                this.streamHandler(streams);
            } else {
                YAPI.SafeYAPI()._Log("Drop non-config pkt:" + newpkt.toString());
            }
        }
    }

    @Override
    public void ioError(String errorMessage) {
        YAPI.SafeYAPI()._Log("USB IO Error:" + errorMessage);
        this.setNewState(PKT_State.IOError, TCP_State.Closed);
    }

    @Override
    public void rawDeviceUpdateState(YUSBRawDevice yusbRawDevice) {
        this._rawDev = yusbRawDevice;
        this._serial = yusbRawDevice.getSerial();
        if (this._rawDev.isUsable()) {
            this.sendConfReset();
        }
    }

    private static enum TCP_State {
        Closed,
        Opened,
        Close_by_dev,
        Close_by_API;

    }

    private static enum PKT_State {
        Plugged,
        Authorize,
        ResetSend,
        ResetReceived,
        StartSend,
        StartReceived,
        StreamReadyReceived,
        IOError;

    }
}

