/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFirmwareFile;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YUSBProgPkt;
import com.yoctopuce.YoctoAPI.YUSBRawDevice;
import java.nio.ByteBuffer;

public class YUSBBootloader
implements YUSBRawDevice.IOHandler {
    private static final long ERASE_TIMEOUT = 10000L;
    private static final long BLOCK_FLASH_TIMEOUT = 5000L;
    private static final long PROG_GET_INFO_TIMEOUT = 1000L;
    private static final long ZONE_VERIF_TIMEOUT = 2000L;
    private static final int PROGRESS_OFFSET = 5;
    private static final int PROGRESS_RANGE = 95;
    private static final int START_APPLICATION_SIGN = 0;
    private static final int START_BOOTLOADER_SIGN = 21602;
    private static final int START_AUTOFLASHER_SIGN = 18018;
    private String _serial;
    private YUSBRawDevice _rawdev = null;
    private int _ROM_nb_zone;
    private int _FLA_nb_zone;
    private YFirmwareFile _firmware;
    private YGenericHub.UpdateProgress _progress;
    private YFirmwareFile.byn_zone _bz;
    private int _flash_page_ofs;
    private int _file_ofs;
    private int _addr_page;
    private int _last_percent;
    private String _last_msg;
    private static final int FAMILY_PIC24FJ256DA210 = 65;
    private static final int PIC24FJ128DA206 = 8;
    private static final int PIC24FJ128DA106 = 9;
    private static final int PIC24FJ128DA210 = 10;
    private static final int PIC24FJ128DA110 = 11;
    private static final int PIC24FJ256DA206 = 12;
    private static final int PIC24FJ256DA106 = 13;
    private static final int PIC24FJ256DA210 = 14;
    private static final int PIC24FJ256DA110 = 15;
    private static final int FAMILY_PIC24FJ64GB004 = 66;
    private static final int PIC24FJ32GB002 = 3;
    private static final int PIC24FJ64GB002 = 7;
    private static final int PIC24FJ32GB004 = 11;
    private static final int PIC24FJ64GB004 = 15;
    private static final int JEDEC_SPANSION_4MB = 22;
    private static final int JEDEC_SPANSION_8MB = 23;
    private final Object _stateLock = new Object();
    private FLASH_STATE _flash_state = FLASH_STATE.DONE;
    private short _pr_blk_size;
    private int _devid_family;
    private int _devid_model;
    private int _last_addr;
    private int _ext_jedec_id;
    private int _ext_page_size;
    private short _ext_total_pages;
    private int _first_code_page;
    private int _first_yfs3_page;
    FLASH_ZONE_STATE _zst;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewState(FLASH_STATE new_state) {
        Object object = this._stateLock;
        synchronized (object) {
            this._flash_state = new_state;
            this._stateLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorState(String error) {
        this.uLogProgress(-1, error);
        Object object = this._stateLock;
        synchronized (object) {
            this._flash_state = FLASH_STATE.FAILED;
            this._stateLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForState(FLASH_STATE wanted, FLASH_STATE next, long mswait, String message) throws YAPI_Exception {
        long timeout = YAPI.GetTickCount() + mswait;
        Object object = this._stateLock;
        synchronized (object) {
            while (this._flash_state != wanted && timeout > YAPI.GetTickCount()) {
                long millis = timeout - YAPI.GetTickCount();
                try {
                    this._stateLock.wait(millis);
                }
                catch (InterruptedException e) {
                    throw new YAPI_Exception(-7, "Device " + this._serial + " " + message, e);
                }
            }
            if (this._flash_state != wanted) {
                throw new YAPI_Exception(-7, "Device " + this._serial + " " + message + " (" + (Object)((Object)this._flash_state) + ")");
            }
            if (next != null) {
                this._flash_state = next;
                this._stateLock.notify();
            }
        }
    }

    @Override
    public void newPKT(ByteBuffer android_raw_pkt) {
        YUSBProgPkt pkt = new YUSBProgPkt(android_raw_pkt);
        int pkt_type = pkt.getType();
        switch (this._flash_state) {
            case GET_INFO: {
                if (pkt_type == 5) {
                    this._pr_blk_size = pkt.getPr_blk_size();
                    this._last_addr = pkt.getLast_addr();
                    this._devid_family = pkt.getDevid_family();
                    this._devid_model = pkt.getDevid_model();
                    this._ext_jedec_id = 65535;
                    this._ext_page_size = 65535;
                    this._ext_total_pages = 0;
                    this._first_code_page = 65535;
                    this._first_yfs3_page = 65535;
                    this.setNewState(FLASH_STATE.INFO_RECEIVED);
                    break;
                }
                if (pkt_type == 6) {
                    this._pr_blk_size = pkt.getPr_blk_size();
                    this._last_addr = pkt.getLast_addr();
                    this._devid_family = pkt.getDevid_family();
                    this._devid_model = pkt.getDevid_model();
                    this._ext_jedec_id = pkt.getExt_jedec_id();
                    this._ext_page_size = pkt.getExt_page_size();
                    this._ext_total_pages = pkt.getExt_total_pages();
                    this._first_code_page = pkt.getFirst_code_page();
                    this._first_yfs3_page = pkt.getFirst_yfs3_page();
                    this.setNewState(FLASH_STATE.INFO_RECEIVED);
                    break;
                }
                this.setErrorState("Not a PROG_INFO pkt");
                break;
            }
            case INFO_RECEIVED: {
                break;
            }
            case ERASE: {
                if (pkt_type == 5 || pkt_type == 6) {
                    this.setNewState(FLASH_STATE.ERASE_CONFIRMED);
                    break;
                }
                this.setErrorState("Not a PROG_INFO pkt");
                break;
            }
            case FLASH: {
                if (pkt_type == 3) {
                    this.setNewState(FLASH_STATE.FLASH_CONFIRMED);
                    break;
                }
                if (pkt_type == 4) {
                    int pageno = pkt.getPageNo();
                    int size = pkt.getSize() * 2;
                    int pos = pkt.getPos() * 4;
                    int addr = pageno * this._ext_page_size + pos;
                    if (addr < this._addr_page) {
                        this.setErrorState(String.format("Error page=0x%x pos=0x%x (up to %x bytes)", pageno, pos, size));
                    }
                    if (addr < this._addr_page + this._flash_page_ofs) {
                        int datasize = size;
                        if (addr + datasize >= this._addr_page + this._flash_page_ofs) {
                            datasize = this._addr_page + this._flash_page_ofs - addr;
                        }
                        byte[] firmware_data = this._firmware.getData();
                        int firmware_ofs = this._file_ofs + (addr - this._addr_page);
                        byte[] pkt_data = pkt.getProgdata();
                        int pkt_ofs = pkt.getProgdata_ofs();
                        for (int i = 0; i < datasize; ++i) {
                            short b = pkt_data[pkt_ofs + i];
                            short b1 = firmware_data[firmware_ofs + i];
                            if (b == b1) continue;
                            this.setErrorState(String.format("Flash verification failed at %x (%x:%x)", addr, pageno, pos));
                        }
                    }
                    if ((addr & this._ext_page_size - 1) + size < this._ext_page_size) break;
                    this.setNewState(FLASH_STATE.FLASH_CONFIRMED);
                    break;
                }
                this.setErrorState("Not a PROG_INFO pkt");
                break;
            }
            case FLASH_CONFIRMED: {
                break;
            }
            case GET_INFO_BFOR_REBOOT: {
                if (pkt_type != 5 && pkt_type != 6) break;
                this.setNewState(FLASH_STATE.REBOOT);
                break;
            }
            case REBOOT: {
                break;
            }
        }
    }

    private void uLogProgress(int percent, String msg) {
        if ((this._last_percent != percent || msg != null && !msg.equals(this._last_msg)) && this._progress != null) {
            this._progress.firmware_progress(percent * 95 / 100 + 5, msg);
        }
        this._last_percent = percent;
        if (msg != null) {
            this._last_msg = msg;
        }
    }

    @Override
    public void ioError(String msg) {
        this.setErrorState(msg);
    }

    @Override
    public void rawDeviceUpdateState(YUSBRawDevice yusbRawDevice) {
        this._rawdev = yusbRawDevice;
        this._serial = yusbRawDevice.getSerial();
    }

    public String getSerial() {
        return this._serial;
    }

    String getCPUName(int devid_family, int devid_model) {
        String res;
        switch (devid_family) {
            case 65: {
                switch (devid_model) {
                    case 8: {
                        return "PIC24FJ128DA206";
                    }
                    case 9: {
                        return "PIC24FJ128DA106";
                    }
                    case 10: {
                        return "PIC24FJ128DA210";
                    }
                    case 11: {
                        return "PIC24FJ128DA110";
                    }
                    case 12: {
                        return "PIC24FJ256DA206";
                    }
                    case 13: {
                        return "PIC24FJ256DA106";
                    }
                    case 14: {
                        return "PIC24FJ256DA210";
                    }
                    case 15: {
                        return "PIC24FJ256DA110";
                    }
                }
                res = "Unknown CPU model(family PIC24FJ256DA210)";
                break;
            }
            case 66: {
                switch (devid_model) {
                    case 3: {
                        return "PIC24FJ32GB002";
                    }
                    case 7: {
                        return "PIC24FJ64GB002";
                    }
                    case 11: {
                        return "PIC24FJ32GB004";
                    }
                    case 15: {
                        return "PIC24FJ64GB004";
                    }
                }
                res = "Unknown CPU model(family PIC24FJ64GB004)";
                break;
            }
            default: {
                res = "Unknown CPU model";
            }
        }
        return res;
    }

    public void firmwareUpdate(YFirmwareFile firmware, YGenericHub.UpdateProgress progress) throws YAPI_Exception {
        YUSBProgPkt pkt;
        this._firmware = firmware;
        this._progress = progress;
        this.setNewState(FLASH_STATE.GET_INFO);
        this.uSendCmd(5);
        this.uLogProgress(1, "Get Info From bootloader");
        this.waitForState(FLASH_STATE.INFO_RECEIVED, null, 1000L, "Bootloader did not respond to GetInfo pkt");
        String baseSerial = this._serial.substring(0, 8);
        if (!firmware.getSerial().startsWith(baseSerial)) {
            throw new YAPI_Exception(-2, "This BYN file is not designed for your device");
        }
        String cpu = this.getCPUName(this._devid_family, this._devid_model);
        if (!cpu.equals(firmware.getPictype())) {
            throw new YAPI_Exception(-2, "This BYN file is not designed for your device");
        }
        this.uLogProgress(2, "Firmware file validated");
        this._ROM_nb_zone = firmware.getROM_nb_zone();
        this._FLA_nb_zone = firmware.getFLA_nb_zone();
        if (this._ext_total_pages > 0) {
            int npages;
            int maxpages = this._ext_jedec_id == 22 || this._ext_jedec_id == 23 ? 16 : 128;
            for (int flashPage = this._first_code_page; flashPage < this._ext_total_pages; flashPage += npages) {
                this.setNewState(FLASH_STATE.ERASE);
                npages = this._ext_total_pages - flashPage;
                this.uLogProgress(3 + 7 * flashPage / this._ext_total_pages, "Erasing flash");
                if (npages > maxpages) {
                    npages = maxpages;
                }
                this.uSendErase(flashPage, npages);
                this.uSendCmd(5);
                this.waitForState(FLASH_STATE.ERASE_CONFIRMED, null, 10000L, "Timeout blanking flash");
            }
        } else {
            this.uLogProgress(3, "erase flash memory");
            this.setNewState(FLASH_STATE.ERASE);
            this.uSendCmd(2);
            this.uSendCmd(5);
        }
        this.waitForState(FLASH_STATE.ERASE_CONFIRMED, FLASH_STATE.FLASH, 10000L + (long)(this._last_addr >> 6), "Timeout blanking flash");
        this._zst = FLASH_ZONE_STATE.FLASH_ZONE_START;
        if (this._ext_total_pages > 0) {
            this.uFlashFlash();
        } else {
            this.uFlashZone();
        }
        this.setNewState(FLASH_STATE.GET_INFO_BFOR_REBOOT);
        this.uSendCmd(5);
        this.waitForState(FLASH_STATE.REBOOT, null, 1000L, "Last communication before reboot failed");
        if (this._ext_total_pages > 0) {
            pkt = new YUSBProgPkt(1, true);
            pkt.setBtSign(18018);
        } else {
            pkt = new YUSBProgPkt(1, false);
        }
        this._rawdev.sendPkt(pkt.getRawPkt());
    }

    private void uFlashZone() throws YAPI_Exception {
        int file_ofs = this._firmware.getFirstZoneOfs();
        for (int cur_zone = 0; cur_zone < this._ROM_nb_zone + this._FLA_nb_zone; ++cur_zone) {
            this._bz = this._firmware.getBynZone(file_ofs);
            if (this._bz.addr_page % (this._pr_blk_size * 2) != 0) {
                throw new YAPI_Exception(-8, "ProgAlign");
            }
            file_ofs += 8;
            int nbInstrInZone = this._bz.len / 3;
            if (nbInstrInZone < this._pr_blk_size) {
                throw new YAPI_Exception(-8, "ProgSmall");
            }
            int block_addr = this._bz.addr_page;
            int inst_in_block = 0;
            while (nbInstrInZone > 0) {
                this.uLogProgress(10 + 80 * file_ofs / this._firmware.getData().length, String.format("Write flash memory zone %d (0x%x)", cur_zone, this._bz.addr_page));
                while (inst_in_block < this._pr_blk_size) {
                    int nb_instructions = nbInstrInZone < 20 ? nbInstrInZone : 20;
                    YUSBProgPkt pkt = new YUSBProgPkt(3, block_addr, nb_instructions, this._firmware.getData(), file_ofs);
                    this._rawdev.sendPkt(pkt.getRawPkt());
                    inst_in_block += nb_instructions;
                    nbInstrInZone -= nb_instructions;
                    file_ofs += nb_instructions * 3;
                }
                this.waitForState(FLASH_STATE.FLASH_CONFIRMED, FLASH_STATE.FLASH, 5000L, String.format("Bootlaoder did not send confirmation for Zone %x Block %x", cur_zone, this._bz.addr_page));
                inst_in_block -= this._pr_blk_size;
                block_addr += this._pr_blk_size * 2;
            }
        }
    }

    private void uFlashFlash() throws YAPI_Exception {
        this._file_ofs = this._firmware.getFirstZoneOfs();
        block0: for (int curzone = 0; curzone < this._ROM_nb_zone + this._FLA_nb_zone; ++curzone) {
            this._bz = this._firmware.getBynZone(this._file_ofs);
            this._file_ofs += 8;
            int page_len = this._bz.len;
            this._addr_page = curzone < this._ROM_nb_zone ? this._first_code_page * this._ext_page_size + 3 * this._bz.addr_page / 2 : this._first_yfs3_page * this._ext_page_size + this._bz.addr_page;
            if ((this._addr_page & 1) != 0 || (page_len & 1) != 0) {
                throw new YAPI_Exception(-8, String.format("Prog block not on a word boundary (0x%x + 0x%x)", this._addr_page, page_len));
            }
            int zone_ofs = 0;
            while (zone_ofs < this._bz.len) {
                int pos;
                int page;
                int datasize;
                int addr;
                if (curzone < this._ROM_nb_zone && this._addr_page >= this._first_yfs3_page * this._ext_page_size) {
                    this._file_ofs += this._bz.len - zone_ofs;
                    continue block0;
                }
                this._flash_page_ofs = 0;
                do {
                    if ((datasize = this._ext_page_size - ((addr = this._addr_page + this._flash_page_ofs) & this._ext_page_size - 1)) > 60) {
                        datasize = 60;
                    }
                    if (zone_ofs + datasize > this._bz.len) {
                        datasize = this._bz.len - zone_ofs;
                    }
                    if ((datasize & 1) != 0) {
                        throw new YAPI_Exception(-8, String.format("Prog block not on a word boundary (%d+%d)", this._addr_page, page_len));
                    }
                    page = addr / this._ext_page_size;
                    pos = addr % this._ext_page_size / 4;
                    String msg = curzone < this._ROM_nb_zone ? String.format("Write memory zone %d (0x%x)", curzone, page) : String.format("Write memory zone %d (0x%x ext)", curzone, page);
                    this.uLogProgress(10 + 80 * (this._file_ofs + this._flash_page_ofs) / this._firmware.getData().length, msg);
                    YUSBProgPkt pkt = new YUSBProgPkt(3, page, pos, datasize / 2, this._firmware.getData(), this._file_ofs + this._flash_page_ofs);
                    this._rawdev.sendPkt(pkt.getRawPkt());
                    this._flash_page_ofs += datasize;
                } while ((addr & this._ext_page_size - 1) + datasize < this._ext_page_size && (zone_ofs += datasize) < this._bz.len);
                addr = this._addr_page;
                page = addr / this._ext_page_size;
                pos = addr % this._ext_page_size / 4;
                YUSBProgPkt pkt = new YUSBProgPkt(4, page, pos);
                this._rawdev.sendPkt(pkt.getRawPkt());
                this.waitForState(FLASH_STATE.FLASH_CONFIRMED, FLASH_STATE.FLASH, 2000L, String.format("Bootlaoder did not send confirmation for Zone %x Block %x", curzone, this._bz.addr_page));
                this._file_ofs += this._flash_page_ofs;
                this._addr_page += this._flash_page_ofs;
            }
        }
    }

    private void uSendCmd(int type) throws YAPI_Exception {
        YUSBProgPkt pkt = new YUSBProgPkt(type, false);
        this._rawdev.sendPkt(pkt.getRawPkt());
    }

    private void uSendErase(int firstPage, int nPages) throws YAPI_Exception {
        YUSBProgPkt pkt = new YUSBProgPkt(2, firstPage, 0, nPages);
        this._rawdev.sendPkt(pkt.getRawPkt());
    }

    public boolean isReady() {
        return this._rawdev != null && this._rawdev.isUsable();
    }

    static enum FLASH_ZONE_STATE {
        FLASH_ZONE_START,
        FLASH_ZONE_PROG,
        FLASH_ZONE_RECV_OK;

    }

    private static enum FLASH_STATE {
        GET_INFO,
        INFO_RECEIVED,
        ERASE,
        ERASE_CONFIRMED,
        FLASH,
        FLASH_CONFIRMED,
        GET_INFO_BFOR_REBOOT,
        REBOOT,
        FAILED,
        DONE;

    }
}

