/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import android.util.Log;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YPEntry;
import com.yoctopuce.YoctoAPI.YUSBDevice;
import java.nio.ByteBuffer;
import java.util.Arrays;

class YPktStreamHead {
    protected static final int USB_PKT_STREAM_HEAD = 2;
    protected static final int YPKT_STREAM = 0;
    protected static final int YPKT_CONF = 1;
    protected static final int USB_CONF_RESET = 0;
    protected static final int USB_CONF_START = 1;
    protected static final int YSTREAM_EMPTY = 0;
    protected static final int YSTREAM_TCP = 1;
    protected static final int YSTREAM_TCP_CLOSE = 2;
    protected static final int YSTREAM_NOTICE = 3;
    protected static final int YSTREAM_REPORT = 4;
    protected static final int YSTREAM_META = 5;
    protected static final int YSTREAM_REPORT_V2 = 6;
    protected static final int YSTREAM_NOTICE_V2 = 7;
    private int _pktNumber;
    private int _streamType;
    private int _pktType;
    private byte[] _data;

    int getPktNumber() {
        return this._pktNumber;
    }

    int getStreamType() {
        return this._streamType;
    }

    int getPktType() {
        return this._pktType;
    }

    int getContentSize() {
        return this._data.length;
    }

    int getFullSize() {
        return this._data.length + 2;
    }

    byte getDataByte(int ofs) {
        return this._data[ofs];
    }

    byte[] getDataAsByteArray() {
        return this._data;
    }

    public YPktStreamHead(int pktNumber, int pktType, int streamType, byte[] data, int offset, int len) {
        this._pktNumber = pktNumber;
        this._streamType = streamType;
        this._pktType = pktType;
        this._data = data == null ? new byte[0] : Arrays.copyOfRange(data, offset, offset + len);
    }

    public YPktStreamHead(int pktNumber, int pktType, int streamType, ByteBuffer pkt, int dataLen) {
        this._pktNumber = pktNumber;
        this._streamType = streamType;
        this._pktType = pktType;
        this._data = new byte[dataLen];
        pkt.get(this._data);
    }

    public String toString() {
        String stream;
        String type;
        block0 : switch (this._pktType) {
            case 1: {
                type = "CONF";
                switch (this._streamType) {
                    case 0: {
                        stream = "RESET";
                        break block0;
                    }
                    case 1: {
                        stream = "START";
                        break block0;
                    }
                }
                stream = "INVALID!";
                break;
            }
            case 0: {
                type = "STREAM";
                switch (this._streamType) {
                    case 0: {
                        stream = "EMPTY";
                        break block0;
                    }
                    case 3: {
                        stream = "NOTICE ";
                        break block0;
                    }
                    case 1: {
                        stream = "TCP";
                        break block0;
                    }
                    case 2: {
                        stream = "TCP_CLOSE";
                        break block0;
                    }
                    case 4: {
                        stream = "REPORT";
                        break block0;
                    }
                    case 5: {
                        stream = "META";
                        break block0;
                    }
                    case 6: {
                        stream = "REPORT_V2";
                        break block0;
                    }
                    case 7: {
                        stream = "NOTICE_v2 ";
                        break block0;
                    }
                }
                stream = "INVALID!";
                break;
            }
            default: {
                type = "INVALID!";
                stream = "INVALID!";
            }
        }
        return String.format("Stream: type=%d(%s) stream/cmd=%d(%s) size=%d (pktno=%d)\n", this._pktType, type, this._streamType, stream, this._data.length, this._pktNumber);
    }

    public static YPktStreamHead Decode(ByteBuffer pkt) throws YAPI_Exception {
        if (pkt.remaining() < 2) {
            return null;
        }
        int b = pkt.get() & 0xFF;
        int pktNumber = b & 7;
        int streamType = b >> 3;
        b = pkt.get() & 0xFF;
        int pktType = b & 3;
        int dataLen = b >> 2;
        if (dataLen > pkt.remaining()) {
            throw new YAPI_Exception(-8, String.format("invalid ystream header (invalid length %d>%d)", dataLen, pkt.remaining()));
        }
        return new YPktStreamHead(pktNumber, pktType, streamType, pkt, dataLen);
    }

    public int getRawStream(byte[] res, int pos) {
        res[pos++] = (byte)(this._pktNumber & 7 | (this._streamType & 0x1F) << 3);
        res[pos++] = (byte)(this._pktType | (this._data.length & 0x3F) << 2);
        if (this._data.length > 0) {
            System.arraycopy(this._data, 0, res, pos, this._data.length);
        }
        return this._data.length + 2;
    }

    public static void PadWithEmpty(byte[] res, int pos, int usbPktSize) {
        int remaining = usbPktSize - pos - 2;
        if (remaining >= 0) {
            res[pos++] = 0;
            res[pos++] = (byte)(0 | (remaining & 0x3F) << 2);
        }
    }

    public boolean isConfPktReset() {
        return this._pktType == 1 && this._streamType == 0;
    }

    public boolean isConfPktStart() {
        return this._pktType == 1 && this._streamType == 1;
    }

    NotificationStreams decodeAsNotification(YUSBDevice dev, boolean isV2) throws YAPI_Exception {
        try {
            return new NotificationStreams(dev, this._data, isV2);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new YAPI_Exception(-8, "Invlalid USB packet");
        }
    }

    static class NotificationStreams {
        private static final int NOTIFY_1STBYTE_MAXTINY = 63;
        private static final int NOTIFY_1STBYTE_MINSMALL = 128;
        private static final int NOTIFY_V2_FUNYDX_MASK = 15;
        private static final int NOTIFY_V2_TYPE_MASK = 3;
        private static final int NOTIFY_V2_TYPE_OFS = 4;
        private static final int NOTIFY_V2_IS_SMALL_FLAG = 128;
        protected static final int NOTIFY_PKT_NAME = 0;
        protected static final int NOTIFY_PKT_PRODNAME = 1;
        protected static final int NOTIFY_PKT_CHILD = 2;
        protected static final int NOTIFY_PKT_FIRMWARE = 3;
        protected static final int NOTIFY_PKT_FUNCNAME = 4;
        protected static final int NOTIFY_PKT_FUNCVAL = 5;
        protected static final int NOTIFY_PKT_STREAMREADY = 6;
        protected static final int NOTIFY_PKT_LOG = 7;
        protected static final int NOTIFY_PKT_FUNCNAMEYDX = 8;
        private final NotType _notType;
        private final String _serial;
        private String _functionId;
        private String _funcval;
        private int _funcvalType;
        private String _logicalname;
        private byte _beacon;
        private String _product;
        private String _childserial;
        private String _firmware;
        private byte _onOff;
        private byte _devydy;
        private int _vendorid;
        private int _deviceid;
        private String _funcname;
        private byte _funydx;
        private byte _funclass;

        static String arrayToString(byte[] data, int ofs, int maxlen) {
            int len;
            if (data == null) {
                return "";
            }
            int pos = ofs;
            for (len = 0; len < maxlen && ofs + len < data.length && data[pos + len] != 0; ++len) {
            }
            return new String(data, pos, len);
        }

        public YPEntry.BaseClass getFunclass() {
            if (this._funclass >= YPEntry.BaseClass.values().length) {
                return YPEntry.BaseClass.Function;
            }
            return YPEntry.BaseClass.forByte(this._funclass);
        }

        public NotificationStreams(YUSBDevice dev, byte[] data, boolean isV2) throws YAPI_Exception {
            byte firstByte = data[0];
            if (isV2 || firstByte <= 63 || firstByte >= 128) {
                this._funcvalType = firstByte >> 4 & 3;
                this._serial = dev.getSerial();
                this._functionId = dev.getFuncidFromYdx(this._serial, firstByte & 0xF);
                if (this._funcvalType == 3) {
                    this._notType = NotType.FUNCVALFLUSH;
                } else {
                    this._notType = NotType.FUNCVAL;
                    if ((firstByte & 0x80) != 0) {
                        throw new YAPI_Exception(-8, "Hub Should not fwd notification");
                    }
                    this._funcval = YGenericHub.decodePubVal(this._funcvalType, data, 1, data.length - 1);
                    Log.d((String)"bug", (String)String.format(" new val %s for %s.%s", this._funcval, this._serial, this._functionId));
                    if (this._functionId == null) {
                        throw new YAPI_Exception(-8, "too early notification");
                    }
                }
            } else {
                this._serial = NotificationStreams.arrayToString(data, 0, 20);
                int p = 20;
                byte type = data[p++];
                switch (type) {
                    case 0: {
                        this._notType = NotType.NAME;
                        this._logicalname = NotificationStreams.arrayToString(data, p, 20);
                        this._beacon = data[p + 20];
                        break;
                    }
                    case 1: {
                        this._notType = NotType.PRODNAME;
                        this._product = NotificationStreams.arrayToString(data, p, 28);
                        break;
                    }
                    case 2: {
                        this._notType = NotType.CHILD;
                        this._childserial = NotificationStreams.arrayToString(data, p, 20);
                        p += 20;
                        this._onOff = data[p++];
                        this._devydy = data[p];
                        break;
                    }
                    case 3: {
                        this._notType = NotType.FIRMWARE;
                        this._firmware = NotificationStreams.arrayToString(data, p, 22);
                        this._vendorid = data[p += 22] + (data[p + 1] << 8);
                        this._deviceid = data[p += 2] + (data[p + 1] << 8);
                        break;
                    }
                    case 4: {
                        this._notType = NotType.FUNCNAME;
                        this._functionId = NotificationStreams.arrayToString(data, p, 20);
                        this._funcname = NotificationStreams.arrayToString(data, p += 20, 20);
                        break;
                    }
                    case 5: {
                        this._notType = NotType.FUNCVAL;
                        this._functionId = NotificationStreams.arrayToString(data, p, 20);
                        this._funcval = NotificationStreams.arrayToString(data, p += 20, 6);
                        break;
                    }
                    case 6: {
                        this._notType = NotType.STREAMREADY;
                        break;
                    }
                    case 7: {
                        this._notType = NotType.LOG;
                        break;
                    }
                    case 8: {
                        this._notType = NotType.FUNCNAMEYDX;
                        this._functionId = NotificationStreams.arrayToString(data, p, 19);
                        p += 19;
                        this._funclass = data[p++];
                        this._funcname = NotificationStreams.arrayToString(data, p, 20);
                        this._funydx = data[p += 20];
                        break;
                    }
                    default: {
                        throw new YAPI_Exception(-8, "Invalid Notification");
                    }
                }
            }
        }

        public NotType getNotType() {
            return this._notType;
        }

        public String getSerial() {
            return this._serial;
        }

        public String getFuncval() {
            return this._funcval;
        }

        public String getLogicalname() {
            return this._logicalname;
        }

        public byte getBeacon() {
            return this._beacon;
        }

        public String getProduct() {
            return this._product;
        }

        public String getChildserial() {
            return this._childserial;
        }

        public byte getDevydy() {
            return this._devydy;
        }

        public int getDeviceid() {
            return this._deviceid;
        }

        public String getFuncname() {
            return this._funcname;
        }

        public byte getFunydx() {
            return this._funydx;
        }

        public String getFunctionId() {
            return this._functionId;
        }

        public String getHardwareId() {
            return this._serial + "." + this._functionId;
        }

        public static enum NotType {
            NAME,
            PRODNAME,
            CHILD,
            FIRMWARE,
            FUNCNAME,
            FUNCVAL,
            FUNCVALFLUSH,
            STREAMREADY,
            LOG,
            FUNCNAMEYDX;

        }
    }
}

