/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import org.json.JSONException;
import org.json.JSONObject;

class YPEntry {
    private String _classname;
    private String _serial = "";
    private String _funcId = "";
    private String _logicalName = "";
    private String _advertisedValue = "";
    private int _index = -1;
    private BaseClass _baseclass = BaseClass.Function;
    private String _categ = "";

    public YPEntry(JSONObject json) throws JSONException {
        String hardwareId = json.getString("hardwareId");
        int pos = hardwareId.indexOf(46);
        this._serial = hardwareId.substring(0, pos);
        this._funcId = hardwareId.substring(pos + 1);
        this._classname = YAPI.SafeYAPI().functionClass(this._funcId);
        this._categ = YAPI.SafeYAPI().functionClass(this._funcId);
        this._logicalName = json.getString("logicalName");
        this._advertisedValue = json.getString("advertisedValue");
        try {
            this._index = json.getInt("index");
        }
        catch (JSONException ex) {
            this._index = 0;
        }
        if (json.has("baseType")) {
            this._baseclass = BaseClass.values()[json.getInt("baseType")];
        }
    }

    public YPEntry(String serial, String functionID) {
        this._serial = serial;
        this._funcId = functionID;
        this._classname = YAPI.SafeYAPI().functionClass(this._funcId);
        this._categ = YAPI.SafeYAPI().functionClass(this._funcId);
    }

    public String toString() {
        return "YPEntry [_categ=" + this._categ + ", _index=" + this._index + ", _serial=" + this._serial + ", _funcId=" + this._funcId + ", _logicalName=" + this._logicalName + ", _advertisedValue=" + this._advertisedValue + "]";
    }

    public String getCateg() {
        return this._categ;
    }

    public String getAdvertisedValue() {
        return this._advertisedValue;
    }

    public void setAdvertisedValue(String _advertisedValue) {
        this._advertisedValue = _advertisedValue;
    }

    public String getHardwareId() {
        return this._serial + "." + this._funcId;
    }

    public String getSerial() {
        return this._serial;
    }

    public String getFuncId() {
        return this._funcId;
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public BaseClass getBaseclass() {
        return this._baseclass;
    }

    public void setBaseclass(BaseClass bclass) {
        this._baseclass = bclass;
    }

    public String getLogicalName() {
        return this._logicalName;
    }

    public void setLogicalName(String _logicalName) {
        this._logicalName = _logicalName;
    }

    public String getClassname() {
        return this._classname;
    }

    public String getFriendlyName() throws YAPI_Exception {
        if (this._classname.equals("Module")) {
            if (this._logicalName.equals("")) {
                return this._serial + ".module";
            }
            return this._logicalName + ".module";
        }
        YPEntry moduleYP = YAPI.SafeYAPI().resolveFunction("Module", this._serial);
        String module = moduleYP.getFriendlyName();
        int pos = module.indexOf(".");
        module = module.substring(0, pos);
        if (this._logicalName.equals("")) {
            return module + "." + this._funcId;
        }
        return module + "." + this._logicalName;
    }

    static enum BaseClass {
        Function(0),
        Sensor(1);

        private int _intval = 0;

        private BaseClass(int intval) {
            this._intval = intval;
        }

        public static BaseClass forByte(byte bval) {
            return BaseClass.values()[bval];
        }
    }
}

