/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareUpdate;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class YModule
extends YFunction {
    public static final String PRODUCTNAME_INVALID = "!INVALID!";
    public static final String SERIALNUMBER_INVALID = "!INVALID!";
    public static final int PRODUCTID_INVALID = -1;
    public static final int PRODUCTRELEASE_INVALID = -1;
    public static final String FIRMWARERELEASE_INVALID = "!INVALID!";
    public static final int PERSISTENTSETTINGS_LOADED = 0;
    public static final int PERSISTENTSETTINGS_SAVED = 1;
    public static final int PERSISTENTSETTINGS_MODIFIED = 2;
    public static final int PERSISTENTSETTINGS_INVALID = -1;
    public static final int LUMINOSITY_INVALID = -1;
    public static final int BEACON_OFF = 0;
    public static final int BEACON_ON = 1;
    public static final int BEACON_INVALID = -1;
    public static final long UPTIME_INVALID = -9223372036854775807L;
    public static final int USBCURRENT_INVALID = -1;
    public static final int REBOOTCOUNTDOWN_INVALID = Integer.MIN_VALUE;
    public static final int USERVAR_INVALID = Integer.MIN_VALUE;
    protected String _productName = "!INVALID!";
    protected String _serialNumber = "!INVALID!";
    protected int _productId = -1;
    protected int _productRelease = -1;
    protected String _firmwareRelease = "!INVALID!";
    protected int _persistentSettings = -1;
    protected int _luminosity = -1;
    protected int _beacon = -1;
    protected long _upTime = -9223372036854775807L;
    protected int _usbCurrent = -1;
    protected int _rebootCountdown = Integer.MIN_VALUE;
    protected int _userVar = Integer.MIN_VALUE;
    protected UpdateCallback _valueCallbackModule = null;
    protected LogCallback _logCallback = null;

    protected YDevice _getDev() throws YAPI_Exception {
        YDevice dev;
        String devid = this._func;
        int dotidx = devid.indexOf(46);
        if (dotidx >= 0) {
            devid = devid.substring(0, dotidx);
        }
        if ((dev = YAPI.SafeYAPI().getDevice(devid)) == null) {
            throw new YAPI_Exception(-4, "Device [" + devid + "] is not online");
        }
        return dev;
    }

    protected YModule(String func) {
        super(func);
        this._className = "Module";
    }

    public int functionCount() throws YAPI_Exception {
        YDevice dev = this._getDev();
        return dev.functionCount();
    }

    public String functionId(int functionIndex) throws YAPI_Exception {
        YDevice dev = this._getDev();
        return dev.getYPEntry(functionIndex).getFuncId();
    }

    public String functionName(int functionIndex) throws YAPI_Exception {
        YDevice dev = this._getDev();
        return dev.getYPEntry(functionIndex).getLogicalName();
    }

    public String functionValue(int functionIndex) throws YAPI_Exception {
        YDevice dev = this._getDev();
        return dev.getYPEntry(functionIndex).getAdvertisedValue();
    }

    public void registerLogCallback(LogCallback callback) {
        this._logCallback = callback;
        YDevice ydev = YAPI.SafeYAPI().getDevice(this._serial);
        if (ydev != null) {
            ydev.registerLogCallback(callback);
        }
    }

    LogCallback get_logCallback() {
        return this._logCallback;
    }

    private byte[] _flattenJsonStruct(byte[] actualSettings) throws YAPI_Exception {
        JSONObject json = null;
        JSONArray out = new JSONArray();
        try {
            json = new JSONObject(new String(actualSettings, YAPI.DeviceCharset));
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        Iterator functionList = json.keys();
        while (functionList.hasNext()) {
            JSONObject functionJson;
            String fun_key = (String)functionList.next();
            if (fun_key.equals("services") || (functionJson = json.optJSONObject(fun_key)) == null) continue;
            Iterator attr_keys = functionJson.keys();
            while (attr_keys.hasNext()) {
                Object value;
                String attr_key = (String)attr_keys.next();
                if (functionJson.optJSONObject(attr_key) != null || (value = functionJson.opt(attr_key)) == null) continue;
                String flat_attr = fun_key + "/" + attr_key + "=" + value.toString();
                out.put((Object)flat_attr);
            }
        }
        return out.toString().getBytes();
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("productName")) {
            this._productName = json_val.getString("productName");
        }
        if (json_val.has("serialNumber")) {
            this._serialNumber = json_val.getString("serialNumber");
        }
        if (json_val.has("productId")) {
            this._productId = json_val.getInt("productId");
        }
        if (json_val.has("productRelease")) {
            this._productRelease = json_val.getInt("productRelease");
        }
        if (json_val.has("firmwareRelease")) {
            this._firmwareRelease = json_val.getString("firmwareRelease");
        }
        if (json_val.has("persistentSettings")) {
            this._persistentSettings = json_val.getInt("persistentSettings");
        }
        if (json_val.has("luminosity")) {
            this._luminosity = json_val.getInt("luminosity");
        }
        if (json_val.has("beacon")) {
            int n = this._beacon = json_val.getInt("beacon") > 0 ? 1 : 0;
        }
        if (json_val.has("upTime")) {
            this._upTime = json_val.getLong("upTime");
        }
        if (json_val.has("usbCurrent")) {
            this._usbCurrent = json_val.getInt("usbCurrent");
        }
        if (json_val.has("rebootCountdown")) {
            this._rebootCountdown = json_val.getInt("rebootCountdown");
        }
        if (json_val.has("userVar")) {
            this._userVar = json_val.getInt("userVar");
        }
        super._parseAttr(json_val);
    }

    public String get_productName() throws YAPI_Exception {
        if (this._cacheExpiration == 0L && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._productName;
    }

    public String getProductName() throws YAPI_Exception {
        return this.get_productName();
    }

    public String get_serialNumber() throws YAPI_Exception {
        if (this._cacheExpiration == 0L && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._serialNumber;
    }

    public String getSerialNumber() throws YAPI_Exception {
        return this.get_serialNumber();
    }

    public int get_productId() throws YAPI_Exception {
        if (this._cacheExpiration == 0L && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._productId;
    }

    public int getProductId() throws YAPI_Exception {
        return this.get_productId();
    }

    public int get_productRelease() throws YAPI_Exception {
        if (this._cacheExpiration == 0L && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._productRelease;
    }

    public int getProductRelease() throws YAPI_Exception {
        return this.get_productRelease();
    }

    public String get_firmwareRelease() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._firmwareRelease;
    }

    public String getFirmwareRelease() throws YAPI_Exception {
        return this.get_firmwareRelease();
    }

    public int get_persistentSettings() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._persistentSettings;
    }

    public int getPersistentSettings() throws YAPI_Exception {
        return this.get_persistentSettings();
    }

    public int set_persistentSettings(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("persistentSettings", rest_val);
        return 0;
    }

    public int setPersistentSettings(int newval) throws YAPI_Exception {
        return this.set_persistentSettings(newval);
    }

    public int get_luminosity() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._luminosity;
    }

    public int getLuminosity() throws YAPI_Exception {
        return this.get_luminosity();
    }

    public int set_luminosity(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("luminosity", rest_val);
        return 0;
    }

    public int setLuminosity(int newval) throws YAPI_Exception {
        return this.set_luminosity(newval);
    }

    public int get_beacon() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._beacon;
    }

    public int getBeacon() throws YAPI_Exception {
        return this.get_beacon();
    }

    public int set_beacon(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("beacon", rest_val);
        return 0;
    }

    public int setBeacon(int newval) throws YAPI_Exception {
        return this.set_beacon(newval);
    }

    public long get_upTime() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -9223372036854775807L;
        }
        return this._upTime;
    }

    public long getUpTime() throws YAPI_Exception {
        return this.get_upTime();
    }

    public int get_usbCurrent() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._usbCurrent;
    }

    public int getUsbCurrent() throws YAPI_Exception {
        return this.get_usbCurrent();
    }

    public int get_rebootCountdown() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return Integer.MIN_VALUE;
        }
        return this._rebootCountdown;
    }

    public int getRebootCountdown() throws YAPI_Exception {
        return this.get_rebootCountdown();
    }

    public int set_rebootCountdown(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("rebootCountdown", rest_val);
        return 0;
    }

    public int setRebootCountdown(int newval) throws YAPI_Exception {
        return this.set_rebootCountdown(newval);
    }

    public int get_userVar() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return Integer.MIN_VALUE;
        }
        return this._userVar;
    }

    public int getUserVar() throws YAPI_Exception {
        return this.get_userVar();
    }

    public int set_userVar(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("userVar", rest_val);
        return 0;
    }

    public int setUserVar(int newval) throws YAPI_Exception {
        return this.set_userVar(newval);
    }

    public static YModule FindModule(String func) {
        YModule obj = (YModule)YFunction._FindFromCache("Module", func);
        if (obj == null) {
            obj = new YModule(func);
            YFunction._AddToCache("Module", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackModule = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackModule != null) {
            this._valueCallbackModule.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int saveToFlash() throws YAPI_Exception {
        return this.set_persistentSettings(1);
    }

    public int revertFromFlash() throws YAPI_Exception {
        return this.set_persistentSettings(0);
    }

    public int reboot(int secBeforeReboot) throws YAPI_Exception {
        return this.set_rebootCountdown(secBeforeReboot);
    }

    public int triggerFirmwareUpdate(int secBeforeReboot) throws YAPI_Exception {
        return this.set_rebootCountdown(-secBeforeReboot);
    }

    public String checkFirmware(String path, boolean onlynew) throws YAPI_Exception {
        int release = onlynew ? Integer.valueOf(this.get_firmwareRelease()) : 0;
        String serial = this.get_serialNumber();
        String tmp_res = YFirmwareUpdate.CheckFirmware(serial, path, release);
        if (tmp_res.indexOf("error:") == 0) {
            this._throw(-2, tmp_res);
        }
        return tmp_res;
    }

    public YFirmwareUpdate updateFirmware(String path) throws YAPI_Exception {
        String serial = this.get_serialNumber();
        byte[] settings = this.get_allSettings();
        return new YFirmwareUpdate(serial, path, settings);
    }

    public byte[] get_allSettings() throws YAPI_Exception {
        return this._download("api.json");
    }

    public int calibVersion(String cparams) {
        if (cparams.equals("0,")) {
            return 3;
        }
        if (cparams.indexOf(",") >= 0) {
            if (cparams.indexOf(" ") > 0) {
                return 3;
            }
            return 1;
        }
        if (cparams.equals("") || cparams.equals("0")) {
            return 1;
        }
        if (cparams.length() < 2 || cparams.indexOf(".") >= 0) {
            return 0;
        }
        return 2;
    }

    public int calibScale(String unit_name, String sensorType) {
        if (unit_name.equals("g") || unit_name.equals("gauss") || unit_name.equals("W")) {
            return 1000;
        }
        if (unit_name.equals("C")) {
            if (sensorType.equals("")) {
                return 16;
            }
            if (Integer.valueOf(sensorType) < 8) {
                return 16;
            }
            return 100;
        }
        if (unit_name.equals("m") || unit_name.equals("deg")) {
            return 10;
        }
        return 1;
    }

    public int calibOffset(String unit_name) {
        if (unit_name.equals("% RH") || unit_name.equals("mbar") || unit_name.equals("lx")) {
            return 0;
        }
        return Short.MAX_VALUE;
    }

    public String calibConvert(String param, String currentFuncValue, String unit_name, String sensorType) {
        int i;
        ArrayList<Object> words = new ArrayList();
        ArrayList<Object> words_str = new ArrayList();
        ArrayList<Double> calibData = new ArrayList<Double>();
        ArrayList<Object> iCalib = new ArrayList();
        int paramVer = this.calibVersion(param);
        int funVer = this.calibVersion(currentFuncValue);
        int funScale = this.calibScale(unit_name, sensorType);
        int funOffset = this.calibOffset(unit_name);
        int paramScale = funScale;
        int paramOffset = funOffset;
        if (funVer < 3) {
            if (funVer == 2) {
                YAPI.SafeYAPI();
                words = YAPI._decodeWords(currentFuncValue);
                if ((Integer)words.get(0) == 1366 && (Integer)words.get(1) == 12500) {
                    funScale = 1;
                    funOffset = 0;
                } else {
                    funScale = (Integer)words.get(1);
                    funOffset = (Integer)words.get(0);
                }
            } else if (funVer == 1 && (currentFuncValue.equals("") || Integer.valueOf(currentFuncValue) > 10)) {
                funScale = 0;
            }
        }
        calibData.clear();
        int calibType = 0;
        if (paramVer < 3) {
            double ratio;
            int maxSize;
            if (paramVer == 2) {
                YAPI.SafeYAPI();
                words = YAPI._decodeWords(param);
                if ((Integer)words.get(0) == 1366 && (Integer)words.get(1) == 12500) {
                    paramScale = 1;
                    paramOffset = 0;
                } else {
                    paramScale = (Integer)words.get(1);
                    paramOffset = (Integer)words.get(0);
                }
                if (words.size() >= 3 && (Integer)words.get(2) > 0) {
                    maxSize = 3 + 2 * ((Integer)words.get(2) % 10);
                    if (maxSize > words.size()) {
                        maxSize = words.size();
                    }
                    for (i = 3; i < maxSize; ++i) {
                        calibData.add(Double.valueOf(((Integer)words.get(i)).intValue()));
                    }
                }
            } else if (paramVer == 1) {
                words_str = new ArrayList<String>(Arrays.asList(param.split(",")));
                for (String string : words_str) {
                    words.add(Integer.valueOf(string));
                }
                if (param.equals("") || (Integer)words.get(0) > 10) {
                    paramScale = 0;
                }
                if (words.size() > 0 && (Integer)words.get(0) > 0) {
                    maxSize = 1 + 2 * ((Integer)words.get(0) % 10);
                    if (maxSize > words.size()) {
                        maxSize = words.size();
                    }
                    for (i = 1; i < maxSize; ++i) {
                        calibData.add(Double.valueOf(((Integer)words.get(i)).intValue()));
                    }
                }
            } else if (paramVer == 0 && (ratio = Double.valueOf(param).doubleValue()) > 0.0) {
                calibData.add(0.0);
                calibData.add(0.0);
                calibData.add(Double.valueOf(Math.round(65535.0 / ratio)));
                calibData.add(65535.0);
            }
            for (i = 0; i < calibData.size(); ++i) {
                if (paramScale > 0) {
                    calibData.set(i, ((Double)calibData.get(i) - (double)paramOffset) / (double)paramScale);
                    continue;
                }
                YAPI.SafeYAPI();
                calibData.set(i, YAPI._decimalToDouble((int)Math.round((Double)calibData.get(i))));
            }
        } else {
            YAPI.SafeYAPI();
            iCalib = YAPI._decodeFloats(param);
            calibType = (int)Math.round(((Integer)iCalib.get(0)).doubleValue() / 1000.0);
            if (calibType >= 30) {
                calibType -= 30;
            }
            for (i = 1; i < iCalib.size(); ++i) {
                calibData.add(((Integer)iCalib.get(i)).doubleValue() / 1000.0);
            }
        }
        if (funVer >= 3) {
            if (calibData.size() == 0) {
                param = "0,";
            } else {
                param = Integer.toString(30 + calibType);
                for (i = 0; i < calibData.size(); ++i) {
                    param = (i & 1) > 0 ? param + ":" : param + " ";
                    param = param + Integer.toString((int)Math.round((Double)calibData.get(i) * 1000.0 / 1000.0));
                }
                param = param + ",";
            }
        } else if (funVer >= 1) {
            int nPoints = calibData.size() / 2;
            param = Integer.toString(nPoints);
            for (i = 0; i < 2 * nPoints; ++i) {
                double wordVal;
                if (funScale == 0) {
                    YAPI.SafeYAPI();
                    wordVal = YAPI._doubleToDecimal((int)Math.round((Double)calibData.get(i)));
                } else {
                    wordVal = (Double)calibData.get(i) * (double)funScale + (double)funOffset;
                }
                param = param + "," + Double.toString(Math.round(wordVal));
            }
        } else if (calibData.size() == 4) {
            param = Double.toString(Math.round(1000.0 * ((Double)calibData.get(3) - (Double)calibData.get(1)) / (Double)calibData.get(2) - (Double)calibData.get(0)));
        }
        return param;
    }

    public int set_allSettings(byte[] settings) throws YAPI_Exception {
        String value;
        String jpath;
        int eqpos;
        int leng;
        String each_str;
        ArrayList<String> restoreLast = new ArrayList<String>();
        ArrayList<Object> old_dslist = new ArrayList();
        ArrayList<String> old_jpath = new ArrayList<String>();
        ArrayList<Integer> old_jpath_len = new ArrayList<Integer>();
        ArrayList<String> old_val_arr = new ArrayList<String>();
        ArrayList<Object> new_dslist = new ArrayList();
        ArrayList<String> new_jpath = new ArrayList<String>();
        ArrayList<Integer> new_jpath_len = new ArrayList<Integer>();
        ArrayList<String> new_val_arr = new ArrayList<String>();
        String oldval = "";
        String newval = "";
        byte[] old_json_flat = this._flattenJsonStruct(settings);
        old_dslist = this._json_get_array(old_json_flat);
        for (String string : old_dslist) {
            each_str = this._json_get_string(string.getBytes());
            leng = each_str.length();
            eqpos = each_str.indexOf("=");
            if (eqpos < 0 || leng == 0) {
                this._throw(-2, "Invalid settings");
                return -2;
            }
            jpath = each_str.substring(0, 0 + eqpos);
            value = each_str.substring(++eqpos, eqpos + leng - eqpos);
            old_jpath.add(jpath);
            old_jpath_len.add(jpath.length());
            old_val_arr.add(value);
        }
        byte[] actualSettings = this._download("api.json");
        actualSettings = this._flattenJsonStruct(actualSettings);
        new_dslist = this._json_get_array(actualSettings);
        for (String string : new_dslist) {
            each_str = this._json_get_string(string.getBytes());
            leng = each_str.length();
            eqpos = each_str.indexOf("=");
            if (eqpos < 0 || leng == 0) {
                this._throw(-2, "Invalid settings");
                return -2;
            }
            jpath = each_str.substring(0, 0 + eqpos);
            value = each_str.substring(++eqpos, eqpos + leng - eqpos);
            new_jpath.add(jpath);
            new_jpath_len.add(jpath.length());
            new_val_arr.add(value);
        }
        int i = 0;
        while (i < new_jpath.size()) {
            int j;
            boolean found;
            String njpath = (String)new_jpath.get(i);
            leng = njpath.length();
            int cpos = njpath.indexOf("/");
            if (cpos < 0 || leng == 0) continue;
            String fun = njpath.substring(0, 0 + cpos);
            String attr = njpath.substring(++cpos, cpos + leng - cpos);
            boolean do_update = true;
            if (fun.equals("services")) {
                do_update = false;
            }
            if (do_update && attr.equals("firmwareRelease")) {
                do_update = false;
            }
            if (do_update && attr.equals("usbCurrent")) {
                do_update = false;
            }
            if (do_update && attr.equals("upTime")) {
                do_update = false;
            }
            if (do_update && attr.equals("persistentSettings")) {
                do_update = false;
            }
            if (do_update && attr.equals("adminPassword")) {
                do_update = false;
            }
            if (do_update && attr.equals("userPassword")) {
                do_update = false;
            }
            if (do_update && attr.equals("rebootCountdown")) {
                do_update = false;
            }
            if (do_update && attr.equals("advertisedValue")) {
                do_update = false;
            }
            if (do_update && attr.equals("poeCurrent")) {
                do_update = false;
            }
            if (do_update && attr.equals("readiness")) {
                do_update = false;
            }
            if (do_update && attr.equals("ipAddress")) {
                do_update = false;
            }
            if (do_update && attr.equals("subnetMask")) {
                do_update = false;
            }
            if (do_update && attr.equals("router")) {
                do_update = false;
            }
            if (do_update && attr.equals("linkQuality")) {
                do_update = false;
            }
            if (do_update && attr.equals("ssid")) {
                do_update = false;
            }
            if (do_update && attr.equals("channel")) {
                do_update = false;
            }
            if (do_update && attr.equals("security")) {
                do_update = false;
            }
            if (do_update && attr.equals("message")) {
                do_update = false;
            }
            if (do_update && attr.equals("currentValue")) {
                do_update = false;
            }
            if (do_update && attr.equals("currentRawValue")) {
                do_update = false;
            }
            if (do_update && attr.equals("currentRunIndex")) {
                do_update = false;
            }
            if (do_update && attr.equals("pulseTimer")) {
                do_update = false;
            }
            if (do_update && attr.equals("lastTimePressed")) {
                do_update = false;
            }
            if (do_update && attr.equals("lastTimeReleased")) {
                do_update = false;
            }
            if (do_update && attr.equals("filesCount")) {
                do_update = false;
            }
            if (do_update && attr.equals("freeSpace")) {
                do_update = false;
            }
            if (do_update && attr.equals("timeUTC")) {
                do_update = false;
            }
            if (do_update && attr.equals("rtcTime")) {
                do_update = false;
            }
            if (do_update && attr.equals("unixTime")) {
                do_update = false;
            }
            if (do_update && attr.equals("dateTime")) {
                do_update = false;
            }
            if (do_update && attr.equals("rawValue")) {
                do_update = false;
            }
            if (do_update && attr.equals("lastMsg")) {
                do_update = false;
            }
            if (do_update && attr.equals("delayedPulseTimer")) {
                do_update = false;
            }
            if (do_update && attr.equals("rxCount")) {
                do_update = false;
            }
            if (do_update && attr.equals("txCount")) {
                do_update = false;
            }
            if (do_update && attr.equals("msgCount")) {
                do_update = false;
            }
            if (do_update) {
                do_update = false;
                newval = (String)new_val_arr.get(i);
                found = false;
                for (j = 0; j < old_jpath.size() && !found; ++j) {
                    if (new_jpath_len.get(i) != old_jpath_len.get(j) || !((String)new_jpath.get(i)).equals(old_jpath.get(j))) continue;
                    found = true;
                    oldval = (String)old_val_arr.get(j);
                    if (newval.equals(oldval)) continue;
                    do_update = true;
                }
            }
            if (do_update) {
                String url;
                if (attr.equals("calibrationParam")) {
                    String old_calib = "";
                    String unit_name = "";
                    String sensorType = "";
                    String new_calib = newval;
                    found = false;
                    for (j = 0; j < old_jpath.size() && !found; ++j) {
                        if (new_jpath_len.get(i) != old_jpath_len.get(j) || !((String)new_jpath.get(i)).equals(old_jpath.get(j))) continue;
                        found = true;
                        old_calib = (String)old_val_arr.get(j);
                    }
                    String tmp = fun + "/unit";
                    found = false;
                    for (j = 0; j < new_jpath.size() && !found; ++j) {
                        if (!tmp.equals(new_jpath.get(j))) continue;
                        found = true;
                        unit_name = (String)new_val_arr.get(j);
                    }
                    tmp = fun + "/sensorType";
                    found = false;
                    for (j = 0; j < new_jpath.size() && !found; ++j) {
                        if (!tmp.equals(new_jpath.get(j))) continue;
                        found = true;
                        sensorType = (String)new_val_arr.get(j);
                    }
                    newval = this.calibConvert(old_calib, (String)new_val_arr.get(i), unit_name, sensorType);
                    url = "api/" + fun + ".json?" + attr + "=" + this._escapeAttr(newval);
                    this._download(url);
                } else {
                    url = "api/" + fun + ".json?" + attr + "=" + this._escapeAttr(oldval);
                    if (attr.equals("resolution")) {
                        restoreLast.add(url);
                    } else {
                        this._download(url);
                    }
                }
            }
            ++i;
        }
        for (String string : restoreLast) {
            this._download(string);
        }
        return 0;
    }

    public byte[] download(String pathname) throws YAPI_Exception {
        return this._download(pathname);
    }

    public byte[] get_icon2d() throws YAPI_Exception {
        return this._download("icon2d.png");
    }

    public String get_lastLogs() throws YAPI_Exception {
        byte[] content = this._download("logs.txt");
        return new String(content);
    }

    public YModule nextModule() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YModule.FindModule(next_hwid);
    }

    public static YModule FirstModule() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Module");
        if (next_hwid == null) {
            return null;
        }
        return YModule.FindModule(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YModule var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YModule var1, String var2);
    }

    public static interface LogCallback {
        public void logCallback(YModule var1, String var2);
    }
}

