/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataSet;
import com.yoctopuce.YoctoAPI.YDataStream;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YModule;
import com.yoctopuce.YoctoAPI.YPEntry;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class YFunction {
    public static final String FUNCTIONDESCRIPTOR_INVALID = "!INVALID!";
    protected String _className = "Function";
    protected String _func;
    protected int _lastErrorType;
    protected String _lastErrorMsg;
    protected Object _userData;
    protected HashMap<String, YDataStream> _dataStreams;
    public static final String LOGICALNAME_INVALID = "!INVALID!";
    public static final String ADVERTISEDVALUE_INVALID = "!INVALID!";
    protected String _logicalName = "!INVALID!";
    protected String _advertisedValue = "!INVALID!";
    protected UpdateCallback _valueCallbackFunction = null;
    protected long _cacheExpiration = 0L;
    protected String _serial;
    protected String _funId;
    protected String _hwId;

    protected YFunction(String func) {
        this._func = func;
        this._lastErrorType = 0;
        this._lastErrorMsg = "";
        this._userData = null;
        this._dataStreams = new HashMap();
    }

    protected void _throw(int error, String message) throws YAPI_Exception {
        throw new YAPI_Exception(error, message);
    }

    protected static YFunction _FindFromCache(String className, String func) {
        return YAPI.SafeYAPI().getFunction(className, func);
    }

    protected static void _AddToCache(String className, String func, YFunction obj) {
        YAPI.SafeYAPI().setFunction(className, func, obj);
    }

    protected static void _UpdateValueCallbackList(YFunction func, boolean add) {
        YAPI.SafeYAPI()._UpdateValueCallbackList(func, add);
    }

    protected static void _UpdateTimedReportCallbackList(YFunction func, boolean add) {
        YAPI.SafeYAPI()._UpdateTimedReportCallbackList(func, add);
    }

    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("logicalName")) {
            this._logicalName = json_val.getString("logicalName");
        }
        if (json_val.has("advertisedValue")) {
            this._advertisedValue = json_val.getString("advertisedValue");
        }
    }

    public String get_logicalName() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._logicalName;
    }

    public String getLogicalName() throws YAPI_Exception {
        return this.get_logicalName();
    }

    public int set_logicalName(String newval) throws YAPI_Exception {
        if (!YAPI.CheckLogicalName(newval)) {
            this._throw(-2, "Invalid name :" + newval);
        }
        String rest_val = newval;
        this._setAttr("logicalName", rest_val);
        return 0;
    }

    public int setLogicalName(String newval) throws YAPI_Exception {
        return this.set_logicalName(newval);
    }

    public String get_advertisedValue() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._advertisedValue;
    }

    public String getAdvertisedValue() throws YAPI_Exception {
        return this.get_advertisedValue();
    }

    public static YFunction FindFunction(String func) {
        YFunction obj = YFunction._FindFromCache("Function", func);
        if (obj == null) {
            obj = new YFunction(func);
            YFunction._AddToCache("Function", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackFunction = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    public int _invokeValueCallback(String value) {
        if (this._valueCallbackFunction != null) {
            this._valueCallbackFunction.yNewValue(this, value);
        }
        return 0;
    }

    public int _parserHelper() {
        return 0;
    }

    public YFunction nextFunction() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YFunction.FindFunction(next_hwid);
    }

    public static YFunction FirstFunction() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Function");
        if (next_hwid == null) {
            return null;
        }
        return YFunction.FindFunction(next_hwid);
    }

    public String describe() {
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            return this._className + "(" + this._func + ")=" + hwid;
        }
        catch (YAPI_Exception yAPI_Exception) {
            return this._className + "(" + this._func + ")=unresolved";
        }
    }

    public String get_hardwareId() throws YAPI_Exception {
        return YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
    }

    public String getHardwareId() throws YAPI_Exception {
        return YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
    }

    public String get_functionId() throws YAPI_Exception {
        return YAPI.SafeYAPI().resolveFunction(this._className, this._func).getFuncId();
    }

    public String getFunctionId() throws YAPI_Exception {
        return YAPI.SafeYAPI().resolveFunction(this._className, this._func).getFuncId();
    }

    public String get_friendlyName() throws YAPI_Exception {
        YPEntry yp = YAPI.SafeYAPI().resolveFunction(this._className, this._func);
        return yp.getFriendlyName();
    }

    public String getFriendlyName() throws YAPI_Exception {
        return this.get_friendlyName();
    }

    public String toString() {
        return this.describe();
    }

    protected void _parse(JSONObject json, long msValidity) throws YAPI_Exception {
        this._cacheExpiration = YAPI.GetTickCount() + msValidity;
        try {
            this._parseAttr(json);
        }
        catch (JSONException e) {
            this._throw(-8, e.getMessage());
        }
        this._parserHelper();
    }

    protected String _escapeAttr(String newval) throws YAPI_Exception {
        try {
            String escaped = URLEncoder.encode(newval, "ISO-8859-1");
            escaped = escaped.replace("%21", "!").replace("%23", "#").replace("%24", "$").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%2C", ",").replace("%2F", "/").replace("%3A", ":").replace("%3B", ";").replace("%3F", "?").replace("%40", "@").replace("%5B", "[").replace("%5D", "]");
            return escaped;
        }
        catch (UnsupportedEncodingException ex) {
            throw new YAPI_Exception(-2, "Unsupported Encoding");
        }
    }

    protected int _setAttr(String attr, String newval) throws YAPI_Exception {
        String attrname;
        if (newval == null) {
            throw new YAPI_Exception(-2, "Undefined value to set for attribute " + attr);
        }
        try {
            attrname = URLEncoder.encode(attr, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            throw new YAPI_Exception(-2, "Unsupported Encoding");
        }
        String extra = "/" + attrname + "?" + attrname + "=" + this._escapeAttr(newval) + "&.";
        this._devRequest(extra);
        if (this._cacheExpiration != 0L) {
            this._cacheExpiration = YAPI.GetTickCount();
        }
        return 0;
    }

    private byte[] _request(String req_first_line, byte[] req_head_and_body) throws YAPI_Exception {
        YDevice dev = this.getYDevice();
        return dev.requestHTTPSync(req_first_line, req_head_and_body);
    }

    protected int _upload(String path, byte[] content) throws YAPI_Exception {
        YDevice dev = this.getYDevice();
        return dev.requestHTTPUpload(path, content);
    }

    protected int _upload(String pathname, String content) throws YAPI_Exception {
        try {
            return this._upload(pathname, content.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new YAPI_Exception(-2, e.getLocalizedMessage());
        }
    }

    protected byte[] _download(String url) throws YAPI_Exception {
        String request = "GET /" + url + " HTTP/1.1\r\n\r\n";
        return this._request(request, null);
    }

    protected String _json_get_key(byte[] json, String key) throws YAPI_Exception {
        JSONObject obj = null;
        try {
            obj = new JSONObject(new String(json, YAPI.DeviceCharset));
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        if (obj.has(key)) {
            String val = obj.optString(key);
            if (val == null) {
                val = obj.toString();
            }
            return val;
        }
        throw new YAPI_Exception(-2, "No key " + key + "in JSON struct");
    }

    protected String _json_get_string(byte[] json) throws YAPI_Exception {
        JSONArray array = null;
        try {
            String s = new String(json, YAPI.DeviceCharset);
            array = new JSONArray("[" + s + "]");
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        try {
            return array.getString(0);
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
    }

    protected ArrayList<String> _json_get_array(byte[] json) throws YAPI_Exception {
        JSONArray array = null;
        try {
            array = new JSONArray(new String(json, YAPI.DeviceCharset));
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            try {
                Object o = array.get(i);
                if (o.getClass().getName().substring(0, 3).equals("JSO")) {
                    list.add(o.toString());
                    continue;
                }
                String s = new JSONStringer().object().key("X").value(o).endObject().toString();
                list.add(s.substring(5, s.length() - 1));
                continue;
            }
            catch (JSONException ex) {
                throw new YAPI_Exception(-8, ex.getLocalizedMessage());
            }
        }
        return list;
    }

    protected JSONObject _devRequest(String extra) throws YAPI_Exception {
        YDevice dev = this.getYDevice();
        YPEntry yp = YAPI.SafeYAPI().resolveFunction(this._className, this._func);
        this._hwId = yp.getHardwareId();
        this._funId = yp.getFuncId();
        this._serial = yp.getSerial();
        JSONObject loadval = null;
        if (extra.equals("")) {
            String yreq = dev.requestAPI();
            try {
                JSONObject jsonval = new JSONObject(yreq);
                loadval = jsonval.getJSONObject(this._funId);
            }
            catch (JSONException ex) {
                throw new YAPI_Exception(-8, "Request failed, could not parse API result for " + dev);
            }
        } else {
            dev.dropCache();
        }
        if (loadval == null) {
            String httpreq;
            if (extra.equals("")) {
                httpreq = "GET /api/" + this._funId + ".json";
                String yreq = dev.requestHTTPSyncAsString(httpreq, null);
                try {
                    loadval = new JSONObject(yreq);
                }
                catch (JSONException ex) {
                    throw new YAPI_Exception(-8, "Request failed, could not parse API value for " + httpreq);
                }
            } else {
                httpreq = "GET /api/" + this._funId + extra;
                dev.requestHTTPAsync(httpreq, null, null, null);
                return null;
            }
        }
        return loadval;
    }

    YDevice getYDevice() throws YAPI_Exception {
        return YAPI.SafeYAPI().funcGetDevice(this._className, this._func);
    }

    YDataStream _findDataStream(YDataSet dataset, String def) throws YAPI_Exception {
        String key = dataset.get_functionId() + ":" + def;
        if (this._dataStreams.containsKey(key)) {
            return this._dataStreams.get(key);
        }
        YDataStream newDataStream = new YDataStream(this, dataset, YAPI._decodeWords(def));
        this._dataStreams.put(key, newDataStream);
        return newDataStream;
    }

    public boolean isOnline() {
        if (this._cacheExpiration > YAPI.GetTickCount()) {
            return true;
        }
        try {
            this.load(YAPI.SafeYAPI().DefaultCacheValidity);
        }
        catch (YAPI_Exception ex) {
            return false;
        }
        return true;
    }

    public int get_errorType() {
        return this._lastErrorType;
    }

    public int getErrorType() {
        return this._lastErrorType;
    }

    public int errorType() {
        return this._lastErrorType;
    }

    public int errType() {
        return this._lastErrorType;
    }

    public String get_errorMessage() {
        return this._lastErrorMsg;
    }

    public String getErrorMessage() {
        return this._lastErrorMsg;
    }

    public String errorMessage() {
        return this._lastErrorMsg;
    }

    public String errMessage() {
        return this._lastErrorMsg;
    }

    public int load(long msValidity) throws YAPI_Exception {
        JSONObject json_obj = this._devRequest("");
        this._parse(json_obj, msValidity);
        return 0;
    }

    public YModule get_module() {
        if (this._serial != null && !this._serial.equals("")) {
            return YModule.FindModule(this._serial + ".module");
        }
        if (this._func.indexOf(46) == -1) {
            try {
                YPEntry ypEntry = YAPI.SafeYAPI().resolveFunction(this._className, this._func);
                return YModule.FindModule(ypEntry.getSerial() + ".module");
            }
            catch (YAPI_Exception ignored) {
                // empty catch block
            }
        }
        try {
            if (this.load(YAPI.SafeYAPI().DefaultCacheValidity) == 0) {
                YPEntry ypEntry = YAPI.SafeYAPI().resolveFunction(this._className, this._func);
                return YModule.FindModule(ypEntry.getSerial() + ".module");
            }
        }
        catch (YAPI_Exception yAPI_Exception) {
            // empty catch block
        }
        return YModule.FindModule("module_of_" + this._className + "_" + this._func);
    }

    public YModule getModule() {
        return this.get_module();
    }

    public YModule module() {
        return this.get_module();
    }

    public String get_functionDescriptor() {
        try {
            return YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
        }
        catch (YAPI_Exception ignored) {
            return "!INVALID!";
        }
    }

    public String getFunctionDescriptor() {
        return this.get_functionDescriptor();
    }

    public String functionDescriptor() {
        return this.get_functionDescriptor();
    }

    public Object get_userData() {
        return this._userData;
    }

    public Object getUserData() {
        return this.get_userData();
    }

    public Object userData() {
        return this.get_userData();
    }

    public void set_userData(Object data) {
        this._userData = data;
    }

    public void setUserData(Object data) {
        this.set_userData(data);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YFunction var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YFunction var1, String var2);
    }
}

