/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareFile;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YModule;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class YFirmwareUpdate {
    protected String _serial;
    protected byte[] _settings;
    protected String _firmwarepath;
    protected String _progress_msg;
    protected int _progress_c = 0;
    protected int _progress = 0;
    protected int _restore_step = 0;
    private Thread _thread = null;

    static byte[] _downloadfile(String url) throws YAPI_Exception {
        ByteArrayOutputStream result = new ByteArrayOutputStream(1024);
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new YAPI_Exception(-8, e.getLocalizedMessage());
        }
        BufferedInputStream in = null;
        try {
            URLConnection connection = u.openConnection();
            in = new BufferedInputStream(connection.getInputStream());
            byte[] buffer = new byte[1024];
            int readed = 0;
            while (readed >= 0) {
                readed = in.read(buffer, 0, buffer.length);
                if (readed < 0) {
                    break;
                }
                result.write(buffer, 0, readed);
            }
        }
        catch (IOException e) {
            throw new YAPI_Exception(-8, "unable to contact www.yoctopuce.com :" + e.getLocalizedMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        return result.toByteArray();
    }

    static YFirmwareFile checkFirmware_r(File folder, String serial_base) throws YAPI_Exception {
        YFirmwareFile bestFirmware = null;
        if (folder.isFile()) {
            bestFirmware = YFirmwareUpdate._loadFirmwareFile(folder);
        } else {
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles != null) {
                for (File subfile : listOfFiles) {
                    YFirmwareFile firmware;
                    block8: {
                        if (!subfile.getName().startsWith(serial_base)) continue;
                        firmware = null;
                        if (subfile.isFile()) {
                            try {
                                firmware = YFirmwareUpdate._loadFirmwareFile(subfile);
                                break block8;
                            }
                            catch (YAPI_Exception ex) {
                                continue;
                            }
                        }
                        if (subfile.isDirectory()) {
                            firmware = YFirmwareUpdate.checkFirmware_r(subfile, serial_base);
                        }
                    }
                    if (firmware == null || !firmware.getSerial().startsWith(serial_base) || bestFirmware != null && bestFirmware.getFirmwareRelaseAsInt() >= firmware.getFirmwareRelaseAsInt()) continue;
                    bestFirmware = firmware;
                }
            }
        }
        return bestFirmware;
    }

    private static YFirmwareFile _loadFirmwareFile(File file) throws YAPI_Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new YAPI_Exception(-14, "File not found");
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream(1024);
        try {
            byte[] buffer = new byte[1024];
            int readed = 0;
            while (readed >= 0) {
                readed = in.read(buffer, 0, buffer.length);
                if (readed < 0) {
                    break;
                }
                result.write(buffer, 0, readed);
            }
        }
        catch (IOException e) {
            throw new YAPI_Exception(-8, "unable to load file :" + e.getLocalizedMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
        return YFirmwareFile.Parse(file.getPath(), result.toByteArray());
    }

    public YFirmwareUpdate(String serial, String path, byte[] settings) {
        this._serial = serial;
        this._firmwarepath = path;
        this._settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _progress(int progress, String msg) {
        YFirmwareUpdate yFirmwareUpdate = this;
        synchronized (yFirmwareUpdate) {
            this._progress = progress;
            this._progress_msg = msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processMore(int start) {
        YFirmwareUpdate yFirmwareUpdate = this;
        synchronized (yFirmwareUpdate) {
            if (!(start <= 0 || this._thread != null && this._thread.isAlive())) {
                this._progress(0, "Firmware update started");
                this._thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            YFirmwareFile firmware;
                            YFirmwareUpdate.this._progress(1, "Loading firmware");
                            if (YFirmwareUpdate.this._firmwarepath.startsWith("www.yoctopuce.com") || YFirmwareUpdate.this._firmwarepath.startsWith("http://www.yoctopuce.com")) {
                                byte[] bytes = YFirmwareUpdate._downloadfile(YFirmwareUpdate.this._firmwarepath);
                                firmware = YFirmwareFile.Parse(YFirmwareUpdate.this._firmwarepath, bytes);
                            } else {
                                firmware = YFirmwareUpdate._loadFirmwareFile(new File(YFirmwareUpdate.this._firmwarepath));
                            }
                            YFirmwareUpdate.this._progress(5, "check if module is already in bootloader");
                            YGenericHub hub = null;
                            YModule module = YModule.FindModule(YFirmwareUpdate.this._serial + ".module");
                            if (module.isOnline()) {
                                YDevice yDevice = module.getYDevice();
                                hub = yDevice.getHub();
                            } else {
                                for (YGenericHub h : YAPI.SafeYAPI()._hubs) {
                                    ArrayList<String> bootloaders = h.getBootloaders();
                                    if (!bootloaders.contains(YFirmwareUpdate.this._serial)) continue;
                                    hub = h;
                                    break;
                                }
                            }
                            if (hub == null) {
                                throw new YAPI_Exception(-4, "device " + YFirmwareUpdate.this._serial + " is not detected");
                            }
                            hub.firmwareUpdate(YFirmwareUpdate.this._serial, firmware, YFirmwareUpdate.this._settings, new YGenericHub.UpdateProgress(){

                                @Override
                                public void firmware_progress(int percent, String message) {
                                    YFirmwareUpdate.this._progress(5 + percent * 80 / 100, message);
                                }
                            });
                            YFirmwareUpdate.this._progress(80, "wait to the device restart");
                            long timeout = YAPI.GetTickCount() + 30000L;
                            while (!module.isOnline() && timeout > YAPI.GetTickCount()) {
                                Thread.sleep(500L);
                                try {
                                    YAPI.UpdateDeviceList();
                                }
                                catch (YAPI_Exception ignore) {}
                            }
                            if (module.isOnline()) {
                                if (YFirmwareUpdate.this._settings != null) {
                                    module.set_allSettings(YFirmwareUpdate.this._settings);
                                }
                                YFirmwareUpdate.this._progress(100, "Success");
                            } else {
                                YFirmwareUpdate.this._progress(-1, "Device did not reboot correctly");
                            }
                        }
                        catch (YAPI_Exception e) {
                            YFirmwareUpdate.this._progress(e.errorType, e.getLocalizedMessage());
                            e.printStackTrace();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }, "Update" + this._serial);
                this._thread.start();
            }
        }
    }

    public static String CheckFirmware(String serial, String path, int minrelease) throws YAPI_Exception {
        String link = "";
        Integer best_rev = 0;
        if (path.startsWith("www.yoctopuce.com") || path.startsWith("http://www.yoctopuce.com")) {
            byte[] json = YFirmwareUpdate._downloadfile("http://www.yoctopuce.com//FR/common/getLastFirmwareLink.php?serial=" + serial);
            JSONObject obj = null;
            try {
                obj = new JSONObject(new String(json, YAPI.DeviceCharset));
            }
            catch (JSONException ex) {
                throw new YAPI_Exception(-8, ex.getLocalizedMessage());
            }
            try {
                link = obj.getString("link");
                best_rev = obj.getInt("version");
            }
            catch (JSONException e) {
                throw new YAPI_Exception(-8, "invalid respond form www.yoctopuce.com" + e.getLocalizedMessage());
            }
        }
        File folder = new File(path);
        YFirmwareFile firmware = YFirmwareUpdate.checkFirmware_r(folder, serial.substring(0, 8));
        if (firmware != null) {
            best_rev = firmware.getFirmwareRelaseAsInt();
            link = firmware.getPath();
        }
        if (minrelease != 0) {
            if (minrelease < best_rev) {
                return link;
            }
            return "";
        }
        return link;
    }

    public static ArrayList<String> GetAllBootLoaders() {
        ArrayList<String> res = new ArrayList<String>();
        for (YGenericHub h : YAPI.SafeYAPI()._hubs) {
            try {
                ArrayList<String> bootloaders = h.getBootloaders();
                if (bootloaders == null) continue;
                res.addAll(bootloaders);
            }
            catch (YAPI_Exception e) {
                YAPI.SafeYAPI()._Log(e.getLocalizedMessage());
            }
        }
        return res;
    }

    public int get_progress() {
        this._processMore(0);
        return this._progress;
    }

    public String get_progressMessage() {
        return this._progress_msg;
    }

    public int startUpdate() {
        this._progress = 0;
        this._progress_c = 0;
        this._processMore(1);
        return this._progress;
    }
}

