/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataSet;
import com.yoctopuce.YoctoAPI.YDataStream;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YOldDataStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class YDataLogger
extends YFunction {
    public static final int CURRENTRUNINDEX_INVALID = -1;
    public static final long TIMEUTC_INVALID = -9223372036854775807L;
    public static final int RECORDING_OFF = 0;
    public static final int RECORDING_ON = 1;
    public static final int RECORDING_INVALID = -1;
    public static final int AUTOSTART_OFF = 0;
    public static final int AUTOSTART_ON = 1;
    public static final int AUTOSTART_INVALID = -1;
    public static final int BEACONDRIVEN_OFF = 0;
    public static final int BEACONDRIVEN_ON = 1;
    public static final int BEACONDRIVEN_INVALID = -1;
    public static final int CLEARHISTORY_FALSE = 0;
    public static final int CLEARHISTORY_TRUE = 1;
    public static final int CLEARHISTORY_INVALID = -1;
    protected int _currentRunIndex = -1;
    protected long _timeUTC = -9223372036854775807L;
    protected int _recording = -1;
    protected int _autoStart = -1;
    protected int _beaconDriven = -1;
    protected int _clearHistory = -1;
    protected UpdateCallback _valueCallbackDataLogger = null;
    protected String _dataLoggerURL;

    public JSONTokener getData(Integer runIdx, Integer timeIdx) throws YAPI_Exception {
        String result;
        if (this._dataLoggerURL == null) {
            this._dataLoggerURL = "/logger.json";
        }
        String devid = this.module().get_serialNumber();
        String httpreq = "GET " + this._dataLoggerURL;
        if (timeIdx != null) {
            httpreq = httpreq + String.format("?run=%d&time=%d", runIdx, timeIdx);
        }
        YDevice dev = YAPI.SafeYAPI().getDevice(devid);
        try {
            result = dev.requestHTTPSyncAsString(httpreq, null);
        }
        catch (YAPI_Exception ex) {
            if (!this._dataLoggerURL.equals("/dataLogger.json")) {
                this._dataLoggerURL = "/dataLogger.json";
                return this.getData(runIdx, timeIdx);
            }
            throw ex;
        }
        JSONTokener loadval = new JSONTokener(result);
        return loadval;
    }

    protected YDataLogger(String func) {
        super(func);
        this._className = "DataLogger";
    }

    public int get_dataStreams(ArrayList<YDataStream> v) throws YAPI_Exception {
        block7: {
            JSONTokener loadval = this.getData(null, null);
            try {
                JSONArray jsonAllStreams = new JSONArray(loadval);
                if (jsonAllStreams.length() == 0) {
                    return 0;
                }
                if (jsonAllStreams.get(0).getClass() == JSONArray.class) {
                    for (int i = 0; i < jsonAllStreams.length(); ++i) {
                        JSONArray arr = jsonAllStreams.getJSONArray(i);
                        YOldDataStream stream = new YOldDataStream(this, arr.getInt(0), arr.getInt(1), arr.getLong(2), arr.getInt(3));
                        v.add(stream);
                    }
                    break block7;
                }
                ArrayList<YDataSet> sets = this.parse_dataSets(jsonAllStreams.toString().getBytes());
                for (int j = 0; j < sets.size(); ++j) {
                    ArrayList<YDataStream> ds = sets.get(j).get_privateDataStreams();
                    for (int si = 0; si < ds.size(); ++si) {
                        v.add(ds.get(si));
                    }
                }
                return 0;
            }
            catch (JSONException ex) {
                throw new YAPI_Exception(-8, ex.getLocalizedMessage());
            }
        }
        return 0;
    }

    public int getDataStreams(ArrayList<YDataStream> v) throws YAPI_Exception {
        return this.get_dataStreams(v);
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("currentRunIndex")) {
            this._currentRunIndex = json_val.getInt("currentRunIndex");
        }
        if (json_val.has("timeUTC")) {
            this._timeUTC = json_val.getLong("timeUTC");
        }
        if (json_val.has("recording")) {
            int n = this._recording = json_val.getInt("recording") > 0 ? 1 : 0;
        }
        if (json_val.has("autoStart")) {
            int n = this._autoStart = json_val.getInt("autoStart") > 0 ? 1 : 0;
        }
        if (json_val.has("beaconDriven")) {
            int n = this._beaconDriven = json_val.getInt("beaconDriven") > 0 ? 1 : 0;
        }
        if (json_val.has("clearHistory")) {
            this._clearHistory = json_val.getInt("clearHistory") > 0 ? 1 : 0;
        }
        super._parseAttr(json_val);
    }

    public int get_currentRunIndex() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._currentRunIndex;
    }

    public int getCurrentRunIndex() throws YAPI_Exception {
        return this.get_currentRunIndex();
    }

    public long get_timeUTC() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -9223372036854775807L;
        }
        return this._timeUTC;
    }

    public long getTimeUTC() throws YAPI_Exception {
        return this.get_timeUTC();
    }

    public int set_timeUTC(long newval) throws YAPI_Exception {
        String rest_val = Long.toString(newval);
        this._setAttr("timeUTC", rest_val);
        return 0;
    }

    public int setTimeUTC(long newval) throws YAPI_Exception {
        return this.set_timeUTC(newval);
    }

    public int get_recording() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._recording;
    }

    public int getRecording() throws YAPI_Exception {
        return this.get_recording();
    }

    public int set_recording(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("recording", rest_val);
        return 0;
    }

    public int setRecording(int newval) throws YAPI_Exception {
        return this.set_recording(newval);
    }

    public int get_autoStart() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._autoStart;
    }

    public int getAutoStart() throws YAPI_Exception {
        return this.get_autoStart();
    }

    public int set_autoStart(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("autoStart", rest_val);
        return 0;
    }

    public int setAutoStart(int newval) throws YAPI_Exception {
        return this.set_autoStart(newval);
    }

    public int get_beaconDriven() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._beaconDriven;
    }

    public int getBeaconDriven() throws YAPI_Exception {
        return this.get_beaconDriven();
    }

    public int set_beaconDriven(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("beaconDriven", rest_val);
        return 0;
    }

    public int setBeaconDriven(int newval) throws YAPI_Exception {
        return this.set_beaconDriven(newval);
    }

    public int get_clearHistory() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._clearHistory;
    }

    public int getClearHistory() throws YAPI_Exception {
        return this.get_clearHistory();
    }

    public int set_clearHistory(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("clearHistory", rest_val);
        return 0;
    }

    public int setClearHistory(int newval) throws YAPI_Exception {
        return this.set_clearHistory(newval);
    }

    public static YDataLogger FindDataLogger(String func) {
        YDataLogger obj = (YDataLogger)YFunction._FindFromCache("DataLogger", func);
        if (obj == null) {
            obj = new YDataLogger(func);
            YFunction._AddToCache("DataLogger", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackDataLogger = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackDataLogger != null) {
            this._valueCallbackDataLogger.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int forgetAllDataStreams() throws YAPI_Exception {
        return this.set_clearHistory(1);
    }

    public ArrayList<YDataSet> get_dataSets() throws YAPI_Exception {
        return this.parse_dataSets(this._download("logger.json"));
    }

    public ArrayList<YDataSet> parse_dataSets(byte[] json) throws YAPI_Exception {
        ArrayList<Object> dslist = new ArrayList();
        ArrayList<YDataSet> res = new ArrayList<YDataSet>();
        dslist = this._json_get_array(json);
        res.clear();
        for (String string : dslist) {
            res.add(new YDataSet(this, string));
        }
        return res;
    }

    public YDataLogger nextDataLogger() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YDataLogger.FindDataLogger(next_hwid);
    }

    public static YDataLogger FirstDataLogger() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("DataLogger");
        if (next_hwid == null) {
            return null;
        }
        return YDataLogger.FindDataLogger(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YDataLogger var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YDataLogger var1, String var2);
    }
}

