/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import org.json.JSONException;
import org.json.JSONObject;

public class YColorLed
extends YFunction {
    public static final int RGBCOLOR_INVALID = -1;
    public static final int HSLCOLOR_INVALID = -1;
    public static final int RGBCOLORATPOWERON_INVALID = -1;
    public static final int BLINKSEQSIZE_INVALID = -1;
    public static final int BLINKSEQMAXSIZE_INVALID = -1;
    public static final int BLINKSEQSIGNATURE_INVALID = -1;
    public static final String COMMAND_INVALID = "!INVALID!";
    public static final YMove RGBMOVE_INVALID = null;
    public static final YMove HSLMOVE_INVALID = null;
    protected int _rgbColor = -1;
    protected int _hslColor = -1;
    protected YMove _rgbMove = new YMove();
    protected YMove _hslMove = new YMove();
    protected int _rgbColorAtPowerOn = -1;
    protected int _blinkSeqSize = -1;
    protected int _blinkSeqMaxSize = -1;
    protected int _blinkSeqSignature = -1;
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackColorLed = null;

    protected YColorLed(String func) {
        super(func);
        this._className = "ColorLed";
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        JSONObject subjson;
        if (json_val.has("rgbColor")) {
            this._rgbColor = json_val.getInt("rgbColor");
        }
        if (json_val.has("hslColor")) {
            this._hslColor = json_val.getInt("hslColor");
        }
        if (json_val.has("rgbMove")) {
            subjson = json_val.getJSONObject("rgbMove");
            if (subjson.has("moving")) {
                this._rgbMove.moving = subjson.getInt("moving");
            }
            if (subjson.has("target")) {
                this._rgbMove.moving = subjson.getInt("target");
            }
            if (subjson.has("ms")) {
                this._rgbMove.moving = subjson.getInt("ms");
            }
        }
        if (json_val.has("hslMove")) {
            subjson = json_val.getJSONObject("hslMove");
            if (subjson.has("moving")) {
                this._hslMove.moving = subjson.getInt("moving");
            }
            if (subjson.has("target")) {
                this._hslMove.moving = subjson.getInt("target");
            }
            if (subjson.has("ms")) {
                this._hslMove.moving = subjson.getInt("ms");
            }
        }
        if (json_val.has("rgbColorAtPowerOn")) {
            this._rgbColorAtPowerOn = json_val.getInt("rgbColorAtPowerOn");
        }
        if (json_val.has("blinkSeqSize")) {
            this._blinkSeqSize = json_val.getInt("blinkSeqSize");
        }
        if (json_val.has("blinkSeqMaxSize")) {
            this._blinkSeqMaxSize = json_val.getInt("blinkSeqMaxSize");
        }
        if (json_val.has("blinkSeqSignature")) {
            this._blinkSeqSignature = json_val.getInt("blinkSeqSignature");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    public int get_rgbColor() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._rgbColor;
    }

    public int getRgbColor() throws YAPI_Exception {
        return this.get_rgbColor();
    }

    public int set_rgbColor(int newval) throws YAPI_Exception {
        String rest_val = String.format("0x%06x", newval);
        this._setAttr("rgbColor", rest_val);
        return 0;
    }

    public int setRgbColor(int newval) throws YAPI_Exception {
        return this.set_rgbColor(newval);
    }

    public int get_hslColor() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._hslColor;
    }

    public int getHslColor() throws YAPI_Exception {
        return this.get_hslColor();
    }

    public int set_hslColor(int newval) throws YAPI_Exception {
        String rest_val = String.format("0x%06x", newval);
        this._setAttr("hslColor", rest_val);
        return 0;
    }

    public int setHslColor(int newval) throws YAPI_Exception {
        return this.set_hslColor(newval);
    }

    public YMove get_rgbMove() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return RGBMOVE_INVALID;
        }
        return this._rgbMove;
    }

    public YMove getRgbMove() throws YAPI_Exception {
        return this.get_rgbMove();
    }

    public int set_rgbMove(YMove newval) throws YAPI_Exception {
        String rest_val = String.format("%d:%d", newval.target, newval.ms);
        this._setAttr("rgbMove", rest_val);
        return 0;
    }

    public int setRgbMove(YMove newval) throws YAPI_Exception {
        return this.set_rgbMove(newval);
    }

    public int rgbMove(int rgb_target, int ms_duration) throws YAPI_Exception {
        String rest_val = String.format("%d:%d", rgb_target, ms_duration);
        this._setAttr("rgbMove", rest_val);
        return 0;
    }

    public YMove get_hslMove() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return HSLMOVE_INVALID;
        }
        return this._hslMove;
    }

    public YMove getHslMove() throws YAPI_Exception {
        return this.get_hslMove();
    }

    public int set_hslMove(YMove newval) throws YAPI_Exception {
        String rest_val = String.format("%d:%d", newval.target, newval.ms);
        this._setAttr("hslMove", rest_val);
        return 0;
    }

    public int setHslMove(YMove newval) throws YAPI_Exception {
        return this.set_hslMove(newval);
    }

    public int hslMove(int hsl_target, int ms_duration) throws YAPI_Exception {
        String rest_val = String.format("%d:%d", hsl_target, ms_duration);
        this._setAttr("hslMove", rest_val);
        return 0;
    }

    public int get_rgbColorAtPowerOn() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._rgbColorAtPowerOn;
    }

    public int getRgbColorAtPowerOn() throws YAPI_Exception {
        return this.get_rgbColorAtPowerOn();
    }

    public int set_rgbColorAtPowerOn(int newval) throws YAPI_Exception {
        String rest_val = String.format("0x%06x", newval);
        this._setAttr("rgbColorAtPowerOn", rest_val);
        return 0;
    }

    public int setRgbColorAtPowerOn(int newval) throws YAPI_Exception {
        return this.set_rgbColorAtPowerOn(newval);
    }

    public int get_blinkSeqSize() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._blinkSeqSize;
    }

    public int getBlinkSeqSize() throws YAPI_Exception {
        return this.get_blinkSeqSize();
    }

    public int get_blinkSeqMaxSize() throws YAPI_Exception {
        if (this._cacheExpiration == 0L && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._blinkSeqMaxSize;
    }

    public int getBlinkSeqMaxSize() throws YAPI_Exception {
        return this.get_blinkSeqMaxSize();
    }

    public int get_blinkSeqSignature() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._blinkSeqSignature;
    }

    public int getBlinkSeqSignature() throws YAPI_Exception {
        return this.get_blinkSeqSignature();
    }

    public String get_command() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return COMMAND_INVALID;
        }
        return this._command;
    }

    public String getCommand() throws YAPI_Exception {
        return this.get_command();
    }

    public int set_command(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("command", rest_val);
        return 0;
    }

    public int setCommand(String newval) throws YAPI_Exception {
        return this.set_command(newval);
    }

    public static YColorLed FindColorLed(String func) {
        YColorLed obj = (YColorLed)YFunction._FindFromCache("ColorLed", func);
        if (obj == null) {
            obj = new YColorLed(func);
            YFunction._AddToCache("ColorLed", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackColorLed = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackColorLed != null) {
            this._valueCallbackColorLed.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int sendCommand(String command) throws YAPI_Exception {
        return this.set_command(command);
    }

    public int addHslMoveToBlinkSeq(int HSLcolor, int msDelay) throws YAPI_Exception {
        return this.sendCommand(String.format("H%d,%d", HSLcolor, msDelay));
    }

    public int addRgbMoveToBlinkSeq(int RGBcolor, int msDelay) throws YAPI_Exception {
        return this.sendCommand(String.format("R%d,%d", RGBcolor, msDelay));
    }

    public int startBlinkSeq() throws YAPI_Exception {
        return this.sendCommand("S");
    }

    public int stopBlinkSeq() throws YAPI_Exception {
        return this.sendCommand("X");
    }

    public int resetBlinkSeq() throws YAPI_Exception {
        return this.sendCommand("Z");
    }

    public YColorLed nextColorLed() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YColorLed.FindColorLed(next_hwid);
    }

    public static YColorLed FirstColorLed() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("ColorLed");
        if (next_hwid == null) {
            return null;
        }
        return YColorLed.FindColorLed(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YColorLed var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YColorLed var1, String var2);
    }

    public static class YMove {
        public int target = Integer.MIN_VALUE;
        public int ms = Integer.MIN_VALUE;
        public int moving = -1;
    }
}

