/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YCellRecord;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class YCellular
extends YFunction {
    public static final int LINKQUALITY_INVALID = -1;
    public static final String CELLOPERATOR_INVALID = "!INVALID!";
    public static final String MESSAGE_INVALID = "!INVALID!";
    public static final String PIN_INVALID = "!INVALID!";
    public static final String LOCKEDOPERATOR_INVALID = "!INVALID!";
    public static final int ENABLEDATA_HOMENETWORK = 0;
    public static final int ENABLEDATA_ROAMING = 1;
    public static final int ENABLEDATA_NEVER = 2;
    public static final int ENABLEDATA_INVALID = -1;
    public static final String APN_INVALID = "!INVALID!";
    public static final String APNSECRET_INVALID = "!INVALID!";
    public static final String COMMAND_INVALID = "!INVALID!";
    protected int _linkQuality = -1;
    protected String _cellOperator = "!INVALID!";
    protected String _message = "!INVALID!";
    protected String _pin = "!INVALID!";
    protected String _lockedOperator = "!INVALID!";
    protected int _enableData = -1;
    protected String _apn = "!INVALID!";
    protected String _apnSecret = "!INVALID!";
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackCellular = null;

    protected YCellular(String func) {
        super(func);
        this._className = "Cellular";
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("linkQuality")) {
            this._linkQuality = json_val.getInt("linkQuality");
        }
        if (json_val.has("cellOperator")) {
            this._cellOperator = json_val.getString("cellOperator");
        }
        if (json_val.has("message")) {
            this._message = json_val.getString("message");
        }
        if (json_val.has("pin")) {
            this._pin = json_val.getString("pin");
        }
        if (json_val.has("lockedOperator")) {
            this._lockedOperator = json_val.getString("lockedOperator");
        }
        if (json_val.has("enableData")) {
            this._enableData = json_val.getInt("enableData");
        }
        if (json_val.has("apn")) {
            this._apn = json_val.getString("apn");
        }
        if (json_val.has("apnSecret")) {
            this._apnSecret = json_val.getString("apnSecret");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    public int get_linkQuality() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._linkQuality;
    }

    public int getLinkQuality() throws YAPI_Exception {
        return this.get_linkQuality();
    }

    public String get_cellOperator() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._cellOperator;
    }

    public String getCellOperator() throws YAPI_Exception {
        return this.get_cellOperator();
    }

    public String get_message() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._message;
    }

    public String getMessage() throws YAPI_Exception {
        return this.get_message();
    }

    public String get_pin() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._pin;
    }

    public String getPin() throws YAPI_Exception {
        return this.get_pin();
    }

    public int set_pin(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("pin", rest_val);
        return 0;
    }

    public int setPin(String newval) throws YAPI_Exception {
        return this.set_pin(newval);
    }

    public String get_lockedOperator() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._lockedOperator;
    }

    public String getLockedOperator() throws YAPI_Exception {
        return this.get_lockedOperator();
    }

    public int set_lockedOperator(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("lockedOperator", rest_val);
        return 0;
    }

    public int setLockedOperator(String newval) throws YAPI_Exception {
        return this.set_lockedOperator(newval);
    }

    public int get_enableData() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1;
        }
        return this._enableData;
    }

    public int getEnableData() throws YAPI_Exception {
        return this.get_enableData();
    }

    public int set_enableData(int newval) throws YAPI_Exception {
        String rest_val = Integer.toString(newval);
        this._setAttr("enableData", rest_val);
        return 0;
    }

    public int setEnableData(int newval) throws YAPI_Exception {
        return this.set_enableData(newval);
    }

    public String get_apn() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._apn;
    }

    public String getApn() throws YAPI_Exception {
        return this.get_apn();
    }

    public int set_apn(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("apn", rest_val);
        return 0;
    }

    public int setApn(String newval) throws YAPI_Exception {
        return this.set_apn(newval);
    }

    public String get_apnSecret() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._apnSecret;
    }

    public String getApnSecret() throws YAPI_Exception {
        return this.get_apnSecret();
    }

    public int set_apnSecret(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("apnSecret", rest_val);
        return 0;
    }

    public int setApnSecret(String newval) throws YAPI_Exception {
        return this.set_apnSecret(newval);
    }

    public String get_command() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return "!INVALID!";
        }
        return this._command;
    }

    public String getCommand() throws YAPI_Exception {
        return this.get_command();
    }

    public int set_command(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("command", rest_val);
        return 0;
    }

    public int setCommand(String newval) throws YAPI_Exception {
        return this.set_command(newval);
    }

    public static YCellular FindCellular(String func) {
        YCellular obj = (YCellular)YFunction._FindFromCache("Cellular", func);
        if (obj == null) {
            obj = new YCellular(func);
            YFunction._AddToCache("Cellular", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackCellular = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackCellular != null) {
            this._valueCallbackCellular.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int sendPUK(String puk, String newPin) throws YAPI_Exception {
        String gsmMsg = this.get_message();
        if (!gsmMsg.equals("Enter SIM PUK")) {
            throw new YAPI_Exception(-2, "PUK not expected at this time");
        }
        if (newPin.equals("")) {
            return this.set_command(String.format("AT+CPIN=%s,0000;+CLCK=SC,0,0000", puk));
        }
        return this.set_command(String.format("AT+CPIN=%s,%s", puk, newPin));
    }

    public int set_apnAuth(String username, String password) throws YAPI_Exception {
        return this.set_apnSecret(String.format("%s,%s", username, password));
    }

    public String _AT(String cmd) throws YAPI_Exception {
        int cmdLen = cmd.length();
        int chrPos = cmd.indexOf("#");
        while (chrPos >= 0) {
            cmd = String.format("%s%c23%s", cmd.substring(0, 0 + chrPos), 37, cmd.substring(chrPos + 1, chrPos + 1 + cmdLen - chrPos - 1));
            cmdLen += 2;
            chrPos = cmd.indexOf("#");
        }
        chrPos = cmd.indexOf("+");
        while (chrPos >= 0) {
            cmd = String.format("%s%c2B%s", cmd.substring(0, 0 + chrPos), 37, cmd.substring(chrPos + 1, chrPos + 1 + cmdLen - chrPos - 1));
            cmdLen += 2;
            chrPos = cmd.indexOf("+");
        }
        chrPos = cmd.indexOf("=");
        while (chrPos >= 0) {
            cmd = String.format("%s%c3D%s", cmd.substring(0, 0 + chrPos), 37, cmd.substring(chrPos + 1, chrPos + 1 + cmdLen - chrPos - 1));
            cmdLen += 2;
            chrPos = cmd.indexOf("=");
        }
        byte[] content = this._download(String.format("at.txt?cmd=%s", cmd));
        return new String(content);
    }

    public ArrayList<YCellRecord> quickCellSurvey() throws YAPI_Exception {
        ArrayList<Object> recs = new ArrayList();
        ArrayList<YCellRecord> res = new ArrayList<YCellRecord>();
        String moni = this._AT("+CCED=0;#MONI=7;#MONI");
        String mccs = moni.substring(7, 10);
        if (mccs.substring(0, 1).equals("0")) {
            mccs = mccs.substring(1, 3);
        }
        if (mccs.substring(0, 1).equals("0")) {
            mccs = mccs.substring(1, 2);
        }
        int mcc = Integer.valueOf(mccs);
        String mncs = moni.substring(11, 14);
        if (mncs.substring(2, 3).equals(",")) {
            mncs = mncs.substring(0, 2);
        }
        if (mncs.substring(0, 1).equals("0")) {
            mncs = mncs.substring(1, 1 + mncs.length() - 1);
        }
        int mnc = Integer.valueOf(mncs);
        recs = new ArrayList<String>(Arrays.asList(moni.split("#")));
        res.clear();
        for (String string : recs) {
            String oper;
            int tad;
            int llen = string.length() - 2;
            if (llen < 44 || !string.substring(41, 44).equals("dbm")) continue;
            int lac = Integer.valueOf(string.substring(16, 20), 16);
            int cellId = Integer.valueOf(string.substring(23, 27), 16);
            String dbms = string.substring(37, 41);
            if (dbms.substring(0, 1).equals(" ")) {
                dbms = dbms.substring(1, 4);
            }
            int dbm = Integer.valueOf(dbms);
            if (llen > 66) {
                String tads = string.substring(54, 56);
                if (tads.substring(0, 1).equals(" ")) {
                    tads = tads.substring(1, 4);
                }
                tad = Integer.valueOf(tads);
                oper = string.substring(66, 66 + llen - 66);
            } else {
                tad = -1;
                oper = "";
            }
            if (lac >= 65535) continue;
            res.add(new YCellRecord(mcc, mnc, lac, cellId, dbm, tad, oper));
        }
        return res;
    }

    public YCellular nextCellular() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YCellular.FindCellular(next_hwid);
    }

    public static YCellular FirstCellular() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Cellular");
        if (next_hwid == null) {
            return null;
        }
        return YCellular.FindCellular(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YCellular var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YCellular var1, String var2);
    }
}

