/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSensor;
import org.json.JSONException;
import org.json.JSONObject;

public class YAltitude
extends YSensor {
    public static final double QNH_INVALID = -1.79769313486231E308;
    public static final String TECHNOLOGY_INVALID = "!INVALID!";
    protected double _qnh = -1.79769313486231E308;
    protected String _technology = "!INVALID!";
    protected UpdateCallback _valueCallbackAltitude = null;
    protected TimedReportCallback _timedReportCallbackAltitude = null;

    protected YAltitude(String func) {
        super(func);
        this._className = "Altitude";
    }

    @Override
    protected void _parseAttr(JSONObject json_val) throws JSONException {
        if (json_val.has("qnh")) {
            this._qnh = (double)Math.round(json_val.getDouble("qnh") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("technology")) {
            this._technology = json_val.getString("technology");
        }
        super._parseAttr(json_val);
    }

    public int set_currentValue(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("currentValue", rest_val);
        return 0;
    }

    public int setCurrentValue(double newval) throws YAPI_Exception {
        return this.set_currentValue(newval);
    }

    public int set_qnh(double newval) throws YAPI_Exception {
        String rest_val = Long.toString(Math.round(newval * 65536.0));
        this._setAttr("qnh", rest_val);
        return 0;
    }

    public int setQnh(double newval) throws YAPI_Exception {
        return this.set_qnh(newval);
    }

    public double get_qnh() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return -1.79769313486231E308;
        }
        return this._qnh;
    }

    public double getQnh() throws YAPI_Exception {
        return this.get_qnh();
    }

    public String get_technology() throws YAPI_Exception {
        if (this._cacheExpiration <= YAPI.GetTickCount() && this.load(YAPI.SafeYAPI().DefaultCacheValidity) != 0) {
            return TECHNOLOGY_INVALID;
        }
        return this._technology;
    }

    public String getTechnology() throws YAPI_Exception {
        return this.get_technology();
    }

    public static YAltitude FindAltitude(String func) {
        YAltitude obj = (YAltitude)YFunction._FindFromCache("Altitude", func);
        if (obj == null) {
            obj = new YAltitude(func);
            YFunction._AddToCache("Altitude", func, obj);
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackAltitude = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackAltitude != null) {
            this._valueCallbackAltitude.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(this, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(this, false);
        }
        this._timedReportCallbackAltitude = callback;
        return 0;
    }

    @Override
    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackAltitude != null) {
            this._timedReportCallbackAltitude.timedReportCallback(this, value);
        } else {
            super._invokeTimedReportCallback(value);
        }
        return 0;
    }

    public YAltitude nextAltitude() {
        String next_hwid;
        try {
            String hwid = YAPI.SafeYAPI().resolveFunction(this._className, this._func).getHardwareId();
            next_hwid = YAPI.SafeYAPI().getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YAltitude.FindAltitude(next_hwid);
    }

    public static YAltitude FirstAltitude() {
        String next_hwid = YAPI.SafeYAPI().getFirstHardwareId("Altitude");
        if (next_hwid == null) {
            return null;
        }
        return YAltitude.FindAltitude(next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YAltitude var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YAltitude var1, String var2);
    }
}

