/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import org.json.JSONException;
import org.json.JSONObject;

class WPEntry {
    private String _logicalName = "";
    private String _productName = "";
    private int _productId = -1;
    private final String _networkUrl;
    private int _beacon;
    private final int _index;
    private boolean _isValid;
    private final String _serialNumber;

    public WPEntry(JSONObject json) throws JSONException {
        this._serialNumber = json.getString("serialNumber");
        this._logicalName = json.getString("logicalName");
        this._productName = json.getString("productName");
        this._productId = json.getInt("productId");
        String networkUrl = json.getString("networkUrl");
        this._networkUrl = networkUrl.substring(0, networkUrl.length() - 4);
        this._beacon = json.getInt("beacon");
        this._index = json.has("index") ? json.getInt("index") : -1;
        this._isValid = true;
    }

    public String toString() {
        return "WPEntry [_index=" + this._index + ", _serialNumber=" + this._serialNumber + ", _logicalName=" + this._logicalName + ", _productName=" + this._productName + ", _productId=" + this._productId + ", _networkUrl=" + this._networkUrl + ", _beacon=" + this._beacon + ", _isValid=" + this._isValid + "]";
    }

    public WPEntry(int index, String serial, String netUrl) {
        this._serialNumber = serial;
        this._networkUrl = netUrl;
        this._index = index;
        this._isValid = false;
    }

    public boolean isValid() {
        return this._isValid;
    }

    public void validate() {
        this._isValid = true;
    }

    public int getIndex() {
        return this._index;
    }

    public int getBeacon() {
        return this._beacon;
    }

    public void setBeacon(int _beacon) {
        this._beacon = _beacon;
    }

    public void setLogicalName(String logicalName) {
        assert (logicalName != null);
        this._logicalName = logicalName;
    }

    public String getLogicalName() {
        return this._logicalName;
    }

    public String getNetworkUrl() {
        return this._networkUrl;
    }

    public int getProductId() {
        return this._productId;
    }

    public void setProductId(int pid) {
        this._productId = pid;
    }

    public String getProductName() {
        return this._productName;
    }

    public void setProductName(String prodname) {
        this._productName = prodname;
    }

    public String getSerialNumber() {
        return this._serialNumber;
    }
}

