/*
 * Decompiled with CFR 0.152.
 */
package com.getpebble.android.kit;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcelable;
import com.getpebble.android.kit.Constants;
import com.getpebble.android.kit.util.PebbleDictionary;
import java.io.Serializable;
import java.util.UUID;
import org.json.JSONException;

public final class PebbleKit {
    private static final int NAME_MAX_LENGTH = 32;
    private static final int ICON_MAX_DIMENSIONS = 32;

    private PebbleKit() {
    }

    public static void customizeWatchApp(Context context, Constants.PebbleAppType appType, String name, Bitmap icon) throws IllegalArgumentException {
        if (appType == null) {
            throw new IllegalArgumentException("app type cannot be null");
        }
        if (name.length() > 32) {
            throw new IllegalArgumentException(String.format("app name exceeds maximum length (%d)", 32));
        }
        if (icon.getHeight() > 32 || icon.getWidth() > 32) {
            throw new IllegalArgumentException(String.format("app icon exceeds maximum dimensions (32px x 32px); got (%dpx x %dpx)", icon.getWidth(), icon.getHeight()));
        }
        Intent customizeAppIntent = new Intent("com.getpebble.action.app.CONFIGURE");
        customizeAppIntent.putExtra("app_type", appType.ord);
        customizeAppIntent.putExtra("name", name);
        customizeAppIntent.putExtra("icon", (Parcelable)icon);
        context.sendBroadcast(customizeAppIntent);
    }

    public static boolean isWatchConnected(Context context) {
        Cursor c = context.getContentResolver().query(Uri.parse((String)"content://com.getpebble.android.provider/state"), null, null, null, null);
        if (c == null || !c.moveToNext()) {
            return false;
        }
        return c.getInt(0) == 1;
    }

    public static boolean areAppMessagesSupported(Context context) {
        Cursor c = context.getContentResolver().query(Uri.parse((String)"content://com.getpebble.android.provider/state"), null, null, null, null);
        if (c == null || !c.moveToNext()) {
            return false;
        }
        return c.getInt(1) == 1;
    }

    public static void startAppOnPebble(Context context, UUID watchappUuid) throws IllegalArgumentException {
        if (watchappUuid == null) {
            throw new IllegalArgumentException("uuid cannot be null");
        }
        Intent startAppIntent = new Intent("com.getpebble.action.app.START");
        startAppIntent.putExtra("uuid", (Serializable)watchappUuid);
        context.sendBroadcast(startAppIntent);
    }

    public static void closeAppOnPebble(Context context, UUID watchappUuid) throws IllegalArgumentException {
        if (watchappUuid == null) {
            throw new IllegalArgumentException("uuid cannot be null");
        }
        Intent stopAppIntent = new Intent("com.getpebble.action.app.STOP");
        stopAppIntent.putExtra("uuid", (Serializable)watchappUuid);
        context.sendBroadcast(stopAppIntent);
    }

    public static void sendDataToPebble(Context context, UUID watchappUuid, PebbleDictionary data) throws IllegalArgumentException {
        if (watchappUuid == null) {
            throw new IllegalArgumentException("uuid cannot be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        if (data.size() == 0) {
            return;
        }
        Intent sendDataIntent = new Intent("com.getpebble.action.app.SEND");
        sendDataIntent.putExtra("uuid", (Serializable)watchappUuid);
        sendDataIntent.putExtra("msg_data", data.toJsonString());
        context.sendBroadcast(sendDataIntent);
    }

    public static void sendAckToPebble(Context context, int transactionId) throws IllegalArgumentException {
        if ((transactionId & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException(String.format("transaction id must be between (0, 255); got '%d'", transactionId));
        }
        Intent ackIntent = new Intent("com.getpebble.action.app.ACK");
        ackIntent.putExtra("transaction_id", transactionId);
        context.sendBroadcast(ackIntent);
    }

    public static void sendNackToPebble(Context context, int transactionId) throws IllegalArgumentException {
        if ((transactionId & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException(String.format("transaction id must be between (0, 255); got '%d'", transactionId));
        }
        Intent nackIntent = new Intent("com.getpebble.action.app.NACK");
        nackIntent.putExtra("transaction_id", transactionId);
        context.sendBroadcast(nackIntent);
    }

    public static BroadcastReceiver registerPebbleConnectedReceiver(Context context, BroadcastReceiver receiver) {
        return PebbleKit.registerBroadcastReceiverInternal(context, "com.getpebble.action.PEBBLE_CONNECTED", receiver);
    }

    public static BroadcastReceiver registerPebbleDisconnectedReceiver(Context context, BroadcastReceiver receiver) {
        return PebbleKit.registerBroadcastReceiverInternal(context, "com.getpebble.action.PEBBLE_DISCONNECTED", receiver);
    }

    public static BroadcastReceiver registerReceivedDataHandler(Context context, PebbleDataReceiver receiver) {
        return PebbleKit.registerBroadcastReceiverInternal(context, "com.getpebble.action.app.RECEIVE", receiver);
    }

    private static BroadcastReceiver registerBroadcastReceiverInternal(Context context, String action, BroadcastReceiver receiver) {
        if (receiver == null) {
            return null;
        }
        IntentFilter filter = new IntentFilter(action);
        context.registerReceiver(receiver, filter);
        return receiver;
    }

    public static abstract class PebbleDataReceiver
    extends BroadcastReceiver {
        private final UUID subscribedUuid;

        protected PebbleDataReceiver(UUID subscribedUuid) {
            this.subscribedUuid = subscribedUuid;
        }

        public abstract void receiveData(Context var1, int var2, PebbleDictionary var3);

        public void onReceive(Context context, Intent intent) {
            UUID receivedUuid = (UUID)intent.getSerializableExtra("uuid");
            if (!this.subscribedUuid.equals(receivedUuid)) {
                return;
            }
            int transactionId = intent.getIntExtra("transaction_id", -1);
            String jsonData = intent.getStringExtra("msg_data");
            if (jsonData == null || jsonData.isEmpty()) {
                return;
            }
            try {
                PebbleDictionary data = PebbleDictionary.fromJson(jsonData);
                this.receiveData(context, transactionId, data);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

