/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

class yHTTPRequest
implements Runnable {
    public static final long MAX_REQUEST_MS = 60000L;
    private YHTTPHub _hub;
    private Socket _socket = null;
    private BufferedOutputStream _out = null;
    private BufferedInputStream _in = null;
    private State _state = State.AVAIL;
    private boolean _eof;
    private String _firstLine;
    private byte[] _rest_of_request;
    private String _dbglabel;
    private final StringBuilder _header = new StringBuilder(1024);
    private Boolean _header_found;
    private final ByteArrayOutputStream _result = new ByteArrayOutputStream(1024);

    yHTTPRequest(YHTTPHub hub, String dbglabel) {
        this._hub = hub;
        this._dbglabel = dbglabel;
    }

    synchronized void _requestReserve() throws YAPI_Exception {
        long timeout = YAPI.GetTickCount() + 60000L;
        while (timeout > YAPI.GetTickCount() && this._state != State.AVAIL) {
            try {
                long toWait = timeout - YAPI.GetTickCount();
                this.wait(toWait);
            }
            catch (InterruptedException ie) {
                throw new YAPI_Exception(-7, "Last Http request did not finished");
            }
        }
        if (this._state != State.AVAIL) {
            throw new YAPI_Exception(-7, "Last Http request did not finished");
        }
        this._state = State.IN_REQUEST;
    }

    synchronized void _requestRelease() {
        this._state = State.AVAIL;
        this.notify();
    }

    void _requestStart(String firstLine, byte[] rest_of_request) throws YAPI_Exception {
        byte[] full_request;
        String str_request;
        this._firstLine = firstLine;
        this._rest_of_request = rest_of_request;
        if (rest_of_request == null) {
            str_request = firstLine + this._hub.getAuthorization(firstLine) + "Connection: close\r\n\r\n";
            full_request = str_request.getBytes();
        } else {
            str_request = firstLine + this._hub.getAuthorization(firstLine) + "Connection: close\r\n";
            int len = str_request.length();
            full_request = new byte[len + rest_of_request.length];
            System.arraycopy(str_request.getBytes(), 0, full_request, 0, len);
            System.arraycopy(rest_of_request, 0, full_request, len, rest_of_request.length);
        }
        try {
            this._socket = new Socket(this._hub.getHttpHost(), this._hub.getHttpPort());
            this._socket.setTcpNoDelay(true);
            this._out = new BufferedOutputStream(this._socket.getOutputStream());
            this._in = new BufferedInputStream(this._socket.getInputStream());
            this._result.reset();
            this._header.setLength(0);
            this._header_found = false;
            this._eof = false;
            this._out.write(full_request);
            this._out.flush();
        }
        catch (UnknownHostException e) {
            this._requestStop();
            throw new YAPI_Exception(-2, "Unknown host(" + this._hub.getHttpHost() + ")");
        }
        catch (IOException e) {
            this._requestStop();
            throw new YAPI_Exception(-8, e.getLocalizedMessage());
        }
    }

    void _requestStop() {
        try {
            if (this._out != null) {
                this._out.close();
                this._out = null;
            }
            if (this._in != null) {
                this._in.close();
                this._in = null;
            }
            if (this._socket != null) {
                this._socket.close();
                this._socket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void _requestReset() throws YAPI_Exception {
        this._requestStop();
        this._requestStart(this._firstLine, this._rest_of_request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _requestProcesss() throws YAPI_Exception {
        int read;
        boolean retry;
        if (this._eof) {
            return -1;
        }
        do {
            retry = false;
            byte[] buffer = new byte[1024];
            try {
                read = this._in.read(buffer, 0, buffer.length);
            }
            catch (IOException e) {
                throw new YAPI_Exception(-8, e.getLocalizedMessage());
            }
            if (read < 0) {
                this._eof = true;
                continue;
            }
            if (read <= 0) continue;
            ByteArrayOutputStream byteArrayOutputStream = this._result;
            synchronized (byteArrayOutputStream) {
                if (!this._header_found.booleanValue()) {
                    String partial_head = new String(buffer, 0, read);
                    this._header.append(partial_head);
                    int pos = this._header.indexOf("\r\n\r\n");
                    if (pos > 0) {
                        pos += 4;
                        try {
                            this._result.write(this._header.substring(pos).getBytes("ISO-8859-1"));
                        }
                        catch (IOException ex) {
                            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
                        }
                        this._header_found = true;
                        this._header.setLength(pos);
                        if (this._header.indexOf("OK\r\n") != 0) {
                            int lpos = this._header.indexOf("\r\n");
                            if (this._header.indexOf("HTTP/1.1 ") != 0) {
                                throw new YAPI_Exception(-8, "Invalid HTTP response header");
                            }
                            String[] parts = this._header.substring(9, lpos).split(" ");
                            if (parts[0].equals("401")) {
                                if (!this._hub.needRetryWithAuth()) {
                                    throw new YAPI_Exception(-12, "Authentication required");
                                }
                                this._hub.parseWWWAuthenticate(this._header.toString());
                                this._requestReset();
                                retry = true;
                                break;
                            }
                            if (!parts[0].equals("200") && !parts[0].equals("304")) {
                                throw new YAPI_Exception(-8, "Received HTTP status " + parts[0] + " (" + parts[1] + ")");
                            }
                        }
                        this._hub.authSucceded();
                    }
                } else {
                    this._result.write(buffer, 0, read);
                }
            }
        } while (retry);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getPartialResult() throws YAPI_Exception {
        byte[] res = null;
        ByteArrayOutputStream byteArrayOutputStream = this._result;
        synchronized (byteArrayOutputStream) {
            if (!this._header_found.booleanValue()) {
                return null;
            }
            if (this._result.size() == 0) {
                if (this._eof) {
                    throw new YAPI_Exception(-9, "end of file reached");
                }
                return null;
            }
            res = this._result.toByteArray();
            this._result.reset();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] RequestSync(String req_first_line, byte[] req_head_and_body) throws YAPI_Exception {
        byte[] res;
        this._requestReserve();
        try {
            int read;
            this._requestStart(req_first_line, req_head_and_body);
            while ((read = this._requestProcesss()) >= 0) {
            }
            ByteArrayOutputStream byteArrayOutputStream = this._result;
            synchronized (byteArrayOutputStream) {
                res = this._result.toByteArray();
                this._result.reset();
            }
        }
        catch (YAPI_Exception ex) {
            this._requestStop();
            this._requestRelease();
            throw ex;
        }
        this._requestStop();
        this._requestRelease();
        return res;
    }

    public void run() {
        try {
            int read;
            this._requestProcesss();
            while ((read = this._requestProcesss()) >= 0) {
            }
        }
        catch (YAPI_Exception yAPI_Exception) {
            // empty catch block
        }
        this._requestStop();
        this._requestRelease();
    }

    void RequestAsync(String req_first_line, byte[] req_head_and_body) throws YAPI_Exception {
        this._requestReserve();
        try {
            this._requestStart(req_first_line, req_head_and_body);
            Thread t = new Thread(this);
            t.start();
        }
        catch (YAPI_Exception ex) {
            this._requestRelease();
            throw ex;
        }
    }

    synchronized void WaitRequestEnd() {
        long timeout = YAPI.GetTickCount() + 60000L;
        while (timeout > YAPI.GetTickCount() && this._state == State.IN_REQUEST) {
            try {
                long toWait = timeout - YAPI.GetTickCount();
                this.wait(toWait);
            }
            catch (InterruptedException ie) {
                // empty catch block
                break;
            }
        }
        if (this._state == State.IN_REQUEST) {
            YAPI.Log("WARNING: Last Http request did not finished");
        }
        this._state = State.STOPED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        AVAIL,
        IN_REQUEST,
        STOPED;

    }
}

