/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YUSBPkt;
import java.nio.ByteBuffer;

public class YUSBRawDevice
implements Runnable {
    protected UsbDevice _device = null;
    private UsbManager _manager = null;
    private UsbDeviceConnection _connection;
    private UsbInterface _intf;
    private String _serial = null;
    private PKTHandler _pktHandler;
    private boolean _muststop = false;
    private final Object _threadLock = new Object();
    private Thread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mustBgThreadStop() {
        boolean b;
        Object object = this._threadLock;
        synchronized (object) {
            b = this._muststop;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBgThread() {
        Object object = this._threadLock;
        synchronized (object) {
            this._muststop = true;
        }
    }

    int getVendorId() {
        return this._device.getVendorId();
    }

    int getDeviceId() {
        return this._device.getDeviceId();
    }

    String getSerial() {
        return this._serial;
    }

    YUSBRawDevice(UsbDevice device, UsbManager manager, PKTHandler pktHandler) {
        this._device = device;
        this._manager = manager;
        this._pktHandler = pktHandler;
    }

    public synchronized void start() throws YAPI_Exception {
        this._intf = this._device.getInterface(0);
        this._connection = this._manager.openDevice(this._device);
        if (this._connection == null) {
            throw new YAPI_Exception(-8, "unable to open connection to device " + this._device.getDeviceName());
        }
        if (!this._connection.claimInterface(this._intf, true)) {
            throw new YAPI_Exception(-8, "unable to claim interface 0 for device " + this._device.getDeviceName());
        }
        this._serial = this._connection.getSerial();
        this.thread = new Thread(this);
        this.thread.setName("IOusb_" + this._serial);
        this.thread.start();
    }

    public synchronized void release() {
        this.stopBgThread();
        this._connection.releaseInterface(this._intf);
        this._connection.close();
        if (this.thread != null) {
            try {
                this.thread.join(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.thread = null;
        }
        this._device = null;
        this._manager = null;
        this._connection = null;
        this._intf = null;
    }

    public synchronized void sendPkt(YUSBPkt ypkt) throws YAPI_Exception {
        int result;
        if (this._intf == null) {
            throw new YAPI_Exception(-8, "Device is gone");
        }
        UsbEndpoint endpointOUT = null;
        for (int e = 0; e < this._intf.getEndpointCount(); ++e) {
            UsbEndpoint endp = this._intf.getEndpoint(e);
            if (endp.getDirection() != 0) continue;
            endpointOUT = endp;
        }
        byte[] outpkt = ypkt.getRawPkt();
        int retry = 15;
        while ((result = this._connection.bulkTransfer(endpointOUT, outpkt, outpkt.length, 1000)) < 0 && --retry >= 0) {
        }
    }

    public void run() {
        int nbSuccesiveError = 0;
        UsbEndpoint endpointIN = null;
        for (int e = 0; e < this._intf.getEndpointCount(); ++e) {
            UsbEndpoint endp = this._intf.getEndpoint(e);
            if (endp.getDirection() != 128) continue;
            endpointIN = endp;
        }
        UsbRequest d2h_r = new UsbRequest();
        d2h_r.initialize(this._connection, endpointIN);
        ByteBuffer d2h_pkt = ByteBuffer.allocate(64);
        d2h_r.queue(d2h_pkt, 64);
        while (!this.mustBgThreadStop() && this._connection != null) {
            UsbRequest finished;
            try {
                finished = this._connection.requestWait();
            }
            catch (Exception e) {
                finished = null;
            }
            if (finished != null) {
                nbSuccesiveError = 0;
                if (finished.getEndpoint().getDirection() != 128) continue;
                this._pktHandler.newPKT(d2h_pkt);
                d2h_pkt = ByteBuffer.allocate(64);
                d2h_r.queue(d2h_pkt, 64);
                continue;
            }
            if (nbSuccesiveError <= 5) continue;
            this._pktHandler.ioError();
            break;
        }
    }

    public static interface PKTHandler {
        public void newPKT(ByteBuffer var1);

        public void ioError();
    }
}

