/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YUSBDevice;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class YUSBPkt {
    public static final int USB_PKT_SIZE = 64;
    protected static final int USB_PKT_STREAM_HEAD = 2;
    protected static final int YPKT_USB_VERSION_BCD = 517;
    protected static final int YPKT_STREAM = 0;
    protected static final int YPKT_CONF = 1;
    protected static final int USB_CONF_RESET = 0;
    protected static final int USB_CONF_START = 1;
    protected static final int YSTREAM_EMPTY = 0;
    protected static final int YSTREAM_TCP = 1;
    protected static final int YSTREAM_TCP_CLOSE = 2;
    protected static final int YSTREAM_NOTICE = 3;
    protected int _pktno = 0;
    protected ArrayList<StreamHead> _streams = new ArrayList();

    protected static boolean isCompatibe(int version, String serial) throws YAPI_Exception {
        if ((version & 0xFF00) != 512) {
            if ((version & 0xFF00) > 512) {
                YAPI.Log(String.format("Yoctopuce library is too old (using 0x%x need 0x%x) to handle device %s, please upgrade your Yoctopuce library\n", 517, version, serial));
                throw new YAPI_Exception(-8, "Library is too old to handle this device");
            }
            throw new YAPI_Exception(-8, "implement backward compatibility when implementing a new protocol");
        }
        if (version != 517) {
            if (version > 517) {
                YAPI.Log(String.format("Device %s is using an newer protocol, consider upgrading your Yoctopuce library\n", serial));
            } else {
                YAPI.Log(String.format("Device %s is using an older protocol, consider upgrading the device firmware\n", serial));
            }
            return false;
        }
        return true;
    }

    public void clear() {
        this._streams.clear();
        this._pktno = 0;
    }

    int getPktno() {
        return this._pktno;
    }

    void setPktno(int _pktno) {
        this._pktno = _pktno & 7;
    }

    public byte[] getRawPkt() throws YAPI_Exception {
        byte[] res = new byte[64];
        int pos = 0;
        this.FillPktWithEmpty();
        for (StreamHead s : this._streams) {
            pos += s.popFromPkt(res, pos);
        }
        return res;
    }

    void parse(ByteBuffer raw_in_pkt) throws YAPI_Exception {
        raw_in_pkt.rewind();
        if (raw_in_pkt.limit() != 64) {
            throw new YAPI_Exception(-8, "invalid packet size");
        }
        this._streams.clear();
        while (raw_in_pkt.position() < raw_in_pkt.limit()) {
            StreamHead header = new StreamHead(raw_in_pkt);
            this._pktno = header.getPktNumber();
            this._streams.add(header);
        }
    }

    public boolean isConfPkt() {
        return this._streams.get(0).getPktType() == 1;
    }

    public static void DebugDumpPkt(ByteBuffer pkt) {
        YAPI.Log("dump packet :" + pkt + "\n");
        byte[] tmp = pkt.array();
        YAPI.Log("byte[] len " + tmp.length + " ->" + tmp + "\n");
        for (int i = 0; i < 8; ++i) {
            String line = String.format("0x02x:", i * 8);
            for (int j = 0; j < 8; ++j) {
                int pos = i * 8 + j;
                line = line + String.format(" 0x%02x", tmp[pos]);
            }
            YAPI.Log(line + "\n");
        }
    }

    public boolean isConfPktReset() {
        return this.isConfPkt() && this._streams.get(0).getStreamType() == 0;
    }

    public ConfPktResetDecoder getConfPktReset() {
        if (!this.isConfPktReset()) {
            return null;
        }
        ConfPktResetDecoder reset = new ConfPktResetDecoder(this._streams.get(0));
        return reset;
    }

    public boolean isConfPktStart() {
        return this.isConfPkt() && this._streams.get(0).getStreamType() == 1;
    }

    public ConfPktStartDecoder getConfPktStart() {
        if (!this.isConfPktStart()) {
            return null;
        }
        ConfPktStartDecoder start = new ConfPktStartDecoder(this._streams.get(0));
        return start;
    }

    public String dumpToString() {
        StringBuilder res = new StringBuilder();
        for (StreamHead s : this._streams) {
            res.append(s.dump());
        }
        return res.toString();
    }

    public StreamHead getStream(int i) {
        return this._streams.get(i);
    }

    public int getNbStreams() {
        return this._streams.size();
    }

    protected void pushStream(int type, int size, ByteBuffer data) throws YAPI_Exception {
        StreamHead header = new StreamHead(this._pktno, 0, type, size, data);
        this._streams.add(header);
    }

    protected void pushEmptyStream(int size) throws YAPI_Exception {
        StreamHead header = new StreamHead(this._pktno, 0, 0, size);
        this._streams.add(header);
    }

    protected void pushConf(int type, ByteBuffer data) throws YAPI_Exception {
        int size = data.remaining();
        if (this._streams.size() != 0) {
            throw new YAPI_Exception(-8, "Conf packet can only be sent on empty packet");
        }
        StreamHead header = new StreamHead(this._pktno, 1, type, size, data);
        this._streams.add(header);
        this.FillPktWithEmpty();
    }

    public int getMaxTcpSize_slow() {
        int remain = 62;
        for (StreamHead stream : this._streams) {
            int size = stream.getSize();
            if (size >= remain) {
                return 0;
            }
            remain -= size;
        }
        return remain;
    }

    public void formatResetPkt() throws YAPI_Exception {
        this.setPktno(0);
        ByteBuffer confpkt = ByteBuffer.allocate(4);
        confpkt.putShort((short)517);
        confpkt.put((byte)1);
        confpkt.flip();
        this.pushConf(0, confpkt);
    }

    public void formatStartPkt() throws YAPI_Exception {
        this.setPktno(0);
        ByteBuffer confpkt = ByteBuffer.allocate(4);
        confpkt.put((byte)1);
        confpkt.flip();
        this.pushConf(1, confpkt);
    }

    public int pushTCP(byte[] tcp, int start, int len) throws YAPI_Exception {
        int avail = this.getMaxTcpSize_slow();
        int contentlen = avail < len ? avail : len;
        this.pushStream(1, contentlen, ByteBuffer.wrap(tcp, start, contentlen));
        return contentlen;
    }

    public void pushTCPClose() throws YAPI_Exception {
        this.pushStream(2, 0, null);
    }

    private void FillPktWithEmpty() throws YAPI_Exception {
        int avail = this.getMaxTcpSize_slow();
        if (avail > 2) {
            this.pushEmptyStream(avail - 2);
        }
    }

    protected static class NotificationDecoder {
        protected static final int NOTIFY_1STBYTE_MAXTINY = 63;
        protected static final int NOTIFY_1STBYTE_MINSMALL = 128;
        protected static final int NOTIFY_PKT_NAME = 0;
        protected static final int NOTIFY_PKT_PRODNAME = 1;
        protected static final int NOTIFY_PKT_CHILD = 2;
        protected static final int NOTIFY_PKT_FIRMWARE = 3;
        protected static final int NOTIFY_PKT_FUNCNAME = 4;
        protected static final int NOTIFY_PKT_FUNCVAL = 5;
        protected static final int NOTIFY_PKT_STREAMREADY = 6;
        protected static final int NOTIFY_PKT_LOG = 7;
        protected static final int NOTIFY_PKT_FUNCNAMEYDX = 8;
        private NotType notType;
        private String serial = null;
        private String logicalname = null;
        private int beacon;
        private String product = null;
        private String childserial = null;
        private int onOff;
        private int devydy;
        private String firmware = null;
        private int vendorid;
        private int deviceid;
        private String funcid = null;
        private String funcname = null;
        private String funcval = null;
        private int funydx;

        public NotificationDecoder(StreamHead s, YUSBDevice dev) throws YAPI_Exception {
            byte firstByte = s.getData(0);
            if (firstByte <= 63) {
                this.notType = NotType.FUNCVAL;
                this.serial = dev.getSerial();
                this.funcid = dev.getFuncidFromYdx(this.serial, firstByte);
                this.funcval = s.getNullTerminedString(1, s.getContentSize() - 1);
            } else if (firstByte >= 128) {
                this.notType = NotType.FUNCVAL;
                this.serial = dev.getSerialFromYdx(s.getData(1));
                this.funcid = dev.getFuncidFromYdx(this.serial, firstByte - 128);
                this.funcval = s.getNullTerminedString(2, s.getContentSize() - 2);
            } else {
                this.serial = s.getNullTerminedString(0, 20);
                int p = 21;
                switch (s.getData(20)) {
                    case 0: {
                        this.notType = NotType.NAME;
                        this.logicalname = s.getNullTerminedString(p, 20);
                        this.beacon = s.getData(p += 20);
                        break;
                    }
                    case 1: {
                        this.notType = NotType.PRODNAME;
                        this.product = s.getNullTerminedString(p, 28);
                        break;
                    }
                    case 2: {
                        this.notType = NotType.CHILD;
                        this.childserial = s.getNullTerminedString(p, 20);
                        p += 20;
                        this.onOff = s.getData(p++);
                        this.devydy = s.getData(p);
                        break;
                    }
                    case 3: {
                        this.notType = NotType.FIRMWARE;
                        this.firmware = s.getNullTerminedString(p, 22);
                        this.vendorid = s.getData(p += 22) + (s.getData(p + 1) << 8);
                        this.deviceid = s.getData(p += 2) + (s.getData(p + 1) << 8);
                        break;
                    }
                    case 4: {
                        this.notType = NotType.FUNCNAME;
                        this.funcid = s.getNullTerminedString(p, 20);
                        this.funcname = s.getNullTerminedString(p += 20, 20);
                        break;
                    }
                    case 5: {
                        this.notType = NotType.FUNCVAL;
                        this.funcid = s.getNullTerminedString(p, 20);
                        this.funcval = s.getNullTerminedString(p += 20, 6);
                        break;
                    }
                    case 6: {
                        this.notType = NotType.STREAMREADY;
                        break;
                    }
                    case 7: {
                        this.notType = NotType.LOG;
                        break;
                    }
                    case 8: {
                        this.notType = NotType.FUNCNAMEYDX;
                        this.funcid = s.getNullTerminedString(p, 20);
                        this.funcname = s.getNullTerminedString(p += 20, 20);
                        this.funydx = s.getData(p += 20);
                        break;
                    }
                    default: {
                        throw new YAPI_Exception(-8, "Invalid Notification");
                    }
                }
            }
        }

        public String dump() {
            String res = "Not(" + this.serial + "): ";
            switch (this.notType) {
                case CHILD: {
                    res = res + String.format("child %s %d %d", this.childserial, this.onOff, this.devydy);
                    break;
                }
                case FIRMWARE: {
                    res = res + String.format("firmware %s %x %x", this.firmware, this.vendorid, this.deviceid);
                    break;
                }
                case FUNCNAME: {
                    res = res + String.format("FuncName %s %s", this.funcid, this.funcname);
                    break;
                }
                case FUNCNAMEYDX: {
                    res = res + String.format("FuncName %s %s %x", this.funcid, this.funcname, this.funydx);
                    break;
                }
                case FUNCVAL: {
                    res = res + String.format("FuncName %s %s", this.funcid, this.funcval);
                    break;
                }
                case LOG: {
                    res = res + "Log";
                    break;
                }
                case NAME: {
                    res = res + String.format("Name %s %x", this.logicalname, this.beacon);
                    break;
                }
                case PRODNAME: {
                    res = res + String.format("product %s", this.product);
                    break;
                }
                case STREAMREADY: {
                    res = res + "StreamReady";
                    break;
                }
                default: {
                    res = res + "unknown";
                }
            }
            res = res + "\n";
            return res;
        }

        public String getSerial() {
            return this.serial;
        }

        public NotType getNotType() {
            return this.notType;
        }

        public String getLogicalname() {
            return this.logicalname;
        }

        public int getBeacon() {
            return this.beacon;
        }

        public String getProduct() {
            return this.product;
        }

        public String getChildserial() {
            return this.childserial;
        }

        public int getOnOff() {
            return this.onOff;
        }

        public int getDevydy() {
            return this.devydy;
        }

        public String getFirmware() {
            return this.firmware;
        }

        public int getVendorid() {
            return this.vendorid;
        }

        public int getDeviceid() {
            return this.deviceid;
        }

        public String getShortFunctionID() {
            return this.funcid;
        }

        public String getLongFunctionID() {
            return this.serial + "." + this.funcid;
        }

        public String getFuncname() {
            return this.funcname;
        }

        public String getFuncval() {
            return this.funcval;
        }

        public int getFunydx() {
            return this.funydx;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum NotType {
            NAME,
            PRODNAME,
            CHILD,
            FIRMWARE,
            FUNCNAME,
            FUNCVAL,
            STREAMREADY,
            LOG,
            FUNCNAMEYDX;

        }
    }

    protected static class ConfPktStartDecoder {
        public int nbiface;

        public ConfPktStartDecoder(StreamHead s) {
            this.nbiface = s.getData(0);
        }
    }

    protected static class ConfPktResetDecoder {
        public int api;
        public int ok;
        public int ifaceno;
        public int nbiface;

        public ConfPktResetDecoder(StreamHead s) {
            this.api = s.getData(0) + (s.getData(1) << 8);
            this.ok = s.getData(2);
            this.ifaceno = s.getData(3);
            this.nbiface = s.getData(4);
        }
    }

    protected static class StreamHead {
        private int _pktNumber;
        private int _streamType;
        private int _pktType;
        private byte[] _data;

        int getPktNumber() {
            return this._pktNumber;
        }

        void setPktNumber(int pktNumber) {
            this._pktNumber = pktNumber;
        }

        int getStreamType() {
            return this._streamType;
        }

        void setStreamType(int streamType) {
            this._streamType = streamType;
        }

        int getPktType() {
            return this._pktType;
        }

        void setPktType(int pktType) {
            this._pktType = pktType;
        }

        int getContentSize() {
            return this._data.length;
        }

        int getSize() {
            return this._data.length + 2;
        }

        byte getData(int ofs) {
            if (this._data == null) {
                return -1;
            }
            return this._data[ofs];
        }

        String getNullTerminedString(int ofs, int maxlen) {
            int len;
            if (this._data == null) {
                return "";
            }
            int pos = ofs;
            for (len = 0; len < maxlen && this._data[pos + len] != 0; ++len) {
            }
            return new String(this._data, pos, len);
        }

        String getDataAsString_dtc() {
            byte[] data = this.getDataAsByteArray();
            return new String(data);
        }

        byte[] getDataAsByteArray() {
            return this._data;
        }

        public StreamHead(int pktNumber, int pktType, int streamType, int size, ByteBuffer buffer) {
            this._pktNumber = pktNumber;
            this._streamType = streamType;
            this._pktType = pktType;
            if (buffer == null) {
                this._data = new byte[0];
            } else {
                this._data = new byte[size];
                buffer.get(this._data);
            }
        }

        public StreamHead(int pktNumber, int pktType, int streamType, int size) {
            this._pktNumber = pktNumber;
            this._streamType = streamType;
            this._pktType = pktType;
            this._data = new byte[size];
        }

        public StreamHead(ByteBuffer pkt) {
            int b = pkt.get() & 0xFF;
            this._pktNumber = b & 7;
            this._streamType = b >> 3;
            b = pkt.get() & 0xFF;
            this._pktType = b & 3;
            this._data = new byte[b >> 2];
            pkt.get(this._data);
        }

        public int popFromPkt(byte[] res, int pos) {
            res[pos++] = (byte)(this._pktNumber & 7 | (this._streamType & 0x1F) << 3);
            res[pos++] = (byte)(this._pktType | (this._data.length & 0x3F) << 2);
            if (this._data.length > 0) {
                System.arraycopy(this._data, 0, res, pos, this._data.length);
            }
            return this._data.length + 2;
        }

        String dump() {
            return String.format("Stream: type=%d stream/cmd=%d size=%d (pktno=%d)\n", this._pktType, this._streamType, this._data.length, this._pktNumber);
        }
    }
}

