/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YPEntry;
import com.yoctopuce.YoctoAPI.YUSBDevice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class YUSBHub
extends YGenericHub {
    private static Context _appContext = null;
    private HashMap<String, YUSBDevice> _devsFromAndroidRef = new HashMap();
    private HashMap<String, YUSBDevice> _devsFromSerial = new HashMap();
    private ArrayList<String> _requestedPermitions = new ArrayList();
    private UsbManager _manager;
    private PendingIntent _askPermissionIntent = null;
    private static final String _ACTION_USB_PERMISSION = "com.yoctopuce.YoctoAPI.USB_PERMISSION";
    private final BroadcastReceiver _usbBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UsbDevice device;
            String action = intent.getAction();
            if (YUSBHub._ACTION_USB_PERMISSION.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device2 = (UsbDevice)intent.getParcelableExtra("device");
                    if (device2 != null) {
                        if (intent.getBooleanExtra("permission", false)) {
                            YAPI.Log("HUB_USB: permission granted for device " + device2.getDeviceName() + "\n");
                            try {
                                YUSBHub.this.updateDeviceList(true);
                            }
                            catch (YAPI_Exception e) {
                                YAPI.Log("Unable to register new plugged device (" + device2.getDeviceName() + ":" + e.getLocalizedMessage() + ")\n");
                                e.printStackTrace();
                            }
                        } else {
                            YAPI.Log("HUB_USB: permission denied for device " + device2.getDeviceName() + "\n");
                        }
                    }
                }
            }
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && (device = (UsbDevice)intent.getParcelableExtra("device")) != null) {
                YAPI.Log("HUB_USB: device " + device.getDeviceName() + "has been unplugeed (intent)");
                ArrayList device2 = YUSBHub.this._requestedPermitions;
                synchronized (device2) {
                    YUSBHub.this._requestedPermitions.remove(device.getDeviceName());
                }
                try {
                    YUSBHub.this.updateDeviceList(true);
                }
                catch (YAPI_Exception e) {
                    YAPI.Log("Unable to unregister unplugged device (" + device + ":" + e.getLocalizedMessage() + ")\n");
                }
            }
        }
    };

    public YUSBHub(int idx) throws YAPI_Exception {
        super(idx);
        this._manager = (UsbManager)_appContext.getSystemService("usb");
        if (this._manager == null) {
            throw new YAPI_Exception(-8, "Unable to get Android USB manager");
        }
        this._askPermissionIntent = PendingIntent.getBroadcast((Context)_appContext, (int)0, (Intent)new Intent(_ACTION_USB_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter();
        filter.addAction(_ACTION_USB_PERMISSION);
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        _appContext.registerReceiver(this._usbBroadcastReceiver, filter);
    }

    public void startNotifications() {
    }

    public void stopNotifications() {
    }

    public void release() {
        for (String devname : new ArrayList<String>(this._devsFromAndroidRef.keySet())) {
            this._devsFromAndroidRef.get(devname).release();
            this._devsFromAndroidRef.remove(devname);
        }
        _appContext.unregisterReceiver(this._usbBroadcastReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshUsableDeviceLsit() {
        HashMap connectedDevices = this._manager.getDeviceList();
        Iterator deviceIterator = connectedDevices.values().iterator();
        ArrayList<String> toRemove = new ArrayList<String>(this._devsFromAndroidRef.keySet());
        boolean hasRequestedPermission = false;
        YAPI.Log(String.format(Locale.ENGLISH, "ANDROID: USB manager know %d devices\n", connectedDevices.size()));
        while (deviceIterator.hasNext()) {
            UsbDevice device = (UsbDevice)deviceIterator.next();
            YAPI.Log(String.format(Locale.ENGLISH, "ANDROID: %s (0x%04x:0x%04x)\n", device.getDeviceName(), device.getVendorId(), device.getProductId()));
            if (device.getVendorId() != 9440) continue;
            int deviceid = device.getDeviceId();
            if (deviceid == 2 || deviceid == 1) {
                YAPI.Log("HUB_USB: drop yoctopuce bootloader for now\n");
                continue;
            }
            if (this._manager.hasPermission(device)) {
                if (!this._devsFromAndroidRef.containsKey(device.getDeviceName())) {
                    YAPI.Log("HUB_USB: use " + device.getDeviceName() + "\n");
                    YUSBDevice newdev = new YUSBDevice(device, this._manager);
                    try {
                        newdev.reset();
                        String serial = newdev.getSerial();
                        this._devsFromAndroidRef.put(device.getDeviceName(), newdev);
                        this._devsFromSerial.put(serial, newdev);
                        YAPI.Log("HUB_USB: Device " + serial + " (" + device.getDeviceName() + ") started\n");
                    }
                    catch (YAPI_Exception e) {
                        newdev.release();
                        YAPI.Log(e.getStackTraceToString());
                    }
                }
                toRemove.remove(device.getDeviceName());
                continue;
            }
            if (hasRequestedPermission) continue;
            ArrayList<String> arrayList = this._requestedPermitions;
            synchronized (arrayList) {
                if (this._requestedPermitions.contains(device.getDeviceName())) {
                    continue;
                }
                YAPI.Log("HUB_USB: request permition for " + device.getDeviceName() + "\n");
                this._requestedPermitions.add(device.getDeviceName());
                this._manager.requestPermission(device, this._askPermissionIntent);
            }
            hasRequestedPermission = true;
        }
        for (String devname : toRemove) {
            this._devsFromAndroidRef.get(devname).release();
            this._devsFromAndroidRef.remove(devname);
        }
    }

    synchronized void updateDeviceList(boolean forceupdate) throws YAPI_Exception {
        this.refreshUsableDeviceLsit();
        HashMap<String, ArrayList<YPEntry>> yellowPages = new HashMap<String, ArrayList<YPEntry>>();
        ArrayList<WPEntry> whitePages = new ArrayList<WPEntry>();
        for (YUSBDevice d : this._devsFromAndroidRef.values()) {
            d.updateWhitesPages(whitePages);
            d.updateYellowPages(yellowPages);
        }
        this.updateFromWpAndYp(whitePages, yellowPages);
    }

    public byte[] devRequest(YDevice device, String req_first_line, byte[] req_head_and_body, Boolean async) throws YAPI_Exception {
        String serial = device.getSerialNumber();
        if (!this._devsFromSerial.containsKey(serial)) {
            throw new YAPI_Exception(-3, "Device has been unpluged");
        }
        YUSBDevice d = this._devsFromSerial.get(serial);
        return d.sendRequest(req_first_line, req_head_and_body, async);
    }

    public static void SetContextType(Object ctx) throws YAPI_Exception {
        YAPI.Log("HUB_USB:context type=" + ctx.getClass().getName() + "\n");
        if (!(ctx instanceof Context)) {
            throw new YAPI_Exception(-2, "Object is not a valid Android Application Context");
        }
        Context app_ctx = ((Context)ctx).getApplicationContext();
        if (_appContext != null && app_ctx != _appContext) {
            throw new YAPI_Exception(-2, "Android Application Context allready set");
        }
        _appContext = app_ctx;
    }

    public static void CheckUSBAcces() throws YAPI_Exception {
        if (_appContext == null) {
            throw new YAPI_Exception(-2, "You must enable USB host mode before registering usb devices");
        }
    }

    public String getRootUrl() {
        return "usb";
    }

    public boolean isSameRootUrl(String url) {
        return url.equals("usb");
    }
}

