/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YPEntry;
import com.yoctopuce.YoctoAPI.YUSBPkt;
import com.yoctopuce.YoctoAPI.YUSBRawDevice;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YUSBDevice
implements YUSBRawDevice.PKTHandler {
    private int _lastpktno;
    private YUSBRawDevice _rawDev;
    private final HashMap<String, WPEntry> _usbWP = new HashMap();
    private final HashMap<String, YPEntry> _usbYP = new HashMap();
    private final Object _stateLock = new Object();
    private State _state = State.Detected;
    private TCP_State _tcp_state = TCP_State.Closed;
    private final ByteArrayOutputStream _req_result = new ByteArrayOutputStream(1024);
    private byte[] _currentRequest;
    private long _currentRequestTimeout;
    private ArrayList<String> _usbIdx2Serial = new ArrayList();
    private HashMap<String, String> _usbIdx2Funcid = new HashMap();

    String getSerialFromYdx(int ydx) {
        return this._usbIdx2Serial.get(ydx);
    }

    int getYdxFormSerial(String serial) {
        return this._usbIdx2Serial.indexOf(serial);
    }

    public String getFuncidFromYdx(String serial, int i) {
        String res = this._usbIdx2Funcid.get(serial + i);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YPEntry getYPEntryForNotification(YUSBPkt.NotificationDecoder not) {
        YPEntry yp;
        HashMap<String, YPEntry> hashMap = this._usbYP;
        synchronized (hashMap) {
            if (!this._usbYP.containsKey(not.getLongFunctionID())) {
                yp = new YPEntry(not.getSerial(), not.getShortFunctionID());
                this._usbYP.put(not.getLongFunctionID(), yp);
            } else {
                yp = this._usbYP.get(not.getLongFunctionID());
            }
        }
        return yp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifcation(YUSBPkt.StreamHead s) throws YAPI_Exception {
        WPEntry wp;
        YUSBPkt.NotificationDecoder not = new YUSBPkt.NotificationDecoder(s, this);
        Object object = this._usbWP;
        synchronized (object) {
            if (!this._usbWP.containsKey(not.getSerial())) {
                wp = new WPEntry(this._usbWP.size(), not.getSerial(), "");
                this._usbWP.put(not.getSerial(), wp);
            } else {
                wp = this._usbWP.get(not.getSerial());
            }
        }
        switch (not.getNotType()) {
            case CHILD: {
                this._usbIdx2Serial.add(not.getDevydy(), not.getChildserial());
                break;
            }
            case FIRMWARE: {
                wp.setProductId(not.getDeviceid());
                break;
            }
            case FUNCNAME: {
                YPEntry yp = this.getYPEntryForNotification(not);
                yp.setLogicalName(not.getFuncname());
                break;
            }
            case FUNCNAMEYDX: {
                this._usbIdx2Funcid.put(not.getSerial() + not.getFunydx(), not.getShortFunctionID());
                YPEntry yp = this.getYPEntryForNotification(not);
                yp.setLogicalName(not.getFuncname());
                yp.setIndex(not.getFunydx());
                break;
            }
            case FUNCVAL: {
                YPEntry yp = this.getYPEntryForNotification(not);
                yp.setAdvertisedValue(not.getFuncval());
                break;
            }
            case LOG: {
                break;
            }
            case NAME: {
                wp.setLogicalName(not.getLogicalname());
                wp.setBeacon(not.getBeacon());
                break;
            }
            case PRODNAME: {
                wp.setProductName(not.getProduct());
                break;
            }
            case STREAMREADY: {
                wp.validate();
                if (!this.getSerial().equals(not.getSerial())) break;
                object = this._stateLock;
                synchronized (object) {
                    if (this._state == State.ConfStarted) {
                        this._state = State.TCPSetuped;
                        this._stateLock.notify();
                    } else {
                        YAPI.Log("Streamready to early! :" + (Object)((Object)this._state));
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newPKT(ByteBuffer rawpkt) {
        block24: {
            try {
                YUSBPkt pkt = new YUSBPkt();
                pkt.parse(rawpkt);
                if (pkt.isConfPkt()) {
                    if (pkt.isConfPktReset()) {
                        YUSBPkt.ConfPktResetDecoder reset = pkt.getConfPktReset();
                        YUSBPkt.isCompatibe(reset.api, this._rawDev.getSerial());
                        this.setNewState(State.ResetOk);
                        break block24;
                    }
                    if (pkt.isConfPktStart()) {
                        Object reset = this._stateLock;
                        synchronized (reset) {
                            if (this._state == State.ResetOk) {
                                this._lastpktno = pkt.getPktno();
                                this._state = State.ConfStarted;
                                this._stateLock.notify();
                            } else {
                                YAPI.Log("Drop late confpkt:" + pkt.dumpToString());
                            }
                            break block24;
                        }
                    }
                    YAPI.Log("Unknown configuration packet received:" + pkt.dumpToString());
                    return;
                }
                int expectedPktno = this._lastpktno + 1 & 7;
                if (pkt.getPktno() != expectedPktno) {
                    YAPI.Log("Missing packet (look of pkt " + expectedPktno + " but get " + pkt.getPktno() + ")\n");
                }
                this._lastpktno = pkt.getPktno();
                int nbstreams = pkt.getNbStreams();
                block17: for (int i = 0; i < nbstreams; ++i) {
                    YUSBPkt.StreamHead s = pkt.getStream(i);
                    switch (s.getStreamType()) {
                        case 3: {
                            this.handleNotifcation(s);
                            continue block17;
                        }
                        case 1: {
                            ByteArrayOutputStream byteArrayOutputStream = this._req_result;
                            synchronized (byteArrayOutputStream) {
                                this._req_result.write(s.getDataAsByteArray());
                                continue block17;
                            }
                        }
                        case 2: {
                            ByteArrayOutputStream byteArrayOutputStream = this._req_result;
                            synchronized (byteArrayOutputStream) {
                                this._req_result.write(s.getDataAsByteArray());
                            }
                            this.remoteClose();
                            continue block17;
                        }
                    }
                }
            }
            catch (YAPI_Exception e) {
                YAPI.Log("Invalid packet received:" + e.getStackTraceToString());
            }
            catch (Exception e) {
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                e.printStackTrace(printWriter);
                YAPI.Log("Invalid packet received:" + e.getLocalizedMessage());
                YAPI.Log(((Object)writer).toString());
            }
        }
    }

    YUSBDevice(UsbDevice device, UsbManager manager) {
        this._rawDev = new YUSBRawDevice(device, manager, this);
    }

    void release() {
        this._rawDev.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewState(State newstate) {
        Object object = this._stateLock;
        synchronized (object) {
            this._state = newstate;
            this._tcp_state = TCP_State.Closed;
            this._stateLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteClose() {
        Object object = this._stateLock;
        synchronized (object) {
            switch (this._tcp_state) {
                case Close_by_API: {
                    this._tcp_state = TCP_State.Closed;
                    this._stateLock.notify();
                    break;
                }
                case Close_by_dev: 
                case Closed: {
                    YAPI.Log("Drop unexepected close from device\n");
                    break;
                }
                case Opened: {
                    this._tcp_state = TCP_State.Close_by_dev;
                    this._stateLock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForState(State wanted, State next, long mswait, String message) throws YAPI_Exception {
        long timeout = YAPI.GetTickCount() + mswait;
        Object object = this._stateLock;
        synchronized (object) {
            while (this._state != State.NotWorking && this._state != wanted && timeout > YAPI.GetTickCount()) {
                long millis = timeout - YAPI.GetTickCount();
                try {
                    this._stateLock.wait(millis);
                }
                catch (InterruptedException e) {
                    throw new YAPI_Exception(-7, "Device " + this._rawDev.getSerial() + " " + message, e);
                }
            }
            if (this._state == State.NotWorking) {
                throw new YAPI_Exception(-8, "Device " + this._rawDev.getSerial() + " " + message + " (io error)");
            }
            if (this._state != wanted) {
                throw new YAPI_Exception(-7, "Device " + this._rawDev.getSerial() + " " + message + " (" + (Object)((Object)this._state) + ")");
            }
            if (next != null) {
                this._state = next;
                this._stateLock.notify();
            }
        }
    }

    public void reset() throws YAPI_Exception {
        this._rawDev.start();
        YUSBPkt ypkt = new YUSBPkt();
        ypkt.formatResetPkt();
        this._rawDev.sendPkt(ypkt);
        this.waitForState(State.ResetOk, null, 5000L, " did not respond to reset pkt");
        ypkt.clear();
        ypkt.formatStartPkt();
        this._rawDev.sendPkt(ypkt);
        this.waitForState(State.ConfStarted, null, 5000L, "unable to start connection to device");
        this.waitForState(State.TCPSetuped, null, 5000L, "unable to start device");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLastRequest(boolean andOpenNewRequest) throws YAPI_Exception {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._tcp_state == TCP_State.Closed) {
                if (andOpenNewRequest) {
                    this._tcp_state = TCP_State.Opened;
                }
                return;
            }
            while (this._tcp_state == TCP_State.Opened && this._currentRequestTimeout > YAPI.GetTickCount()) {
                try {
                    this._stateLock.wait(this._currentRequestTimeout - YAPI.GetTickCount());
                }
                catch (InterruptedException e) {
                    throw new YAPI_Exception(-7, "HTTP request on " + this._rawDev.getSerial() + " did not finished correctly", e);
                }
            }
            YUSBPkt ypkt = new YUSBPkt();
            ypkt.pushTCPClose();
            this._rawDev.sendPkt(ypkt);
            if (this._tcp_state == TCP_State.Close_by_dev) {
                this._tcp_state = andOpenNewRequest ? TCP_State.Opened : TCP_State.Closed;
                return;
            }
            this._tcp_state = TCP_State.Close_by_API;
            long timeout = YAPI.GetTickCount() + 100L;
            while (this._tcp_state == TCP_State.Close_by_API && timeout > YAPI.GetTickCount()) {
                try {
                    this._stateLock.wait(timeout - YAPI.GetTickCount());
                }
                catch (InterruptedException e) {
                    throw new YAPI_Exception(-7, "HTTP request on " + this._rawDev.getSerial() + " did not finished correctly", e);
                }
            }
            if (this._tcp_state != TCP_State.Closed) {
                YAPI.Log("USB Close without device ack\n");
                this._tcp_state = TCP_State.Closed;
            }
            if (andOpenNewRequest) {
                this._tcp_state = TCP_State.Opened;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] sendRequest(String firstLine, byte[] rest_of_request, boolean async) throws YAPI_Exception {
        byte[] result;
        this.waitForState(State.TCPSetuped, null, 10L, "Device not ready");
        this.finishLastRequest(true);
        ByteArrayOutputStream byteArrayOutputStream = this._req_result;
        synchronized (byteArrayOutputStream) {
            this._req_result.reset();
        }
        if (rest_of_request == null) {
            this._currentRequest = (firstLine + "\r\n\r\n").getBytes();
        } else {
            firstLine = firstLine + "\r\n";
            int len = firstLine.length() + rest_of_request.length;
            this._currentRequest = new byte[len];
            System.arraycopy(firstLine.getBytes(), 0, this._currentRequest, 0, len);
            System.arraycopy(rest_of_request, 0, this._currentRequest, firstLine.length(), rest_of_request.length);
        }
        this._currentRequestTimeout = YAPI.GetTickCount() + 10000L;
        YUSBPkt ypkt = new YUSBPkt();
        for (int pos = 0; pos < this._currentRequest.length; pos += ypkt.pushTCP(this._currentRequest, pos, this._currentRequest.length - pos)) {
            this._rawDev.sendPkt(ypkt);
            ypkt.clear();
        }
        if (!async) {
            this.finishLastRequest(false);
            ByteArrayOutputStream byteArrayOutputStream2 = this._req_result;
            synchronized (byteArrayOutputStream2) {
                result = this._req_result.toByteArray();
            }
            int hpos = YAPI._find_in_bytes(result, "\r\n\r\n".getBytes());
            if (hpos >= 0) {
                return Arrays.copyOfRange(result, hpos + 4, result.length);
            }
        } else {
            return new byte[0];
        }
        return result;
    }

    public String getSerial() {
        return this._rawDev.getSerial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWhitesPages(ArrayList<WPEntry> publicWP) {
        HashMap<String, WPEntry> hashMap = this._usbWP;
        synchronized (hashMap) {
            for (WPEntry wp : this._usbWP.values()) {
                if (!wp.isValid()) continue;
                publicWP.add(wp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateYellowPages(HashMap<String, ArrayList<YPEntry>> publicYP) {
        HashMap<String, YPEntry> hashMap = this._usbYP;
        synchronized (hashMap) {
            for (YPEntry yp : this._usbYP.values()) {
                if (!publicYP.containsKey(yp.getCateg())) {
                    publicYP.put(yp.getCateg(), new ArrayList());
                }
                publicYP.get(yp.getCateg()).add(yp);
            }
        }
    }

    @Override
    public void ioError() {
        this.setNewState(State.NotWorking);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TCP_State {
        Closed,
        Opened,
        Close_by_dev,
        Close_by_API;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Detected,
        ResetOk,
        ConfStarted,
        TCPSetuped,
        TCPWaiting,
        NotWorking;

    }
}

