/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import org.json.JSONException;
import org.json.JSONObject;

class YPEntry {
    private String _serial = "";
    private String _funcId = "";
    private String _logicalName = "";
    private String _advertisedValue = "";
    private int _index = -1;
    private String _categ = "";

    public YPEntry(JSONObject json) throws JSONException {
        String hardwareId = json.getString("hardwareId");
        int pos = hardwareId.indexOf(46);
        this._serial = hardwareId.substring(0, pos);
        this._funcId = hardwareId.substring(pos + 1);
        this._categ = YAPI.functionClass(this._funcId);
        this._logicalName = json.getString("logicalName");
        this._advertisedValue = json.getString("advertisedValue");
        try {
            this._index = json.getInt("index");
        }
        catch (JSONException ex) {
            this._index = 0;
        }
    }

    public YPEntry(String serial, String shortFunctionID) {
        this._serial = serial;
        this._funcId = shortFunctionID;
        this._categ = YAPI.functionClass(this._funcId);
    }

    public String toString() {
        return "YPEntry [_categ=" + this._categ + ", _index=" + this._index + ", _serial=" + this._serial + ", _funcId=" + this._funcId + ", _logicalName=" + this._logicalName + ", _advertisedValue=" + this._advertisedValue + "]";
    }

    public String getCateg() {
        return this._categ;
    }

    public String getAdvertisedValue() {
        return this._advertisedValue;
    }

    public void setAdvertisedValue(String _advertisedValue) {
        this._advertisedValue = _advertisedValue;
        YAPI.setFunctionValue(this._serial + "." + this._funcId, _advertisedValue);
    }

    public String getHardwareId() {
        return this._serial + "." + this._funcId;
    }

    public String getSerial() {
        return this._serial;
    }

    public String getFuncId() {
        return this._funcId;
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public String getLogicalName() {
        return this._logicalName;
    }

    public void setLogicalName(String _logicalName) {
        this._logicalName = _logicalName;
    }
}

