/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFunctionType;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YPEntry;
import com.yoctopuce.YoctoAPI.yHTTPRequest;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class YHTTPHub
extends YGenericHub {
    protected URL url;
    private NotificationThread thread;
    private String _http_host = "";
    private int _http_port = 4444;
    private String _http_user = "";
    private String _http_pass = "";
    private String _http_realm = "";
    private String _nounce = "";
    private int _nounce_count = 0;
    private String _ha1 = "";
    private String _opaque = "";
    private Random _randGen = new Random();
    private MessageDigest mdigest;
    private long _notifyPos = -1L;
    private int _notifRetryCount = 0;
    private int _authRetryCount = 0;
    private boolean _writeProtected = false;
    private HashMap<YDevice, yHTTPRequest> _httpReqByDev = new HashMap();

    synchronized boolean needRetryWithAuth() {
        if (this._http_user.length() == 0 || this._http_pass.length() == 0) {
            return false;
        }
        return this._authRetryCount++ <= 3;
    }

    synchronized void authSucceded() {
        this._authRetryCount = 0;
    }

    synchronized void parseWWWAuthenticate(String header) {
        String[] tags;
        int pos = header.indexOf("\r\nWWW-Authenticate:");
        if (pos == -1) {
            return;
        }
        int eol = (header = header.substring(pos + 19)).indexOf(13);
        if (eol >= 0) {
            header = header.substring(0, eol);
        }
        this._http_realm = "";
        this._nounce = "";
        this._opaque = "";
        this._nounce_count = 0;
        for (String tag : tags = header.split(" ")) {
            String value;
            String name;
            String[] parts = tag.split("[=\",]");
            if (parts.length == 2) {
                name = parts[0];
                value = parts[1];
            } else {
                if (parts.length != 3) continue;
                name = parts[0];
                value = parts[2];
            }
            if (name.equals("realm")) {
                this._http_realm = value;
                continue;
            }
            if (name.equals("nonce")) {
                this._nounce = value;
                continue;
            }
            if (!name.equals("opaque")) continue;
            this._opaque = value;
        }
        String plaintext = this._http_user + ":" + this._http_realm + ":" + this._http_pass;
        this.mdigest.reset();
        this.mdigest.update(plaintext.getBytes());
        byte[] digest = this.mdigest.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        this._ha1 = bigInt.toString(16);
    }

    synchronized String getAuthorization(String request) throws YAPI_Exception {
        if (this._http_user.length() == 0 || this._http_realm.length() == 0) {
            return "";
        }
        ++this._nounce_count;
        int pos = request.indexOf(32);
        String method = request.substring(0, pos);
        int enduri = request.indexOf(32, pos + 1);
        if (enduri < 0) {
            enduri = request.length();
        }
        String uri = request.substring(pos + 1, enduri);
        String nc = String.format("%08x", this._nounce_count);
        String cnonce = String.format("%08x", this._randGen.nextInt());
        String plaintext = method + ":" + uri;
        this.mdigest.reset();
        this.mdigest.update(plaintext.getBytes());
        byte[] digest = this.mdigest.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        String ha2 = bigInt.toString(16);
        plaintext = this._ha1 + ":" + this._nounce + ":" + nc + ":" + cnonce + ":auth:" + ha2;
        this.mdigest.reset();
        this.mdigest.update(plaintext.getBytes());
        digest = this.mdigest.digest();
        bigInt = new BigInteger(1, digest);
        String reponse = bigInt.toString(16);
        String res = String.format("Authorization: Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", qop=auth, nc=%s, cnonce=\"%s\", response=\"%s\", opaque=\"%s\"\r\n", this._http_user, this._http_realm, this._nounce, uri, nc, cnonce, reponse, this._opaque);
        return res;
    }

    String getHttpHost() {
        return this._http_host;
    }

    String getHttpPass() {
        return this._http_pass;
    }

    int getHttpPort() {
        return this._http_port;
    }

    String getHttpUser() {
        return this._http_user;
    }

    private String _cleanRegisteredUrl(String url) {
        int portpos;
        int end_url;
        int pos = 0;
        if (url.startsWith("http://")) {
            pos = 7;
        }
        int end_auth = url.indexOf(64, pos);
        int end_user = url.indexOf(58, pos);
        if (end_auth > 0 && end_user > 0 && end_user < end_auth) {
            this._http_user = url.substring(pos, end_user);
            this._http_pass = url.substring(end_user + 1, end_auth);
            pos = end_auth + 1;
        }
        if ((end_url = url.indexOf(47, pos)) < 0) {
            end_url = url.length();
        }
        if ((portpos = url.indexOf(58, pos)) > 0 && portpos < end_url) {
            this._http_host = url.substring(pos, portpos);
            this._http_port = Integer.parseInt(url.substring(portpos, end_url));
        } else {
            this._http_host = url.substring(pos, end_url);
        }
        return url;
    }

    public YHTTPHub(int idx, String url_str) throws YAPI_Exception {
        super(idx);
        this._cleanRegisteredUrl(url_str);
        try {
            this.mdigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new YAPI_Exception(-3, "No MD5 provider");
        }
    }

    public void startNotifications() throws YAPI_Exception {
        this._notifyPos = -1L;
        this.thread = new NotificationThread();
        this.thread.setupConnection(this);
        this.thread.setName("Notif_" + this._http_host);
        this.thread.start();
    }

    public void stopNotifications() {
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.thread = null;
    }

    public void release() {
        for (yHTTPRequest req : this._httpReqByDev.values()) {
            req.WaitRequestEnd();
        }
        this._httpReqByDev = null;
    }

    public String getRootUrl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isSameRootUrl(String url) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void updateDeviceList(boolean forceupdate) throws YAPI_Exception {
        long now = YAPI.GetTickCount();
        if (forceupdate) {
            this._devListExpires = 0L;
        }
        if (this._devListExpires > now) {
            return;
        }
        yHTTPRequest req = new yHTTPRequest(this, "updateDeviceList " + this._http_host);
        String yreq = new String(req.RequestSync("GET /api.json\r\n", null));
        HashMap<String, ArrayList<YPEntry>> yellowPages = new HashMap<String, ArrayList<YPEntry>>();
        ArrayList<WPEntry> whitePages = new ArrayList<WPEntry>();
        try {
            JSONObject loadval = new JSONObject(yreq);
            if (!loadval.has("services") || !loadval.getJSONObject("services").has("whitePages")) {
                throw new YAPI_Exception(-2, "Device " + this._http_host + " is not a hub");
            }
            JSONArray whitePages_json = loadval.getJSONObject("services").getJSONArray("whitePages");
            JSONObject yellowPages_json = loadval.getJSONObject("services").getJSONObject("yellowPages");
            if (loadval.has("network")) {
                String adminpass = loadval.getJSONObject("network").getString("adminPassword");
                this._writeProtected = adminpass.length() > 0;
            }
            Iterator keys = yellowPages_json.keys();
            while (keys.hasNext()) {
                String classname = keys.next().toString();
                YFunctionType ftype = YAPI.getFnByType(classname);
                JSONArray yprecs_json = yellowPages_json.getJSONArray(classname);
                ArrayList<YPEntry> yprecs_arr = new ArrayList<YPEntry>(yprecs_json.length());
                for (int i = 0; i < yprecs_json.length(); ++i) {
                    YPEntry yprec = new YPEntry(yprecs_json.getJSONObject(i));
                    yprecs_arr.add(yprec);
                    if (!ftype.reindexFunction(yprec.getHardwareId(), yprec.getLogicalName(), yprec.getAdvertisedValue())) continue;
                }
                yellowPages.put(classname, yprecs_arr);
            }
            for (int i = 0; i < whitePages_json.length(); ++i) {
                WPEntry devinfo = new WPEntry(whitePages_json.getJSONObject(i));
                this._serialByYdx.put(devinfo.getIndex(), devinfo.getSerialNumber());
                whitePages.add(devinfo);
            }
        }
        catch (JSONException e) {
            throw new YAPI_Exception(-8, "Request failed, could not parse API result for " + this._http_host, (Exception)((Object)e));
        }
        this.updateFromWpAndYp(whitePages, yellowPages);
        now = YAPI.GetTickCount();
        this._devListExpires = now + this._devListValidity;
    }

    public byte[] devRequest(YDevice device, String req_first_line, byte[] req_head_and_body, Boolean async) throws YAPI_Exception {
        if (!this._httpReqByDev.containsKey(device)) {
            this._httpReqByDev.put(device, new yHTTPRequest(this, "Device " + device.getSerialNumber()));
        }
        yHTTPRequest req = this._httpReqByDev.get(device);
        if (!async.booleanValue()) {
            return req.RequestSync(req_first_line, req_head_and_body);
        }
        if (this._writeProtected && !this._http_user.equals("admin")) {
            throw new YAPI_Exception(-12, "Access denied: admin credentials required");
        }
        req.RequestAsync(req_first_line, req_head_and_body);
        return null;
    }

    private class NotificationThread
    extends Thread {
        private yHTTPRequest _yreq;

        private NotificationThread() {
        }

        public void setupConnection(YHTTPHub hub) {
            this._yreq = new yHTTPRequest(hub, "Notification of " + YHTTPHub.this._http_host);
        }

        private void handleNetNotification(String notification_line) {
            String ev = notification_line.trim();
            if (ev.length() >= 3 && ev.charAt(0) == 'y') {
                String serial;
                String funcid;
                YHTTPHub.this._devListValidity = 10000L;
                YHTTPHub.this._notifRetryCount = 0;
                if (YHTTPHub.this._notifyPos >= 0L) {
                    YHTTPHub.this._notifyPos += ev.length() + 1;
                }
                int devydx = ev.charAt(1) - 65;
                int funydx = ev.charAt(2) - 48;
                if (funydx >= 64) {
                    funydx -= 64;
                    devydx += 128;
                }
                String value = ev.substring(3);
                if (YHTTPHub.this._serialByYdx.containsKey(devydx) && !(funcid = YAPI.getDevice(serial = (String)YHTTPHub.this._serialByYdx.get(devydx)).functionId(funydx)).equals("")) {
                    YAPI.setFunctionValue(serial + "." + funcid, value);
                }
            } else if (ev.length() >= 5 && ev.startsWith("YN01")) {
                char notype;
                YHTTPHub.this._devListValidity = 10000L;
                YHTTPHub.this._notifRetryCount = 0;
                if (YHTTPHub.this._notifyPos >= 0L) {
                    YHTTPHub.this._notifyPos += ev.length() + 1;
                }
                if ((notype = ev.charAt(4)) == '@') {
                    YHTTPHub.this._notifyPos = Integer.valueOf(ev.substring(5)).intValue();
                } else {
                    switch (notype) {
                        case '0': 
                        case '2': 
                        case '4': 
                        case '8': {
                            YHTTPHub.this._devListExpires = 0L;
                            break;
                        }
                        case '\u0005': {
                            String[] parts = ev.substring(5).split(",");
                            YAPI.setFunctionValue(parts[0] + "." + parts[1], parts[2]);
                        }
                    }
                }
            } else {
                YHTTPHub.this._devListValidity = 500L;
                YHTTPHub.this._notifyPos = -1L;
            }
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    this._yreq._requestReserve();
                    String notUrl = YHTTPHub.this._notifyPos < 0L ? "GET /not.byn\r\n" : String.format("GET /not.byn?abs=%d\r\n", YHTTPHub.this._notifyPos);
                    this._yreq._requestStart(notUrl, null);
                    String fifo = "";
                    do {
                        int pos;
                        this._yreq._requestProcesss();
                        byte[] partial = this._yreq.getPartialResult();
                        if (partial != null) {
                            fifo = fifo + new String(partial);
                        }
                        do {
                            if ((pos = fifo.indexOf("\n")) <= 0) continue;
                            String line = fifo.substring(0, pos + 1);
                            this.handleNetNotification(line);
                            fifo = fifo.substring(pos + 1);
                        } while (pos > 0);
                    } while (!this.isInterrupted());
                    this._yreq._requestStop();
                    this._yreq._requestRelease();
                }
                catch (YAPI_Exception ex) {
                    this._yreq._requestStop();
                    this._yreq._requestRelease();
                    YHTTPHub.this._notifRetryCount++;
                    YHTTPHub.this._devListValidity = 500L;
                    if (this.isInterrupted()) {
                        return;
                    }
                    long delay = 500 << YHTTPHub.this._notifRetryCount;
                    if (delay > 8000L) {
                        delay = 8000L;
                    }
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ex1) {}
                }
            }
        }

        public void interrupt() {
            super.interrupt();
            this._yreq._requestStop();
            this._yreq._requestRelease();
        }
    }
}

